#include <string.h>
#include <limits.h>
#include <dirent.h>
#include "misc.h"

/*
	Get the list of files (anything in fact) in a directory
	Return the number of entry placed in lst.

	Return -1 if the directory can't be opened.
*/
int dir_getlist (const char *path, SSTRINGS &lst)
{
	int ret = -1;
	DIR *fin = opendir(path);
	if (fin != NULL){
		struct dirent *dire = NULL;
		while ((dire = readdir(fin))!=NULL){
			lst.add (new SSTRING(dire->d_name));
		}
		closedir(fin);
		ret = lst.getnb();
	}
	return ret;
}

/*
	Get the list of files (anything in fact) in a directory beginning
	witht the same prefix
*/
int dir_getlist_p (const char *fpath, SSTRINGS &lst)
{
	char bufpath[PATH_MAX];
	strcpy (bufpath,fpath);
	char *last = strrchr (bufpath,'/');
	char *dirpath = bufpath;
	char *prefix = "";
	if (last != NULL){
		*last = '\0';
		prefix = last;
	}else{
		prefix = bufpath;
		dirpath = ".";
	}
	SSTRINGS tmp;
	int nb = dir_getlist (dirpath,tmp);
	int ret = -1;
	if (nb != -1){
		ret = 0;
		int lenprefix = strlen(prefix);
		for (int i=0; i<nb; i++){
			const char *p = tmp.getitem(i)->get();
			if (strncmp(prefix,p,lenprefix)==0){
				char tmppath[PATH_MAX];
				sprintf (tmppath,"%s/%s",dirpath,p);
				lst.add (new SSTRING(tmppath));
				ret++;
			}
		}
	}
	return ret;
}

