#pragma implementation
#include <stdlib.h>
#include <string.h>
#include "misc.h"
#include "confdb.h"

PUBLIC CONFOBJ::CONFOBJ (
	const char *_key,
	const char *_val)
{
	key.setfrom (_key);
	val.setfrom (_val);
}

/*
	Add a non-parsed line to the database
*/
PUBLIC void CONFDB::addline (const char *buf)
{
	char keyw[100];
	char *pt = str_copyword (keyw,buf);
	pt = str_skip(pt);
	ARRAY::add (new CONFOBJ(keyw,pt));
}

PUBLIC CONFDB::CONFDB(CONFIG_FILE &_fcfg)
{
	fcfg  = &_fcfg;
	/* #Specification: misc / CONFDB / intro
		The CONFDB object was designed to support the
		/etc/conf.linuxconf file. This save configuration
		information in an ascii file with a simple one line
		one record format.

		The line start with a key and the value(s) (words  or whatever)
		follow up to the end of the line. The key is separated
		from the value(s) by blank characters.
	*/
	FILE *fin = fcfg->fopen ("r");
	if (fin != NULL){
		char buf[500];
		int noline = 0;
		while (fgets(buf,sizeof(buf),fin)!=NULL){
			/* #Specification: /etc/conf.linuxconf / format
				/etc/conf.linuxconf is an ascii file. It
				contain all the information used to configured
				most services which lack a standard configuration
				file. Its format is simple

				#
				keyword value ...
				#

				The file is maintain by linuxconf.
				No comments or whatever are allowed.

				This mecanism is handled by the CONFDB
				object. It is expect to be used for
				other stuff than /etc/conf.linuxconf.
			*/
			noline++;
			strip_end (buf);
			if (buf[0] != '\0') addline (buf);
		}
		fclose (fin);
	}
}
/*
	Constructor used when the database is not simply read from a file
*/
PUBLIC CONFDB::CONFDB()
{
	fcfg = NULL;
}

PUBLIC CONFOBJ *CONFDB::getitem(int no)
{
	return (CONFOBJ*)ARRAY::getitem(no);
}

/*
	Update the configuration file
	Return -1 if any error.
*/
PUBLIC int CONFDB::save(PRIVILEGE *priv)
{
	int ret = -1;
	if (fcfg != NULL){
		FILE *fout = fcfg->fopen (priv,"w");
		if (fout != NULL){
			int nb = getnb();
			for (int i=0; i<nb; i++){
				CONFOBJ *o = getitem(i);
				fprintf (fout,"%s %s\n",o->key.get()
					,o->val.get());
			}
			ret = fclose (fout);
		}
	}
	return ret;
}

PUBLIC int CONFDB::save()
{
	return save(NULL);
}

/*
	Build a key
*/
static const char *confdb_bkey(const char *prefix, const char *key)
{
	/* #Specification: linuxconf / /etc/conf.linuxconf / keys
		The keyword of /etc/conf.linuxconf use a special
		format convention. With a dot notation, the keyword
		is splitted in two part: The first identify the
		system and the second represent one parameter of this
		system. This strategy prevent clashes between two
		systems.
	*/
	static char buf[100];
	strcpy (buf,prefix);
	strcat (buf,".");
	strcat (buf,key);
	return buf;
}

/*
	Find a record.
	Return NULL if not found.
*/
PUBLIC const char *CONFDB::getval(
	const char *prefix,
	const char *key,
	const char *defval)
{
	int nb = getnb();
	const char *bkey = confdb_bkey(prefix,key);
	for (int i=0; i<nb; i++){
		CONFOBJ *o = getitem(i);
		if (o->key.cmp(bkey)==0){
			defval = o->val.get();
			break;
		}
	}
	return defval;
}
/*
	Find a record.
	Return NULL if not found.
*/
PUBLIC const char *CONFDB::getval(const char *prefix, const char *key)
{
	return getval (prefix,key,NULL);
}
/*
	Locate one numeric configuration parameter.
	Return defval if not found.
*/
PUBLIC int CONFDB::getvalnum (
	const char *prefix,
	const char *key,
	int defval)
{
	const char *val = getval (prefix,key);
	if (val != NULL) defval = atoi(val);
	return defval;
}
/*
	Locate one numeric configuration parameter.
	Return defval if not found.
*/
PUBLIC double CONFDB::getvalf (
	const char *prefix,
	const char *key,
	double defval)
{
	const char *val = getval (prefix,key);
	if (val != NULL) defval = atof(val);
	return defval;
}

/*
	Locate all configuration parameter with the same key.
	Return the number found.
*/
PUBLIC int CONFDB::getall (
	const char *prefix,
	const char *key,
	SSTRINGS &lst,
	int copy)	// Take a copy of the values
{
	int ret = 0;
	if (!copy) lst.neverdelete();
	int nb = getnb();
	const char *bkey = confdb_bkey(prefix,key);
	for (int i=0; i<nb; i++){
		CONFOBJ *o = getitem(i);
		if (o->key.cmp(bkey)==0){
			SSTRING *val = &o->val;
			if (copy) val = new SSTRING (*val);
			lst.add (val);
			ret++;
		}
	}
	return ret;
}


/*
	Remove all entry with a given key.
*/
PUBLIC void CONFDB::removeall (const char *prefix, const char *key)
{
	const char *bkey = confdb_bkey(prefix,key);
	int nb = getnb();
	for (int i=0; i<nb; i++){
		CONFOBJ *o = getitem(i);
		if (o->key.cmp(bkey)==0){
			remove_del (o);
			i--;
			nb--;
		}
	}
}




/*
	Add one record to the configuration file
*/
PUBLIC void CONFDB::add (
	const char *prefix,
	const char *key,
	const char *val)
{
	const char *bkey = confdb_bkey(prefix,key);
	ARRAY::add (new CONFOBJ(bkey,val));
}

/*
	Add one record to the configuration file
*/
PUBLIC void CONFDB::add (
	const char *prefix,
	const char *key,
	const SSTRING &val)
{
	add (prefix,key,val.get());
}
/*
	Add one record to the configuration file
*/
PUBLIC void CONFDB::add (
	const char *prefix,
	const char *key,
	int val)
{
	char buf[20];
	sprintf (buf,"%d",val);
	add (prefix,key,buf);
}

/*
	Replace one record in the configuration file
*/
PUBLIC void CONFDB::replace (const char *prefix, const char *key, const char *val)
{
	removeall(prefix,key);
	add (prefix,key,val);
}

/*
	Replace one record in the configuration file
*/
PUBLIC void CONFDB::replace (const char *prefix, const char *key, int val)
{
	char buf[20];
	sprintf (buf,"%d",val);
	replace (prefix,key,buf);
}
/*
	Replace one record in the configuration file
*/
PUBLIC void CONFDB::replace (const char *prefix, const char *key, double val)
{
	char buf[30];
	sprintf (buf,"%f",val);
	replace (prefix,key,buf);
}
/*
	Replace one record in the configuration file
*/
PUBLIC void CONFDB::replace (
	const char *prefix,
	const char *key,
	const SSTRING &val)
{
	replace (prefix,key,val.get());
}

/*
	Replace one record in the configuration file
*/
PUBLIC void CONFDB::replace (
	const char *prefix,
	const char *key,
	const SSTRINGS &vals)
{
	removeall(prefix,key);
	int nb = vals.getnb();
	for (int i=0; i<nb; i++) add (prefix,key,*vals.getitem(i));
}
