#include <dialog.h>
#include "internal.h"
#include <userconf.h>
#include "mailconf.m"

static MAILCONF_HELP_FILE help_basic ("basic");
extern CONFIG_FILE f_sendmail;

/*
	Define the help list for the available mailer
*/
void basic_setmailer (FIELD_COMBO *comb)
{
	comb->addopt ("esmtp",MSG_U(F_ESMTP,"Enhanced smtp"));
	comb->addopt ("smtp",MSG_U(F_SMTP,"Normal smtp"));
	comb->addopt ("uucp-dom",MSG_U(F_MODERNUUCP,"Recommended modern UUCP"));
	comb->addopt ("uucp",MSG_U(F_OLDUUCP,"Old uucp"));
}


PUBLIC int MAILCONF::basicedit()
{
	DIALOG dia;
	dia.newf_title ("",MSG_U(F_WHENSEND,"When sending"));
	dia.newf_str (MSG_U(F_PRESENT,"Present your system as"),mailas);
	dia.newf_str (MSG_U(F_MAILHOST,"mail host"),mailhost);
	dia.newf_str (MSG_U(F_SMARTHOST,"Smart host"),smarthost);
	FIELD_COMBO *comb = dia.newf_combo (MSG_U(F_SMARTMAIL
		,"Smart host mailer"),smartmailer);
	basic_setmailer (comb);
	dia.newf_title ("",MSG_U(T_FEATURES,"Features"));
	dia.newf_chk ("",features.uucpnobatch,MSG_U(F_NOBATCH
		,"no batching for uucp mail"));
	dia.newf_num (MSG_U(F_MAXSIZE,"Max size of uucp messages")
		,features.uucpmax);
	dia.newf_str (MSG_U(F_DELIVER,"Deliver locally to users")
		,users.deliverlocal);
	dia.newf_str (MSG_U(F_NOMASQ,"No masquerade from users")
		,users.dontmasque);

	dia.newf_chk (MSG_U(F_USEMTABLE,"special routing database")
		,features.mailertable,MSG_U(I_USEMTABLE,"Enabled"));
	comb = dia.newf_combo (MSG_U(F_SPECIAL
		 ,"Special routing database format")
		,features.dbformat);
	comb->addopt ("btree");
	comb->addopt ("hash");
	comb->addopt ("dbm");
	comb->addopt ("NIS");

	comb = dia.newf_combo (MSG_U(F_LOCALMAILER,"Local delivery agent")
		,deliver);
	comb->addopt ("deliver","/usr/bin/deliver");
	comb->addopt ("mail.local","/bin/mail.local");
	comb->addopt ("procmail","/usr/bin/procmail");

	dia.newf_title ("",MSG_U(T_DNSFEATURES,"DNS features"));
	dia.newf_chk ("",features.dnsneeded,MSG_U(F_WAITDNS,"wait for DNS"));
	dia.newf_chk ("",features.nodns,MSG_U(F_NODNS,"don't use DNS"));
	#ifdef DNS_LIMIT
		/* #Specification: mailconf / limiting DNS scope
			An attempt was made to somewhat limit
			the DNS usage of sendmail. One way
			is to desactivate DNS canonification in
			ruleset 96. mailconf allows this.

			This is fine for small site with a single
			mailhost for example.

			Larger site may have several mailhost
			with several subdomain and yet no full
			connectivity to the internet, and to make
			things worst, have sometime some connectivity
			on the internet. It means that the DNS knows
			how to resolv any name but will generally
			fail, unless someone establish the internet
			connection.

			So on one hand, we need DNS flexibility and
			MXs, and on the other hand we must avoid it
			to make sure sendmail won't timeout needlessly.
			In fact, in this setup, email is either local
			or through a forwarder which knows better anyway.

			This half DNS solution is still a problem.
			One solution would be to restart the DNS
			with or without a root.cache file when
			connected or not connected to the internet.

			If this problem rings bell to you, I would
			be happy to talk about it. I am pretty sure
			something generally useful would come out of  it.
		*/
		dia.newf_title ("",MSG_U(F_LIMITDNS,"Limit DNS for those domains"));
		for (int d=0; d<MAXDNSFOR; d++){
			dia.newf_str ("",dnsfor[d]);
		}
	#endif

	dia.newf_title ("",MSG_U(T_WHENREC,"When receiving"));
	{
		alias.add (new SSTRING);
		const char *title = MSG_U(F_YOURSYS,"Aliases for your system");
		int nb_empty = 3;	// Always 3 empty line available for convenience
		for (int i=0; i<alias.getnb(); i++){
			SSTRING *s = alias.getitem(i);
			dia.newf_str (title,*s);
			title = "";
			if (s->is_empty()) nb_empty--;
		}
		for (int e=0; e<nb_empty; e++){
			SSTRING *s = new SSTRING;
			alias.add (s);
			dia.newf_str ("",*s);
		}
	}

	dia.addwhat (MSG_U(I_ADDEMPTY,"an empty alias line"));
	int ret = 0;
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit(
			MSG_U(T_BASIC,"Basic Sendmail configuration")
			,""
			,help_basic
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_ADD);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ADD){
			for (int e=0; e<3; e++){
				SSTRING *s = new SSTRING;
				alias.add (s);
				dia.newf_str ("",*s);
			}
		}else if (code == MENU_ACCEPT){
			if (perm_rootaccess(MSG_U(P_CONFMAIL,"configure sendmail"))){
				for (int i=0; i<alias.getnb(); i++){
					SSTRING *s = alias.getitem(i);
					if (s->is_empty()){
						alias.remove_del(s);
						i--;
					}
				}
				write ();
				ret = 1;
				break;
			}
		}
	}
	if (ret != 1) dia.restore();
	return ret;
}

