#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <dialog.h>
#include "fstab.h"
#include "../paths.h"
#include <userconf.h>
#include "internal.h"
#include "fstab.m"

FSTAB_HELP_FILE help_mount ("mountpoint");
extern FSTAB_HELP_FILE help_fstab;

/*
	Return the numeric value of a SSTRING or a default value
*/
static int fstab_get_opt_val(SSTRING &str, int defval)
{
	int ret = defval;
	if (!str.is_empty()){
		ret = str.getval();
	}
	return ret;
}

static int fstab_rootaccess()
{
	return perm_rootaccess("to maintain volumes");
}

/*
	Edit one entry of the /etc/fstab file.
	Return 0 if the user accepted the changes
	Return -1 if the user escape the dialog
	Return 1 if the user want to delete this entry
*/
PUBLIC int FSTAB_ENTRY::edit(FSTAB_ENTRY_TYPE fstype)
{
	DIALOG dia;
	char server[100];
	char volume[100];
	if (fstype == FSTAB_ENTRY_NFS){
		source.copy (server);
		char *pt = strchr(server,':');
		volume[0] = '\0';
		if (pt != NULL){
			*pt++ = '\0';
			strcpy (volume,pt);
		}			
		dia.newf_str (MSG_U(F_SERVER,"Server"),server,sizeof(server)-1);
		dia.newf_str (MSG_U(F_VOLUME,"Volume"),volume,sizeof(volume)-1);
		type.setfrom ("nfs");
	}else if (fstype == FSTAB_ENTRY_SAMBA){
		char buf[200];
		source.copy (buf);
		char *pt = buf;
		while (*pt == '/') pt++;
		strcpy (server,pt);
		pt = strchr (server,'/');
		volume[0] = '\0';
		if (pt != NULL){
			*pt++ = '\0';
			strcpy (volume,pt);
		}			
		dia.newf_str (MSG_R(F_SERVER),server,sizeof(server)-1);
		dia.newf_str (MSG_U(F_SHARE,"Share"),volume,sizeof(volume)-1);
		type.setfrom ("smbfs");
	}else{
		FIELD_COMBO *co = dia.newf_combo(MSG_U(F_PARTITION,"Partition")
			,source);
		PARTITIONS *parts = partition_load();
		for (int i=0; i<parts->getnb(); i++){
			PARTITION *p = parts->getitem(i);
			char str[80];
			p->formatinfo (str);
			if (fstype == FSTAB_ENTRY_SWAP){
				if (p->isswap()) co->addopt(p->getdevice(),str);
			}else{
				if (p->isdos() || p->islinux()){
					co->addopt(p->getdevice(),str);
				}
			}
		}
		if (fstype == FSTAB_ENTRY_SWAP){
			type.setfrom ("swap");
			mpoint.setfrom ("none");
		}else{
			FIELD_COMBO *cot = dia.newf_combo(MSG_U(F_TYPE,"Type"),type);
			cot->addopt("ext2",MSG_U(F_EXT2,"Standard Linux"));
			cot->addopt("minix",MSG_U(F_MINIX,"Sometime for floppy"));
			cot->addopt("msdos"," ");
			cot->addopt("umsdos",MSG_U(F_UMSDOS,"Superset of msdos"));
			cot->addopt("hpfs",MSG_U(F_OS2,"OS/2 High Performance FS"));
			cot->addopt("sysv",MSG_U(F_UNIXV,"Unix system V old fs"));
			cot->addopt("xiafs",MSG_U(F_XIAFS,"Old linux fs"));
			cot->addopt("iso9660",MSG_U(F_ISOFS,"Cdrom file system"));
		}
	}
	if (fstype != FSTAB_ENTRY_SWAP){
		dia.newf_str (MSG_U(F_MPOINT,"Mount point"),mpoint);
		dia.newf_title ("",MSG_U(T_GENOPTIONS,"General options"));
		dia.newf_chk (MSG_U(F_OPTIONS,"Options"),bool_opt.readonly
			,MSG_U(F_READONLY,"Read only"));
		dia.newf_chk ("",bool_opt.user,MSG_U(F_USERMNT,"User mountable"));
		dia.newf_chk ("",bool_opt.noauto,MSG_U(F_BOOTTIME,"Not mount at boot time"));
		dia.newf_chk ("",bool_opt.noexec,MSG_U(F_NOEXEC,"No program allowed to execute"));
		dia.newf_chk ("",bool_opt.nodev,MSG_U(F_NOSPC,"No special device file support"));
		dia.newf_chk ("",bool_opt.nosuid,MSG_U(F_NOSUID,"No setuid programs allowed"));
	}
	SSTRING msdos_uid,msdos_gid,msdos_umask;
	SSTRING nfs_rsize,nfs_wsize;
	GROUPS groups;
	groups.sortbyname();
	USERS users;
	users.sortbyname();
	if (fstype == FSTAB_ENTRY_LOCAL){
		dia.newf_num (MSG_U(F_DUMPFREQ,"Dump frequency"),dumpfreq);
		dia.newf_num (MSG_U(F_CHKPRI,"Fsck priority"),fsckpriority);
		dia.newf_title ("",MSG_U(T_MSOPT,"(U)MsDOS and HPFS options")); 
		USER *user = users.getfromuid(msdos_opt.uid);
		if (user != NULL){
			msdos_uid.setfrom(user->getname());
		}else if (msdos_opt.uid != MSDOS_OPT_UNUSE){
			msdos_uid.setfrom(msdos_opt.uid);
		}
		FIELD_COMBO *cv = dia.newf_combo (MSG_U(F_DEFUID,"default user id")
			,msdos_uid);
		int i;
		for (i=0; i<users.getnb(); i++){
			user = users.getitem(i);
			cv->addopt(user->getname(),user->getgecos());
		}
		GROUP *grp = groups.getfromgid(msdos_opt.gid);
		if (grp != NULL){
			msdos_gid.setfrom(grp->getname());
		}else if(msdos_opt.gid != MSDOS_OPT_UNUSE){
			msdos_gid.setfrom(msdos_opt.gid);
		}
		cv = dia.newf_combo (MSG_U(F_DEFGID,"default group id"), msdos_gid);
		for (i=0; i<groups.getnb(); i++){
			grp = groups.getitem(i);
			cv->addopt(grp->getname());
		}
		if (msdos_opt.perm != MSDOS_OPT_UNUSE){
			msdos_umask.setfrom (msdos_opt.perm);
		}
		dia.newf_str (MSG_U(F_DEFPERM,"default permission") , msdos_umask);
		FIELD_COMBO *conv = dia.newf_combo (
			MSG_U(F_TRAMODE,"translation mode")
			,msdos_opt.conv);
		conv->addopt ("binary",MSG_U(F_NOTRA,"No file translation"));
		conv->addopt ("auto",MSG_U(F_EXTTRA,"Translate based on extension"));
		conv->addopt ("text",MSG_U(F_ALWTRANS,"Always translate"));
	}else if (fstype == FSTAB_ENTRY_NFS){
		dia.newf_title ("",MSG_U(T_NFSOPT,"NFS options")); 
		dia.newf_chk ("",nfs_opt.soft,MSG_U(F_SOFTMNT,"Soft mount"));
		dia.newf_chk ("",nfs_opt.bg,MSG_U(F_BGMOUNT,"Background mount"));
		if (nfs_opt.rsize != NFS_OPT_UNUSE){
			nfs_rsize.setfrom(nfs_opt.rsize);
		}
		dia.newf_str (MSG_U(F_READSIZE,"read size"),nfs_rsize);
		if (nfs_opt.wsize != NFS_OPT_UNUSE){
			nfs_wsize.setfrom(nfs_opt.wsize);
		}
		dia.newf_str ("write size",nfs_wsize);
	}
	dia.newf_title ("","");
	dia.newf_str(MSG_U(F_OTHEROPT,"Other options"),options);
	dia.newf_str(MSG_U(F_COMMENT,"Comment"),comment);
	int ret = -1;
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit(
			MSG_U(T_VOLSPEC,"Volume specification")
			,MSG_U(I_VOLSPEC,"You must enter the specification of a volume\n"
			 "or partition and the position (mount point)\n"
			 "where you want to install this volume\n"
			 "in the directory structure of this workstation\n")
			,help_mount
			,nof,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_DEL);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_DEL){
			if (xconf_areyousure(MSG_U(Q_DELENTRY
				,"Confirm deletion of /etc/fstab entry"))){
				ret = 1;
				break;
			}
		}else if (code==MENU_ACCEPT){
			if (!fstab_rootaccess()) continue;
			if (fstype == FSTAB_ENTRY_NFS){
				char buf[200];
				sprintf (buf,"%s:%s",server,volume);
				source.setfrom (buf);
				nfs_opt.rsize = fstab_get_opt_val(nfs_rsize
					,NFS_OPT_UNUSE);
				nfs_opt.wsize = fstab_get_opt_val(nfs_wsize
					,NFS_OPT_UNUSE);
			}else if (fstype == FSTAB_ENTRY_SAMBA){
				char buf[200];
				sprintf (buf,"//%s/%s",server,volume);
				source.setfrom (buf);
			}else{
				GROUP *grp = groups.getitem(msdos_gid.get());
				if (grp != NULL){
					msdos_opt.gid = grp->getgid();
				}else{
					msdos_opt.gid = fstab_get_opt_val(
						msdos_gid,MSDOS_OPT_UNUSE);
				}
				USER *usr = users.getitem(msdos_uid.get());
				if (usr != NULL){
					msdos_opt.uid = usr->getuid();
				}else{
					msdos_opt.uid = fstab_get_opt_val(
						msdos_uid,MSDOS_OPT_UNUSE);
				}
				msdos_opt.perm = fstab_get_opt_val(
						msdos_umask,MSDOS_OPT_UNUSE);
			}
			valid = 1;
			if (check() == 0){
				ret = 0;
				break;
			}
		}
	}
	if (ret != 0) dia.restore();
	return ret;
}

/*
	Edit, add, delete entry of /etc/fstab.
	seltype: 0 local partition
		 1 Remote volume
		 2 swap
*/
PUBLIC void FSTAB::edit (FSTAB_ENTRY_TYPE fstype)
{
	int choice = 0;
	while (1){
		int nb = getnb();
		const char *tb[100];
		static const char *tbfs[]={
			MSG_U(T_LOCALVOL,"Local volume"),
			MSG_U(T_NFSVOL,"NFS volume"),
			MSG_U(T_SMBVOL,"SMB volume"),
			MSG_U(T_SWAPSPACE,"Swap space"),
			MSG_U(T_NOVELL,"NOVELL volume")
		};
		int i;
		//int maxlen1 = 0;
		//int maxlen2 = 0;
		int nbshow = 0;
		FSTAB_ENTRY *tbsel[50];
		// Collect viewable entries and get format information
		for (i=0; i<nb; i++){
			FSTAB_ENTRY *ent = getitem(i);
			if (ent->is_valid()
				&& ent->gettype() == fstype){
				#if 0
				int len1 = strlen(ent->getmpoint());
				int len2 = strlen(ent->getfs());
				if (len1 > maxlen1) maxlen1 = len1;
				if (len2 > maxlen2) maxlen2 = len2;
				#endif
				tbsel[nbshow++] = ent;
			}
		}
		int j=0;
		PARTITIONS *parts = partition_load();
		for (i=0; i<nbshow; i++){
			FSTAB_ENTRY *ent = tbsel[i];
			const char *source = ent->getsource();
			tb[j++] = source;
			char buf[100];
			PARTITION *p = parts->getitem(source);
			char str[80];
			str[0] = '\0';
			struct stat s;
			if (p != NULL){
				p->formatinfo (str);
			}else if (stat(source,&s)!=-1){
				sprintf (str,"%7ldM",s.st_size/(1024*1024l));
			}
			sprintf (buf,"%s\t%s\t%s",ent->getmpoint(),ent->getfs(),str);
			tb[j++] = strdup (buf);
		}
		tb[j] = NULL;
		MENU_STATUS code = xconf_menu (
			tbfs[fstype] 
			,MSG_U(I_MOUNTS,"You can edit, add, or delete mounts")
			,help_fstab
			,NULL
			,NULL
			,NULL
			,MSG_U(I_ADDDEF,"to add a new definition")
			,tb,choice);
		for (i=0; i<nbshow; i++){
			free ((char*)tb[i*2+1]);
		}
		if (code == MENU_ESCAPE || code == MENU_QUIT){
			break;
		}else if (code == MENU_OK){
			FSTAB_ENTRY *ent = tbsel[choice];
			int ok = ent->edit(fstype);
			if (ok != -1){
				if (ok == 1) remove_del (ent);
				write();
			}
		}else if (fstab_rootaccess()){
			if (code == MENU_ADD){
				FSTAB_ENTRY *ent = new FSTAB_ENTRY();
				if (ent->edit(fstype)==0){
					add (ent);
					write();
				}else{
					delete ent;
				}
			}
		}
	}
}

/*
	Edit, add, delete entry of /etc/fstab
*/
void fstab_edit (FSTAB_ENTRY_TYPE fstype)
{
	FSTAB fs;
	fs.edit (fstype);
}

