#pragma implementation
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include "fstab.h"
#include <userconf.h>
#include <netconf.h>
#include "fstab.m"

static FSTAB_HELP_FILE help_access ("access");

void fstab_edit()
{
	/* #Specification: netconf / principal
		The user must select one of these choice

		bla bla
	*/
	int choice=0;
	while (1){
		static const char *local_partition = MSG_U(M_LOCALD,"local drive");
		static const char *remote_nfs = MSG_U(M_NFSVOL,"nfs volume");
		static const char *samba_fs   = MSG_U(M_SAMBA,"samba volume (WfWg)");
		static const char *swap_volume = MSG_U(M_SWAP,"swap files and partitions");
		static const char *fixperm = MSG_U(M_FIXPERM,"some file permissions");
		static const char *menuopt[]={
			MSG_U(M_ACCESS,"Access"),		local_partition,
			" ",							remote_nfs,
			" ",							samba_fs,
			MSG_U(M_CONFIGURE,"Configure"),	swap_volume,
			"-",		"",
			MSG_U(M_CHECK,"Check"),			fixperm,
			NULL
		};
		MENU_STATUS code = xconf_menu (
			MSG_U(T_FSCONF,"Filesystem configurator")
			,MSG_U(I_FSCONF,"This package allows you to configure\n"
			 "which partition and network volume your workstation\n"
			 "can access")
			,help_access
			,menuopt,choice);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
			const char *key = menuopt[choice*2+1];
			if (key == local_partition){
				fstab_edit (FSTAB_ENTRY_LOCAL);
			}else if (key == remote_nfs){
				fstab_edit (FSTAB_ENTRY_NFS);
			}else if (key == samba_fs){
				xconf_notice (MSG_U(N_NOSAMBA
					,"Samba management not available\n"
					"at this time"));
			}else if (key == swap_volume){
				fstab_edit (FSTAB_ENTRY_SWAP);
			}else if (key == fixperm){
				if (perm_rootaccess (
					MSG_U(P_FIXPERM,"To fix file permission"))){
					simul_init();
					fixperm_check();
					int ok = simul_prompt();
					if (ok==1){
						net_setshowmode (0);
						fixperm_check();
						net_setshowmode (1);
					}else if (ok == -1){
						xconf_notice (MSG_U(N_ALLISOK,"All is ok"));
					}
				}
			}
		}
	}
}

int fstab_main(int argc, char *argv[])
{
	if (netconf_mainaccess()){
		if (argc == 1){
			fstab_edit();
		}else if (argc == 2 && strcmp(argv[1],"--check")==0){
			fstab_check();
		}else{
			xconf_error (
				MSG_U(E_FSTABARG
					,"Invalid argument\n\n"
					 "fsconf<enter>\n"
					 "fsconf --check<enter>\n")
				);
		}
	}
	return 0;
}


