#pragma interface
#ifndef FIXPERM_H
#define FIXPERM_H

#ifndef MISC_H
	#include <misc.h>
#endif

struct SPEC_ONE;

class FIXPERM_TASK{
public:
	FIXPERM_TASK *next;
	virtual int check(bool boottime)=0;
	/*~PROTOBEG~ FIXPERM_TASK */
public:
	FIXPERM_TASK (void);
	/*~PROTOEND~ FIXPERM_TASK */
};

enum FPERM_TYPE { FPERM_FILE, FPERM_DIR};

struct FIXPERM_OPTIONS{
	bool boot;
	bool recurse;
	bool required;
};


class FIXPERM_SPEC: public ARRAY_OBJ{
	friend class FIXPERM_SPECS;
	SSTRING path;
	SSTRING owner;
	SSTRING group;
	FPERM_TYPE type;
	int perm;
	int dev;
	FIXPERM_OPTIONS opts;
	int uid;
	int gid;
	bool valid;		// Is this record valid
	/*~PROTOBEG~ FIXPERM_SPEC */
public:
	FIXPERM_SPEC (SPEC_ONE&sp);
	int check (void);
	int create (void);
private:
	void parsedev (SPEC_ONE&sp);
public:
	/*~PROTOEND~ FIXPERM_SPEC */
};

class FIXPERM_SPECS: public ARRAY{
	/*~PROTOBEG~ FIXPERM_SPECS */
public:
	FIXPERM_SPECS (const char *fname);
	FIXPERM_SPECS (void);
	void addline (const char *buf);
private:
	void addline (const char *buf, SPEC_ONE&sp);
public:
	int check (bool boottime);
	int check (void);
	FIXPERM_SPEC *getitem (int no);
	/*~PROTOEND~ FIXPERM_SPECS */
};

#endif

