#include "diadef.h"
#include "dialog.h"
#include "dialog.m"

class FIELD_MENU: public FIELD_STRING{
	int *tbcol;	// Width of each columns
	char *tag;
	/*~PROTOBEG~ FIELD_MENU */
public:
	FIELD_MENU (const char *_tag, const char *_str);
protected:
	void dokey (WINDOW *, int , FIELD_MSG&);
public:
	void drawgen (WINDOW *win, int selected);
	void drawtxt (WINDOW *dialog);
	void format_htmlkey (char *key, int);
	const char *getmenustr (void);
protected:
	int getwidths (int tb[]);
public:
	void html_draw (int nof);
	int html_validate (int);
protected:
	void restore (void);
	void save (void);
public:
	void setcursor (WINDOW *dialog);
	void setwidths (int total_width, int tb[]);
	void unselect (WINDOW *dialog);
	~FIELD_MENU (void);
	/*~PROTOEND~ FIELD_MENU */
};

PUBLIC FIELD_MENU::FIELD_MENU(
	const char *_tag,
	const char *_str)
	: FIELD_STRING ("",(char*)_str,60)
{
	tag = strdup(_tag);
	setwidths (strlen(_tag)+strlen(buf),NULL);	// Fixed to some value until
											// setwidth1() is called, much later
	set_readonly();
}

PUBLIC FIELD_MENU::~FIELD_MENU()
{
	free (tag);
}

/*
	Build a key that uniquely identify this field in the dialog
*/
PUBLIC void FIELD_MENU::format_htmlkey(char *key, int)
{
	html_formatkey (key,"%s %s",tag,buf);
}

/*
	Fix the final disposition of the menu item
	(The start of the second column)
*/
PUBLIC void FIELD_MENU::setwidths (int total_width, int tb[])
{
	tbcol = tb;
	box.width = total_width;
}
/*
	Get the width of each sub-columns of the second column.
	Return the number of sub-columns.
*/
PROTECTED int FIELD_MENU::getwidths (int tb[])
{
	int ret = 1;	// The tag is always one column
	char *pt = buf;
	char *pt0 = pt;
	tb[0] = strlen(tag)+2;
	while (*pt != '\0'){
		if (*pt == '\t'){
			tb[ret] = (int)(pt-pt0)+1;
			ret++;
			pt0 = pt+1;
		}
		pt++;
	}
	tb[ret++] = (int)(pt - pt0)+1;
	return ret;
}
/*
	Return the second string of a menu item
*/
PUBLIC const char *FIELD_MENU::getmenustr()
{
	return str;
}

/*
	A FIELD_MENU is not really a string editor.
	The following function are just there to prevent writing
	over constant string.
*/
PROTECTED void FIELD_MENU::save()
{
}
PROTECTED void FIELD_MENU::restore()
{
}
PROTECTED void FIELD_MENU::dokey(
	WINDOW *,
	int,
	FIELD_MSG & )
{
}
/*
	Print menu item
*/
PUBLIC void FIELD_MENU::drawgen(WINDOW *win, int selected)
{
	wattrset(win, menubox_attr);
	wmove(win, box.y, box.x);
	int i;
	// Cleanup
	for (i = 0; i < box.width; i++) waddch(win, ' ');
	wmove(win, box.y, box.x);
	char *pttag = tag;
	if (tag[0] != ' ' && tag[0] != '\0'){
		wattrset(win, selected ? tag_key_selected_attr : tag_key_attr);
		waddch(win, tag[0]);
		pttag++;
	}
	wattrset(win, selected ? tag_selected_attr : tag_attr);
	waddstr(win, pttag);
	wmove(win, box.y, box.x + tbcol[0]);
	wattrset(win, selected ? item_selected_attr : item_attr);
	const char *pt = buf;
	int nocol = 1;
	int ptcol = 0;
	int curcol = tbcol[0];
	while (*pt != '\0' && curcol < box.width){
		if (*pt == '\t'){
			int wcol = tbcol[nocol];
			while (ptcol < wcol){
				waddch(win,' ');
				ptcol++;
				curcol++;
			}
			ptcol = 0;
			nocol++;
		}else{
			waddch(win, *pt);
			ptcol++;
			curcol++;
		}
		pt++;
	}
	wmove(win, box.y, box.x);
}

PUBLIC void FIELD_MENU::unselect(WINDOW *dialog)
{
	drawgen(dialog,0);
}

PUBLIC void FIELD_MENU::setcursor(WINDOW *dialog)
{
	drawgen (dialog,1);
}
PUBLIC void FIELD_MENU::drawtxt(WINDOW *dialog)
{
	drawgen (dialog,0);
}

PUBLIC void FIELD_MENU::html_draw(int nof)
{
	char key[300];
	format_htmlkey (key,nof);
	html_printf ("<tr><td>");
	if (may_select){
		html_setaref (key,tag);
	}else{
		html_printf ("%s",tag);
	}

	const char *pt = buf;
	char tdbuf[300];
	char *ptdst = tdbuf;
	html_printf ("<td>");
	while (*pt != '\0'){
		if (*pt == '\t'){
			*ptdst = '\0';
			if (may_select){
				html_setaref (key,tdbuf);
			}else{
				html_printf ("%s",tdbuf);
			}
			html_printf ("<td>");
			ptdst = tdbuf;
		}else{
			*ptdst++ = *pt;
		}
		pt++;
	}
	*ptdst = '\0';
	if (may_select){
		html_setaref (key,tdbuf);
	}else{
		html_printf ("%s",tdbuf);
	}

	html_printf ("\n");
}
PUBLIC int FIELD_MENU::html_validate(int)
{
	return 0;
}
/*
	Evaluate the width of the first column.
	Options are organisez in 2 columns.
*/
PRIVATE void DIALOG::fixwidth1()
{
	int i;
	memset (tbcol,0,sizeof(tbcol));
	nbcol = 0;
	int n = getnb();
	for (i=0; i<n; i++){
		FIELD *f = getitem(i);
		int tbf[20];
		int nbc = f->getwidths(tbf);
		for (int c=0; c<nbc; c++){
			if (tbf[c] > tbcol[c]) tbcol[c] = tbf[c];
		}
		if (nbc > nbcol) nbcol = nbc;
	}
	int max_width = 0;
	for (i=0; i<nbcol; i++) max_width += tbcol[i];
	if (max_width > COLS - 6) max_width = COLS - 6;
	for (i=0; i<n; i++) getitem(i)->setwidths(max_width,tbcol);
}

/*
	Add a new menu item to a dialog

	You will have to use the DIALOG::editmenu instead of just
	DIALOG::edit() or your dialog will lack some buttons and won't
	be layout properly.
*/
PUBLIC void DIALOG::new_menuline (
	const char *prompt1,
	const char *prompt2,
	int may_select)
{
	if (strcmp(prompt1,"-")==0){
		/* #Specification: dialog / menus / splitter
			If the first member of a menu entry
			is a single '-', this entry is
			drawn as a full splitter line

			The second entry will be used as the
			splitter title.
		*/
		newf_title ("",prompt2);
	}else{
		if (prompt1[0] == '\0') prompt1 = " ";
		FIELD_MENU *men = new FIELD_MENU (prompt1,prompt2);
		men->set_selectable (may_select);
		add (men);
	}
}
/*
	Add a new menu item to a dialog

	You will have to use the DIALOG::editmenu instead of just
	DIALOG::edit() or your dialog will lack some buttons and won't
	be layout properly.
*/
PUBLIC void DIALOG::new_menuitem (const char *prompt1, const char *prompt2)
{
	new_menuline (prompt1,prompt2,1);
}
/*
	Add a new info line in a menu (non selectable)
*/
PUBLIC void DIALOG::new_menuinfo (const char *prompt1, const char *prompt2)
{
	new_menuline (prompt1,prompt2,0);
}
/*
	Add a new menu item to a dialog

	You will have to use the DIALOG::editmenu instead of just
	DIALOG::edit() or your dialog will lack some buttons and won't
	be layout properly.
*/
PUBLIC void DIALOG::new_menuitem (const char *prompt1, const SSTRING &prompt2)
{
	new_menuitem (prompt1,prompt2.get());
}
PUBLIC void DIALOG::new_menuitem (const SSTRING &prompt1, const SSTRING &prompt2)
{
	new_menuitem (prompt1.get(),prompt2);
}
/*
	Add a bunch of menu option to the menu
*/
PUBLIC void DIALOG::new_menuitems (const char *opt[])
{
	for (int i=0; opt[i] != NULL; i+=2){
		new_menuitem (opt[i],opt[i+1]);
	}
}

/*
	Return the second string of a menu item
*/
PUBLIC const char *DIALOG::getmenustr(int choice)
{
	const char *ret = NULL;
	if (choice >=0 && choice < getnb()){
		ret = getitem(choice)->getmenustr();
	}
	return ret;
}

/*
	Record a small help for the Save button
*/
PUBLIC void DIALOG::savewhat (const char *help)
{
	what.save.setfrom (help);
}
/*
	Record a small help for the Del button
*/
PUBLIC void DIALOG::delwhat (const char *help)
{
	what.del.setfrom (help);
}
/*
	Record a small help for the Ins button
*/
PUBLIC void DIALOG::inswhat (const char *help)
{
	what.ins.setfrom (help);
}
/*
	Record a small help for the Add button
*/
PUBLIC void DIALOG::addwhat (const char *help)
{
	what.add.setfrom (help);
}
static void append_what (
	int &options,
	int optval,
	SSTRING &str,
	const char *msg,
	SSTRING &explan)
{
	if (!str.is_empty()){
		char buf[100];
		sprintf (buf,MSG_U(I_SELECT
			,"\nSelect [%s] to %s %s"),msg,msg,str.get());
		options |= optval;
		explan.append (buf);
	}
}

/*
	Edit a menu
*/
PUBLIC MENU_STATUS DIALOG::editmenu(
	MENU_CONTEXT context,
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,
	int &sel,	// Will hold the selection or -1 if escape
			// It must already contains the initial selection
	int  options)	// MENUBUT_ADD | MENUBUT_INS | MENUBUT_DEL | MENUBUT_SAVE
{
	SSTRING tmp_explan (prompt);
	int spc_options = 0;
	append_what (spc_options,MENUBUT_SAVE,what.save
		,MSG_U(I_SAVE,"save"),tmp_explan);
	append_what (spc_options,MENUBUT_ADD,what.add
		,MSG_U(I_ADD,"add"),tmp_explan);
	append_what (spc_options,MENUBUT_INS,what.ins
		,MSG_U(I_INS,"ins"),tmp_explan);
	append_what (spc_options,MENUBUT_DEL,what.del
		,MSG_U(I_DEL,"del"),tmp_explan);
	module_setmenu (*this,context);
	fixwidth1();
	MENU_STATUS ret = MENU_ESCAPE;
	while (1){
		ret = edit (title,tmp_explan.get(),helpfile,sel
			,options|spc_options|MENUBUT_OK|MENUBUT_QUIT);
		if (ret != MENU_OK){
			break;
		}else if (!module_domenu(context,getmenustr(sel))){
			break;
		}
	}
	return ret;
}
#if 0

PUBLIC MENU_STATUS DIALOG::editmenu(
	MENU_CONTEXT context,
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,
	int &sel,	// Will hold the selection or -1 if escape
			// It must already contains the initial selection
	int  options)	// MENUBUT_ADD | MENUBUT_INS | MENUBUT_DEL | MENUBUT_SAVE
{
	return editmenu (context,title,prompt,helpfile,sel,options);
}
#endif
PUBLIC MENU_STATUS DIALOG::editmenu(
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,
	int &sel,	// Will hold the selection or -1 if escape
			// It must already contains the initial selection
	int  options)	// MENUBUT_ADD | MENUBUT_INS | MENUBUT_DEL | MENUBUT_SAVE
{
	return editmenu (MENU_UNKNOWN,title,prompt,helpfile,sel,options);
}

/*
 * Display a menu for choosing among a number of options
 * Return	MENU_OK, MENU_QUIT or MENU_ESCAPE
 * Depending on the options parameter, may return MENU_INS, MENU_SAVE
 * 	MENU_ADD or MENU_DEL.
 */
MENU_STATUS dialog_menu(
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,
	int  options,	// MENUBUT_ADD | MENUBUT_INS | MENUBUT_DEL | MENUBUT_SAVE
	int item_no,
	char **items,
	int &sel)	// Will hold the selection or -1 if escape
			// It must already contains the initial selection
{
	DIALOG dia;
	for (int i=0; i<item_no; i++){
		dia.new_menuitem(items[i*2],items[i*2+1]);
	}
	return dia.editmenu (MENU_UNKNOWN,title,prompt,helpfile,sel,options);
}


#ifdef TEST

int main (int argc, char *argv[])
{
	int ret,choice=0;
	static char *tb[]={
		"a",	"message",
		"allo",	"alal",
		"b",	"bbbbbb",
		"bozo",	"bzbzbzbz",
		"c",	"coco",
		"coco",	"cocococococ",
		"d",	"dddd",
		"dozo",	"dozozododo",
	};
	init_dialog();
	if (argc == 2){
		dialog_settimeout(atoi(argv[1]), '\n');
	}
	ret  = dialog_menu(
		"This is a test"
		,"Are you\nsure you want to exit"
		,"/tmp/dialog.bak"
		,MENUBUT_SAVE
		,8,tb,choice);
	ret  = dialog_menu(
		"This is a test"
		,"Are you\nsure you want to exit\n"
		,"/tmp/dialog.bak"
		,MENUBUT_SAVE | MENUBUT_ADD | MENUBUT_DEL
		,8,tb,choice);


	endwin();
	printf ("ret = %d choice = %d\n",ret,choice);
	return 0;
}

#endif


