#include "diadef.h"
#include "dialog.h"

class FIELD_TITLE: public FIELD_STRING{
	/*~PROTOBEG~ FIELD_TITLE */
public:
	FIELD_TITLE (const char *_prompt,
		 const char *_str);
	void drawtxt (WINDOW *win);
	void html_draw (int);
	int html_validate (int);
	/*~PROTOEND~ FIELD_TITLE */
};

PUBLIC FIELD_TITLE::FIELD_TITLE(
	const char *_prompt,
	const char *_str)
	: FIELD_STRING (_prompt,(char*)_str,strlen(_str))
{
	readonly = 1;
}

PUBLIC void FIELD_TITLE::drawtxt(WINDOW *win)
{
	// Draw an horizontal line
	wmove(win, box.y, box.x);
	wattrset(win, inputbox_attr);
	if (strcmp(buf,"-")==0){
		// Special case, draw a small separator
		for (int i=0; i<10; i++) waddch(win, ACS_HLINE);
	}else{
		for (int i = 0; i < box.width; i++) waddch(win, ACS_HLINE);
		// Draw the text in the middle
		int len = strlen(buf);
		if (len > 0){
			wmove(win, box.y, box.x + (box.width-len)/2);
			waddstr(win, buf);
		}
	}
}

/*
	Draw the field with the prompt
*/
PUBLIC void FIELD_TITLE::html_draw(int)
{
	if (strcmp(buf,"-")==0){
		html_printf ("<tr><td>%s<td><hr>\n",prompt);
	}else{
		html_printf ("<tr><td>%s<td><strong>%s</strong>\n",prompt,buf);
	}
}
PUBLIC int FIELD_TITLE::html_validate(int)
{
	return 0;
}

/*
	Add a new field/title.
	A field/title act as a splitter between to logical section
	of a dialog

	There are 3 cases:

	msg contain a string. It will appear centered with horizontal
	rules on each side.

	msg is empty. A single horizontal rule will be drawn filling the line.

	msg is "-". A left justified horizontal rule will be drawn, not filling
	the line.
*/
PUBLIC void DIALOG::newf_title(const char *prompt, const char *msg)
{
	FIELD_TITLE *ti = new FIELD_TITLE(prompt,msg);
	add (ti);
}



