#pragma implementation
#include "diadef.h"
#include "dialog.h"
#include "internal.h"

/*
	Update all variables with the edition buffer.
*/
PUBLIC void DIALOG::save()
{
	for (int i=0; i<getnb(); i++){
		FIELD *fi = getitem(i);
		if (!fi->is_readonly()) fi->save();
	}
	rstmodified();
}
/*
	Set all variables to its original content.
*/
PUBLIC void DIALOG::restore()
{
	for (int i=0; i<getnb(); i++){
		FIELD *fi = getitem(i);
		if (!fi->is_readonly()) fi->restore();
	}
}
/*
	Set all field into readonly mode
*/
PUBLIC void DIALOG::set_readonly()
{
	for (int i=0; i<getnb(); i++) getitem(i)->set_readonly();
}
/*
	Set the last field entered readonly
*/
PUBLIC void DIALOG::set_lastreadonly()
{
	int n = getnb()-1;
	if (n >= 0) getitem(n)->set_readonly();
}
/*
	Set the last field entered so it does not accept empty input
*/
PUBLIC void DIALOG::last_noempty()
{
	int n = getnb()-1;
	if (n >= 0) getitem(n)->set_noempty();
}
/*
	Return != 0 if anyone field has been modified
*/
PUBLIC int DIALOG::was_modified()
{
	modified = 0;
	return ARRAY::was_modified();
}

PUBLIC FIELD *DIALOG::getitem(int no)
{
	return (FIELD*)ARRAY::getitem(no);
}

void dialog_clear()
{
	if (dialog_mode != DIALOG_HTML){
		init_dialog();
		attr_clear(stdscr, LINES, COLS, screen_attr);
	}
}


void dialog_clearinit()
{
	static char done = 0;
	if (!done){
		dialog_clear();
		done = 1;
	}
}

PUBLIC FIELD_MSG::FIELD_MSG()
{
	is_loaded = 0;
}


/*
	Record the icon name (no extension) which describe this dialog.
	This will often be a translatable name (uh ?) allowing different icons
	for different culture/language/society
*/
PUBLIC void DIALOG::seticon (const char *_icon)
{
	icon.setfrom (_icon);
}

PUBLIC void DIALOG::setbutinfo (
	int id,					// MENU_xxxx (Not MENUBUT_xxxx)
	const char *title,		// Name that goes in the button
	const char *icon)		// Icon to use in html mode
{
	buttons->setbutinfo(id,title,icon);
}

/*
	Use this function to record preformat HTML information.
	This function may be called several times and will override the
	normal formatting of dialog. This is a bypass for dialog which are
	HTML aware and want to do something "nicer".

	Using this function once will disable all other field formatting.
*/
PUBLIC void DIALOG::html_body(const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	char buf[10000];
	vsprintf (buf,ctl,list);
	html_bypass.body.append (buf);
	va_end (list);
}

/*
	Use this function to record preformat HTML introduction which
	will be insert at the beginning of the dialog.
*/
PUBLIC void DIALOG::html_intro(const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	char buf[10000];
	vsprintf (buf,ctl,list);
	html_bypass.intro.append (buf);
	va_end (list);
}

/*
	Use this function to record preformat HTML end of document which
	will be append after the body of the dialog.
*/
PUBLIC void DIALOG::html_end(const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	char buf[10000];
	vsprintf (buf,ctl,list);
	html_bypass.end.append (buf);
	va_end (list);
}

/*
	Record a title string which will be displayed inside the dialog
	centered.

	The other title goes on the window.

	In HTML mode, the standard title in drawn centered unless overriden
	by this one. This is because the title is not readable by many
	browser (The top border of the window contain to much).
*/
PUBLIC void DIALOG::set_alt_title(const char *_title)
{
	internal_title.setfrom (_title);
}

