#!/bin/sh
# Un-installation script for linuxconf
BIN=/bin
USRBIN=/usr/bin
SBIN=/sbin
rcm=/etc/rc.d/rc.M
# DVER identify which version you have
DVER=
INITTAB=
UPDCONF=
TMP=/tmp/uninstall.$$
checkalready(){
	if [ `grep askrunlevel $rcs | wc -l` = 0 ] ; then
		echo
		echo Linuxconf is not installed on this
		echo machine. Nothing to do.
		echo
		exit 1
	fi
}

backupuns(){
	if [ ! -f $1-installed -a -f $1 ]; then
		echo Preserving $1 in $1-installed
		mv $1 $1-installed
	fi
}
restore(){
	if [ -f $1.old ]; then
		echo Restoring original $1 from $1.old
		cp -a $1.old $1
	fi
}

restorecmd(){
	if [ -f $BIN/$1 -o -L $BIN/$1 ] ; then
		if [ -f $BIN/$1.old ] ; then
			backupuns $BIN/$1
			mv -f $BIN/$1.old $BIN/$1
		fi
	elif [ -f $USRBIN/$1 -o -L $USRBIN/$1 ] ; then
		if [ -f $USRBIN/$1.old ] ; then
			backupuns $USRBIN/$1
			mv -f $USRBIN/$1.old $USRBIN/$1
		fi
	fi
}


if [ -f /etc/init.d/boot ] ; then
	echo
	echo Debian based system detected
	echo
	rcs=/etc/init.d/boot
	rcm=/etc/init.d/rc.M
	DVER=debian
	INITTAB=inittab.debian
	UPDCONF=conf.linuxconf-debian
elif [ -f /etc/rc.d/rc.sysinit ] ; then
	if [ -f /sbin/mingetty ] ; then
		echo
		echo RedHat 4.0 based system detected
		echo This installation script has been tested on
		echo "     " RedHat 4.0
		echo
		rcs=/etc/rc.d/rc.sysinit
		DVER=redhat4.0
		INITTAB=inittab.redhat-4.0
		UPDCONF=conf.linuxconf.redhat-4.0
	else
		echo
		echo RedHat 2.x/3.0.3 based system detected
		echo This installation script has been tested on
		echo "     " RedHat 3.0.3
		#echo "     " Caldera 1.0
		echo
		rcs=/etc/rc.d/rc.sysinit
		DVER=redhat
		INITTAB=inittab.redhat
	fi
elif [ -f /etc/rc.d/rc.S -a -f /etc/rc.d/rc.inet1 -a -f /etc/rc.d/rc.inet2 ]; then
	echo
	echo Slackware based system detected
	echo
	rcs=/etc/rc.d/rc.S
	DVER=slack
else
	echo
	echo Unknown linux distribution. Can\'t uninstall linuxconf
	echo
	exit 1
fi
checkalready

# Remove the /sbin/askrunlevel from the startup script.
if grep -v /sbin/askrunlevel $rcs >$TMP
then
	backupuns $rcs
	mv $TMP $rcs
	chmod +x $rcs
else
	echo error removing /sbin/askrunlevel from startup script
	exit 1
fi

# Put back the original inittab
if [ "$INITTAB" != "" ] ; then
	if [ -f /etc/inittab.old ] ; then
		backupuns /etc/inittab
		restore /etc/inittab
	fi
fi

# Put back the original rc.M
if [ -f $rcm.old ] ; then
	backupuns $rcm
	restore $rcm
fi

if [ -f /etc/conf.linuxconf ] ; then
	backupuns /etc/conf.linuxconf
	rm -f /etc/conf.linuxconf
	echo Your configuration file /etc/conf.linuxconf has been renamed
	echo to /etc/conf.linuxconf-installed.
fi	

echo 
echo Linuxconf is now disabled from your system, but still usable.
echo You can still configure most things with it.
echo
echo -n Do you want to remove linuxconf completly '? (y/n) '
read yes
if [ "$yes" = "y" ] ; then
	rm -fr /usr/lib/linuxconf
	rm -f /bin/linuxconf
	rm -f $BIN/netconf
	rm -f $BIN/xconf
	rm -f $BIN/lpdconf
	rm -f $BIN/fsconf
	rm -f $SBIN/askrunlevel
	rm -f $SBIN/dnsconf
	rm -f $SBIN/fixperm
	rm -f $SBIN/mailconf
	rm -f $BIN/userconf
	restorecmd passwd
	echo
	echo All the utilities and linuxconf support file have been removed
	echo
	echo To reinstall linuxconf, just untar the distribution
	echo execute the script /install/doinst.sh
	echo
else
	echo
	echo To reinstall linuxconf, just execute script /install/doinst.sh
	echo
fi

