# nis.tcl Library
#
# Copyright (c) 1997 Mark Black
#
# Rebuild index using "auto_mkindex /home/mark/mat/lib *.tcl"
#
# This library contains the following functions:
#   NISGroups     - Group update GUI
#   NISHosts      - Hosts update GUI
#   NISUser       - User update GUI
#   NISMail       - Email alias GUI
#   useropt    - User options GUI
#   -------------- Task Procedures ----------------



#
# NIS Group update procedure
#
# USE NISGroup CurrentHost CurrentGroup SelectedData
#             CurrentHost = host to update
#             CurrentGroup = The current selected group
#                           If 9999 then it is a new entry
#             SelectedData = line of data to modify
# NOTE: Data must be seperated by a single space or a singel tab
#
proc NISGroups { currenthost currentgroup line } {
    set host $currenthost
    if { [winfo exists .ypgroup ] == 0 } {
	toplevel .ypgroup -class Dialog
	wm title .ypgroup "NIS Group Editor: $currenthost"
	wm iconname .ypgroup "Group Editor"
	entry .ypgroup.hidden1 
	entry .ypgroup.hidden2
	# NOT GOOD
	.ypgroup.hidden1 insert end $currenthost
	.ypgroup.hidden2 insert end $currentgroup
	frame .ypgroup.f1 -bd 2 -relief "raised"
	label .ypgroup.f1.l1 -text "Group:" -width 6
	entry .ypgroup.f1.e1 -width 10
	pack .ypgroup.f1.l1 .ypgroup.f1.e1 -fill both -side left -expand 1
	frame .ypgroup.f2 -bd 2 -relief "raised"
	label .ypgroup.f2.l1 -text "GID #:" -width 6
	entry .ypgroup.f2.e1 -width 10
	pack .ypgroup.f2.l1 .ypgroup.f2.e1 -fill both -side left -expand 1
	frame .ypgroup.f3 -bd 2 -relief "raised"
	label .ypgroup.f3.l1 -text "Users" 
	pack .ypgroup.f3.l1 -fill x
	frame .ypgroup.f3.f1 -bd 2 -relief "flat"
	entry .ypgroup.f3.f1.e1 -width 10
	button .ypgroup.f3.f1.b1 -text "Add" -command {
	    if { [.ypgroup.f3.f1.e1 get] != "" } {
		.ypgroup.f3.f2.text insert end [.ypgroup.f3.f1.e1 get]
	    }
	    .ypgroup.f3.f1.e1 delete 0 end
	}
	pack .ypgroup.f3.f1.e1 .ypgroup.f3.f1.b1 -fill both -side left -expand 1
	frame .ypgroup.f3.f2 -bd 2 -relief "flat"
	scrollbar .ypgroup.f3.f2.vscroll -orient vertical -command ".ypgroup.f3.f2.text yview" 
	listbox .ypgroup.f3.f2.text -selectforeground white -selectbackground #000080 -yscrollcommand {.ypgroup.f3.f2.vscroll set } -height 5 -width 10
	.ypgroup.f3.f2.text config -cursor hand2
	pack .ypgroup.f3.f2.vscroll -side left -fill y
	pack .ypgroup.f3.f2.text -side left -expand 1 -fill both
	button .ypgroup.f3.f2.b1 -text "Delete" -foreground red -activeforeground #a00000 -command {
	    if { [.ypgroup.f3.f2.text curselection ] != "" } {
		.ypgroup.f3.f2.text delete [.ypgroup.f3.f2.text curselection ]
	    }
	}
	pack .ypgroup.f3.f2.b1 -side left
	pack .ypgroup.f3.f1 .ypgroup.f3.f2 -side top -fill both -expand 1
	frame .ypgroup.f4 -bd 2 -relief "flat"
	button .ypgroup.f4.b1 -text "Apply" -foreground red -activeforeground #a00000 -command {
	    if { [.ypgroup.f2.e1 get] > -2 || [.ypgroup.f2.e1 get] < 65536 } {
		if { [.ypgroup.f1.e1 get] != "" } {
		    set tmpline "[ string tolower [.ypgroup.f1.e1 get]]::[ string tolower [.ypgroup.f2.e1 get]]:"
		    foreach user [.ypgroup.f3.f2.text get 0 end] {
			append tmpline "[string tolower [string trimright $user]],"
		    }
		    set newline [string trimright $tmpline "," ] 
		    set currentgroup [.ypgroup.hidden2 get]
		    if { $currentgroup == 9999 } {
			set cmd "NIS add group $newline"
		    } else {
			set cmd "NIS mod group $currentgroup $newline"
		    }
		    set returnval [queryHost $currenthost $cmd 1 ]
		    if { [lindex [split $returnval " " ] 0 ] == "\{ERROR:" } {
			error 91
			puts stdout "ERROR:  Unable to update the /etc/group file on $currenthost\n       Check the files permissions"
		    } else {
			set returndata [queryHost $currenthost "get group" 0 ]
			filltext $returndata .general.text 2
			destroy .ypgroup
		    }
		}
	    }
	}
	button .ypgroup.f4.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    set returndata [queryHost $currenthost "NIS get group" 0 ]
	    filltext $returndata .general.text 2
	    destroy .ypgroup
	}
	button .ypgroup.f4.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help groups
	}
	pack .ypgroup.f4.b1 .ypgroup.f4.b2 .ypgroup.f4.b3 -side left -fill x 
	pack .ypgroup.f1 .ypgroup.f2 .ypgroup.f3 .ypgroup.f4 -fill both -expand 1
	# ----- Bindings -----
	bind .ypgroup.f1.e1 <Return> {
	    focus .ypgroup.f2.e1
	}
	bind .ypgroup.f2.e1 <Return> {
	    focus .ypgroup.f3.f1.e1
	}
	bind .ypgroup.f3.f1.e1 <Return> {
	    if { [.ypgroup.f3.f1.e1 get] != "" } {
		.ypgroup.f3.f2.text insert end [.ypgroup.f3.f1.e1 get]
	    }
	    .ypgroup.f3.f1.e1 delete 0 end
	}
    } else {
	.ypgroup.hidden1 delete 0 end
	.ypgroup.hidden2 delete 0 end
	.ypgroup.hidden1 insert end $currenthost
	.ypgroup.hidden2 insert end $currentgroup
	wm title .ypgroup "Groups Editor: $currenthost"
    }

    # Fill boxes with data
    if { $currentgroup != 9999 } {
	.ypgroup.f1.e1 delete 0 end
	.ypgroup.f2.e1 delete 0 end
	.ypgroup.f3.f2.text delete 0 end
	.ypgroup.f1.e1 insert end [lindex [split $line ":"] 0]
	.ypgroup.f2.e1 insert end [lindex [split $line ":"] 2]
	set tmp [lindex [split $line ":"] 3]
	foreach user [split $tmp ","] {
	    .ypgroup.f3.f2.text insert end $user
	}
	    
    }	
}


#
# NIS Hosts Update procedure
#
# USE:  NISHosts CurrentHost EditHost SelectedData
#             CurrentHost = host to update
#             editHost = The hostip to modify
#             SelectedData = line of data to modify
# NOTE: Data must be seperated by a single space or a singel tab
#
proc NISHosts { currenthost editHost line args } {
    set host $currenthost
    if { [string length $args ] != 0 } {
	append line " $args"
    }
    if { [winfo exists .yphost ] == 0 } {
	toplevel .yphost -class Dialog
	wm title .yphost "NIS Hosts Editor: $currenthost"
	wm iconname .yphost "Hosts Editor"
	entry .yphost.hidden1 
	entry .yphost.hidden2
	# NOT GOOD
	.yphost.hidden1 insert end $currenthost
	.yphost.hidden2 insert end $editHost
	frame .yphost.f1 -bd 2 -relief "raised"
	label .yphost.f1.label -text "IP address:" -width 12
	entry .yphost.f1.e1 -width 3
	label .yphost.f1.l1 -text "."
	entry .yphost.f1.e2 -width 3
	label .yphost.f1.l2 -text "."
	entry .yphost.f1.e3 -width 3
	label .yphost.f1.l3 -text "."
	entry .yphost.f1.e4 -width 3
	
	pack .yphost.f1.label .yphost.f1.e1 .yphost.f1.l1 .yphost.f1.e2 .yphost.f1.l2 .yphost.f1.e3 .yphost.f1.l3 .yphost.f1.e4 -fill both -side left -expand 1
	frame .yphost.f2 -bd 2 -relief "raised"
	label .yphost.f2.label -text "Host name:" -width 12
	entry .yphost.f2.entry 
	pack .yphost.f2.label .yphost.f2.entry -fill both -side left -expand 1

	frame .yphost.f3 -bd 2 -relief "raised"
	label .yphost.f3.l1 -text "Host Nickname(s)" 
	pack .yphost.f3.l1 -fill x
	frame .yphost.f3.f1 -bd 2 -relief "flat"
	entry .yphost.f3.f1.e1 -width 10
	button .yphost.f3.f1.b1 -text "Add" -command {
	    if { [.yphost.f3.f1.e1 get] != "" } {
		.yphost.f3.f2.text insert end [.yphost.f3.f1.e1 get]
	    }
	    .yphost.f3.f1.e1 delete 0 end
	}
	pack .yphost.f3.f1.e1 .yphost.f3.f1.b1 -fill both -side left -expand 1
	frame .yphost.f3.f2 -bd 2 -relief "flat"
	scrollbar .yphost.f3.f2.vscroll -orient vertical -command ".yphost.f3.f2.text yview" 
	listbox .yphost.f3.f2.text -selectforeground white -selectbackground #000080 -yscrollcommand {.yphost.f3.f2.vscroll set } -height 3 -width 10
	.yphost.f3.f2.text config -cursor hand2
	pack .yphost.f3.f2.vscroll -side left -fill y
	pack .yphost.f3.f2.text -side left -expand 1 -fill both
	button .yphost.f3.f2.b1 -text "Delete" -foreground red -activeforeground #a00000 -command {
	    if { [.yphost.f3.f2.text curselection ] != "" } {
		.yphost.f3.f2.text delete [.yphost.f3.f2.text curselection ]
	    }
	}
	pack .yphost.f3.f2.b1 -side left
	pack .yphost.f3.f1 .yphost.f3.f2 -side top -fill both -expand 1

#	frame .yphost.f3 -bd 2 -relief "raised"
#	label .yphost.f3.label -text "Alias(es):" -width 12
#	entry .yphost.f3.entry 
#	pack .yphost.f3.label .yphost.f3.entry -fill x -side left -expand 1

	pack .yphost.f1 .yphost.f2 .yphyost.f3 -fill both
	button .yphost.ok -text "Okay" -foreground red -activeforeground #a00000 -command {
	    set nicks {}
	    foreach nick [.yphost.f3.f2.text get 0 end] {
		append nicks "[string tolower [string trimright $nick]] "
	    }
	    
	    NIShostUpdate [.yphost.hidden1 get] [.yphost.hidden2 get] [ .yphost.f1.e1 get] [ .yphost.f1.e2 get] [ .yphost.f1.e3 get] [ .yphost.f1.e4 get] [ .yphost.f2.entry get] $nicks
	    set returndata [queryHost $currenthost "NIS get hosts" 0 ]
	    filltext $returndata .general.text 1
	    destroy .yphost
	}
	button .yphost.app -text "Apply" -foreground red -activeforeground #a00000 -command {
	    set nicks {}
	    foreach nick [.yphost.f3.f2.text get 0 end] {
		append nicks "[string tolower [string trimright $nick]] "
	    }
	    NIShostUpdate [.yphost.hidden1 get] [.yphost.hidden2 get] [ .yphost.f1.e1 get] [ .yphost.f1.e2 get] [ .yphost.f1.e3 get] [ .yphost.f1.e4 get] [ .yphost.f2.entry get] $nicks
	    .yphost.f1.e1 delete 0 end
	    .yphost.f1.e2 delete 0 end
	    .yphost.f1.e3 delete 0 end
	    .yphost.f1.e4 delete 0 end
	    .yphost.f2.entry delete 0 end
	    .yphost.f3.f2.text delete 0 end
	    .yphost.hidden2 delete 0 end
	    .yphost.hidden2 insert end 9999
	    set returndata [queryHost $currenthost "NIS get hosts" 0 ]
	    filltext $returndata .general.text 1
	}
	button .yphost.can -text "Cancel"  -foreground blue -activeforeground #000080 -command {
	    destroy .yphost
	}
	button .yphost.help -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help hosts
	}
	pack .yphost.ok .yphost.app .yphost.can .yphost.help -fill x -side left -expand 1
	
	# -----------  Bindings for Hosts  -------------------------
	bind .yphost.f1.e1 <Return> {
	    focus .yphost.f1.e2 
	}
	bind .yphost.f1.e1 . {
	    after 250 {
		.yphost.f1.e1 delete [expr [string length [.yphost.f1.e1 get]] -1] end
	    }
	    focus .yphost.f1.e2 
	}
	bind .yphost.f1.e2 <Return> {
	    focus .yphost.f1.e3 
	}
	bind .yphost.f1.e2 . {
	    after 250 {
		.yphost.f1.e2 delete [expr [string length [.yphost.f1.e2 get]] -1] end
	    }
	    focus .yphost.f1.e3 
	}
	bind .yphost.f1.e3 <Return> {
	    focus .yphost.f1.e4 
	}
	bind .yphost.f1.e3 . {
	    after 250 {
		.yphost.f1.e3 delete [expr [string length [.yphost.f1.e3 get]] -1] end
	    }
	    focus .yphost.f1.e4 
	}
	bind .yphost.f1.e4 <Return> {
	    focus .yphost.f2.entry 
	}
	bind .yphost.f2.entry <Return> {
	    focus .yphost.f3.f1.e1 
	}
	bind .yphost.f3.f1.e1 <Return> {
	    if { [.yphost.f3.f1.e1 get] != "" } {
		.yphost.f3.f2.text insert end [.yphost.f3.f1.e1 get]
	    }
	    .yphost.f3.f1.e1 delete 0 end
	}
    } else {
	wm title .yphost "Hosts Editor: $currenthost"
	.yphost.hidden1 delete 0 end
	.yphost.hidden2 delete 0 end
	.yphost.hidden1 insert end $currenthost
	.yphost.hidden2 insert end $editHost
    }

    if { $editHost != "9999" && [lindex [split $line {} ] 0] != "#" } {
	set tmp [lindex [split $line " 	"] 0]
	.yphost.f1.e1 delete 0 end
	.yphost.f1.e2 delete 0 end
	.yphost.f1.e3 delete 0 end
	.yphost.f1.e4 delete 0 end
	.yphost.f2.entry delete 0 end
	.yphost.f3.f2.text delete 0 end
	.yphost.f1.e1 insert end [lindex [split $tmp "."] 0]
	.yphost.f1.e2 insert end [lindex [split $tmp "."] 1]
	.yphost.f1.e3 insert end [lindex [split $tmp "."] 2]
	.yphost.f1.e4 insert end [lindex [split $tmp "."] 3]
	.yphost.f2.entry insert end [lindex [split $line " 	"] 1]
	for { set position 2 } { $position < [llength [split $line " 	"] ] } { incr position 1 } {
	    .yphost.f3.f2.text insert end [lindex [split $line " 	"] $position ]
	}
    }
}

	    
#
# ---- Procedure to build the update line
#
proc NIShostUpdate { currenthost lineNo ip1 ip2 ip3 ip4  name alias } {
    if { $ip1 > 255 || $ip1 < 0 } {
	error 50
	return -1
    } elseif { $ip2 > 255 || $ip2 < 0 } {
	error 50
	return -1
    } elseif { $ip3 > 255 || $ip3 < 0 } {
	error 50
	return -1
    } elseif { $ip4 > 255 || $ip4 < 0 } {
	error 50
	return -1
    } else { 
	if { $lineNo != 9999 } {
	    set cmd "NIS mod hosts $lineNo $ip1.$ip2.$ip3.$ip4	[string tolower $name ]	[string tolower $alias]"
	} else {
	    set cmd "NIS add hosts $ip1.$ip2.$ip3.$ip4	[string tolower $name ]	[string tolower $alias]"
	}
	set returnval [queryHost $currenthost $cmd 1 ]
	if { [lindex [split $returnval " " ] 0 ] == "\{ERROR:" } {
	    error 51
	    puts stdout "ERROR:  Unable to update the /etc/hosts file on $currenthost\n        Check the files permissions"
	}
    }
}


#
# NISUser Update procedure
#
# USE:  NISUser  CurrentUser CurrentLogin SelectedData
#
#             editUser = User to update
#             CurrentLogin = The login name of the user to modify
#             SelectedData = line of data to modify
# NOTE: Data must be seperated by a single space or a singel tab
#
proc NISUser { currenthost editUser line args } {
    global userkey
    # This is the minimum alowable gid.  It protects the more sensiteve groups from less sensitive administerators
    set mingid 10
    # This is the minimum allowable User ID
    set minuid 100
    set homedir "/home"
    # NOTE:   modify apply button to reflect any changes here
    set shell "/bin/sh"
    set key {}
    if { [string length $args ] != 0 } {
	append line " $args"
    }
    set host $currenthost
    if { [winfo exists .ypopt ] != 0 } {
	destroy .ypopt
    }
    if { [winfo exists .yppass ] == 0 } {
	toplevel .yppass -class Dialog
	wm title .yppass "User Editor: $currenthost"
	wm iconname .yppass "User Editor"
	entry .yppass.hidden1 
	entry .yppass.hidden2
	entry .yppass.hidden3
	entry .yppass.hidpass
	entry .yppass.hiduid
	entry .yppass.hidgid
	entry .yppass.hidshell
	entry .yppass.hiddir
	listbox .yppass.hiddenlist
	# NOT GOOD
	.yppass.hidden1 insert end $currenthost
	.yppass.hidden2 insert end $editUser
	.yppass.hidden3 insert end $line
	.yppass.hidpass delete 0 end
	frame .yppass.f1 -bd 2 -relief "raised"
	label .yppass.f1.label -text "First Name" -width 10
	entry .yppass.f1.e1 -width 16
	pack .yppass.f1.label .yppass.f1.e1 -fill both -side left -expand 1
	frame .yppass.f2 -bd 2 -relief "raised"
	label .yppass.f2.label -text "Surname" -width 10
	entry .yppass.f2.entry -width 16
	pack .yppass.f2.label .yppass.f2.entry -fill both -side left -expand 1
	frame .yppass.f3 -bd 2 -relief "raised"
	label .yppass.f3.label -text "Login" -width 10
	entry .yppass.f3.entry -width 16
	pack .yppass.f3.label .yppass.f3.entry -fill both -side left -expand 1
	frame .yppass.f4 -bd 2 -relief "raised"
	label .yppass.f4.l1 -text "Primary Group"
	pack .yppass.f4.l1 -fill x
	scrollbar .yppass.f4.vscroll -orient vertical -command ".yppass.f4.text yview" 
	listbox .yppass.f4.text -selectforeground white -selectbackground #000080 -yscrollcommand {.yppass.f4.vscroll set } -height 5 -width 10
	.yppass.f4.text config -cursor hand2
	pack .yppass.f4.vscroll -side left -fill y
	pack .yppass.f4.text -side left -expand 1 -fill both

	frame .yppass.f5 -bd 2 -relief "raised"
	button .yppass.f5.b1 -text "Apply" -foreground red -activeforeground #a00000 -command {
	    global userkey
	    set flag 0
	    if { [.yppass.f4.text curselection ] != "" } {
		set gid [lindex [split [.yppass.hiddenlist get [lindex $userkey [ .yppass.f4.text curselection ]]] ":" ] 2]
	    } else {
		set gid [ .yppass.hidgid get ]
	    }
	    if { [.yppass.hiddir get] == "" } {
		.yppass.hiddir insert end "/home/[.yppass.f3.entry get]"
	    }
	    if { [.yppass.f2.entry get] == "" } {
#		set newline "[.yppass.f3.entry get]:[.yppass.hidpass get]:[.yppass.hiduid get]:[.yppass.hidgid get]:[.yppass.f1.e1 get]:[.yppass.hiddir get]:[.yppass.hidshell get]"
set newline "[.yppass.f3.entry get]:[.yppass.hidpass get]:[.yppass.hiduid get]:$gid:[.yppass.f1.e1 get]:[.yppass.hiddir get]:[.yppass.hidshell get]"
	    } else {
#		set newline "[.yppass.f3.entry get]:[.yppass.hidpass get]:[.yppass.hiduid get]:[.yppass.hidgid get]:[.yppass.f1.e1 get] [.yppass.f2.entry get]:[.yppass.hiddir get]:[.yppass.hidshell get]"
		set newline "[.yppass.f3.entry get]:[.yppass.hidpass get]:[.yppass.hiduid get]:$gid:[.yppass.f1.e1 get] [.yppass.f2.entry get]:[.yppass.hiddir get]:[.yppass.hidshell get]"
	    }
	    if { [.yppass.hidden2 get] == 9999 } {
		set cmd "NIS add pass $newline"
	    } else {
		set cmd "NIS mod pass [.yppass.hidden2 get] $newline"
	    }
	    set returnval [queryHost $currenthost $cmd 1 ]
	    if { [lindex [split $returnval " " ] 0 ] == "\{ERROR:" } {
		error 91
		puts stdout "ERROR:  Unable to update the NIS passwd file on $currenthost\n       Check the file and directory permissions"
	    }
	    # Close window
	    repack 5
	    destroy .yppass
	}

	button .yppass.f5.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    if { [winfo exists .ypopt ] != 0 } {
		destroy .ypopt
	    }
	    destroy .yppass
	}
	button .yppass.f5.b3 -text "Options" -foreground #008000 -command {
	    useropt 
	}
	button .yppass.f5.b4 -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help users
	}
	pack .yppass.f5.b1 .yppass.f5.b2 .yppass.f5.b3 .yppass.f5.b4 -fill x -side left -expand 1

	frame .yppass.f6 -bd 2 -relief "raised"
	button .yppass.f6.b1 -text "Lock Account" -foreground red -activeforeground #a00000 -command {
	    .yppass.hidpass delete 0 end
	    .yppass.hidpass insert end "LOCK"
	}
	button .yppass.f6.b2 -text "Unlock Account" -foreground red -activeforeground #a00000 -command {
	    .yppass.hidpass delete 0 end
	    .yppass.hidpass insert end "UNLOCK"
	}
	pack .yppass.f6.b1 .yppass.f6.b2 -fill x -side left -expand 1

	pack .yppass.f1 .yppass.f2 .yppass.f3 .yppass.f4 .yppass.f5 .yppass.f6 -fill x -side top -expand 1

	bind .yppass.f1.e1 <Return> {
	    focus .yppass.f2.entry 
	}
	bind .yppass.f2.entry <Return> {
	    focus .yppass.f3.entry
	    if { [ .yppass.hidden2 get ] != 9999 } {
		.yppass.f3.entry insert end [ string tolower [ lindex [ split [ .yppass.f1.e1 get ] "" ] 0 ] ]
		set splt_name [ split [ .yppass.f2.entry get ] "" ]
		set max [ llength $splt_name ]
		if { $max > 0 } {
		    if { $max >= 7 } {
			set max 7
		    }
		    set i 0
		    while { $i < $max } {
			.yppass.f3.entry delete 0 end
			.yppass.f3.entry insert end [ string tolower [ lindex $splt_name $i ] ]
			incr i
		    }
		}
	    }
	}
	bind .yppass.f3.entry <Return> {
	    focus .yppass.f1.e1 
	}
    } else {
	# --- Window open already ---
	wm title .yppass "User Editor: $currenthost"
	.yppass.hidden1 delete 0 end
	.yppass.hidden2 delete 0 end
	.yppass.hidden3 delete 0 end
	.yppass.hidden1 insert end $currenthost
	.yppass.hidden2 insert end $editUser
	.yppass.hidden3 insert end $line
    }
    .yppass.f4.text delete 0 end
    set userkey {}
    set cnt1 0
    .yppass.hidpass delete 0 end
    .yppass.hidpass insert end "PASSWORD"
    .yppass.hiduid delete 0 end
    .yppass.hiduid insert end "AUTO"
    .yppass.hidgid delete 0 end
    .yppass.hidshell delete 0 end
    .yppass.hidshell insert end $shell
    .yppass.hiddir delete 0 end
    
    set index 0
    set returndata [queryHost $currenthost "NIS get group" 0 ]
    for { set position 0 } { $position < [llength $returndata] } { incr position 1 } {
	set tmp [string trimright [lindex $returndata $position ] ]
	# Maintain an actual list of the file in a hidden list
	.yppass.hiddenlist insert end $tmp
	set tmp2 [split $tmp ":" ]
	if { [lindex $tmp2 2 ] >= $mingid } {
	    set gidnum [lindex $tmp2 2 ]
	    set gid2index($gidnum) $index
	    incr index 1
	    .yppass.f4.text insert end [lindex $tmp2 0 ]
	    lappend userkey $cnt1
	}
	incr cnt1 1
    }
    if { $editUser != 9999 } {
	#####   Set values from the supplied list
	.yppass.hidpass delete 0 end
	.yppass.hidpass insert end [lindex [split $line ":"] 1]
	.yppass.hiduid delete 0 end
	.yppass.hiduid insert end [lindex [split [.yppass.hidden3 get] ":"] 2]
	.yppass.hidshell delete 0 end
	.yppass.hidshell insert end [lindex [split [.yppass.hidden3 get] ":"] 6]
	.yppass.hiddir delete 0 end
	.yppass.hiddir insert end [lindex [split [.yppass.hidden3 get] ":"] 5]
	.yppass.f1.e1 delete 0 end
	.yppass.f2.entry delete 0 end
	.yppass.f3.entry delete 0 end
	.yppass.f1.e1 insert end [lindex [split [lindex [split $line ":"] 4] " "] 0]
	.yppass.f2.entry insert end [lindex [split [lindex [split $line ":"] 4] " "] 1]
	.yppass.f3.entry insert end [lindex [split $line ":"] 0]
	#####   Find and select the appropriate gid
	set defgid [lindex [split $line ":"] 3]
	.yppass.hidgid delete 0 end
	.yppass.hidgid insert end $defgid
	focus .yppass.f4.text
	catch ".yppass.f4.text selection set $gid2index($defgid)" fail
	if { $fail == {} } {
	    .yppass.f4.text see $gid2index($defgid)
	    .yppass.f4.text activate $gid2index($defgid)
	} else {
	    # GID not listed in group file
	    puts stdout "GID not in group file.  Failed with: $fail"
	    error 310
	    
	}
    }
}

#
# ------- User Options Menu -----------
#
proc useropt {} {
    if { [winfo exists .ypopt ] == 0 } {
	toplevel .ypopt -class Dialog
	wm title .ypopt "Options for: [ .yppass.f3.entry get ]"
	wm iconname .ypopt "Options"
	frame .ypopt.f1 -bd 2 -relief "raised"
	label .ypopt.f1.label -text "Password" -width 9
	entry .ypopt.f1.e1 -width 16 -show "*"
	label .ypopt.f1.label2 -text "Confirm" -width 9
	entry .ypopt.f1.e2 -width 16 -show "*"
	pack .ypopt.f1.label .ypopt.f1.e1 .ypopt.f1.label2 .ypopt.f1.e2 -fill both -side left -expand 1
	frame .ypopt.f2 -bd 2 -relief "raised"
	label .ypopt.f2.label -text "UID" -width 8
	set uid "a"
	radiobutton .ypopt.f2.rb1 -text "Auto" -selectcolor #000080 -variable uid -value "1" -command {
	    .ypopt.f2.e1 delete 0 end
	    .yppass.hiduid delete 0 end
	    .ypopt.f2.e1 insert end "AUTO"
	    .yppass.hiduid insert end "AUTO"
	    .ypopt.f2.e1 configure -state disabled
	}
	radiobutton .ypopt.f2.rb2 -text "Select" -selectcolor #000080 -variable uid -value 0 -command {
	    .ypopt.f2.e1 configure -state normal
	    .yppass.hiduid delete 0 end
	    .ypopt.f2.e1 delete 0 end
	    focus .ypopt.f2.e1
	}
	entry .ypopt.f2.e1 -width 6
	pack .ypopt.f2.label .ypopt.f2.rb1 .ypopt.f2.rb2 .ypopt.f2.e1 -side left -fill both -expand 1
	frame .ypopt.f3 -bd 2 -relief "raised"
	label .ypopt.f3.label -text "Shell" -width 10
	entry .ypopt.f3.entry -width 24
	pack .ypopt.f3.label .ypopt.f3.entry -fill both -side left -expand 1
	frame .ypopt.f4 -bd 2 -relief "raised"
	label .ypopt.f4.label -text "Home Dir" -width 10
	entry .ypopt.f4.entry -width 24
	pack .ypopt.f4.label .ypopt.f4.entry -fill both -side left -expand 1
	frame .ypopt.f5 -bd 2 -relief "raised" 
	button .ypopt.f5.b1 -text "OK" -foreground red -activeforeground #a00000 -command {
	    if { [.yppass.hidden2 get] == 9999 } {
		#####   New Password
		if { [.ypopt.f1.e1 get] != "" } {
		    if { [.ypopt.f1.e1 get] != [.ypopt.f1.e2 get] } {
			.ypopt.f1.e1 delete 0 end
			.ypopt.f1.e2 delete 0 end
			focus .ypopt.f1.e1
			error 102
		    } else {
			.yppass.hidpass delete 0 end
			.yppass.hidpass insert end [.ypopt.f1.e1 get]
			.yppass.hiduid delete 0 end
			.yppass.hiduid insert end [.ypopt.f2.e1 get]
			.yppass.hiddir delete 0 end
			.yppass.hiddir insert end [.ypopt.f4.entry get]
			.yppass.hidshell delete 0 end
			.yppass.hidshell insert end [.ypopt.f3.entry get]
			destroy .ypopt
		    }
		} else {
		    .yppass.hidshell delete 0 end
		    .yppass.hidshell insert end [.ypopt.f3.entry get]
		    .yppass.hiduid delete 0 end
		    .yppass.hiduid insert end [.ypopt.f2.e1 get]
		    .yppass.hiddir delete 0 end
		    .yppass.hiddir insert end [.ypopt.f4.entry get]
		    destroy .ypopt
		}
	    } else {
		#####  Old Password
		if { [.ypopt.f1.e1 get] != "" } {
		    #####  Update password
		    if { [.ypopt.f1.e1 get] != [.ypopt.f1.e2 get] } {
			.ypopt.f1.e1 delete 0 end
			.ypopt.f1.e2 delete 0 end
			focus .ypopt.f1.e1
			error 102
		    } else {
			.yppass.hidpass delete 0 end
			.yppass.hidpass insert end [.ypopt.f1.e1 get]
			.yppass.hiduid delete 0 end
			.yppass.hiduid insert end [.ypopt.f2.e1 get]
			.yppass.hiddir delete 0 end
			.yppass.hiddir insert end [.ypopt.f4.entry get]
			.yppass.hidshell delete 0 end
			.yppass.hidshell insert end [.ypopt.f3.entry get]
			destroy .ypopt
		    }
		} else {
		    .yppass.hidshell delete 0 end
		    .yppass.hidshell insert end [.ypopt.f3.entry get]
		    .yppass.hiduid delete 0 end
		    .yppass.hiduid insert end [.ypopt.f2.e1 get]
		    .yppass.hiddir delete 0 end
		    .yppass.hiddir insert end [.ypopt.f4.entry get]
		    destroy .ypopt
		}  
	    }
	}
	button .ypopt.f5.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    destroy .ypopt
	}
	button .ypopt.f5.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help users
	}
	pack .ypopt.f5.b1 .ypopt.f5.b2 -side left -anchor w 
	pack .ypopt.f1 .ypopt.f2 .ypopt.f3 .ypopt.f4 .ypopt.f5 -side top -fill both -expand 1
	
    } else {
	for { set entry 0 } { $entry < $num } { incr entry 1 } {
	    destroy .ypopt.f3.$entry
	}
    }
    #####  Fill the Entrys with the appropriate values
    .ypopt.f4.entry delete 0 end
    .yppass.hiddir delete 0 end
    .yppass.hiduid delete 0 end
    .yppass.hidshell delete 0 end
    .ypopt.f2.e1 delete 0 end
    if { [.yppass.hidden2 get] != 9999 } {
	#####  Set the Appropriate values
	##  Home Dir
	.ypopt.f4.entry insert end [lindex [split [.yppass.hidden3 get] ":"] 5]
	.yppass.hiddir insert end [lindex [split [.yppass.hidden3 get] ":"] 5]
	##  UID
	.ypopt.f2.e1 insert end [lindex [split [.yppass.hidden3 get] ":"] 2]
	.yppass.hiduid insert end [lindex [split [.yppass.hidden3 get] ":"] 2]
	.ypopt.f2.rb2 select
	## SHell 
	.ypopt.f3.entry insert end [lindex [split [.yppass.hidden3 get] ":"] 6]
	.yppass.hidshell insert end [lindex [split [.yppass.hidden3 get] ":"] 6]
    } else {
	.ypopt.f4.entry delete 0 end
	.ypopt.f4.entry insert end "/home/[.yppass.f3.entry get]"
	.ypopt.f3.entry delete 0 end
	.ypopt.f3.entry insert end "/bin/sh"
	.ypopt.f2.rb1 invoke
    }
    if { [.ypopt.f2.e1 get] != "AUTO" } {
	set uid 1000
    }
#-------------  Support for the Shell's file -------------------------------
#    set returnval [queryHost [.yppass.hidden1 get] "get shells" 0 ]
#    set num 0 
#    set tmpline [lindex [split [.yppass.hidden3 get] ":"] 6]
#    foreach line $returnval {
#	if { [lindex [split $line {} ] 0 ] == "/" } {
#	    radiobutton .ypopt.f3.$num -text "$line" -selectcolor #000080 -variable shell -value $line -command "
#	        .yppass.hidshell delete 0 end
#		.yppass.hidshell insert end $line 
#	    "
#	    if {$line == $tmpline } {
#		set shell $line
#		.ypopt.f3.$num select
#		.yppass.hidshell delete 0 end
#		.yppass.hidshell insert end $line
#	    }
#	    pack .ypopt.f3.$num -side left
#	    incr num 1
#	}
#    }
    # -----------------  Bindings Option Menu  ----------------------------
    bind .ypopt.f1.e1 <Return> {
	focus .ypopt.f1.e2
    }
    bind .ypopt.f1.e2 <Return> {
	if { [.ypopt.f1.e1 get] != [.ypopt.f1.e2 get] } {
	    .ypopt.f1.e1 delete 0 end
	    .ypopt.f1.e2 delete 0 end
	    focus .ypopt.f1.e1
	    error 102
	} else {
	    focus .ypopt.f4.entry
	}
    }
}



# NIS Mail Alias update procedure
#
# USE NISMail CurrentHost CurrentLine SelectedData
#             CurrentHost = host to update
#             CurrentLine = Line number of selected line
#                           If 9999 then it is a new entry
#             SelectedData = line of data to modify
# NOTE: Data must be seperated by a single space or a singel tab
#
proc NISMail { currenthost currentline line args } {
    set host $currenthost
    if { [string length $args ] != 0 } {
	append line " $args"
    }
    if { [winfo exists .ypmail ] == 0 } {
	toplevel .ypmail -class Dialog
	wm title .ypmail "NIS Mail List Editor: $currenthost"
	wm iconname .ypmail "Mail Editor"
	entry .ypmail.hidden1 
	entry .ypmail.hidden2
	entry .ypmail.hidden3
	# NOT GOOD
	.ypmail.hidden1 insert end $currenthost
	.ypmail.hidden2 insert end $currentline
	.ypmail.hidden3 insert end $line
	frame .ypmail.f1 -bd 2 -relief "raised"
	label .ypmail.f1.l1 -text "Mail Alias:" -width 10
	entry .ypmail.f1.e1 -width 10
	pack .ypmail.f1.l1 .ypmail.f1.e1 -fill both -side left -expand 1
	pack .ypmail.f1 -fill both -side top -expand 1
	frame .ypmail.f2 -bd 2 -relief "raised"
	label .ypmail.f2.l1 -text "Alias Type:" -width 10
	set mtype "None"
	radiobutton .ypmail.f2.b1 -text "List" -selectcolor #000080 -variable mtype -value "List" -command "pack forget .ypmail.f3 .ypmail.f5 ;pack .ypmail.f4 .ypmail.f5 -fill both " 
	radiobutton .ypmail.f2.b2 -text "Redirect" -selectcolor #000080 -variable mtype -value "Redirect" -command "pack forget .ypmail.f4 .ypmail.f5 ;pack .ypmail.f3 .ypmail.f5 -fill both ;.ypmail.f3.l1 configure -text {Email address to redirect to} " 
	radiobutton .ypmail.f2.b3 -text "Log" -selectcolor #000080 -variable mtype -value "Log" -command "pack forget .ypmail.f4 .ypmail.f5 ;pack .ypmail.f3 .ypmail.f5 -fill both ;.ypmail.f3.l1 configure -text {File to log emails in:} "
	radiobutton .ypmail.f2.b4 -text "Command" -selectcolor #000080 -variable mtype -value "Command" -command "pack forget .ypmail.f4 .ypmail.f5 ;pack .ypmail.f3 .ypmail.f5 -fill both ;.ypmail.f3.l1 configure -text {Program to pass email to:} "
	pack .ypmail.f2.l1 .ypmail.f2.b1 .ypmail.f2.b2 .ypmail.f2.b3 .ypmail.f2.b4 -fill both -side left -expand 1
	pack .ypmail.f2 -fill both -side top -expand 1
	# Redirect type
	frame .ypmail.f3 -bd 2 -relief "raised"
	label .ypmail.f3.l1 -text "Email address to redirect to" -width 10
	entry .ypmail.f3.e1 -width 30
	pack .ypmail.f3.l1 .ypmail.f3.e1 -fill x -side top -expand 1
	# Mail list type
	frame .ypmail.f4 -bd 2 -relief "raised"
	label .ypmail.f4.l1 -text "Mailing List" -width 10
	frame .ypmail.f4.f0 -bd 0 -relief "flat"
	label .ypmail.f4.f0.l1 -text "List file:" -width 10
	entry .ypmail.f4.f0.e1 -width 30
	pack .ypmail.f4.f0.l1 .ypmail.f4.f0.e1 -fill both -side left -expand 1
	frame .ypmail.f4.f1 -bd 2 -relief "flat"
	entry .ypmail.f4.f1.e1 -width 20
	button .ypmail.f4.f1.b1 -text "Add" -command {
	    if { [.ypmail.f4.f1.e1 get] != "" } {
		.ypmail.f4.f2.text insert end [.ypmail.f4.f1.e1 get]
	    }
	    .ypmail.f4.f1.e1 delete 0 end
	}
	pack .ypmail.f4.f1.e1 .ypmail.f4.f1.b1 -fill both -side left -expand 1
	frame .ypmail.f4.f2 -bd 2 -relief "flat"
	scrollbar .ypmail.f4.f2.vscroll -orient vertical -command ".ypmail.f4.f2.text yview" 
	listbox .ypmail.f4.f2.text -selectforeground white -selectbackground #000080 -yscrollcommand {.ypmail.f4.f2.vscroll set } -height 5 -width 30
	.ypmail.f4.f2.text config -cursor hand2
	pack .ypmail.f4.f2.vscroll -side left -fill y
	pack .ypmail.f4.f2.text -side left -expand 1 -fill both
	button .ypmail.f4.f2.b1 -text "Delete" -foreground red -activeforeground red -command {
	    if { [.ypmail.f4.f2.text curselection ] != "" } {
		.ypmail.f4.f2.text delete [.ypmail.f4.f2.text curselection ]
	    }
	}
	pack .ypmail.f4.f2.b1 -side left
	pack .ypmail.f4.f0 .ypmail.f4.f1 .ypmail.f4.f2 -side top -fill both -expand 1

	frame .ypmail.f5 -bd 2 -relief "raised"
	button .ypmail.f5.b1 -text "Apply" -foreground red -activeforeground #a00000 -command {
	    # Update aliases file first
	    set newline "[.ypmail.f1.e1 get ]:"
	    if { $mtype == "List" } {
		# Mailing list file
		append newline " :include:[ .ypmail.f4.f0.e1 get ]"
	    } elseif { $mtype == "Redirect" } {
		# Redirect type entry
		append newline " [ .ypmail.f3.e1 get ]"
	    } elseif { $mtype == "Log" } {
		# Email Log type
		append newline " [ .ypmail.f3.e1 get ]"
	    } elseif { $mtype == "Command" } {
		# Email Command type
		append newline "|\"[ .ypmail.f3.e1 get ]\""
	    } else {
		puts stdout "ERROR:  Unknown alias type:  $mtype"
	    }
	    if { [.ypmail.hidden2 get ] != 9999 } {
		# Not New data
		set cmd "mod alias [.ypmail.hidden2 get ] $newline"
	    } else {
		set cmd "add alias $newline"
	    }
	    puts stdout "MAIL:  cmd = $cmd "
	    set returnval [queryHost [.ypmail.hidden1 get ] $cmd 1 ]
	    if { [lindex [split $returnval " " ] 0 ] == "\{ERROR:" } {
		error 240
		puts stdout "ERROR:  Unable to update the Mail Aliases file on $currenthost\n       Check the files permissions"
	    } elseif { $mtype == "List"} {
		if { [winfo ismapped .ypmail.f4 ] == 1 } {
		    # Mailing list alias type:  Update list
		    set cmd "put ascii [.ypmail.f4.f0.e1 get ]"
		    set returnval [queryHost [.ypmail.hidden1 get ] $cmd 1 "ext" "put" "l" ".ypmail.f4.f2.text" ]
		    if { [lindex [split [lindex $returnval end ] " " ] 0 ] == "ERROR:" } {
			error 241
			puts stdout "ERROR:  Unable to update the Mail Aliases file on $currenthost\n       Check the files permissions"
		    } else {
			set returndata [queryHost $currenthost "get alias" 0 ]
			filltext $returndata .general.text 8
			destroy .ypmail
		    }
		}
	    } else {
		set returndata [queryHost $currenthost "get alias" 0 ]
		filltext $returndata .general.text 8
		destroy .ypmail
	    }
	}
	button .ypmail.f5.b2 -text "Cancel" -foreground #000080 -activeforeground #000040 -command {
	    destroy .ypmail
	}
	button .ypmail.f5.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command "help mail"
	pack .ypmail.f5.b1 .ypmail.f5.b2 .ypmail.f5.b3 -side left

	#---------------- Bindings ------------------------------
	bind .ypmail.f1.e1 <Return> { 
	    if {$mtype == "List" } {
		focus .ypmail.f4.f0.e1
	    } else {
		focus .ypmail.f3.e1 
	    }
	}
	bind .ypmail.f3.e1 <Return> {
	    .ypmail.f5.b1 invoke
	}
	bind .ypmail.f4.f0.e1 <Return> {
	    focus .ypmail.f4.f1.e1
	}
	bind .ypmail.f4.f1.e1 <Return> {
	    if { [.ypmail.f4.f1.e1 get] != "" } {
		.ypmail.f4.f2.text insert end [.ypmail.f4.f1.e1 get]
	    }
	    .ypmail.f4.f1.e1 delete 0 end
	}
    } else {
	# Window is already open
	# Clean up old entries
	.ypmail.hidden1 delete 0 end
	.ypmail.hidden2 delete 0 end
	.ypmail.hidden3 delete 0 end
	.ypmail.hidden1 insert end $currenthost
	.ypmail.hidden2 insert end $currentline
	.ypmail.hidden3 insert end $line
	
    }
    # -----------------  Populate Widgets -------------------
    .ypmail.f1.e1 delete 0 end
    .ypmail.f3.e1 delete 0 end
    .ypmail.f4.f0.e1 delete 0 end
    if { [.ypmail.hidden2 get ] != 9999 } {
	set tmp [split [ .ypmail.hidden3 get] ":" ]
	.ypmail.f1.e1 insert end [ lindex $tmp 0 ]
	set trimval [ expr [string length [lindex $tmp 0 ] ] + 1 ]
	set tmp3 [ string trim [ string range [ .ypmail.hidden3 get] $trimval end ] ]
	set schar [string range $tmp3 0 0 ]
	if { $schar == "/" } {
	    .ypmail.f2.b3 invoke
	    .ypmail.f3.e1 insert end $tmp3
	} elseif { $schar == "|" } {
	    # Command type
	    .ypmail.f2.b4 invoke
	    .ypmail.f3.e1 insert end [ string trim $tmp3 {\|\"} ]
	} elseif { $schar == ":" } {
	    # Mail List type
	    .ypmail.f2.b1 invoke
	    set tmp3 [ string trim [ string range $tmp3 [ string length ":include:" ] end ] {\"} ]
	    .ypmail.f4.f0.e1 insert end $tmp3
	    set cmd "get raw $tmp3"
	    puts stdout "Cmd = $cmd"
	    set returnval [queryHost [.ypmail.hidden1 get ] $cmd 0 ]
	    if { [lindex [split $returnval " " ] 0 ] == "\{ERROR:" } {
		error 242
		puts stdout "ERROR:  Unable to read the mailing list $tmp3 on $currenthost\n       Check the files permissions."
	    } else {
		for { set position 0 } { $position < [llength $returnval] } { incr position 1 } {
#		    set tmp [string trim [lindex $returnval $position ] ]
		    set tmp [lindex $returnval $position ] 
		    .ypmail.f4.f2.text insert end $tmp
		}
	    }
	} else {
	    .ypmail.f2.b2 invoke
	    .ypmail.f3.e1 insert end $tmp3
	}    
    }
}

