#  Main.tcl    
#  Copyright (c) 1997 Mark Black
#  Version 0.1
#
#  This library of functions is required by the main body of code.
#  It contains the code for filling the list boxes.
#
# Contents:
#   error        - Error box
#   pingHost     - MAT ping a host
#   queryhost    - Host-to-Host communications
#   getPasswd    - Login Procedure
#   newPass      - password update procedure
#   filllist     - Read data and fill listbox
#   fillhostlist - Unused
#   Selecter     - Select and De-select lines of text
#   HostInfo     - Display Host Info

# CVERSION is a flag to indicate that the C version of the server is the target
set CVERSION 1

#
# ----- Error Procedures -----
#
proc error { class } {
    # Error Numbers
    # 180 - 199  - fstab errors
    # 200 - 219  - DNS Client
    # 220 - 239  - Password
    # 240 - 259  - Mail Aliases
    # 260 - 279  - Motd
    # 280 - 309  - DNS Master
    # 310 - 339  - Users 
    # 340 - 359  - MAT Users
    # 360 - 379  - Crontab
    global currenthost
    if { [winfo exists .lerror ] != 0 } {
	destroy .lerror
    }
    toplevel .lerror -class Dialog
    wm title .lerror "Warning"
    wm iconname .lerror Dialog
    if { $class == 1 } {
        message .lerror.msg -width 3i -text "Unable to Update $currenthost" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 2 } {
        message .lerror.msg -width 3i -text "Please Select a Host first!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground #000080
    } elseif { $class == 3 } {
        message .lerror.msg -width 3i -text "Please Select a Task to Delete!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground #000080
    } elseif { $class == 4 } {
        message .lerror.msg -width 3i -text "Please Select Something first!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground #000080
    } elseif { $class == 5 } {
        message .lerror.msg -width 3i -text "Invalid Pass String!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground #d00000
    } elseif { $class == 50 } {
        message .lerror.msg -width 3i -text "Error in IP Address" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 51 } {
        message .lerror.msg -width 3i -text "Hosts Update Failed!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 71 } {
        message .lerror.msg -width 3i -text "Cannot Delete Entry!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 91 } {
        message .lerror.msg -width 3i -text "Cannot Update Entry!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 101 } {
        message .lerror.msg -width 3i -text "Please Select a Primary Group" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground #000080
    } elseif { $class == 102 } {
        message .lerror.msg -width 3i -text "Password are not the same!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 103 } {
        message .lerror.msg -width 3i -text "Please give an initial Password" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground #000080
    } elseif { $class == 104 } {
        message .lerror.msg -width 3i -text "Unable to Add/Modify User!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 180 } {
        message .lerror.msg -width 3i -text "Unrecognized filesystem type" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 181 } {
        message .lerror.msg -width 3i -text "Please Specify an NFS Server" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground #000080
    } elseif { $class == 182 } {
        message .lerror.msg -width 3i -text "Unable to update /etc/(v)fstab!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 200 } {
        message .lerror.msg -width 3i -text "Invalid IP address" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 201 } {
        message .lerror.msg -width 3i -text "Invalid IP address.  Reserved for broadcasts" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 202 } {
        message .lerror.msg -width 3i -text "This is a Network address" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 203 } {
        message .lerror.msg -width 3i -text "Please Specify the Domain" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground #000080
    } elseif { $class == 204 } {
        message .lerror.msg -width 3i -text "Please Specify at least one Nameserver" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground #000080
    } elseif { $class == 205 } {
        message .lerror.msg -width 3i -text "Unable to update DNS Client configuration!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 220 } {
        message .lerror.msg -width 3i -text "New Strings are not the same!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 221 } {
        message .lerror.msg -width 3i -text "Unable to Change Authentication String!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 240 } {
        message .lerror.msg -width 3i -text "Unable to Update the Mail Aliases File" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 241 } {
        message .lerror.msg -width 3i -text "Unable to Update the Mailing List file" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 242 } {
        message .lerror.msg -width 3i -text "Unable to Read the Mailing List file" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 260 } {
        message .lerror.msg -width 3i -text "Unable to Update the Login Message" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 280 } {
        message .lerror.msg -width 3i -text "Please Select a Domain to edit, or add a new one." -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 281 } {
        message .lerror.msg -width 3i -text "Please use a byte oriented network address (ends in 0)." -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground blue
    } elseif { $class == 282 } {
        message .lerror.msg -width 3i -text "Domain not found.  Creating new one." -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground blue
    } elseif { $class == 283 } {
        message .lerror.msg -width 3i -text "Unable to update DNS records!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 284 } {
        message .lerror.msg -width 3i -text "Please provide a host name!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground blue
    } elseif { $class == 285 } {
        message .lerror.msg -width 3i -text "Unable to write DNS named.boot file" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 310 } {
        message .lerror.msg -width 3i -text "Warning:  The users GID is not listed in the group file." -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground blue
    } elseif { $class == 340 } {
        message .lerror.msg -width 3i -text "Please give a login name." -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 341 } {
        message .lerror.msg -width 3i -text "Please give a password." -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 342 } {
        message .lerror.msg -width 3i -text "Passwords do not match. Try again." -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } elseif { $class == 360 } {
        message .lerror.msg -width 3i -text "Please provide a process to run." -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground blue
    } elseif { $class == 361 } {
        message .lerror.msg -width 3i -text "Update of crontab failed!" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground red
    } else {
        message .lerror.msg -width 3i -text "Infernal Internal Error\n Number: $class" -font -Adobe-Times-Medium-R-Normal-*-180-* -foreground green
    }
    pack .lerror.msg -expand 1 -padx 3m -pady 3m
    button .lerror.quit -text "Dismiss" -command { destroy .lerror }
    pack .lerror.quit -side bottom -padx 3m -pady 3m
}

set ping_sock 0
set ping_val {}

#
# ---------------- Procedure for Pinging MAT Agent -------------------
#
# USE:  pingHost $hostname
# Returns 1 on success, 0 in failure
#
proc pingHost { hostname } {
    global port
    global ping_sock
    global ping_val
    catch "socket $hostname $port" retval
    set ping_sock $retval
    if { [string first "sock" [lindex $retval 0 ]] == -1 } {
	# Ping failed.....  Host not responding
	return 0
    } else {
	set stream_status 0
	fileevent $ping_sock readable {
	    set ping_val [gets $ping_sock ]
	    set stream_status 1
	}
	# Let start line pass
	vwait stream_status
	set stream_status 0
	puts $ping_sock "ping"
	flush $ping_sock
	vwait stream_status
	close $ping_sock
    }
    return $ping_val
}


#
# ---------------- Procedure for Querying Hosts ----------------
#
#   hostname = the Name of the host
#   command  = The command to send
#   visable  = (1) display result, (0) display nothing
#   args     = extended command set
#              arg(0) = ext    - Extended command flag
#              arg(1) = type   - Extended command type  [ put ]
#                                USE:  put {type} {widget}    type = widget type [t=text, l=list]   widget = widget path 
# This is ONLY good for one line commands
proc queryHost { hostname command visable args } {
    global port
    global passwd
    global username
    global socket_data
    . config -cursor watch
#    puts stderr "queryHost: $passwd  $command $visable $args"
    if { $visable == 1 } {
	if { [winfo exists .sock ] == 0 } {
	    toplevel .sock -class Dialog
	    wm title .sock "Command Output"
	    wm iconname .sock "Command Output"
	    text .sock.text -width 70 -height 12 -yscrollcommand { .sock.textscroll set }
	    scrollbar .sock.textscroll -orient vertical -command ".sock.text yview"
	    pack .sock.textscroll -side left -fill y
	    pack .sock.text -side bottom -expand 1 -fill both
	    button .sock.quit -text "Dismiss" -command "destroy .sock"
	    pack .sock.quit 
	}
    }
    if { [winfo exists .shidden1 ] == 0 } {
	entry .shidden1 
    }
    .shidden1 delete 0 end
    .shidden1 insert end $visable
    set socket_data ""
    set stream_status 0
    global authenticated
    set authenticated 0
    global server_socket
    # If can't connect issue an error
    catch "socket $hostname $port" retval
    set server_socket $retval
    if { [string first "sock" [lindex $retval 0 ]] == -1 } {
	# Host not responding
	return "ERROR:  MAT Agent on $hostname not responding"
    }

    fconfigure $server_socket -buffering line  
    fileevent $server_socket readable {
	set l [gets $server_socket ]
#	puts stderr "Got: $l"
	global authenticated
	if { $authenticated == 0 } {
	    if { $l == "Authentication Passed" } {
		set authenticated 1
		set stream_status 100
	    } elseif { [lindex [split $l " " ] 0 ] == "ERROR:" } {
		set authenticated 0
		set stream_status 99
		error 5
		puts stderr "PASS ERROR:  Auth=$authenticated  Stream_stat=$stream_status"
	    }
	    if { [.shidden1 get ] == 1 } {
		    .sock.text insert end "$l\n"
	    }
	    if { $authenticated == 0 } {
		puts $server_socket "$username:$passwd"
		flush $server_socket
	    }
	} else {
	    if { $l == "TRANSFER OK" } {
		set stream_status 1
	    } else {
		if { [.shidden1 get ] == 1 } {
		    .sock.text insert end "$l\n"
		}
		lappend socket_data $l
		if { [lindex [split $l " " ] 0 ] == "ERROR:" } {
		    set stream_status 1
		}
	    }
	}
    }
    flush $server_socket
    vwait stream_status
    if { $authenticated != 1 } {
	# Authentication failed
	close $server_socket
	. config -cursor top_left_arrow
	puts stderr "The pass string for $hostname is invalid  auth=$authenticated  stream_stat=$stream_status"
	return ""
    }
    set stream_status 0
    puts $server_socket $command
    flush $server_socket
    vwait stream_status
    if { [string length $args ] == 0 } {
	close $server_socket
	. config -cursor top_left_arrow
#	puts stdout "No extended commands "
	return $socket_data
    } else {
#	puts stdout "Extended command issued....."
	if { [lindex $args 0 ] == "ext" } {
	    if { [lindex $args 1 ] == "put" } {
		set wtype [lindex $args 2 ]
		set widget [lindex $args 3 ]
		if { $wtype == "v" } {
		    # This is for Variables
		    global upgrade_buff                    # <------------ Needed for upgrade
		    for { set position 0 } { $position < [llength $upgrade_buff ] } { incr position 1 } {
			set data [lindex $upgrade_buff $position ]    
			# <------------  Needs upgrade_buff instead of $widget
#			puts $server_socket "MaT>[string trimright $data ]\n"
			puts $server_socket "MaT>$data" 
			flush $server_socket
#			puts stdout "Data = $data"
		    } 
		} elseif { $wtype == "l" } {
		    # This is for listboxes
		    for { set position 0 } { $position < [$widget index end ] } { incr position 1 } {
			eval "set data \"[$widget get $position ]\" "
			puts $server_socket "MaT>$data" 
			flush $server_socket
		    } 
		} else {
		    # This is for text widgets
		    for { set position 1 } { $position < [$widget index end ] } { incr position 1 } {
			set data [$widget get $position.0 $position.end ]
#			puts stdout "Sent: $data"
#			eval "set data \"[$widget get $position.0 $position.end ]\" "
			puts $server_socket "MaT>$data"
			flush $server_socket
		    } 
		}
		puts $server_socket "MaT_DoNe."
		flush $server_socket
		vwait stream_status
		close $server_socket
		. config -cursor top_left_arrow
		return $socket_data
	    }
	} else {
	    puts stdout "Unknown command sequence: [lindex $args 0 ] "
	    close $server_socket
	    . config -cursor top_left_arrow
	    return $socket_data
	}
    }
    # Should not get here, but just in case:
    close $server_socket
}


#
# -- Procedure to Login --
#
# Passwd value is stored in passwd variable
# Login name is stored in user
# type - n=new, otherwise regular
proc getPasswd	{ currenthost type } {
    global passwd
    global new
    global username
    if { [winfo exists .getPass ] != 0 } {
	destroy .login
    }
    set new $type
    toplevel .login -class Dialog
    wm title .login "User Authentication"

    frame .login.f1 -relief raised -bd 2
    label .login.f1.l1 -text "Login" -justify center -width 12
    entry .login.f1.e1 -width 16 
    pack .login.f1.l1 .login.f1.e1 -side left
    pack .login.f1 -side top -fill both
    
    frame .login.f2 -relief raised -bd 2
    label .login.f2.l1 -text "Pass String" -justify center -width 12
    entry .login.f2.e1 -width 16 -show "*"
    pack .login.f2.l1 .login.f2.e1 -side left
    pack .login.f2 -side top -fill both
    
    frame .login.f3 -relief raised -bd 2
    label .login.f3.l1 -text "Enter the New Authentication String\nIt will NOT be displayed\nMinimum 10 characters" -justify center
    entry .login.f3.e1 -width 16 -show "*"
    label .login.f3.l2 -text "Enter the New String Again" -justify center
    entry .login.f3.e2 -width 16 -show "*"
    pack .login.f3.l1 .login.f3.e1 .login.f3.l2 .login.f3.e2 -side top

    button .login.b1 -text "Okay" -foreground #008000 -command "newPass $currenthost "
    button .login.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command "destroy .login"
    button .login.b3 -text "Change Password" -foreground red -activeforeground #800000 -command "pack forget .login.b1 ;pack forget .login.b2 ;pack forget .login.b3 ; pack .login.f3 -fill both -side top ;pack .login.b1 .login.b2 -side left ; set new n" 
    if { $type == "n" } {
	pack .login.f3 -fill both -side top 
	pack .login.b1 .login.b2 -side left
    } else {
	pack .login.b1 .login.b2 .login.b3 -side left
    }

    focus .login.f1.e1
    .login.f1.e1 delete 0 end
    .login.f1.e1 insert end $username
    .login.f2.e1 delete 0 end
    .login.f2.e1 insert end $passwd

    #-------------- Bindings -------------------
    bind .login.f1.e1 <Return> {
	focus .login.f2.e1
    }
    bind .login.f2.e1 <Return> {
	if { $new != "n" } {
	    .login.b1 invoke
	} else {
	    focus .login.f3.e1
	}
    }
    bind .login.f3.e1 <Return> {
	focus .login.f3.e2
    }
    bind .login.f3.e2 <Return> {
	.login.b1 invoke
    }
}

#
# --  Procedure to update Password 
#
# This procedure will update the password on all the machines in currenthost
# It can olny be called from getPasswd
proc newPass { currenthost } {
    global passwd
    global new
    global username
    puts stdout "newPass:  Type = $new "  
    if { $new != "n" } {
	set username [.login.f1.e1 get]
	set passwd [.login.f2.e1 get]
	destroy .login
    } else {
	if { [.login.f3.e1 get] != [.login.f3.e2 get ] } {
	    .login.f3.e1 delete 0 end
	    .login.f3.e2 delete 0 end
	    error 220
	} else {
	    set cmdline "mod matpass [.login.f1.e1 get]:[.login.f3.e2 get]:"
	    puts stderr "Sending $cmdline"
	    set cmdresult [queryHost $currenthost $cmdline 1 $passwd ]
	    if { [lindex [split $cmdresult] 0] == "\{ERROR:" } {
		error 221
	    } else {
		set passwd [.login.f3.e2 get]
		destroy .login
	    }
	} 
    }
}




#
# -- Procedure to read data from raw data and fill list window --
#
proc filllist { data window } {  
    $window delete 0 end
    for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	set tmp [lindex $data $position ]
	$window insert end "$tmp\n"
    }
}

#
# -- Procedure to read hostss from raw data and fill list box window --
#
proc fillhostlist { data window } {  
    $window delete 0 end
    for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	set tmp [lindex $data $position ]
	$window insert end $tmp
    }
}



#
# -- Procedure to Select and De-select lines of text
#
proc Selecter { window tag } {
    global SelectorLine
    set isSelect [ $window tag cget $tag -underline ]
    puts stdout $isSelect
    if { $isSelect == {} || $isSelect == 0 } {
	if { $SelectorLine != 9999 } {
	    # De-select other line first
	    $window tag configure l$SelectorLine -underline 0
	}
	set notIsSelect 1
	set SelectorLine [ string range $tag 1 end ]
    } else {
	set notIsSelect 0
	set SelectorLine 9999
    }
    $window tag configure $tag -underline $notIsSelect
}

#
# --------------- Procedure for Displaying Host Info -----------
#
# 
proc HostInfo { hostname data } {
    if { [winfo exists .hI ] != 1 } {
	toplevel .hI -class Dialog
	wm title .hI "Host Info for $hostname"
	wm iconname .hI "$hostname HostInfo"
	frame .hI.nameFrame -relief raised -bd 2 
	label .hI.nameLabel -text "Host Name" -width 13
	entry .hI.nameEntry -relief sunken -bd 2 -width 15 
	pack .hI.nameLabel .hI.nameEntry -in .hI.nameFrame -side left -expand 1 -fill both
	frame .hI.matFrame -relief raised -bd 2 
	label .hI.matLabel -text "MAT Version" -width 13
	entry .hI.matEntry -relief sunken -bd 2 -width 15 
	pack .hI.matLabel .hI.matEntry -in .hI.matFrame -side left -expand 1 -fill both
	frame .hI.osFrame -relief raised -bd 2
	label .hI.osLabel -text "OS Type" -width 13
	entry .hI.osEntry -relief sunken -bd 2 -width 15
	pack .hI.osLabel .hI.osEntry -in .hI.osFrame -side left -expand 1 -fill both
	frame .hI.verFrame -relief raised -bd 2
	label .hI.verLabel -text "Version" -width 13
	entry .hI.verEntry -relief sunken -bd 2 -width 15
	pack .hI.verLabel .hI.verEntry -in .hI.verFrame -side left -expand 1 -fill both
	frame .hI.archFrame -relief raised -bd 2
	label .hI.archLabel -text "Architecture" -width 13
	entry .hI.archEntry -relief sunken -bd 2 -width 15
	pack .hI.archLabel .hI.archEntry -in .hI.archFrame -side left -expand 1 -fill both
	frame .hI.upFrame -relief raised -bd 2
	label .hI.upLabel -text "Up Time" -width 13
	entry .hI.upEntry -relief sunken -bd 2 -width 15
	pack .hI.upLabel .hI.upEntry -in .hI.upFrame -side left -expand 1 -fill both
	frame .hI.ipFrame -relief raised -bd 2
	label .hI.ipLabel -text "IP Address" -width 13
	entry .hI.ipEntry -relief sunken -bd 2 -width 15
	pack .hI.ipLabel .hI.ipEntry -in .hI.ipFrame -side left -expand 1 -fill both
	frame .hI.memFrame -relief raised -bd 2
	label .hI.memLabel -text "RAM Size" -width 13
	entry .hI.memEntry -relief sunken -bd 2 -width 15
	pack .hI.memLabel .hI.memEntry -in .hI.memFrame -side left -expand 1 -fill both
	frame .hI.swapFrame -relief raised -bd 2
	label .hI.swapLabel -text "SWAP Size" -width 13
	entry .hI.swapEntry -relief sunken -bd 2 -width 15
	pack .hI.swapLabel .hI.swapEntry -in .hI.swapFrame -side left -expand 1 -fill both
	button .hI.done -text "Dismiss" -command { 
	    destroy .hI 
	} 
	pack .hI.nameFrame .hI.matFrame .hI.osFrame .hI.verFrame .hI.archFrame .hI.upFrame .hI.ipFrame .hI.memFrame .hI.swapFrame -fill both
	pack .hI.done
    } else {
	.hI.nameEntry delete 0 end
	.hI.matEntry delete 0 end
	.hI.osEntry delete 0 end 
	.hI.verEntry delete 0 end
	.hI.archEntry delete 0 end
	.hI.upEntry delete 0 end
	.hI.ipEntry delete 0 end
	.hI.memEntry delete 0 end
	.hI.swapEntry delete 0 end 
    }
    .hI.matEntry insert end [lindex [split [lindex $data 0 ] ": " ] 2 ]
    .hI.nameEntry insert end [lindex [split [lindex $data 1 ] ": " ] 2 ]
    .hI.osEntry insert end [lindex [split [lindex $data 2 ] ": " ] 2 ]
    .hI.verEntry insert end [lindex [split [lindex $data 3 ] ": " ] 2 ]
    .hI.archEntry insert end [lindex [split [lindex $data 4 ] ": " ] 2 ]
    .hI.upEntry insert end [lindex [split [lindex $data 5 ] " " ] 1 ]
    .hI.ipEntry insert end [lindex [split [lindex $data 6 ] ": " ] 2 ]
    .hI.memEntry insert end [lindex [split [lindex $data 7 ] ": " ] 2 ]
    .hI.swapEntry insert end [lindex [split [lindex $data 8 ] ": " ] 2 ]
}


proc about {} {
    if { [winfo exists .about ] != 0 } {
	destroy .about
    }
    toplevel .about -class Dialog
    wm title .about "License"
    wm iconname .about Dialog
    frame .about.t1 -relief raised -bd 2 
    text .about.t1.t -width 50 -height 12 
    pack .about.t1.t -fill both -expand 1
    .about.t1.t configure -font -*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-* -wrap word
    .about.t1.t tag configure norm -font -*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-* -justify center
    .about.t1.t tag configure big -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-*
    .about.t1.t tag configure red -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-* -foreground #f04040 -justify center
    .about.t1.t tag configure bigCenter -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-* -justify center
    .about.t1.t tag configure title -font -*-Helvetica-Bold-R-Normal--*-180-*-*-*-*-*-* -justify center

    .about.t1.t insert end "MAT\n" title
    .about.t1.t insert end "\n"
    .about.t1.t insert end "Monitoring and Administration Tool (MAT)\n" bigCenter
    .about.t1.t insert end "Version 0.1 (" bigCenter
    .about.t1.t insert end "ALPHA" red
    .about.t1.t insert end ")\n" bigCenter
    .about.t1.t insert end "(c) 1997" bigCenter
    .about.t1.t insert end "\n"
    .about.t1.t insert end "Mark Black\n\n" bigCenter
    .about.t1.t insert end "Email:  sblack@ee.ryerson.ca\n" bigCenter
    .about.t1.t insert end "MAT is in no way affiliated with Ryerson " norm
    .about.t1.t insert end "Polytechnical University\n" norm
    frame .about.f2 -relief raised -bd 2 
    button .about.f2.b2 -text "-- Close --" -command "destroy .about"
    pack .about.f2.b2 -side left -fill x 
    pack .about.t1 .about.f2 -side top -fill both
}

proc licen {} {
    if { [winfo exists .licen ] != 0 } {
	destroy .licen
    }
    toplevel .licen -class Dialog
    wm title .licen "License"
    wm iconname .licen Dialog
    frame .licen.t1 -relief raised -bd 2 
    text .licen.t1.t -width 50 -height 16 -yscrollcommand {.licen.t1.tscroll set }
    scrollbar .licen.t1.tscroll -orient vertical -command ".licen.t1.t yview"
    pack .licen.t1.tscroll -side left -fill y
    pack .licen.t1.t -fill both -expand 1
    .licen.t1.t configure -font -*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-* -wrap word
    .licen.t1.t tag configure courier -font -Adobe-Courier-Medium-R-Normal--*-120-*-*-*-*-*-* 
    .licen.t1.t tag configure big -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-*
    .licen.t1.t tag configure red -font -*-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-* -foreground #f02020
    .licen.t1.t tag configure blue -font -*-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-* -foreground #2020f0
    .licen.t1.t tag configure green -font -*-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-* -foreground #20a020
    .licen.t1.t tag configure bigCenter -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-* -justify center
    .licen.t1.t tag configure title -font -*-Helvetica-Bold-R-Normal--*-180-*-*-*-*-*-* -justify center

    .licen.t1.t insert end "MAT License Agreement\n" title
    .licen.t1.t insert end "\n"
    .licen.t1.t insert end "Monitoring and Administration Tool (MAT) is provided AS IS.  This is an "
    .licen.t1.t insert end "ALPHA" red 
    .licen.t1.t insert end " release, as such we make NO gaurentee as to the softwares fitness.\n\n"
    .licen.t1.t insert end "IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL"
    .licen.t1.t insert end " DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE "
    .licen.t1.t insert end "BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\n"
    .licen.t1.t insert end "This software is provided free of charge, as such we accept NO liability for lost "
    .licen.t1.t insert end "data, time, or any other type of loss.  You by accepting or running part or all of the MAT software programs accept all "
    .licen.t1.t insert end "responsibility for any consiquences of it's use."
    .licen.t1.t insert end "\n\n"
    .licen.t1.t insert end "This software may be freely distributed provided it is complete, and unaltered.  This code cannot be modified for sale."
    .licen.t1.t insert end "\n\n"
    .licen.t1.t insert end "This software is provided AS-IS.  The authors have no obligation to provide support, maintenance, updates, enhancements, or"
    .licen.t1.t insert end "modifications.\n"
    .licen.t1.t insert end "\n"
    frame .licen.f2 -relief raised -bd 2 
    button .licen.f2.b1 -text "I accept the above agreement" -command {
	global mb_hosts
	set fid [ open $mb_hosts w ]
	close $fid
        help startup
	destroy .licen
    }
    button .licen.f2.b2 -text "I reject the above agreement" -command "destroy ."
    pack .licen.f2.b1 .licen.f2.b2 -side left -fill x 
    pack .licen.t1 .licen.f2 -side top -fill both
}




