# Mail.tcl
# Copyright (c) 1997 Mark Black
#
# Mail Alias update procedure
#
# USE Mail CurrentHost CurrentLine SelectedData
#             CurrentHost = host to update
#             CurrentLine = Line number of selected line
#                           If 9999 then it is a new entry
#             SelectedData = line of data to modify
# NOTE: Data must be seperated by a single space or a singel tab
#
proc Mail { currenthost currentline line args } {
    set host $currenthost
    if { [string length $args ] != 0 } {
	append line " $args"
    }
    if { [winfo exists .mail ] == 0 } {
	toplevel .mail -class Dialog
	wm title .mail "Mail List Editor: $currenthost"
	wm iconname .mail "Mail Editor"
	entry .mail.hidden1 
	entry .mail.hidden2
	entry .mail.hidden3
	# NOT GOOD
	.mail.hidden1 insert end $currenthost
	.mail.hidden2 insert end $currentline
	.mail.hidden3 insert end $line
	frame .mail.f1 -bd 2 -relief "raised"
	label .mail.f1.l1 -text "Mail Alias:" -width 10
	entry .mail.f1.e1 -width 10
	pack .mail.f1.l1 .mail.f1.e1 -fill both -side left -expand 1
	pack .mail.f1 -fill both -side top -expand 1
	frame .mail.f2 -bd 2 -relief "raised"
	label .mail.f2.l1 -text "Alias Type:" -width 10
	set mtype "None"
	radiobutton .mail.f2.b1 -text "List" -selectcolor #000080 -variable mtype -value "List" -command "pack forget .mail.f3 .mail.f5 ;pack .mail.f4 .mail.f5 -fill both " 
	radiobutton .mail.f2.b2 -text "Redirect" -selectcolor #000080 -variable mtype -value "Redirect" -command "pack forget .mail.f4 .mail.f5 ;pack .mail.f3 .mail.f5 -fill both ;.mail.f3.l1 configure -text {Email address to redirect to} " 
	radiobutton .mail.f2.b3 -text "Log" -selectcolor #000080 -variable mtype -value "Log" -command "pack forget .mail.f4 .mail.f5 ;pack .mail.f3 .mail.f5 -fill both ;.mail.f3.l1 configure -text {File to log emails in:} "
	radiobutton .mail.f2.b4 -text "Command" -selectcolor #000080 -variable mtype -value "Command" -command "pack forget .mail.f4 .mail.f5 ;pack .mail.f3 .mail.f5 -fill both ;.mail.f3.l1 configure -text {Program to pass email to:} "
	pack .mail.f2.l1 .mail.f2.b1 .mail.f2.b2 .mail.f2.b3 .mail.f2.b4 -fill both -side left -expand 1
	pack .mail.f2 -fill both -side top -expand 1
	# Redirect type
	frame .mail.f3 -bd 2 -relief "raised"
	label .mail.f3.l1 -text "Email address to redirect to" -width 10
	entry .mail.f3.e1 -width 30
	pack .mail.f3.l1 .mail.f3.e1 -fill x -side top -expand 1
	# Mail list type
	frame .mail.f4 -bd 2 -relief "raised"
	label .mail.f4.l1 -text "Mailing List" -width 10
	frame .mail.f4.f0 -bd 0 -relief "flat"
	label .mail.f4.f0.l1 -text "List file:" -width 10
	entry .mail.f4.f0.e1 -width 30
	pack .mail.f4.f0.l1 .mail.f4.f0.e1 -fill both -side left -expand 1
	frame .mail.f4.f1 -bd 2 -relief "flat"
	entry .mail.f4.f1.e1 -width 20
	button .mail.f4.f1.b1 -text "Add" -command {
	    if { [.mail.f4.f1.e1 get] != "" } {
		.mail.f4.f2.text insert end [.mail.f4.f1.e1 get]
	    }
	    .mail.f4.f1.e1 delete 0 end
	}
	pack .mail.f4.f1.e1 .mail.f4.f1.b1 -fill both -side left -expand 1
	frame .mail.f4.f2 -bd 2 -relief "flat"
	scrollbar .mail.f4.f2.vscroll -orient vertical -command ".mail.f4.f2.text yview" 
	listbox .mail.f4.f2.text -selectforeground white -selectbackground #000080 -yscrollcommand {.mail.f4.f2.vscroll set } -height 5 -width 30
	.mail.f4.f2.text config -cursor hand2
	pack .mail.f4.f2.vscroll -side left -fill y
	pack .mail.f4.f2.text -side left -expand 1 -fill both
	button .mail.f4.f2.b1 -text "Delete" -foreground red -activeforeground red -command {
	    if { [.mail.f4.f2.text curselection ] != "" } {
		.mail.f4.f2.text delete [.mail.f4.f2.text curselection ]
	    }
	}
	pack .mail.f4.f2.b1 -side left
	pack .mail.f4.f0 .mail.f4.f1 .mail.f4.f2 -side top -fill both -expand 1

	frame .mail.f5 -bd 2 -relief "raised"
	button .mail.f5.b1 -text "Apply" -foreground red -activeforeground #a00000 -command {
	    # Update aliases file first
	    set newline "[.mail.f1.e1 get ]:"
	    if { $mtype == "List" } {
		# Mailing list file
		append newline " :include:[ .mail.f4.f0.e1 get ]"
	    } elseif { $mtype == "Redirect" } {
		# Redirect type entry
		append newline " [ .mail.f3.e1 get ]"
	    } elseif { $mtype == "Log" } {
		# Email Log type
		append newline " [ .mail.f3.e1 get ]"
	    } elseif { $mtype == "Command" } {
		# Email Command type
		append newline "|\"[ .mail.f3.e1 get ]\""
	    } else {
		puts stdout "ERROR:  Unknown alias type:  $mtype"
	    }
	    if { [.mail.hidden2 get ] != 9999 } {
		# Not New data
		set cmd "mod alias [.mail.hidden2 get ] $newline"
	    } else {
		set cmd "add alias $newline"
	    }
	    puts stdout "MAIL:  cmd = $cmd "
	    set returnval [queryHost [.mail.hidden1 get ] $cmd 1 ]
	    if { [lindex [split $returnval " " ] 0 ] == "\{ERROR:" } {
		error 240
		puts stdout "ERROR:  Unable to update the Mail Aliases file on $currenthost\n       Check the files permissions"
	    } elseif { $mtype == "List"} {
		if { [winfo ismapped .mail.f4 ] == 1 } {
		    # Mailing list alias type:  Update list
		    set cmd "put ascii [.mail.f4.f0.e1 get ]"
		    set returnval [queryHost [.mail.hidden1 get ] $cmd 1 "ext" "put" "l" ".mail.f4.f2.text" ]
		    if { [lindex [split [lindex $returnval end ] " " ] 0 ] == "ERROR:" } {
			error 241
			puts stdout "ERROR:  Unable to update the Mail Aliases file on $currenthost\n       Check the files permissions"
		    } else {
			set returndata [queryHost $currenthost "get alias" 0 ]
			filltext $returndata .general.text 8
			destroy .mail
		    }
		}
	    } else {
		set returndata [queryHost $currenthost "get alias" 0 ]
		filltext $returndata .general.text 8
		destroy .mail
	    }
	}
	button .mail.f5.b2 -text "Cancel" -foreground #000080 -activeforeground #000040 -command {
	    destroy .mail
	}
	button .mail.f5.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command "help mail"
	pack .mail.f5.b1 .mail.f5.b2 .mail.f5.b3 -side left

	#---------------- Bindings ------------------------------
	bind .mail.f1.e1 <Return> { 
	    if {$mtype == "List" } {
		focus .mail.f4.f0.e1
	    } else {
		focus .mail.f3.e1 
	    }
	}
	bind .mail.f3.e1 <Return> {
	    .mail.f5.b1 invoke
	}
	bind .mail.f4.f0.e1 <Return> {
	    focus .mail.f4.f1.e1
	}
	bind .mail.f4.f1.e1 <Return> {
	    if { [.mail.f4.f1.e1 get] != "" } {
		.mail.f4.f2.text insert end [.mail.f4.f1.e1 get]
	    }
	    .mail.f4.f1.e1 delete 0 end
	}
    } else {
	# Window is already open
	# Clean up old entries
	.mail.hidden1 delete 0 end
	.mail.hidden2 delete 0 end
	.mail.hidden3 delete 0 end
	.mail.hidden1 insert end $currenthost
	.mail.hidden2 insert end $currentline
	.mail.hidden3 insert end $line
	
    }
    # -----------------  Populate Widgets -------------------
    .mail.f1.e1 delete 0 end
    .mail.f3.e1 delete 0 end
    .mail.f4.f0.e1 delete 0 end
    if { [.mail.hidden2 get ] != 9999 } {
	set tmp [split [ .mail.hidden3 get] ":" ]
	.mail.f1.e1 insert end [ lindex $tmp 0 ]
	set trimval [ expr [string length [lindex $tmp 0 ] ] + 1 ]
	set tmp3 [ string trim [ string range [ .mail.hidden3 get] $trimval end ] ]
	set schar [string range $tmp3 0 0 ]
	if { $schar == "/" } {
	    .mail.f2.b3 invoke
	    .mail.f3.e1 insert end $tmp3
	} elseif { $schar == "|" } {
	    # Command type
	    .mail.f2.b4 invoke
	    .mail.f3.e1 insert end [ string trim $tmp3 {\|\"} ]
	} elseif { $schar == ":" } {
	    # Mail List type
	    .mail.f2.b1 invoke
	    set tmp3 [ string trim [ string range $tmp3 [ string length ":include:" ] end ] {\"} ]
	    .mail.f4.f0.e1 insert end $tmp3
	    set cmd "get raw $tmp3"
	    puts stdout "Cmd = $cmd"
	    set returnval [queryHost [.mail.hidden1 get ] $cmd 0 ]
	    if { [lindex [split $returnval " " ] 0 ] == "\{ERROR:" } {
		error 242
		puts stdout "ERROR:  Unable to read the mailing list $tmp3 on $currenthost\n       Check the files permissions."
	    } else {
		for { set position 0 } { $position < [llength $returnval] } { incr position 1 } {
#		    set tmp [string trim [lindex $returnval $position ] ]
		    set tmp [lindex $returnval $position ] 
		    .mail.f4.f2.text insert end $tmp
		}
	    }
	} else {
	    .mail.f2.b2 invoke
	    .mail.f3.e1 insert end $tmp3
	}    
    }
}

