/*      -------------------------------------------------------------------
	xldlas -- A Stastics Package

	Copyright (C) 1996 Thor Sigvaldason

	Handles the echoing of on-screen output to user-specified log and
	texlog files
	
        -------------------------------------------------------------------*/

#include "xldlas.h"

extern void inhibit_input();
extern void reenable_input();
extern void say_status(char the_status[XLDLASMAX_INPUT]);
extern void do_system_call(char the_command[XLDLASMAX_INPUT]);

void filter_tex_specials(char input_string[XLDLASMAX_INPUT])
{
	int i;
	int no_filter;
	int place;
	place = 0;
	strcpy(filtered_tex_string,"");
	for(i = 0; i < strlen(input_string); i++)
	{
		no_filter = TRUE;
		if(input_string[i] == '$')
		{
			no_filter = FALSE;
			filtered_tex_string[place] = '\\';
			place++;
			filtered_tex_string[place] = '$';
			place++;
		}
		if(input_string[i] == '%')
		{
			no_filter = FALSE;
			filtered_tex_string[place] = '\\';
			place++;
			filtered_tex_string[place] = '%';
			place++;
		}
		if(input_string[i] == '&')
		{
			no_filter = FALSE;
			filtered_tex_string[place] = '\\';
			place++;
			filtered_tex_string[place] = '&';
			place++;
		}
		if(input_string[i] == '#')
		{
			no_filter = FALSE;
			filtered_tex_string[place] = '\\';
			place++;
			filtered_tex_string[place] = '#';
			place++;
		}
		if(input_string[i] == '_')
		{
			no_filter = FALSE;
			filtered_tex_string[place] = '\\';
			place++;
			filtered_tex_string[place] = '_';
			place++;
		}
		if(no_filter == TRUE)
		{
			filtered_tex_string[place] = input_string[i];
			place++;
		}
	}
	filtered_tex_string[place] = '\0';
}

int click_end_viewfile(FL_FORM *form, void *arg)
{
	say_status("Ready");
	return(FL_OK);
}

void end_viewfile(FL_OBJECT *obj, long arg)
{
	say_status("Ready");
	fl_hide_form(viewfile_window);
}

void view_a_file(char the_file[XLDLASMAX_INPUT])
{
	say_status("Viewing File");
	fl_clear_browser(viewfile_browser);
	fl_load_browser(viewfile_browser,the_file);
	fl_show_form(viewfile_window,FL_PLACE_FREE,FL_TRANSIENT,the_file);
}

void print_a_file(char the_file[XLDLASMAX_INPUT])
{
	char string_one[XLDLASMAX_INPUT];
	say_status("Printing File");
	sprintf(string_one,"%s %s",print_command, the_file);
	do_system_call(string_one);
	say_status("Ready");
}

void dvi_a_file(char the_file[XLDLASMAX_INPUT])
{
	char string_one[XLDLASMAX_INPUT];
	char one_character;
	FILE *original_file;
	FILE *working_file;
	say_status("Preview a TeXLog file ...");
	original_file = fopen(the_file,"r");
	working_file = fopen("xldlas_temp.tex","w");
	while(!feof(original_file))
	{
		fscanf(original_file,"%c",&one_character);
		fprintf(working_file,"%c",one_character);
	}
	fprintf(working_file,"\n\n\\bye");
	fclose(original_file);
	fclose(working_file);
	sprintf(string_one, "%s xldlas_temp.tex ; %s xldlas_temp.dvi ; rm xldlas_temp.tex ; rm xldlas_temp.log ; rm xldlas_temp.dvi ", tex_command, dviview_command);
	do_system_call(string_one);
	say_status("Configuring TeXLog");
}

void texprint_a_file(char the_file[XLDLASMAX_INPUT])
{
	char string_one[XLDLASMAX_INPUT];
	char one_character;
	FILE *original_file;
	FILE *working_file;
	say_status("Preview a TeXLog file ...");
	original_file = fopen(the_file,"r");
	working_file = fopen("xldlas_temp.tex","w");
	while(!feof(original_file))
	{
		fscanf(original_file,"%c",&one_character);
		fprintf(working_file,"%c",one_character);
	}
	fprintf(working_file,"\n\n\\bye");
	fclose(original_file);
	fclose(working_file);
	sprintf(string_one, "%s xldlas_temp.tex ; %s xldlas_temp.dvi ; rm xldlas_temp.tex ; rm xldlas_temp.log ; rm xldlas_temp.dvi ", tex_command, dviprint_command);
	do_system_call(string_one);
	say_status("Configuring TeXLog");
}


int  click_done_logtexlog(FL_FORM *form, void *arg)
{
	reenable_input();
	say_status("Ready");
	return(FL_OK);
}

void log_init_output()
{
	time_t	timeval;
	(void)time(&timeval);
	fprintf(log_file,"#\n#This file was created/appended by xldlas v%d.%d on %s#\n", XLDLAS_MAJOR, XLDLAS_MINOR, ctime(&timeval)); 
}

void htmllog_init_output()
{
	time_t	timeval;
	(void)time(&timeval);
	fprintf(htmllog_file,"<P> This file was created/appended by xldlas v%d.%d on %s </P>\n", XLDLAS_MAJOR, XLDLAS_MINOR, ctime(&timeval)); 
}

void texlog_init_output()
{
	time_t	timeval;
	(void)time(&timeval);
	fprintf(texlog_file,"%%\n%%This file was created/appended by xldlas v%d.%d on %s%%\n", XLDLAS_MAJOR, XLDLAS_MINOR, ctime(&timeval)); 
	fprintf(texlog_file,"%s\n", tex_preamble);
}

void set_texlog_inhibits()
{
	if(strlen(texlog_name) < 1)
	{
		fl_set_input(texlog_file_input,"");
		fl_set_button(texlog_on_button, 0);
		fl_deactivate_object(texlog_on_button);
		fl_set_object_lcol(texlog_on_button,FL_INACTIVE);
		fl_set_button(texlog_verbose_button, texlog_verbose_on);
		fl_deactivate_object(texlog_verbose_button);
		fl_set_object_lcol(texlog_verbose_button,FL_INACTIVE);
		fl_deactivate_object(texlog_source_button);
		fl_set_object_lcol(texlog_source_button,FL_INACTIVE);
		fl_deactivate_object(texlog_dvi_button);
		fl_set_object_lcol(texlog_dvi_button,FL_INACTIVE);
		fl_deactivate_object(texlog_print_button);
		fl_set_object_lcol(texlog_print_button,FL_INACTIVE);
	}
	else
	{
		fl_set_input(texlog_file_input,texlog_name);
		fl_set_button(texlog_on_button, texlog_on);
		fl_activate_object(texlog_on_button);
		fl_set_object_lcol(texlog_on_button,FL_BLACK);
		fl_set_button(texlog_verbose_button, texlog_verbose_on);
		fl_activate_object(texlog_verbose_button);
		fl_set_object_lcol(texlog_verbose_button,FL_BLACK);
		fl_activate_object(texlog_source_button);
		fl_set_object_lcol(texlog_source_button,FL_BLACK);
		fl_activate_object(texlog_dvi_button);
		fl_set_object_lcol(texlog_dvi_button,FL_BLACK);
		fl_activate_object(texlog_print_button);
		fl_set_object_lcol(texlog_print_button,FL_BLACK);
	}
}

void set_log_inhibits()
{
	if(strlen(log_name) < 1)
	{
		fl_set_input(log_file_input,"");
		fl_set_button(log_on_button, 0);
		fl_deactivate_object(log_on_button);
		fl_set_object_lcol(log_on_button,FL_INACTIVE);
		fl_set_button(log_verbose_button, log_verbose_on);
		fl_deactivate_object(log_verbose_button);
		fl_set_object_lcol(log_verbose_button,FL_INACTIVE);
		fl_deactivate_object(log_view_button);
		fl_set_object_lcol(log_view_button,FL_INACTIVE);
		fl_deactivate_object(log_print_button);
		fl_set_object_lcol(log_print_button,FL_INACTIVE);
	}
	else
	{
		fl_set_input(log_file_input,log_name);
		fl_set_button(log_on_button, log_on);
		fl_activate_object(log_on_button);
		fl_set_object_lcol(log_on_button,FL_BLACK);
		fl_set_button(log_verbose_button, log_verbose_on);
		fl_activate_object(log_verbose_button);
		fl_set_object_lcol(log_verbose_button,FL_BLACK);
		fl_activate_object(log_view_button);
		fl_set_object_lcol(log_view_button,FL_BLACK);
		fl_activate_object(log_print_button);
		fl_set_object_lcol(log_print_button,FL_BLACK);
	}
}

void set_htmllog_inhibits()
{
	if(strlen(htmllog_name) < 1)
	{
		fl_set_input(htmllog_file_input,"");
		fl_set_button(htmllog_on_button, 0);
		fl_deactivate_object(htmllog_on_button);
		fl_set_object_lcol(htmllog_on_button,FL_INACTIVE);
		fl_set_button(htmllog_verbose_button, htmllog_verbose_on);
		fl_deactivate_object(htmllog_verbose_button);
		fl_set_object_lcol(htmllog_verbose_button,FL_INACTIVE);
		fl_deactivate_object(htmllog_view_button);
		fl_set_object_lcol(htmllog_view_button,FL_INACTIVE);
	}
	else
	{
		fl_set_input(htmllog_file_input,htmllog_name);
		fl_set_button(htmllog_on_button, htmllog_on);
		fl_activate_object(htmllog_on_button);
		fl_set_object_lcol(htmllog_on_button,FL_BLACK);
		fl_set_button(htmllog_verbose_button, htmllog_verbose_on);
		fl_activate_object(htmllog_verbose_button);
		fl_set_object_lcol(htmllog_verbose_button,FL_BLACK);
		fl_activate_object(htmllog_view_button);
		fl_set_object_lcol(htmllog_view_button,FL_BLACK);
	}
}

void logtexlog_routines(FL_OBJECT *obj, long arg)
{
	char string_one[XLDLASMAX_INPUT];
	if(arg == 11)
	{
		if(fl_get_button(log_on_button) == TRUE) log_on = TRUE;
		else log_on = FALSE;
		return;
	}
	if(arg == 12)
	{
		if(fl_get_button(log_verbose_button) == TRUE) log_verbose_on = TRUE;
		else log_verbose_on = FALSE;
		return;
	}
	if(arg == 13)
	{
		strcpy(string_one,fl_get_input(log_file_input));
		if(log_file)
		{
			fclose(log_file);
		}
		log_file = fopen(string_one,"a");
		if(!log_file)
		{
			fl_show_alert("Sorry, could not open the requested file for writing","(Is it a legal file name?)","",TRUE);
			return;
		}
		strcpy(log_name,string_one);
		log_verbose_on = TRUE;
		log_on = TRUE;
		set_log_inhibits();
		log_init_output();
		return;
	}
	if(arg == 14)
	{
		fclose(log_file);
		view_a_file(log_name);
		log_file = fopen(log_name,"a");
		return;
	}
	if(arg == 16)
	{
		fclose(log_file);
		print_a_file(log_name);
		log_file = fopen(log_name,"a");
		return;
	}
	if(arg == 17)
	{
		strcpy(string_one,fl_get_input(log_file_input));
		if(strlen(string_one) > 0 && strcmp(string_one,log_name) != 0)
		{
			if(log_file)
			{
				fclose(log_file);
			}
			log_file = fopen(string_one,"a");
			if(!log_file)
			{
				fl_show_alert("Sorry, could not open the requested file for writing","(Is it a legal file name?)","",TRUE);
				return;
			}
			strcpy(log_name,string_one);
			log_verbose_on = TRUE;
			log_on = TRUE;
			set_log_inhibits();
			log_init_output();
		}
		fl_hide_form(log_window);
		say_status("Ready");
		reenable_input();
		return;
	}
	if(arg == 21)
	{
		if(fl_get_button(texlog_on_button) == TRUE) texlog_on = TRUE;
		else texlog_on = FALSE;
		return;
	}
	if(arg == 22)
	{
		if(fl_get_button(log_verbose_button) == TRUE) texlog_verbose_on = TRUE;
		else texlog_verbose_on = FALSE;
		return;
	}
	if(arg == 23)
	{
		strcpy(string_one,fl_get_input(texlog_file_input));
		if(texlog_file)
		{
			fclose(texlog_file);
		}
		texlog_file = fopen(string_one,"a");
		if(!texlog_file)
		{
			fl_show_alert("Sorry, could not open the requested file for writing","(Is it a legal file name?)","",TRUE);
			return;
		}
		strcpy(texlog_name,string_one);
		texlog_verbose_on = TRUE;
		texlog_on = TRUE;
		set_texlog_inhibits();
		texlog_init_output();
		return;
	}
	if(arg == 24)
	{
		fclose(texlog_file);
		view_a_file(texlog_name);
		texlog_file = fopen(texlog_name,"a");
		return;
	}
	if(arg == 25)
	{
		fclose(texlog_file);
		dvi_a_file(texlog_name);
		texlog_file = fopen(texlog_name,"a");
		return;
	}
	if(arg == 26)
	{
		fclose(texlog_file);
		texprint_a_file(texlog_name);
		texlog_file = fopen(texlog_name,"a");
		return;
	}
	if(arg == 27)
	{
		strcpy(string_one,fl_get_input(texlog_file_input));
		if(strlen(string_one) > 0 && strcmp(string_one,texlog_name) != 0)
		{		
			if(texlog_file)
			{
				fclose(texlog_file);
			}
			texlog_file = fopen(string_one,"a");
			if(!texlog_file)
			{
				fl_show_alert("Sorry, could not open the requested file for writing","(Is it a legal file name?)","",TRUE);
				return;
			}
			strcpy(texlog_name,string_one);
			texlog_verbose_on = TRUE;
			texlog_on = TRUE;
			set_texlog_inhibits();
			texlog_init_output();
		}
		fl_hide_form(texlog_window);
		say_status("Ready");
		reenable_input();
		return;
	}
	if(arg == 31)
	{
		if(fl_get_button(htmllog_on_button) == TRUE) htmllog_on = TRUE;
		else htmllog_on = FALSE;
		return;
	}
	if(arg == 32)
	{
		if(fl_get_button(htmllog_verbose_button) == TRUE) htmllog_verbose_on = TRUE;
		else htmllog_verbose_on = FALSE;
		return;
	}
	if(arg == 33)
	{
		strcpy(string_one,fl_get_input(htmllog_file_input));
		if(htmllog_file)
		{
			fclose(htmllog_file);
		}
		htmllog_file = fopen(string_one,"a");
		if(!htmllog_file)
		{
			fl_show_alert("Sorry, could not open the requested file for writing","(Is it a legal file name?)","",TRUE);
			return;
		}
		strcpy(htmllog_name,string_one);
		htmllog_verbose_on = TRUE;
		htmllog_on = TRUE;
		set_htmllog_inhibits();
		htmllog_init_output();
		return;
	}
	if(arg == 34)
	{
		fclose(htmllog_file);
		view_a_file(htmllog_name);
		htmllog_file = fopen(htmllog_name,"a");
		return;
	}
	if(arg == 37)
	{
		strcpy(string_one,fl_get_input(htmllog_file_input));
		if(strlen(string_one) > 0 && strcmp(string_one,htmllog_name) != 0)
		{
			if(htmllog_file)
			{
				fclose(htmllog_file);
			}
			htmllog_file = fopen(string_one,"a");
			if(!htmllog_file)
			{
				fl_show_alert("Sorry, could not open the requested file for writing","(Is it a legal file name?)","",TRUE);
				return;
			}
			strcpy(htmllog_name,string_one);
			htmllog_verbose_on = TRUE;
			htmllog_on = TRUE;
			set_htmllog_inhibits();
			htmllog_init_output();
		}
		fl_hide_form(htmllog_window);
		say_status("Ready");
		reenable_input();
		return;
	}
}


void start_log()
{
	inhibit_input();
	say_status("Adjusting Log File Status");
	set_log_inhibits();
	fl_show_form(log_window,FL_PLACE_FREE,FL_TRANSIENT,"Log File Settings");
}

void start_htmllog()
{
	inhibit_input();
	say_status("Adjusting HTML Log File Status");
	set_htmllog_inhibits();
	fl_show_form(htmllog_window,FL_PLACE_FREE,FL_TRANSIENT,"HTML Log File Settings");
}

void start_texlog()
{
	inhibit_input();
	say_status("Adjusting TeXLog File Status");
	set_texlog_inhibits();
	fl_show_form(texlog_window,FL_PLACE_FREE,FL_TRANSIENT,"TeXLog File Settings");
}


void graph_output(char save_name[XLDLASMAX_INPUT], int the_xvar, int the_variables[], int how_many)
{
	int i;
	char string_one[XLDLASMAX_INPUT];
	char string_two[XLDLASMAX_INPUT];
	if(strlen(save_name) < 1)
	{
		sprintf(string_one,"plot>\tPlotted ");
		for(i = 0; i < how_many; i++)
		{
			strcat(string_one, data_matrix[the_variables[i]].name);
			if(i == how_many -1)
			{
				strcat(string_one," vs ");
			}
			else
			{
				strcat(string_one,", ");
			}
		}
		strcat(string_one, data_matrix[the_xvar].name);
		strcat(string_one," (not saved)");
		fl_addto_browser(main_browser,string_one);
		if(log_on == TRUE && log_verbose_on == TRUE)
		{
			fprintf(log_file,"%s\n", string_one);
		}
		if(texlog_on == TRUE && texlog_verbose_on == TRUE)
		{
			sprintf(string_two,"%%\t%s", string_one);
			fprintf(texlog_file,"%s\n", string_two);
		}
	}
	else
	{
		sprintf(string_one,"plot>\tPlotted ");
		for(i = 0; i < how_many; i++)
		{
			strcat(string_one, data_matrix[the_variables[i]].name);
			if(i == how_many -1)
			{
				strcat(string_one," vs ");
			}
			else
			{
				strcat(string_one,", ");
			}
		}
		strcat(string_one, data_matrix[the_xvar].name);
		strcat(string_one," (saved to ");
		strcat(string_one,save_name);
		strcat(string_one,")");
		fl_addto_browser(main_browser,string_one);
		if(log_on == TRUE && log_verbose_on == TRUE)
		{
			fprintf(log_file,"%s\n", string_one);
		}
		if(texlog_on == TRUE && strlen(tex_graphmacrol) > 0)
		{
			sprintf(string_one,"%s%s%s", tex_graphmacrol, save_name, tex_graphmacror);
			fprintf(texlog_file,"%s\n", string_one);
		}
		if(texlog_on == TRUE && texlog_verbose_on == TRUE && strlen(tex_graphmacrol) < 1)
		{
			sprintf(string_two,"%%\t%s", string_one);
			fprintf(texlog_file,"%s\n", string_two);
		}
		if(htmllog_on == TRUE)
		{
			sprintf(string_one," <CENTER> <IMG SRC=\"%s\"> </CENTER>", save_name);
			fprintf(htmllog_file,"%s\n",string_one);
		}
	}
} 

void simple_line_output(char which_routine[XLDLASMAX_INPUT], char the_output[XLDLASMAX_INPUT])
{
	strcpy(line_of_output,which_routine);
	strcat(line_of_output,">\t");
	strcat(line_of_output,the_output);
	fl_addto_browser(main_browser, line_of_output);
	if(log_on == TRUE && log_verbose_on == TRUE)
	{
		fprintf(log_file,"%s\n",line_of_output);
	}
	if(texlog_on == TRUE && texlog_verbose_on == TRUE)
	{
		fprintf(texlog_file,"%%\t%s\n", line_of_output);
	}
	if(htmllog_on == TRUE && htmllog_verbose_on == TRUE)
	{
		fprintf(htmllog_file,"<P> %s\n</P>\n", line_of_output);
	}
}

void seperator_output(int how_many)
{
	char string_one[XLDLASMAX_INPUT];
	char string_two[XLDLASMAX_INPUT];
	int i,j;
	strcpy(string_one,"");
	for(i = 0; i <= how_many; i++)
	{
		for(j = 0; j < NAME_LENGTH; j++)
		{
			strcat(string_one,"-");
		}
	}
	strcpy(string_two, "@f@Stbl>  ");
	strcat(string_two, string_one);
	fl_addto_browser(main_browser, string_two);
	if(log_on == TRUE)
	{
		strcpy(string_two, "tbl>  ");
		strcat(string_two, string_one);
		fprintf(log_file, string_two);
		fprintf(log_file,"\n");
	}
	if(texlog_on == TRUE)
	{
		fprintf(texlog_file,"height2pt\n");
		for(i = 0; i < how_many; i++)
		{
			fprintf(texlog_file,"&\\omit&");
		}
		fprintf(texlog_file,"\\cr\n");
		fprintf(texlog_file,"\\noalign{\\hrule}");
		fprintf(texlog_file,"height2pt\n");
		for(i = 0; i < how_many; i++)
		{
			fprintf(texlog_file,"&\\omit&");
		}
		fprintf(texlog_file,"\\cr\n");
	}
}

void begin_table_output(int how_many, char title[XLDLASMAX_INPUT])
{
	int i;
	char string_one[XLDLASMAX_INPUT];
	sprintf(string_one,"@f@Stbl>  %s",title);
	fl_addto_browser(main_browser," ");
	fl_addto_browser(main_browser,string_one);
	if(log_on == TRUE)
	{
		fprintf(log_file,"\n\n");
	}
	if(texlog_on == TRUE)
	{
		filter_tex_specials(title);	
		fprintf(texlog_file,"\n\n\\midinsert\n\n\\centerline{%s}\n\n\\bigskip\n\n",filtered_tex_string);
		fprintf(texlog_file,"\n\n%%\n%%  This table macro is taken from _The TeX Book_ ((C) 1992) pg. 246\n%%\n\n");
		fprintf(texlog_file,"\n\n$$\n\\vbox{\\offinterlineskip\n\\hrule\n\\halign{&\\vrule#&\n\t\\strut\\quad\\hfil#\\quad\\cr\n");
		fprintf(texlog_file,"height2pt\n");
		for(i = 0; i < how_many; i++)
		{
			fprintf(texlog_file,"&\t\\omit\t&");
		}
		fprintf(texlog_file,"\\cr\n");
	}
	if(htmllog_on == TRUE)
	{
		fprintf(htmllog_file,"<CENTER> <TABLE BORDER=2 CELLPADDING=5> <CAPTION> %s </CAPTION>\n", title);
	}
}

void end_table_output(int how_many)
{
	int i;
	fl_addto_browser(main_browser," ");
	if(log_on == TRUE)
	{
		fprintf(log_file,"\n\n");
	}
	if(texlog_on == TRUE)
	{
		fprintf(texlog_file,"height2pt\n");
		for(i = 0; i < how_many; i++)
		{
			fprintf(texlog_file,"&\t\\omit\t&");
		}
		fprintf(texlog_file,"\\cr}\n\\hrule}\n$$\n\\endinsert\n\n");
	}
	if(htmllog_on == TRUE)
	{
		fprintf(htmllog_file,"</TABLE> </CENTER><BR>\n");
	}
}

int check_blanks(char the_string[XLDLASMAX_INPUT])
{
	int i;
	int all_blank;
	all_blank = TRUE;
	for(i = 0; i < strlen(the_string); i++)
	{
		if(the_string[i] != ' ')
		{
			all_blank = FALSE;
		}
	}
	return(all_blank);
}

void begin_column_output(char first_column[XLDLASMAX_INPUT], int justify)
{
	char html_output[XLDLASMAX_INPUT];
	strcpy(line_of_output,"@f@Stbl>  ");
	strcat(line_of_output,first_column);
	if(texlog_on == TRUE)
	{
		filter_tex_specials(first_column);	
		if(justify == XLDLAS_JUST_CENTER)
		{
			fprintf(texlog_file,"&\t\\hfill %s \\hfill\t&",filtered_tex_string);
		}
		if(justify == XLDLAS_JUST_RIGHT)
		{
			fprintf(texlog_file,"&\t\\hfill %s \t&",filtered_tex_string);
		}
		if(justify == XLDLAS_JUST_LEFT)
		{
			fprintf(texlog_file,"&\t %s \\hfill\t&",filtered_tex_string);
		}
	}
	if(htmllog_on == TRUE)
	{
		if(check_blanks(first_column) == TRUE)
		{
			strcpy(html_output,"&nbsp");
		}
		else
		{
			strcpy(html_output,first_column);
		}
		if(justify == XLDLAS_JUST_CENTER)
		{
			fprintf(htmllog_file,"<TR> <TD align=CENTER> %s \n", html_output);
		}
		if(justify == XLDLAS_JUST_RIGHT)
		{
			fprintf(htmllog_file,"<TR> <TD align=RIGHT> %s \n", html_output);
		}
		if(justify == XLDLAS_JUST_LEFT)
		{
			fprintf(htmllog_file,"<TR> <TD align=LEFT> %s \n", html_output);
		}
	}
}

void add_column_output(char next_column[XLDLASMAX_INPUT], int justify)
{
	char html_output[XLDLASMAX_INPUT];
	strcat(line_of_output,next_column);
	if(texlog_on == TRUE)
	{
		filter_tex_specials(next_column);	
		if(justify == XLDLAS_JUST_CENTER)
		{
			fprintf(texlog_file,"&\t\\hfill %s \\hfill\t&",filtered_tex_string);
		}
		if(justify == XLDLAS_JUST_RIGHT)
		{
			fprintf(texlog_file,"&\t\\hfill %s \t&",filtered_tex_string);
		}
		if(justify == XLDLAS_JUST_LEFT)
		{
			fprintf(texlog_file,"&\t %s \\hfill\t&",filtered_tex_string);
		}
	}
	if(htmllog_on == TRUE)
	{
		if(check_blanks(next_column) == TRUE)
		{
			strcpy(html_output, "&nbsp");
		}
		else
		{
			strcpy(html_output, next_column);
		}
		if(justify == XLDLAS_JUST_CENTER)
		{
			fprintf(htmllog_file,"<TD align=CENTER> %s \n", html_output);
		}
		if(justify == XLDLAS_JUST_RIGHT)
		{
			fprintf(htmllog_file,"<TD align=RIGHT> %s \n", html_output);
		}
		if(justify == XLDLAS_JUST_LEFT)
		{
			fprintf(htmllog_file,"<TD align=LEFT> %s \n", html_output);
		}
	}
}

void end_column_output()
{
	fl_addto_browser(main_browser, line_of_output);
	if(log_on == TRUE)
	{
		fprintf(log_file,"%s\n", line_of_output);
	}
	if(texlog_on == TRUE)
	{
		fprintf(texlog_file,"\\cr\n");
	}
}

void log_routines(FL_OBJECT *menu, long user_data)
{
	int choice;
	choice = fl_get_menu(menu);
	if(choice == 1)  start_log();
	if(choice == 2) start_texlog();
	if(choice == 3) start_htmllog();
}

