/* topo.h */

/* VIS-5D version 4.0 */

/*
VIS-5D system for visualizing five dimensional gridded data sets
Copyright (C) 1990, 1991, 1992, 1993, 1994  Bill Hibbard, Brian Paul,
Dave Santek, and Andre Battaiola.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef TOPO_H
#define TOPO_H


#include "globals.h"



extern float elevation( Context ctx, float lat, float lon, int *water );


extern int init_topo( Context ctx, char toponame[], int textureflag,
                      int hi_res );


extern void free_topo( Context ctx );


extern void init_topo_color_table( Context ctx, unsigned int ct[],
                                   int size );


extern void recolor_topo( Context ctx, unsigned int ct[], int size );


extern void draw_topo( Context ctx, int time,
                       int texture_flag, int flat_flag );


#endif

