/* $Id: proj.h,v 1.6 1996/03/27 15:02:10 brianp Exp $ */

/* Vis5D version 4.2 */

/*
Vis5D system for visualizing five dimensional gridded data sets
Copyright (C) 1990-1996 Bill Hibbard, Brian Paul, Dave Santek,
and Andre Battaiola.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


/* Map projections */


#ifndef PROJ_H
#define PROJ_H



extern int setup_projection( Context ctx );

extern int setup_vertical_system( Context ctx );

extern void get_projection( Context ctx, int *projection, float *projargs );

extern void get_vertical_system( Context ctx, int *vertical, float *vertargs );


extern float gridlevel_to_z( Context ctx, int time, int var, float level );

extern float gridlevel_to_height( Context ctx, float level );

extern float height_to_z( Context ctx, float hgt );


extern void grid_to_xyz( Context ctx, int time, int var, int n,
                         float r[], float c[], float l[],
                         float x[], float y[], float z[] );


extern void grid_to_compXYZ( Context ctx, int time, int var, int n,
                             float r[], float c[], float l[],
                             int_2 xyz[][3] );


extern void geo_to_xyz( Context ctx, int time, int var, int n,
                        float lat[], float lon[], float hgt[],
                        float x[], float y[], float z[] );


extern void rowcol_to_latlon( Context ctx, int time, int var,
                              float row, float col, float *lat, float *lon );


extern void xyz_to_grid( Context ctx, int time, int var,
                         float x, float y, float z,
                         float *row, float *col, float *lev );


extern void xyz_to_geo( Context ctx, int time, int var,
                        float x, float y, float z,
                        float *lat, float *lon, float *hgt );


extern void project_normals( Context ctx, int n,
                             float vr[], float vc[], float vl[],
                             float nx[], float ny[], float nz[],
                             int_1 cnorms[][3] );


extern float earth_distance( float lat1, float lon1, float lat2, float lon2 );



extern void latlon_bounds( Context ctx,
                          float *lats, float *latn, float *lonw, float *lone );


extern void pandg_back( float *lat, float *lon, float a, float b, float r );


extern void pandg_for( float *lat, float *lon, float a, float b, float r );


#endif
