/* Prints out X and Y values of the Lorentz system as it evolves
 * in time.
 */

#include <stdio.h>
#include <unistd.h>

const double INIT_X = 1.0;
const double INIT_Y = 1.0;
const double INIT_Z = 1.0;
const double L_A = 16.0;   /* constants in equations */
const double L_B = 45.92;
const double L_C = 4;

int main()
{
   double x = INIT_X, y = INIT_Y, z = INIT_Z;
   double dx, dy, dz;
   char buf[100];

   while (1)
   {
      sprintf(buf, "%f %f\n", x, y);
      write(STDOUT_FILENO, buf, strlen(buf));

      dx = 0.01 * (L_A * (y - x));
      dy = 0.01 * (L_B * x - y - x * z);
      dz = 0.01 * (x * y - L_C * z);

      x += dx;
      y += dy;
      z += dz;
      
      usleep(1);
   }
   return(0);
}
   
   

