/* some crude ideas for something like a spread sheet */
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/cursor.h>
#include <xview/panel.h>
#include <xview/canvas.h>
#include <xview/xv_xrect.h>
#include <xview/cms.h>
#include <xview/textsw.h>
#include <xview/server.h>
#include <xview/notice.h>
#include <xview/notify.h>
#include <xview/xv_error.h>

#include "robot.h"

static  FILE            *fp; /* file for output */

#define THE_WIDTH       450
#define PANEL_HEIGHT    27
#define SHEET_HEIGHT	200
#define B_SIZE		5120

#define FACTOR		60 /* a kludge to scale memory limits in text
				 window - gotta be a better way */
Frame   sheet_frame;
Textsw  sheet_text;
void load_data();

int	no_points;
float	x, y, delx, dely;
int	i;
int	one = 1, two = 2, three = 3, four = 4;
/* char	buf[BUFSIZ+1]; */

/* char	buffer[B_SIZE]; */
char	buf[B_SIZE + 1];

char	line[160];

void
show_sheet()
{
Bool	load_me;

/* load data into window if the edit window isn't actually displayed yet */
	if(xv_get(sheet_frame, XV_SHOW) != TRUE){
		load_me = TRUE;
	}
	else{
		load_me = FALSE;
	}

        xv_set(sheet_frame, XV_SHOW, TRUE, NULL);
        xv_set(sheet_frame, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
	if(load_me){
		load_data();
	}

}

void
load_data()
{
void	getnp_();
char	*label="X	Y	delY	delX\n";
int	l_length, b_length;

	textsw_reset(sheet_text, 0, 0);
	textsw_insert(sheet_text, label, strlen(label));

	xv_set(sheet_text,
		XV_SHOW, FALSE,
		NULL);

	xv_set(sheet_frame,
                FRAME_BUSY,     TRUE,
		NULL);

	getnp_(&no_points);

	sprintf(buf, "");
	b_length = 0;

	/* printf("scaling to %d\n", FACTOR * no_points);
        xv_set(sheet_text,
		TEXTSW_MEMORY_MAXIMUM,  FACTOR * no_points,
		TEXTSW_WRAPAROUND_SIZE, FACTOR * no_points,
		NULL); */


	for(i = 1; i <= no_points; i++){
		arasgn_(&x, &one, &i);
		arasgn_(&y, &two, &i);
		arasgn_(&delx, &three, &i);
		arasgn_(&dely, &four, &i);



/* this very clumsy scheme of using two buffers doesn't actually appear
 * to do anything useful (speed approximately the same) for small
 * values of B_SIZE
 * However, 5000 seems to quite faster - good use of memory or not?
 */
		sprintf(line, "%g\t%g\t%g\t%g\n", x, y, dely, delx);
		l_length = strlen(line);
		if((b_length + l_length) < B_SIZE){
			strcat(buf, line);
			b_length = b_length + l_length;
		}
		else{
		   textsw_insert(sheet_text, buf, b_length);
		   sprintf(buf, line);
		   b_length = l_length;
		}
	}
/* anything to flush? */
		if(b_length != 0){
		    textsw_insert(sheet_text, buf, b_length);
		}

/* try to go to top of text */
	xv_set(sheet_text,
		TEXTSW_FIRST, 0,
		NULL);

	xv_set(sheet_text,
		XV_SHOW, TRUE,
		NULL);

	xv_set(sheet_frame,
                FRAME_BUSY,     FALSE,
		NULL);
}


void
replace_data()
{
void	getnp_();
int	last_was_NL;
int	msize;
char	fname[BUFSIZ];

Textsw_index cur_pos, next_pos;

   last_was_NL = FALSE;

   sprintf(fname, "/tmp/rob%-ddat.tmp", getpid());

   fp = fopen(fname, "w");

    next_pos = 0;
    cur_pos = next_pos - B_SIZE;
    while (next_pos == cur_pos + B_SIZE) {
		cur_pos = next_pos;
		next_pos = (Textsw_index)xv_get(sheet_text,
			TEXTSW_CONTENTS, cur_pos, buf, B_SIZE);
    if ((next_pos - cur_pos) != 0) {
        buf[next_pos - cur_pos] = '\0';
        fprintf(fp, "%s", buf);
        last_was_NL = (buf[next_pos - cur_pos - 1] == '\n');

    }
    }
    /* stick carriage return at end */
    if (!last_was_NL)
                putc('\n', fp);

	fclose(fp);
        if((fp = fopen(fname, "r")) == (FILE *) NULL){
			fprintf(stderr, "Error reopening file %s\n", fname);
			return;
	}

	getmsiz_(&msize);

	i = 0;
	fscanf(fp, "%[^\n]\n", buf); /* FWIW read title */
	while(1){
	/* for(i = 1; i <= no_points; i++){ */
		fscanf(fp, "%g %g %g %g", &x, &y, &dely, &delx);
		if(feof(fp)) break;
		i++;
		if(i > msize){
		  totext2_("ERROR: too much data.");
		  totext2_("Use ARRAYSIZE command to increase space.");
		    break;
		}
		araput_(&x, &one, &i);
		araput_(&y, &two, &i);
		araput_(&delx, &three, &i);
		araput_(&dely, &four, &i); 
		
	}


/* set number of points */
	setnp_(&i);



        if(unlink(fname))
        fprintf(stderr, 
        "ERROR: deleting temporary Data file\n");
}
		
void
write_data()
{
printf("in write data\n");
}
	

/* A window to give information */
void
sheet_frame_create(frame)
Frame   frame;
{
        sheet_frame = xv_create(frame, FRAME_CMD,
                                FRAME_LABEL, "Robot: Edit Data",
                                FRAME_SHOW_FOOTER,      FALSE,
                                FRAME_CMD_PUSHPIN_IN, TRUE,
				FRAME_SHOW_RESIZE_CORNER, TRUE,
                                NULL);
        sheet_panel = xv_get(sheet_frame, FRAME_CMD_PANEL);
        xv_set(sheet_panel, 
                XV_WIDTH, THE_WIDTH,
                XV_HEIGHT, PANEL_HEIGHT,
                XV_X,   0,
                NULL);


        sheet_text = (Textsw) xv_create(sheet_frame, TEXTSW,
                                         XV_WIDTH, THE_WIDTH,
                                         WIN_BELOW, sheet_panel,
                                         XV_X,  0,
                                         XV_HEIGHT, SHEET_HEIGHT,
                                         TEXTSW_READ_ONLY, FALSE,
					 TEXTSW_MEMORY_MAXIMUM,  200000,
					 TEXTSW_WRAPAROUND_SIZE, 200000,
					 TEXTSW_HISTORY_LIMIT, 0,
                                         NULL);
        /* textsw_normalize_view(sheet_text, 0); */

        xv_create(sheet_panel, PANEL_BUTTON,
                        XV_HELP_DATA, "robot:load_data",
                        PANEL_LABEL_STRING, "Load Data",
			PANEL_NOTIFY_PROC,  load_data,
                        NULL);

        xv_create(sheet_panel, PANEL_BUTTON,
                        XV_HELP_DATA, "robot:replace_data",
                        PANEL_LABEL_STRING, "Replace Data",
			PANEL_NOTIFY_PROC,  replace_data,
                        NULL);

/*        xv_create(sheet_panel, PANEL_BUTTON,
                        XV_HELP_DATA, "robot:write_data",
                        PANEL_LABEL_STRING, "Write Data",
			PANEL_NOTIFY_PROC,  write_data,
                        NULL); */
if(not_open_look){
        

           xv_create(sheet_panel, PANEL_BUTTON,
                XV_HELP_DATA,           "robot:dismiss",
                PANEL_LABEL_STRING,     DISMISS,
                PANEL_NOTIFY_PROC,      hide_me,
                NULL);
}

        window_fit(sheet_frame);
}
