#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/panel.h>

#include "robot.h"

Menu canvas_menu;
Menu old_canvas_menu;

extern void orient(), show_controls(), show_print();
extern void kill_old_plot(), print_old_plot(), make_old_current();
extern void last_to_current();
extern void menu_proc();
extern void cursor_proc();
extern void reset_proc();
void	setpscale();

/* create a menu for the current frame */
void
make_canvas_menu(frame)
Frame	frame;
{

	canvas_menu = xv_create((Xv_object) NULL, MENU,
			MENU_GEN_PIN_WINDOW, frame, "Plot Area Menu",
			MENU_TITLE_ITEM, "Plot Menu",
			MENU_ITEM,
				MENU_STRING,	"Bring Controls to Front",
				MENU_NOTIFY_PROC, show_controls,
				XV_HELP_DATA,	"robot:show_controls",
				NULL,
			MENU_ITEM,	
				MENU_STRING,	"Flip Orientation",
				MENU_NOTIFY_PROC, orient,
				XV_HELP_DATA,	"robot:flip",
				NULL,
/* A gap */
			MENU_ITEM,
				MENU_STRING,	"",
				MENU_INACTIVE, TRUE,
				NULL,
			MENU_ITEM,
				MENU_STRING,	"Cursor Zoom",
				MENU_NOTIFY_PROC, cursor_proc,
				XV_HELP_DATA,	"robot:cursor_button",
				NULL,
			MENU_ITEM,
				MENU_STRING,	"Full Data Range",
				MENU_NOTIFY_PROC, reset_proc,
				XV_HELP_DATA,	"robot:reset_button",
				NULL,
			MENU_ITEM,
				MENU_STRING,	"Print...",
				MENU_NOTIFY_PROC, show_print,
				XV_HELP_DATA,	"robot:print",
				NULL,
			MENU_ITEM,
				MENU_STRING,	"Plotscale",
				MENU_NOTIFY_PROC, setpscale,
				XV_HELP_DATA,	"robot:plotscale",
				NULL,
			NULL);

	if(not_open_look){
		xv_set(canvas_menu, MENU_APPEND_ITEM,
			xv_create((Xv_object) NULL, MENUITEM,
				MENU_STRING, "",
				MENU_INACTIVE, TRUE,
				NULL),
			NULL);	
		xv_set(canvas_menu, MENU_APPEND_ITEM, 
			xv_create((Xv_object) NULL, MENUITEM,
				MENU_STRING, DISMISS,
				MENU_NOTIFY_PROC, menu_proc,
				NULL),
			NULL);
	}
}

/* a much simpler menu for old plot areas */
void
make_old_canvas_menu(frame)
Frame	frame;
{
	old_canvas_menu = xv_create((Xv_object) NULL, MENU,
			MENU_TITLE_ITEM, "Old Plot Menu",

			MENU_ITEM,
				MENU_STRING, "Select Plot",
				MENU_NOTIFY_PROC, make_old_current,
				NULL,
				XV_HELP_DATA,	"robot:select_plot",
			MENU_ITEM,
				MENU_STRING, "",
				MENU_INACTIVE, TRUE,
				NULL,
			MENU_ITEM,
				XV_HELP_DATA,	"robot:kill_plot",
				MENU_STRING, "Destroy Plot Area",
				MENU_NOTIFY_PROC, kill_old_plot,
				NULL,			NULL);
}

void show_canvas_menu(canvas, event)
Canvas	canvas;
Event	*event;
{
	menu_show(canvas_menu, canvas, event, NULL);
}
				
void show_old_canvas_menu(canvas, event, old_menu_title)
Canvas	canvas;
Event	*event;
char	*old_menu_title;
{
	xv_set(old_canvas_menu, 
		MENU_TITLE_ITEM, old_menu_title,
		NULL);
	menu_show(old_canvas_menu, canvas, event, NULL);
}
				
				
void hide_old_canvas_menu()
{
	xv_set(xv_get(old_canvas_menu, MENU_PIN_WINDOW), 
		XV_SHOW, FALSE, NULL);
}

void
setpscale()
{

	sprintf(inst, "PLOTSCALE");
        to_robot();
}
