#define DOUBLE
#include "plplot.h" 
#include <stdio.h> 
#include <math.h> 
#include <stdlib.h> 

#define WORD_CHARS "ABCDEFGHIJKLMNOPQRSTUVWXYZ_1234567890abcdefghijklmnopqrstuvwxyz"
#define IWORD_CHARS "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz,;="
#define NUM_CHARS "0123456789+-.EDed"
/* Structure symbols in data file */
#define END_WORD "="
#define END_LINE ";"
#define SEP_RTR ","
#define COMMENT "*"

#define STYLEMAX 7
#define MM 800
#define mm 300
#define NELS 7

PLFLT xspace[7]={0.38,0.35,0.33,0.28,0.25,0.22,0.2},
       yspace[7]={0.48,0.45,0.42,0.35,0.3,0.28,0.25},
       tsize[7]={0.82,0.75,0.7,0.6,0.5,0.45,0.4};

PLINT 
linemark[STYLEMAX][NELS]={{MM,MM,MM,MM,MM,MM},{MM,MM,MM,MM,MM,0},{MM,MM,MM,MM,MM,MM},{MM,0,MM,0,MM,0},{mm,0,mm,0,mm,0},{MM,MM,mm,mm,0,0},{mm,mm,mm,mm,mm,mm}};
PLINT
linespace[STYLEMAX][NELS]={{0,0,0,0,0,0},{0,0,0,0,MM,MM},{0,MM,0,MM,0,MM},{MM,0,MM,0,MM,0},{MM,0,MM,0,MM,0},{0,MM,MM,0,MM,0},{0,0,0,0,MM,MM}};

/**********************************************************************/
/* Set new line style, from own line styles                           */
/* Tested OK */
int lstyle(PLINT style)
{ if (style>0 && style <=STYLEMAX)
   plstyl(NELS,linemark[style-1],linespace[style-1]);
}

void limits(PLFLT xmin,PLFLT xmax,PLFLT ymin,PLFLT ymax)
{
 plwind(xmin,xmax,ymin,ymax);
}



int window(PLINT xnum,PLINT ynum,PLINT currentx,PLINT currenty)
{ PLFLT sx,sy,cscale;
  PLFLT xminp,yminp,xmaxp,ymaxp,x1s,x2s,y1s,y2s;
  int maxwind;
  sx = pow(xnum,-1);
  sy = pow(ynum,-1); 
  
  xminp=(currentx-1)*sx;
  xmaxp=(currentx)*sx;
  yminp=(1-(currenty)*sy);
  ymaxp=(1-(currenty-1)*sy);  
  x1s=0.28*xspace[xnum-1];
  x2s=0.07*xspace[xnum-1];
  y1s=0.15*yspace[ynum-1];
  y2s=0.05*yspace[ynum-1];
  plvpor(xminp+x1s,xmaxp-x2s,yminp+y1s,ymaxp-y2s);
  if (ynum>xnum)
    maxwind=ynum;
  else 
   maxwind=xnum;
  cscale=4.0*tsize[maxwind-1];
  plschr(cscale,1);
  plssym(cscale,1);
 return(0);
}

int sticky_window(PLINT xnum,PLINT ynum,PLINT currentx,PLINT currenty,
                  double top, double right, double bot, double left)
{ PLFLT sx,sy,cscale;
  PLFLT xminp,yminp,xmaxp,ymaxp,x1s,x2s,y1s,y2s;
  int maxwind;
  sx = pow(xnum,-1);
  sy = pow(ynum,-1); 
  
  xminp=(currentx-1)*sx;
  xmaxp=(currentx)*sx;
  yminp=1-(currenty)*sy;
  ymaxp=1-(currenty-1)*sy;  
  x1s=0.28*xspace[xnum-1]*left;
  x2s=0.07*xspace[xnum-1]*right;
  y1s=0.15*yspace[ynum-1]*bot;
  y2s=0.05*yspace[ynum-1]*top;
  plvpor(xminp+x1s,xmaxp-x2s,yminp+y1s,ymaxp-y2s);
  if (ynum>xnum)
    maxwind=ynum;
  else 
   maxwind=xnum;
  cscale=4.0*tsize[maxwind-1];
  plschr(cscale,1);
  plssym(cscale,1);
 return(0);
}


int key(PLINT windx,PLINT windy,PLFLT relx,PLFLT rely,PLFLT incy,
        PLINT n,char keyname[][80],PLINT ltype[])
{ PLINT tel;
 
  limits(0,1,1,0);
  plschr(0,0.9);
  for (tel=0;tel<n;tel++)
    { lstyle(ltype[tel]);
      plcol(ltype[tel]);
      plwid(3);
      pljoin(relx,rely+(tel*incy),relx+0.15,rely+(tel*incy));
      plcol(15);
      plwid(2);
      plptex(relx+0.17,rely+(tel*incy),0,0,0,keyname[tel]);
    }
  plschr(0,1);
}

int charkey(PLINT windx,PLINT windy,PLFLT relx,PLFLT rely,PLFLT incy,
        PLINT n,char keyname[][80])
{ PLINT tel;
 
  limits(0,1,1,0);
  plcol(15);
  plschr(0,0.9);
  for (tel=0;tel<n;tel++)
      plptex(relx,rely+(tel*incy),0,0,0,keyname[tel]);
  plschr(0,1);
}


int plsetfile(char fname[])
{ FILE *fle;
  
  fle=fopen(fname,"w");
  if (fle==NULL) return(0);
  else 
   { plsfile(fle);
     return(1);
   }
}

    
void plogxline(int n,double *x,double *y)
{ int i,count;
  double *a,*b;
  
  a=(double*)malloc(n*sizeof(double));
  b=(double*)malloc(n*sizeof(double));  
  count=0;
  for (i=0;i<n;i++)
   { if (x[i]>0)
      { a[count]=log10(x[i]);
        b[count]=y[i];
        count++;
      }
   }
   plline(count,a,b);
}

void plogyline(int n,double *x,double *y)
{ int i,count;
  double *a,*b;
  
  a=(double*)malloc(n*sizeof(double));
  b=(double*)malloc(n*sizeof(double));  
  count=0;
  for (i=0;i<n;i++)
   { if (y[i]>0)
      { a[count]=x[i];
        b[count]=log10(y[i]);
        count++;
      }
   }
   plline(count,a,b);
}

void plogxyline(int n,double *x,double *y)
{ int i,count;
  double *a,*b;
  
  a=(double*)malloc(n*sizeof(double));
  b=(double*)malloc(n*sizeof(double));  
  count=0;
  for (i=0;i<n;i++)
   { if (y[i]>0 && x[i]>0)
      { a[count]=log10(x[i]);
        b[count]=log10(y[i]);
        count++;
      }
   }
   plline(count,a,b);
}

int logfilter(int n,double *x,double *y,double *a,double *b)
{ int i,count;
  count=0;
  for (i=0;i<n;i++)
   { if (y[i]>0 && x[i]>0)
      { a[count]=x[i];
        b[count]=y[i];
        count++;
      }
   }
  return(count);
}


void pltest(double *line,int x, int y)
{ int j,k;
  double **pt;
  printf("x=%d y=%d\n",x,y);
  for (k=0;k<x*y;k++)
    printf("%2.3f ",line[k]);
  printf("\n");
  pt=(double **)malloc(y*sizeof(double *));
   for (j=0; j<y; j++)
     pt[j]=(line+j*x);
  
  for (j=0;j<y;j++)
   { for (k=0;k<x;k++)
      printf("%2.3f ",pt[j][k]);
     printf("\n");
   }
}


double **make2d(double *line,int x, int y)
{ int j,k;
  double *myline,**pt;

  pt=(double **)malloc(x*sizeof(double *));
  myline=(double *)malloc(x*y*sizeof(double));
   for (j=0; j<x; j++)
     pt[j]=(myline+j*y);
   for (j=0; j<x; j++)
    for (k=0; k<y; k++)
     { pt[j][k]=line[j+k*x];
 /*      printf("%2.1f ",pt[j][k]);*/
     }
  return(pt);
}

double **TwoD_init(int x,int y)
{ int ct;
  double **pt,*bpt;
  pt=(double **)malloc(x*sizeof(double *));
  bpt=(double *)malloc(x * y * sizeof(double));
   for (ct=0; ct<x; ct++)
     pt[ct]=(bpt+ct*y);
  return(pt);
}


void pplcont2d(double *z0,int nx,int ny,double *clevel, int nlevel,
              double *x0,double *y0)
{ double **z,**c_x,**c_y;
  PLcGrid2 cgrid1;
  
  z=make2d(z0,nx,ny);  
  c_x=make2d(x0,nx,ny);
  c_y=make2d(y0,nx,ny);
     cgrid1.xg = c_x;
     cgrid1.yg = c_y;
     cgrid1.nx = nx;
     cgrid1.ny = ny;
  plcont(z,nx,ny,1,nx,1,ny,clevel,nlevel,pltr2,(void *) &cgrid1);                 
}

void pplcont1(double *z0,int nx,int ny,double *clevel, int nlevel)
{ double **z,*x,*y;
  int i;
  PLcGrid cgrid1;
  z=make2d(z0,nx,ny);
  x=(double *)malloc(nx*sizeof(double));
  y=(double *)malloc(ny*sizeof(double));
  for (i=0;i<nx;i++)
     x[i]=i+1;
  for (i=0;i<ny;i++)
     y[i]=i+1;
     cgrid1.xg = x;
     cgrid1.yg = y;
     cgrid1.nx = nx;
     cgrid1.ny = ny;
  plcont(z,nx,ny,1,nx,1,ny,clevel,nlevel,pltr1,(void*) &cgrid1);
  
}

void pplshade0(double *z0,int nx,int ny,double *clevel, int nlevel,
               double zmin, double zmax,double *x0,double *y0)
{ double **z,**c_x,**c_y;
  int i;
  PLcGrid2 cgrid1;
  double shade_min, shade_max, sh_color;
  int sh_cmap = 0, sh_width, min_color = 1, min_width = 1, max_color = 70, 
      max_width = 1;

   z=make2d(z0,nx,ny);
   c_x=make2d(x0,nx,ny);
   c_y=make2d(y0,nx,ny);
     cgrid1.xg = c_x;
     cgrid1.yg = c_y;
     cgrid1.nx = nx;
     cgrid1.ny = ny;
     
    for (i = 0; i < nlevel; i++) {
	shade_min = zmin + (zmax - zmin) * i / (double) nlevel;
	shade_max = zmin + (zmax - zmin) * (i +1) / (double) nlevel;
	sh_color = floor(i / (double) (nlevel)*max_color);
 	printf("sh_color=%2.3f\n",sh_color);
 	sh_width = 1;
	plpsty(0);

	plshade(z, nx, ny, NULL, 1, (double)nx, 1, (double)ny, 
		shade_min, shade_max, 
		sh_cmap, sh_color, sh_width,
		min_color, min_width, max_color, max_width,
		plfill, 0, pltr1, (void *) &cgrid1);
    }
  
}

void pplshade1(double *z0,int nx,int ny,double *clevel, int nlevel,
               double zmin, double zmax)
{ double **z,*x,*y;
  int i;
  PLcGrid cgrid1;
  double shade_min, shade_max, sh_color;
  int sh_cmap = 1, sh_width, min_color = 1, min_width = 1, max_color = 70, 
      max_width = 1;

  z=make2d(z0,nx,ny);
  x=(double *)malloc(nx*sizeof(double));
  y=(double *)malloc(ny*sizeof(double));
  for (i=0;i<nx;i++)
     x[i]=i+1;
  for (i=0;i<ny;i++)
     y[i]=i+1;
     cgrid1.xg = x;
     cgrid1.yg = y;
     cgrid1.nx = nx;
     cgrid1.ny = ny;
     
    for (i = 0; i < nlevel; i++) {
	shade_min = zmin + (zmax - zmin) * i / (double) nlevel;
	shade_max = zmin + (zmax - zmin) * (i +1) / (double) nlevel;
	sh_color = i / (double) (max_color);
	printf("sh_color=%2.3f\n",sh_color);
	sh_width = 1;
	plpsty(0);

	plshade(z, nx, ny, NULL, 1, nx, 1, ny, 
		shade_min, shade_max, 
		sh_cmap, sh_color, sh_width,
		min_color, min_width, max_color, max_width,
		plfill, 0, pltr1, (void *) &cgrid1);
        printf("shade %d completed",i);
    }
  
}

void my_plot3d(double *x,double *y,double *z, int nx, int ny, int opt, int side)
{ double **c_z;
 
  c_z=make2d(z,nx,ny);
  plot3d(x,y,c_z,nx,ny,opt,side);
}

void my_plmesh(double *x,double *y,double *z, int nx, int ny, int opt)
{ double **c_z;
 
  c_z=make2d(z,nx,ny);
  plmesh(x,y,c_z,nx,ny,opt);
}

int my_read_matrix(char fname[],int line1,int line2,
               int xcol,double *x0,int xnum)
{ double **x;
  int i,j,num;
  
  x=TwoD_init(line2-line1+1,xnum);
  num=read_matrix(fname,line1,line2,xcol,x,xnum);
  for (j=0;j<=(line2-line1);j++)
    for (i=0;i<xnum;i++)
      x0[j*xnum+i]=x[j][i];
  return(num);
}

void my_plbox(char *xopt,double xtick,int nxsub,char *yopt,double ytick,int nysub)
{ int xsub,ysub;
  
  xsub=(int)nxsub;
  ysub=(int)nysub;
  plbox(xopt,xtick,xsub,yopt,ytick,ysub);
}

void pvfield(int vnum,double *x1,double *y1, double *x2,double *y2,
             double size,char point[])
{int i;
 double xa,xb,ya,yb,l=3,xp1,xp2,yp1,yp2,th,norm;
 for (i=0; i<vnum;i++)
   { xa=x1[i];
     xb=x1[i]+x2[i];
     ya=y1[i];
     yb=y1[i]+y2[i];
     pljoin(xa,ya,xb,yb);
     norm=sqrt(pow(x2[i],2)+pow(y2[i],2));
     if (xa!=xb)
      th=atan((yb-ya)/(xb-xa));
       
     else
      { if (yb>=ya)
         th=M_PI/2;
        else
         th=-M_PI/2;
      }
     if (xb>=xa) 
      { xp1=xb+size*norm*cos(M_PI+th-0.5236);
        yp1=yb+size*norm*sin(M_PI+th-0.5236);
        xp2=xb+size*norm*cos(M_PI+th+0.5236);  
        yp2=yb+size*norm*sin(M_PI+th+0.5236);
      }
     else
      { xp1=xb-size*norm*cos(M_PI+th-0.5236);
        yp1=yb-size*norm*sin(M_PI+th-0.5236);
        xp2=xb-size*norm*cos(M_PI+th+0.5236);  
        yp2=yb-size*norm*sin(M_PI+th+0.5236);
      }
     pljoin(xb,yb,xp1,yp1);
     pljoin(xb,yb,xp2,yp2);
     plptex(xa,ya,0,0,0.5,point);
   }
}

void pvfield1(int nx,int ny,double *x2,double *y2,
             double size,char point[])
{int i,vnum,j;
 double xa,xb,ya,yb,l=3,xp1,xp2,yp1,yp2,th,norm,*x1,*y1;

 vnum=nx*ny; 
 x1=(double *)malloc(vnum*sizeof(double));
 y1=(double *)malloc(vnum*sizeof(double));
  for (i=0;i<nx;i++)
    for (j=0;j<ny;j++)
      { y1[i*nx+j]=j+1;
        x1[i*nx+j]=i+1;
      }
 for (i=0; i<vnum;i++)
   { xa=x1[i];
     xb=x1[i]+x2[i];
     ya=y1[i];
     yb=y1[i]+y2[i];
     pljoin(xa,ya,xb,yb);
     norm=sqrt(pow(x2[i],2)+pow(y2[i],2));
     if (xa!=xb)
      th=atan((yb-ya)/(xb-xa));
       
     else
      { if (yb>=ya)
         th=M_PI/2;
        else
         th=-M_PI/2;
      }
     if (xb>=xa) 
      { xp1=xb+size*norm*cos(M_PI+th-0.5236);
        yp1=yb+size*norm*sin(M_PI+th-0.5236);
        xp2=xb+size*norm*cos(M_PI+th+0.5236);  
        yp2=yb+size*norm*sin(M_PI+th+0.5236);
      }
     else
      { xp1=xb-size*norm*cos(M_PI+th-0.5236);
        yp1=yb-size*norm*sin(M_PI+th-0.5236);
        xp2=xb-size*norm*cos(M_PI+th+0.5236);  
        yp2=yb-size*norm*sin(M_PI+th+0.5236);
      }
     pljoin(xb,yb,xp1,yp1);
     pljoin(xb,yb,xp2,yp2);
     plptex(xa,ya,0,0,0.5,point);
   }
}
