/**********************************************************************

	--- Qt Architect generated file ---

	File: xgfeMain.cpp

    Xgfe: X Windows GUI front end to Gnuplot
    Copyright (C) 1998 David Ishee

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 *********************************************************************/

#include "xgfeMain.h"

#define Inherited xgfeMainData

xgfeMain::xgfeMain
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
  setCaption( "X Gnuplot Front End" );
}


xgfeMain::~xgfeMain()
{
}

void xgfeMain::plot()
{
  gnuInt->setReplotFlag(0); // set replot flag to false

  // figure out if plotting 2d or 3d

  // look at files
  if (filePlotType->isItemChecked(file2d_id) == TRUE)
    gnuInt->setFilePlotType("plot");
  else if (filePlotType->isItemChecked(file3d_id) == TRUE)
    gnuInt->setFilePlotType("splot");

  // look at function
  if (funcPlotType->isItemChecked(func2d_id) == TRUE)
    gnuInt->setFuncPlotType("plot");
  else if (funcPlotType->isItemChecked(func3d_id) == TRUE)
    gnuInt->setFuncPlotType("splot");

  // save filename
  gnuInt->setPlotFilename(filenameEdit->text());

  // save function
  gnuInt->setPlotFunction(functionEdit->text());
  
  // save x and y variable names
  gnuInt->setXVariableName(varX->text());
  gnuInt->setYVariableName(varY->text());

  // save x,y,z ranges
  gnuInt->setXRangeStart(xStart->text());
  gnuInt->setXRangeEnd(xEnd->text());
  gnuInt->setYRangeStart(yStart->text());
  gnuInt->setYRangeEnd(yEnd->text());
  gnuInt->setZRangeStart(zStart->text());
  gnuInt->setZRangeEnd(zEnd->text());
  
  // set x,y,z axis labels
  gnuInt->setXlabel(xLabel->text());
  gnuInt->setXOffset_X(XLabelOffset_X->text());
  gnuInt->setXOffset_Y(XLabelOffset_Y->text());
  
  gnuInt->setYlabel(yLabel->text());
  gnuInt->setYOffset_X(YLabelOffset_X->text());
  gnuInt->setYOffset_Y(YLabelOffset_Y->text());

  gnuInt->setZlabel(zLabel->text());
  gnuInt->setZOffset_X(ZLabelOffset_X->text());
  gnuInt->setZOffset_Y(ZLabelOffset_Y->text());
  
  // save title
  gnuInt->setTitle(titleLabel->text());
  gnuInt->setTitleOffset_X(titleOffset_X->text());
  gnuInt->setTitleOffset_Y(titleOffset_Y->text());

  // filename option is checked
  if (filenameCB->isChecked() == TRUE)
    gnuInt->setPlotFileFlag(1);
  else
    gnuInt->setPlotFileFlag(0);

  // multiple filename option is checked
  if (multiFileCheckbox->isChecked() == TRUE)
    gnuInt->setPlotMultipleFileFlag(1);
  else
    gnuInt->setPlotMultipleFileFlag(0);

  // function option is checked
   if (functionCB->isChecked() == TRUE)
     gnuInt->setPlotFuncFlag(1);
   else
     gnuInt->setPlotFuncFlag(0);

  // multiple function option is checked
   if (multiFuncCheckbox->isChecked() == TRUE)
     gnuInt->setPlotMultipleFuncFlag(1);
   else
     gnuInt->setPlotMultipleFuncFlag(0);

   // plot
   gnuInt->doPlot();
}

void xgfeMain::replot()
{
  gnuInt->setReplotFlag(1); // set replot flag to true

  // save filename
  gnuInt->setPlotFilename(filenameEdit->text());

  // save function
  gnuInt->setPlotFunction(functionEdit->text());
  
  // don't set ranges because they can't be reset in a replot
  
  // set x,y,z axis labels
  gnuInt->setXlabel(xLabel->text());
  gnuInt->setXOffset_X(XLabelOffset_X->text());
  gnuInt->setXOffset_Y(XLabelOffset_Y->text());
  
  gnuInt->setYlabel(yLabel->text());
  gnuInt->setYOffset_X(YLabelOffset_X->text());
  gnuInt->setYOffset_Y(YLabelOffset_Y->text());

  gnuInt->setZlabel(zLabel->text());
  gnuInt->setZOffset_X(ZLabelOffset_X->text());
  gnuInt->setZOffset_Y(ZLabelOffset_Y->text());
  
  // save title
  gnuInt->setTitle(titleLabel->text());
  gnuInt->setTitleOffset_X(titleOffset_X->text());
  gnuInt->setTitleOffset_Y(titleOffset_Y->text());

  if (filenameCB->isChecked() == TRUE) // filename option is checked
  {
    gnuInt->setPlotFileFlag(1);
    gnuInt->setFilePlotType("replot");
  }
  else
    gnuInt->setPlotFileFlag(0);
  
  if (functionCB->isChecked() == TRUE) // function option is checked
  {
    gnuInt->setPlotFuncFlag(1);
    gnuInt->setFuncPlotType("replot");
  }
  else
    gnuInt->setPlotFuncFlag(0);

  // plot
  gnuInt->doPlot();

}

void xgfeMain::setFilePlotType2d()
{
  // clear check marks
  filePlotType->setItemChecked(file2d_id, FALSE);
  filePlotType->setItemChecked(file3d_id, FALSE);

  // set appropriate check mark
  filePlotType->setItemChecked(file2d_id, TRUE);
  
}

void xgfeMain::setFilePlotType3d()
{
  // clear check marks
  filePlotType->setItemChecked(file2d_id, FALSE);
  filePlotType->setItemChecked(file3d_id, FALSE);

  // set appropriate check mark
  filePlotType->setItemChecked(file3d_id, TRUE);
  
}

void xgfeMain::setFuncPlotType2d()
{
  // clear check marks
  funcPlotType->setItemChecked(func2d_id, FALSE);
  funcPlotType->setItemChecked(func3d_id, FALSE);

  // set appropriate check mark
  funcPlotType->setItemChecked(func2d_id, TRUE);
}

void xgfeMain::setFuncPlotType3d()
{
  // clear check marks
  funcPlotType->setItemChecked(func2d_id, FALSE);
  funcPlotType->setItemChecked(func3d_id, FALSE);

  // set appropriate check mark
  funcPlotType->setItemChecked(func3d_id, TRUE);
}

void xgfeMain::dataFileOpen()
{
  string temp;
  QString filename = QFileDialog::getOpenFileName(); // get filename
  
  if ( !filename.isNull() )
  {
    filenameEdit->setText(filename); // set label to filename
    filenameCB->setChecked(TRUE);     // set filename checkbox
    temp = filename;
    gnuInt->setPlotFilename(temp);
  }
  
}

void xgfeMain::save()
{
  QString saveFile;
  string temp;
  
  saveFile = QFileDialog::getSaveFileName(); // get filename
  
  if (!saveFile.isEmpty())
  {
    temp = saveFile;
    gnuInt->setGnuFileSave(temp);
    gnuInt->doSave();
  }
}

void xgfeMain::load()
{
  QString loadFile;
  string temp;
  
  loadFile = QFileDialog::getOpenFileName(); // get filename

  if (!loadFile.isEmpty())
  {
    temp = loadFile;
    gnuInt->setGnuFileLoad(temp);
    gnuInt->doLoad();
  }
}

void xgfeMain::saveXgfe()
{
  QString saveFile;
  string temp;
  
  saveFile = QFileDialog::getSaveFileName(); // get filename
  
  if (!saveFile.isEmpty())
  {
    temp = saveFile;
    gnuInt->savePlotData(temp);
  }
}

void xgfeMain::loadXgfe()
{
  QString loadFile;
  string temp;
  
  loadFile = QFileDialog::getOpenFileName(); // get filename

  if (!loadFile.isEmpty())
  {
    temp = loadFile;
    gnuInt->loadPlotData(temp);

    // get options and set GUI

    // checkboxes 
    int plotFileFlag = gnuInt->getPlotFileFlag();
    int plotMultipleFileFlag = gnuInt->getPlotMultipleFileFlag();
    int plotFuncFlag = gnuInt->getPlotFuncFlag();
    int plotMultipleFuncFlag = gnuInt->getPlotMultipleFuncFlag();

    if (plotFileFlag == 1)
      filenameCB->setChecked(TRUE);
    else
      filenameCB->setChecked(FALSE);
      
    if (plotMultipleFileFlag == 1)
      multiFileCheckbox->setChecked(TRUE);
    else
      multiFileCheckbox->setChecked(FALSE);

    if (plotFuncFlag == 1)
      functionCB->setChecked(TRUE);
    else
      functionCB->setChecked(FALSE);

    if (plotMultipleFuncFlag == 1)
      multiFuncCheckbox->setChecked(TRUE);
    else
      multiFuncCheckbox->setChecked(FALSE);

    string tempval;
    tempval = "";

    // filename edit box
    tempval = gnuInt->getPlotFilename();
    filenameEdit->setText(tempval.c_str());

    // function edit box
    tempval = gnuInt->getPlotFunction();
    functionEdit->setText(tempval.c_str());

    // x,y,z variable names and start/end values
    tempval = gnuInt->getXVariableName();
    varX->setText(tempval.c_str());

    tempval = gnuInt->getXRangeStart();
    xStart->setText(tempval.c_str());
    
    tempval = gnuInt->getXRangeEnd();
    xEnd->setText(tempval.c_str());
    
    tempval = gnuInt->getYVariableName();
    varY->setText(tempval.c_str());
    
    tempval = gnuInt->getYRangeStart();
    yStart->setText(tempval.c_str());
    
    tempval = gnuInt->getYRangeEnd();
    yEnd->setText(tempval.c_str());
    
    tempval = gnuInt->getZRangeStart();
    zStart->setText(tempval.c_str());
    
    tempval = gnuInt->getZRangeEnd();
    zEnd->setText(tempval.c_str());
    
    // x,y,z labels and offsets
    tempval = gnuInt->getXlabel();
    xLabel->setText(tempval.c_str());

    tempval = gnuInt->getXOffset_X();
    XLabelOffset_X->setText(tempval.c_str());

    tempval = gnuInt->getXOffset_Y();
    XLabelOffset_Y->setText(tempval.c_str());

    tempval = gnuInt->getYlabel();
    yLabel->setText(tempval.c_str());

    tempval = gnuInt->getYOffset_X();
    YLabelOffset_X->setText(tempval.c_str());

    tempval = gnuInt->getYOffset_Y();
    YLabelOffset_Y->setText(tempval.c_str());

    tempval = gnuInt->getZlabel();
    zLabel->setText(tempval.c_str());

    tempval = gnuInt->getZOffset_X();
    ZLabelOffset_X->setText(tempval.c_str());

    tempval = gnuInt->getZOffset_Y();
    ZLabelOffset_Y->setText(tempval.c_str());

    // title and offsets
    tempval = gnuInt->getTitle();
    titleLabel->setText(tempval.c_str());

    tempval = gnuInt->getTitleOffset_X();
    titleOffset_X->setText(tempval.c_str());

    tempval = gnuInt->getTitleOffset_Y();
    titleOffset_Y->setText(tempval.c_str());

    // output
    tempval = gnuInt->getOutput();
    outputLabel->setText(tempval.c_str());

    // terminal
    tempval = gnuInt->getTerminal();
    
    if (tempval == "bfig")
    {
      clearTermChecks();
      terminals->setItemChecked(bfig_t_id, TRUE);
      termLabel->setText("bfig");
    }
    else if (tempval == "corel")
    {
      clearTermChecks();
      terminals->setItemChecked(corel_t_id, TRUE);
      termLabel->setText("corel");
    }
    else if (tempval == "dxf")
    {
      clearTermChecks();
      terminals->setItemChecked(dxf_t_id, TRUE);
      termLabel->setText("dxf");
    }
    else if (tempval == "eepic")
    {
      clearTermChecks();
      terminals->setItemChecked(eepic_t_id, TRUE);
      termLabel->setText("eepic");
    }
    else if (tempval == "emtex")
    {
      clearTermChecks();
      terminals->setItemChecked(emtex_t_id, TRUE);
      termLabel->setText("emtex");
    }
    else if (tempval == "fig")
    {
      clearTermChecks();
      terminals->setItemChecked(fig_t_id, TRUE);
      termLabel->setText("fig");
    }
    else if (tempval == "latex")
    {
      clearTermChecks();
      terminals->setItemChecked(latex_t_id, TRUE);
      termLabel->setText("latex");
    }
    else if (tempval == "pbm")
    {
      clearTermChecks();
      terminals->setItemChecked(pbm_t_id, TRUE);
      termLabel->setText("pbm");
    }
    else if (tempval == "postscript")
    {
      clearTermChecks();
      terminals->setItemChecked(ps_t_id, TRUE);
      termLabel->setText("postscript");
    }
    else if (tempval == "pslatex")
    {
      clearTermChecks();
      terminals->setItemChecked(pslatex_t_id, TRUE);
      termLabel->setText("pslatex");
    }
    else if (tempval == "pstricks")
    {
      clearTermChecks();
      terminals->setItemChecked(pstricks_t_id, TRUE);
      termLabel->setText("pstricks");
    }
    else if (tempval == "table")
    {
      clearTermChecks();
      terminals->setItemChecked(table_t_id, TRUE);
      termLabel->setText("table");
    }
    else if (tempval == "texdraw")
    {
      clearTermChecks();
      terminals->setItemChecked(texdraw_t_id, TRUE);
      termLabel->setText("texdraw");
    }
    else if (tempval == "tgif")
    {
      clearTermChecks();
      terminals->setItemChecked(tgif_t_id, TRUE);
      termLabel->setText("tgif");
    }
    else if (tempval == "tpic")
    {
      clearTermChecks();
      terminals->setItemChecked(tpic_t_id, TRUE);
      termLabel->setText("tpic");
    }
    else if (tempval == "x11")
    {
      clearTermChecks();
      terminals->setItemChecked(x11_t_id, TRUE);
      termLabel->setText("x11");
    }

    // file plot type (2d/3d)
    tempval = gnuInt->getFilePlotType();
    
    if (tempval == "plot")
    {
      filePlotType->setItemChecked(file2d_id,TRUE);
      filePlotType->setItemChecked(file3d_id,FALSE);
    }
    else if (tempval == "splot")
    {
      filePlotType->setItemChecked(file2d_id,FALSE);
      filePlotType->setItemChecked(file3d_id,TRUE);
    }
    
    // function plot type  (2d/3d)
    tempval = gnuInt->getFuncPlotType();
    
    if (tempval == "plot")
    {
      funcPlotType->setItemChecked(func2d_id,TRUE);
      funcPlotType->setItemChecked(func3d_id,FALSE);
    }
    else if (tempval == "splot")
    {
      funcPlotType->setItemChecked(func2d_id,FALSE);
      funcPlotType->setItemChecked(func3d_id,TRUE);
    }
    
    // file style
    tempval = gnuInt->getFileStyleType();
    
    if (tempval == "points")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_p_id,TRUE);
    }
    else if (tempval == "lines")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_l_id, TRUE);
    }
    else if (tempval == "linespoints")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_lp_id, TRUE);
    }
    else if (tempval == "impulses")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_i_id, TRUE);
    }
    else if (tempval == "dots")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_d_id, TRUE);
    }
    else if (tempval == "steps")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_s_id, TRUE);
    }
    else if (tempval == "fsteps")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_fs_id, TRUE);
    }
    else if (tempval == "histeps")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_hs_id, TRUE);      
    }
    else if (tempval == "errorbars")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_eb_id, TRUE);
    }
    else if (tempval == "xerrorbars")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_xeb_id, TRUE);
    }
    else if (tempval == "yerrorbars")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_yeb_id, TRUE);      
    }
    else if (tempval == "xyerrorbars")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_xyeb_id, TRUE);
    }
    else if (tempval == "boxes")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_b_id, TRUE);
    }
    else if (tempval == "boxerrorbars")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_be_id, TRUE);
    }
    else if (tempval == "boxxyerrorbars")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_bxye_id, TRUE);
    }
    else if (tempval == "financebars")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_fin_id, TRUE);
    }
    else if (tempval == "candlesticks")
    {
      clearFileStyleChecks();
      fileStyle->setItemChecked(file_cs_id, TRUE);
    }

    // function style
    tempval = gnuInt->getFuncStyleType();

    if (tempval == "lines")
    {
      clearFuncStyleChecks();
      funcStyle->setItemChecked(func_l_id, TRUE);
    }
    else if (tempval == "linespoints")
    {
      clearFuncStyleChecks();
      funcStyle->setItemChecked(func_lp_id, TRUE);
    }
    else if (tempval == "impulses")
    {
      clearFuncStyleChecks();
      funcStyle->setItemChecked(func_i_id, TRUE);
    }
    else if (tempval == "dots")
    {
      clearFuncStyleChecks();
      funcStyle->setItemChecked(func_d_id, TRUE);
    }
    else if (tempval == "steps")
    {
      clearFuncStyleChecks();
      funcStyle->setItemChecked(func_s_id, TRUE);
    }
    else if (tempval == "errorbars")
    {
      clearFuncStyleChecks();
      funcStyle->setItemChecked(func_eb_id, TRUE);
    }
    else if (tempval == "boxes")
    {
      clearFuncStyleChecks();
      funcStyle->setItemChecked(func_b_id, TRUE);
    }
  }
}

void xgfeMain::xgfeQuit()
{
  gnuInt->closeGnuplot();
  QApplication::exit(0);
}

void xgfeMain::setFilePoints()
{
  gnuInt->setFileStyleType("points");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_p_id,TRUE);
  
}

void xgfeMain::setFileLines()
{
  gnuInt->setFileStyleType("lines");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_l_id, TRUE);
}

void xgfeMain::setFileLinesPoints()
{
  gnuInt->setFileStyleType("linespoints");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_lp_id, TRUE);
}

void xgfeMain::setFileImpulses()
{
  gnuInt->setFileStyleType("impulses");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_i_id, TRUE);
}

void xgfeMain::setFileDots()
{
  gnuInt->setFileStyleType("dots");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_d_id, TRUE);
}

void xgfeMain::setFileSteps()
{
  gnuInt->setFileStyleType("steps");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_s_id, TRUE);
}

void xgfeMain::setFileFsteps()
{
  gnuInt->setFileStyleType("fsteps");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_fs_id, TRUE);
}

void xgfeMain::setFileHisteps()
{
  gnuInt->setFileStyleType("histeps");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_hs_id, TRUE);
}

void xgfeMain::setFileErrorbars()
{
  gnuInt->setFileStyleType("errorbars");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_eb_id, TRUE);
}

void xgfeMain::setFileXerrorbars()
{
  gnuInt->setFileStyleType("xerrorbars");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_xeb_id, TRUE);
}

void xgfeMain::setFileYerrorbars()
{
  gnuInt->setFileStyleType("yerrorbars");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_yeb_id, TRUE);
}

void xgfeMain::setFileXyerrorbars()
{
  gnuInt->setFileStyleType("xyerrorbars");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_xyeb_id, TRUE);
}

void xgfeMain::setFileBoxes()
{
  gnuInt->setFileStyleType("boxes");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_b_id, TRUE);
}

void xgfeMain::setFileBoxerrorbars()
{
  gnuInt->setFileStyleType("boxerrorbars");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_be_id, TRUE);
}

void xgfeMain::setFileBoxxyerrorbars()
{
  gnuInt->setFileStyleType("boxxyerrorbars");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_bxye_id, TRUE);
}

void xgfeMain::setFileFinancebars()
{
  gnuInt->setFileStyleType("financebars");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_fin_id, TRUE);
}

void xgfeMain::setFileCandlesticks()
{
  gnuInt->setFileStyleType("candlesticks");
  
  clearFileStyleChecks();
  fileStyle->setItemChecked(file_cs_id, TRUE);
}

void xgfeMain::setFuncPoints()
{
  gnuInt->setFuncStyleType("points");
  
  clearFuncStyleChecks();
  funcStyle->setItemChecked(func_p_id,TRUE);
  
}

void xgfeMain::setFuncLines()
{
  gnuInt->setFuncStyleType("lines");
  
  clearFuncStyleChecks();
  funcStyle->setItemChecked(func_l_id, TRUE);
}

void xgfeMain::setFuncLinesPoints()
{
  gnuInt->setFuncStyleType("linespoints");
  
  clearFuncStyleChecks();
  funcStyle->setItemChecked(func_lp_id, TRUE);
}

void xgfeMain::setFuncImpulses()
{
  gnuInt->setFuncStyleType("impulses");
  
  clearFuncStyleChecks();
  funcStyle->setItemChecked(func_i_id, TRUE);
}

void xgfeMain::setFuncDots()
{
  gnuInt->setFuncStyleType("dots");
  
  clearFuncStyleChecks();
  funcStyle->setItemChecked(func_d_id, TRUE);
}

void xgfeMain::setFuncSteps()
{
  gnuInt->setFuncStyleType("steps");
  
  clearFuncStyleChecks();
  funcStyle->setItemChecked(func_s_id, TRUE);
}

void xgfeMain::setFuncErrorbars()
{
  gnuInt->setFuncStyleType("errorbars");
  
  clearFuncStyleChecks();
  funcStyle->setItemChecked(func_eb_id, TRUE);
}

void xgfeMain::setFuncBoxes()
{
  gnuInt->setFuncStyleType("boxes");
  
  clearFuncStyleChecks();
  funcStyle->setItemChecked(func_b_id, TRUE);
}

void xgfeMain::clearFileStyleChecks()
{
  bool ans;
  int numStyles = 17;
  int fileStyleTypes[numStyles];

  fileStyleTypes[0] = file_p_id;
  fileStyleTypes[1] = file_l_id;
  fileStyleTypes[2] = file_lp_id;
  fileStyleTypes[3] = file_i_id;
  fileStyleTypes[4] = file_d_id;
  fileStyleTypes[5] = file_s_id;
  fileStyleTypes[6] = file_fs_id;
  fileStyleTypes[7] = file_hs_id;
  fileStyleTypes[8] = file_eb_id;
  fileStyleTypes[9] = file_xeb_id;
  fileStyleTypes[10] = file_yeb_id;
  fileStyleTypes[11] = file_xyeb_id;
  fileStyleTypes[12] = file_b_id;
  fileStyleTypes[13] = file_be_id;
  fileStyleTypes[14] = file_bxye_id;
  fileStyleTypes[15] = file_fin_id;
  fileStyleTypes[16] = file_cs_id;

  for (int i = 0; i < numStyles; i++)
  {
    ans = fileStyle->isItemChecked(fileStyleTypes[i]);
    
    if (ans = TRUE)
      fileStyle->setItemChecked(fileStyleTypes[i],FALSE);
  }  
}

void xgfeMain::clearTermChecks()
{
  bool ans;
  int numTerms = 16;
  int termTypes[numTerms];

  termTypes[0] = bfig_t_id;
  termTypes[1] = corel_t_id;
  termTypes[2] = dxf_t_id;
  termTypes[3] = eepic_t_id;
  termTypes[4] = emtex_t_id;
  termTypes[5] = fig_t_id;
  termTypes[6] = latex_t_id;
  termTypes[7] = pbm_t_id;
  termTypes[8] = ps_t_id;
  termTypes[9] = pslatex_t_id;
  termTypes[10] = pstricks_t_id;
  termTypes[11] = table_t_id;
  termTypes[12] = texdraw_t_id;
  termTypes[13] = tgif_t_id;
  termTypes[14] = tpic_t_id;
  termTypes[15] = x11_t_id;
  
  for (int i = 0; i < numTerms; i++)
  {
    ans = terminals->isItemChecked(termTypes[i]);
    
    if (ans = TRUE)
      terminals->setItemChecked(termTypes[i],FALSE);
  }  
}

void xgfeMain::clearFuncStyleChecks()
{
  bool ans;
  int numStyles = 8;
  int funcStyleTypes[numStyles];

  funcStyleTypes[0] = func_p_id;
  funcStyleTypes[1] = func_l_id;
  funcStyleTypes[2] = func_lp_id;
  funcStyleTypes[3] = func_i_id;
  funcStyleTypes[4] = func_d_id;
  funcStyleTypes[5] = func_s_id;
  funcStyleTypes[6] = func_eb_id;
  funcStyleTypes[7] = func_b_id;

  for (int i = 0; i < numStyles; i++)
  {
    ans = funcStyle->isItemChecked(funcStyleTypes[i]);
    
    if (ans = TRUE)
      funcStyle->setItemChecked(funcStyleTypes[i],FALSE);
  }  
}

void xgfeMain::setTermBfig()
{
  gnuInt->setTerminal("bfig");
  
  clearTermChecks();
  terminals->setItemChecked(bfig_t_id, TRUE);
  termLabel->setText("bfig");
}

void xgfeMain::setTermCorel()
{
  gnuInt->setTerminal("corel");
  
  clearTermChecks();
  terminals->setItemChecked(corel_t_id, TRUE);
  termLabel->setText("corel");
}

void xgfeMain::setTermDxf()
{
  gnuInt->setTerminal("dxf");
  
  clearTermChecks();
  terminals->setItemChecked(dxf_t_id, TRUE);
  termLabel->setText("dxf");
}

void xgfeMain::setTermEepic()
{
  gnuInt->setTerminal("eepic");
  
  clearTermChecks();
  terminals->setItemChecked(eepic_t_id, TRUE);
  termLabel->setText("eepic");
}

void xgfeMain::setTermEmtex()
{
  // open dialog and capture results
  latexEmtexOp* emtexOptions = new latexEmtexOp;
  
  emtexOptions->setGnuInterface(gnuInt);

  if (emtexOptions->exec())
  {
    // OK was pressed
    // set appropriate checkmark
    clearTermChecks();
    terminals->setItemChecked(emtex_t_id, TRUE);

    gnuInt->setTerminal("emtex");

    // set label
    termLabel->setText("emtex");
  }
  
}

void xgfeMain::setTermFig()
{
  gnuInt->setTerminal("fig");
  
  clearTermChecks();
  terminals->setItemChecked(fig_t_id, TRUE);
  termLabel->setText("fig");
}

void xgfeMain::setTermLatex()
{
  // open dialog and capture results
  latexEmtexOp* latexOptions = new latexEmtexOp;
  
  latexOptions->setGnuInterface(gnuInt);

  if (latexOptions->exec())
  {
    // OK was pressed
    // set appropriate checkmark
    clearTermChecks();
    terminals->setItemChecked(latex_t_id, TRUE);

    gnuInt->setTerminal("latex");
    
    // set label
    termLabel->setText("latex");
  }
}

void xgfeMain::setTermPbm()
{
  // open dialog and capture results
  pbmOp* pbmOptions = new pbmOp;

  pbmOptions->setGnuInterface(gnuInt);

  if (pbmOptions->exec())
  {
    // OK was pressed
    // set appropriate checkmark  
    clearTermChecks();
    terminals->setItemChecked(pbm_t_id, TRUE);

    gnuInt->setTerminal("pbm");

    // set label
    termLabel->setText("pbm");
  }
}

void xgfeMain::setTermPostscript()
{
  // open dialog and capture results
  psOpt* psOptions = new psOpt;
  psOptions->setGnuInterface(gnuInt);

  if (psOptions->exec())
  {
    // OK was pressed
    // set appropriate checkmark  
    clearTermChecks();
    terminals->setItemChecked(ps_t_id, TRUE);

    gnuInt->setTerminal("postscript");
    
    // set label
    termLabel->setText("postscript");
  }
}

void xgfeMain::setTermPslatex()
{
  gnuInt->setTerminal("pslatex");
  
  clearTermChecks();
  terminals->setItemChecked(pslatex_t_id, TRUE);
  termLabel->setText("pslatex");
}

void xgfeMain::setTermPstricks()
{
  gnuInt->setTerminal("pstricks");
  
  clearTermChecks();
  terminals->setItemChecked(pstricks_t_id, TRUE);
  termLabel->setText("pstricks");
}

void xgfeMain::setTermTable()
{
  gnuInt->setTerminal("table");
  
  clearTermChecks();
  terminals->setItemChecked(table_t_id, TRUE);
  termLabel->setText("table");
}

void xgfeMain::setTermTexdraw()
{
  gnuInt->setTerminal("texdraw");
  
  clearTermChecks();
  terminals->setItemChecked(texdraw_t_id, TRUE);
  termLabel->setText("texdraw");
}

void xgfeMain::setTermTgif()
{
  gnuInt->setTerminal("tgif");
  
  clearTermChecks();
  terminals->setItemChecked(tgif_t_id, TRUE);
  termLabel->setText("tgif");
}

void xgfeMain::setTermTpic()
{
  gnuInt->setTerminal("tpic");
  
  clearTermChecks();
  terminals->setItemChecked(tpic_t_id, TRUE);
  termLabel->setText("tpic");
}

void xgfeMain::setTermX11()
{
  gnuInt->setTerminal("x11");
  
  clearTermChecks();
  terminals->setItemChecked(x11_t_id, TRUE);
  termLabel->setText("x11");
}

void xgfeMain::setPlotSize()
{
  sizeOp* sizeOptions = new sizeOp;

  sizeOptions->setGnuInterface(gnuInt);
  sizeOptions->show();
}

void xgfeMain::rawGnuInput()
{
  rawGnu* rawInput = new rawGnu;

  rawInput->setGnuInterface(gnuInt);
  rawInput->show();
}

void xgfeMain::getFileOptions()
{
  fileOptions* fileOp = new fileOptions;
  
  fileOp->setGnuInterface(gnuInt);
  fileOp->show();
}

void xgfeMain::getLegendOps()
{
  legendOp* legendOptions = new legendOp;
  legendOptions->setGnuInterface(gnuInt);
  legendOptions->show();
}

void xgfeMain::getMultiFile()
{
  multiFile* multifile = new multiFile;
  multifile->setGnuInterface(gnuInt);
  multifile->show();
}

void xgfeMain::getMultiFunction()
{
  multiFunc* multifunc = new multiFunc;
  multifunc->setGnuInterface(gnuInt);
  multifunc->show();
}

void xgfeMain::setFileLegendTitle()
{
  fileLegendTitle* fileLegend = new fileLegendTitle;
  fileLegend->setGnuInterface(gnuInt);
  fileLegend->show();
}

void xgfeMain::setFuncLegendTitle()
{
  funcLegendTitle* funcLegend = new funcLegendTitle;
  funcLegend->setGnuInterface(gnuInt);
  funcLegend->show();
}

void xgfeMain::setLogScaleOptions()
{
  logScaleOp* logScale = new logScaleOp;
  logScale->setGnuInterface(gnuInt);
  logScale->show();
}

void xgfeMain::setFileFilter()
{
  fileFilter* fileFilterOp = new fileFilter;
  fileFilterOp->setGnuInterface(gnuInt);
  fileFilterOp->show();
}

void xgfeMain::setBarOptions()
{
  barOp* bar = new barOp;
  bar->setGnuInterface(gnuInt);
  bar->show();
}

void xgfeMain::resetBarOptions()
{
  gnuInt->setBarSizeOption("");
}

void xgfeMain::getCurveFit()
{
  curveFit* cFit = new curveFit;
  cFit->setGnuInterface(gnuInt);
  cFit->show();
}

void xgfeMain::setBoxWidthOption()
{
  boxWidthOp* bWidth = new boxWidthOp;
  bWidth->setGnuInterface(gnuInt);
  bWidth->show();
}

void xgfeMain::resetBoxWidthOption()
{
  gnuInt->setBoxWidth("");
}

void xgfeMain::setTicsOptions()
{
  ticsOp* tics = new ticsOp;
  tics->setGnuInterface(gnuInt);
  tics->show();
}
