/* -------------------------- gnuPlotFile class --------------------------
   
   This is a class to create an object to plot datafiles. It contains all
   variables necessary for plotting files and knows how to issue the correct
   command to gnuPlot to plot the file with its options. 

   This file is part of Xgfe: X Windows GUI front end to Gnuplot
   Copyright (C) 1998 David Ishee

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ------------------------------------------------------------------------*/

#ifndef gnuPlotFile_included
#define gnuPlotFile_included

#include <string>

class gnuPlotFile
{
public:
  gnuPlotFile();
  /* Description:
       Constructor function */

  string getPlotCmd();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: plotting command for the file
     Description: 
       Builds a string to plot the file */

  void setFilename(string file);
  /* Incoming arguments:
       string file: Filename to plot
     Outgoing arguments:
       none
     Description: 
       Sets the filename to plot */

  string getFilename();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: current filename
     Description: 
       Gets the current filename */  

  void setFileStyleType(string type);
  /* Incoming arguments:
       string type: style of plotting. With Gnuplot 3.5 the following types
       are supported: points, lines, linespoints, impulses, dots, steps,
       errorbars, and boxes. Others can be specified if Gnuplot will
       understand it. 
     Outgoing arguments:
       none
     Description:
       Sets the style of plotting the datafile */

  string getFileStyleType();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: current style
     Description: 
       Gets the current style */  

  void setFileDataSetStart(string start);
  string getFileDataSetStart();
  void setFileDataSetEnd(string end);
  string getFileDataSetEnd();
  void setFileDataSetIncrement(string inc);
  string getFileDataSetIncrement();
  void setFileSampPointInc(string pinc);
  string getFileSampPointInc();
  void setFileSampLineInc(string linc);
  string getFileSampLineInc();
  void setFileSampStartPoint(string startp);
  string getFileSampStartPoint();
  void setFileSampStartLine(string startl);
  string getFileSampStartLine();
  void setFileSampEndPoint(string endp);
  string getFileSampEndPoint();
  void setFileSampEndLine(string endl);
  string getFileSampEndLine();
  void setFileSmoothType(string type);
  string getFileSmoothType();
  
  void setFileXColumn(string column);
  /* Incoming arguments:
       string column: column to use for x variable
     Outgoing arguments:
       none
     Description: 
       Sets the column to use for the x variable */

  string getFileXColumn();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: x column that is currently specified
     Description: 
       Gets the column to use for the x variable */

  void setFileYColumn(string column);
  /* Incoming arguments:
       string column: column to use for y variable 
     Outgoing arguments:
       none
     Description: 
       Sets the column to use for the y variable */

  string getFileYColumn();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: y column that is currently specified
     Description: 
       Gets the column to use for the y variable */

  void setFileZColumn(string column);
  /* Incoming arguments:
       string column: column to use for z variable 
     Outgoing arguments:
       none
     Description: 
       Sets the column to use for the z variable */

  string getFileZColumn();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: z column that is currently specified
     Description: 
       Gets the column to use for the z variable */

  void setFileFormatString(string format);
  /* Incoming arguments:
       string format: scanf format string including quotes
     Outgoing arguments:
       none
     Description: 
       Sets the scanf format string to read the data file with */

  string getFileFormatString();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: current format string
     Description: 
       Gets the current scanf format string */

  void setRawFileFormatString(string format);
  /* Incoming arguments:
       string format: format for plotting file
     Outgoing arguments:
       none
     Description: 
       Sets the format string to whatever is specified. If this is set, it 
       will be used instead of building one from the columns and format 
       string specifications. This allows complex formats to be specified. */

  string getRawFileFormatString();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: current raw file format
     Description: 
       Gets the current format string */

  void setLegendTitle(string title);
  /* Incoming arguments:
       title: title for legend
              if = notitle, notitle command is issued
              if = default, title option is not given, 
                   gnuplot will use default
     Outgoing arguments:
       none
     Description:
       Sets title to be used in legend */

  string getLegendTitle();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: title for current file
     Description:
       Gets title to be used in legend for the file */

  void setFileFilter(string thefilter);
  /* Incoming arguments:
       string: filter command
     Outgoing arguments:
       none
     Description:
       Sets filter command for the file */

  string getFileFilter();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: filter command
     Description:
       Gets filter command for the file */

  void setFileFilterQuoteChar(string quote);
  /* Incoming arguments:
       string quote: quoting char
     Outgoing arguments:
       none
     Description:
       Sets quoting character for the single file filter cmd */

  string getFileFilterQuoteChar();
  /* Incoming arguments:
       none
     Outgoing arguments:
       string: quoting character
     Description:
       Gets quoting character for the single file filter cmd */

private:

  string filename;
  string styleType;
  string dataSetStart;
  string dataSetEnd;
  string dataSetInc;
  string samplePointInc;
  string sampleLineInc;
  string sampleStartPoint;
  string sampleStartLine;
  string sampleEndPoint;
  string sampleEndLine;
  string fileSmoothType;
  string xColumn;
  string yColumn;
  string zColumn;
  string formatString;
  string rawFormatString;
  string legendTitle;
  string filter;
  string filterQuoteChar;

};



#endif // gnuPlotFile_included
