/**********************************************************************

	File: gnuInterface.cpp

    This file is part of Xgfe: X Windows GUI front end to Gnuplot
    Copyright (C) 1998 David Ishee

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 *********************************************************************/

#include "gnuInterface.h"

gnuInterface::gnuInterface()
{
  plotFileFlag = 0;
  plotMultipleFileFlag = 0;
  plotFuncFlag = 0;
  plotMultipleFuncFlag = 0;
  filePlotType = "plot";
  funcPlotType = "plot";
  hSize = "";
  vSize = "";
  terminal = "x11";
  termLatexEmtexFont = "roman";
  termLatexEmtexFontSize = "10";
  termPBMfontSize = "small";
  termPBMcolormode = "monochrome";
  termPBMhSize = "1";
  termPBMvSize = "1";
  termPSmode = "landscape";
  termPScolor = "monochrome";
  termPSdashed = "dashed";
  termPSfont = "Helvetica";
  termPSfontSize = "14";
  termPSenhanced = "noenhanced";
  termPShSize = "1";
  termPSvSize = "1";
  legendFlag = "key";
  legendPositionLeft = 0;
  legendPositionRight = 1;
  legendPositionTop = 1;
  legendPositionBottom = 0;
  legendPositionOutside = 0;
  legendPositionBelow = 0;
  legendPositionXVal = "";
  legendPositionYVal = "";
  legendPositionZVal = "";
  legendTextJustify = "Right";
  legendReverse = "noreverse";
  legendBox = "nobox";
  legendLinetype = "";
  legendSampleLength = "4";
  legendSpacing = "1.25";
  legendWidthIncrement = "";
  legendTitle = "";
  xticsOnFlag = 1;
  xticsLocation = "border";
  xticsMirror = "mirror";
  xticsRotation = "norotate";
  xticsPositionType = "SIE";
  xticsStartPos = "";
  xticsIncPos = "";
  xticsEndPos = "";
  xticsLabelsPos = "";
  yticsOnFlag = 1;
  yticsLocation = "border";
  yticsMirror = "mirror";
  yticsRotation = "norotate";
  yticsPositionType = "SIE";
  yticsStartPos = "";
  yticsIncPos = "";
  yticsEndPos = "";
  yticsLabelsPos = "";
  zticsOnFlag = 0;
  zticsMirror = "nomirror";
  zticsRotation = "norotate";
  zticsPositionType = "SIE";
  zticsStartPos = "";
  zticsIncPos = "";
  zticsEndPos = "";
  zticsLabelsPos = "";
  x2ticsOnFlag = 0;
  x2ticsLocation = "border";
  x2ticsMirror = "mirror";
  x2ticsRotation = "norotate";
  x2ticsPositionType = "SIE";
  x2ticsStartPos = "";
  x2ticsIncPos = "";
  x2ticsEndPos = "";
  x2ticsLabelsPos = "";
  y2ticsOnFlag = 0;
  y2ticsLocation = "border";
  y2ticsMirror = "mirror";
  y2ticsRotation = "norotate";
  y2ticsPositionType = "SIE";
  y2ticsStartPos = "";
  y2ticsIncPos = "";
  y2ticsEndPos = "";
  y2ticsLabelsPos = "";
  logScaleBase = 10;
  logScaleXAxisFlag = 0;
  logScaleYAxisFlag = 0;
  logScaleZAxisFlag = 0;
  logScaleX2AxisFlag = 0;
  logScaleY2AxisFlag = 0;
  barSize = "";
  boxWidth = "";
  
  // open a plot file object
  plotFileOb = new gnuPlotFile;

  // open a new multifile object
  multiFile = new gnuMultiFile;

  // open a plot function object
  plotFunctionOb = new gnuPlotFunction;

  // open a new multifunc object
  multiFunc = new gnuMultiFunc;

  // open a curve fitting object
  curveFitOb = new gnuCurveFit;
}

FILE* gnuInterface::openGnuplot()
{
  gnuCommand = popen("gnuplot","w");
  return gnuCommand;
}

void gnuInterface::doPlot()
{
  string xrange = "";           // reset range temp variables
  string yrange = "";
  string zrange = "";

  string filePlotCMD = "";      // reset plot substrings
  string funcPlotCMD = "";
  string rangePlotCMD = "";


  /* There are several things we need to do in order to create a plot. 
     (1) Set x,y,z labels, output, terminal, size, title, key, etc as 
         individual "set" commands that can be executed individually
     (2) Choose plot, splot, or replot command, specify x,y,z axis ranges
         as head of plot command. 
     (3) Issue commands for datafiles and functions and their options as the 
         tail of the command. */


  // Do task (1): setup x,y,z labels, output, terminal, size, title, key, etc

  // add x,y,z labels if given

  // setup xlabel 
  string label = "";

  if ((XLabel == "") && (XOffset_X != "") || (XOffset_Y != ""))
    cout << "X label offsets given, but no X label was specified. "
         << "No X label will be printed.\n";
  
  if (XLabel != "")
  {
    fprintf(gnuCommand, "set xlabel '");
    fprintf(gnuCommand,XLabel.c_str());
    fprintf(gnuCommand,"' ");
    cout << "\nset xlable '" << XLabel << "' ";

    // set offsets
    string offset = "";
    
    // both xlabel offsets are specified
    if ((XOffset_X != "") && (XOffset_Y != ""))
    {
      offset = XOffset_X;
      offset += ",";
      offset += XOffset_Y;
    }

    // xlabel x offset only specified
    if ((XOffset_X != "") && (XOffset_Y == ""))
    {
      fprintf(gnuCommand, XOffset_X.c_str());
      cout << XOffset_X;
      label = XOffset_X;
    }

    // xlabel y offset only specified
    if ((XOffset_X == "") && (XOffset_Y != ""))
    {
      fprintf(gnuCommand, ",");
      fprintf(gnuCommand, XOffset_Y.c_str());
      cout << "," << XOffset_Y;
    }
      
    fprintf(gnuCommand,"\n");
    fflush(gnuCommand);
    cout << endl;
  }
  else
  {
    fprintf(gnuCommand, "set xlabel\n");
    fflush(gnuCommand);
    cout << "set xlable" << endl;
  }
  
  // setup ylabel 

  if ((YLabel == "") && (YOffset_X != "") || (YOffset_Y != ""))
    cout << "Y label offsets given, but no Y label was specified. "
         << "No Y label will be printed.\n";

  if (YLabel != "")
  {
    fprintf(gnuCommand, "set ylabel '");
    fprintf(gnuCommand,YLabel.c_str());
    fprintf(gnuCommand,"' ");
    cout << "set ylabel '" << YLabel << "' ";

    // set ylabel offsets

    // both ylabel offsets are specified
    if ((YOffset_X != "") && (YOffset_Y != ""))
    {
      fprintf(gnuCommand, YOffset_X.c_str());
      fprintf(gnuCommand, ",");
      fprintf(gnuCommand, YOffset_Y.c_str());
      cout << YOffset_X << "," << YOffset_Y;
    }

    // ylabel x offset only specified
    if ((YOffset_X != "") && (YOffset_Y == ""))
    {
      fprintf(gnuCommand, YOffset_X.c_str());
      cout << YOffset_X;
    }

    // ylabel y offset only specified
    if ((YOffset_X == "") && (YOffset_Y != ""))
    {
      fprintf(gnuCommand, ",");
      fprintf(gnuCommand, YOffset_Y.c_str());
      cout << "," << YOffset_Y;
    }

    fprintf(gnuCommand,"\n");
    fflush(gnuCommand);
    cout << endl;
  }
  else
  {
    fprintf(gnuCommand, "set ylabel\n");
    fflush(gnuCommand);
    cout << "set ylable" << endl;
  }

  // setup zlabel 

  if ((ZLabel == "") && (ZOffset_X != "") || (ZOffset_Y != ""))
    cout << "Z label offsets given, but no Z label was specified. "
         << "No Z label will be printed.\n";
  
  if (ZLabel != "")
  {
    fprintf(gnuCommand, "set zlabel '");
    fprintf(gnuCommand,ZLabel.c_str());
    fprintf(gnuCommand,"' ");
    cout << "set zlabel '" << ZLabel << "' ";

    // set zlabel offsets

    // both offsets are specified
    if ((ZOffset_X != "") && (ZOffset_Y != ""))
    {
      fprintf(gnuCommand, ZOffset_X.c_str());
      fprintf(gnuCommand, ",");
      fprintf(gnuCommand, ZOffset_Y.c_str());
      cout << ZOffset_X << "," << ZOffset_Y;
    }

    // zlabel x offset only specified
    if ((ZOffset_X != "") && (ZOffset_Y == ""))
    {
      fprintf(gnuCommand, ZOffset_X.c_str());
      cout << ZOffset_X;
    }

    // zlabel y offset only specified
    if ((ZOffset_X == "") && (ZOffset_Y != ""))
    {
      fprintf(gnuCommand, ",");
      fprintf(gnuCommand, ZOffset_Y.c_str());
      cout << "," << ZOffset_Y;
    }

    fprintf(gnuCommand,"\n");
    fflush(gnuCommand);
    cout << endl;
  }
  else
  {
    fprintf(gnuCommand, "set zlabel\n");
    fflush(gnuCommand);
    cout << "set zlable" << endl;
  }

  // set output
  if (output == "")
  {
    fprintf(gnuCommand, "set output\n");
    fflush(gnuCommand);
    cout << "set output\n";
  }
  else
  {
    fprintf(gnuCommand, "set output '");
    fprintf(gnuCommand,output.c_str());
    fprintf(gnuCommand,"'");
    fprintf(gnuCommand,"\n");
    fflush(gnuCommand);
    cout << "set output '" << output << "'" << endl;
  }

  // set terminal
  if (terminal != "")
  {
    fprintf(gnuCommand, "set terminal ");
    fprintf(gnuCommand, terminal.c_str());

    if ((terminal == "emtex") || (terminal == "latex"))
    {

      fprintf(gnuCommand, " ");
      fprintf(gnuCommand, termLatexEmtexFont.c_str());
      fprintf(gnuCommand, " ");
      fprintf(gnuCommand, termLatexEmtexFontSize.c_str());
      fprintf(gnuCommand, "\n");
      fflush(gnuCommand);
      cout << "set terminal " << terminal << " "<< termLatexEmtexFont 
           << " " << termLatexEmtexFontSize << endl;
    }
    else if (terminal == "pbm")
    {
      fprintf(gnuCommand, " ");
      fprintf(gnuCommand, termPBMfontSize.c_str());
      fprintf(gnuCommand, " ");
      fprintf(gnuCommand, termPBMcolormode.c_str());
      fprintf(gnuCommand, "\n");
      fflush(gnuCommand);
      cout << "set terminal " << terminal << " " << termPBMfontSize 
           << " " << termPBMcolormode << endl;
    }
    else if (terminal == "postscript")
    {
      fprintf(gnuCommand, " ");
      fprintf(gnuCommand,termPSmode.c_str());
      fprintf(gnuCommand, " ");
      fprintf(gnuCommand,termPSenhanced.c_str());
      fprintf(gnuCommand, " ");
      fprintf(gnuCommand,termPScolor.c_str());
      fprintf(gnuCommand, " ");
      fprintf(gnuCommand,termPSdashed.c_str());
      fprintf(gnuCommand, " ");
      fprintf(gnuCommand, "\"");
      fprintf(gnuCommand,termPSfont.c_str());
      fprintf(gnuCommand,"\"");
      fprintf(gnuCommand, " ");
      fprintf(gnuCommand,termPSfontSize.c_str());
      fprintf(gnuCommand, "\n");
      fflush(gnuCommand);
      cout << "set terminal " << terminal << " " << termPSmode << " " 
           << termPSenhanced << " " << termPScolor << " " << termPSdashed << " " 
           << " " << '"' << termPSfont << '"' << " " << termPSfontSize << endl;
    }
    else 
    {
      fprintf(gnuCommand, "\n");
      fflush(gnuCommand);
      cout << "set terminal " << terminal << endl;
    }
  }

  // set size
  fprintf(gnuCommand, "set size ");
  cout << "set size ";

  if ((hSize != "") && (vSize != ""))
  {
    fprintf(gnuCommand, hSize.c_str());
    fprintf(gnuCommand, ",");
    fprintf(gnuCommand, vSize.c_str());
    cout << hSize << "," << vSize;
  }
  fprintf(gnuCommand, "\n");
  cout << endl;
  fflush(gnuCommand);

  // setup title 

  if ((title == "") && ((titleOffset_X != "") || (titleOffset_Y != "")))
    cout << "Offsets given for title, but no title given. "
         << "No title will be printed." << endl;
  
  // set title
  if (title != "")
  {
    fprintf(gnuCommand, "set title '");
    fprintf(gnuCommand,title.c_str());
    fprintf(gnuCommand,"' ");
    cout << "set title '" << title << "' ";

    // set title offsets

    // both title offsets are specified
    if ((titleOffset_X != "") && (titleOffset_Y != ""))
    {
      fprintf(gnuCommand, titleOffset_X.c_str());
      fprintf(gnuCommand, ",");
      fprintf(gnuCommand, titleOffset_Y.c_str());
      cout << titleOffset_X << "," << titleOffset_Y;
    }

    // title x offset only specified
    if ((titleOffset_X != "") && (titleOffset_Y == ""))
    {
      fprintf(gnuCommand, titleOffset_X.c_str());
      cout << titleOffset_X;
    }

    // title y offset only specified
    if ((titleOffset_X == "") && (titleOffset_Y != ""))
    {
      fprintf(gnuCommand, ",");
      fprintf(gnuCommand, titleOffset_Y.c_str());
      cout << "," << titleOffset_Y;
    }

    fprintf(gnuCommand,"\n");
    fflush(gnuCommand);
    cout << endl;
  }
  else
  {
    fprintf(gnuCommand, "set title ''\n");
    fflush(gnuCommand);
    cout << "set title ''" << endl;
  }

  // setup legend command
  string legend = "set ";

  legend += legendFlag; // key or nokey
  
  if (legendFlag != "nokey")
  {
    if (legendPositionLeft == 1)
      legend += " left ";
  
    if (legendPositionRight == 1)
      legend += " right ";

    if (legendPositionTop == 1)
      legend += " top ";

    if (legendPositionBottom == 1)
      legend += " bottom ";

    if (legendPositionOutside == 1)
      legend += " outside ";

    if (legendPositionBelow == 1)
      legend += " below ";

    if ((legendPositionXVal != "") && (legendPositionYVal != ""))
    {
      legend += legendPositionXVal;
      legend += ",";
      legend += legendPositionYVal;
    
      if (legendPositionZVal != "")
      {
        legend += ",";
        legend += legendPositionZVal;
      }
    
      legend += " ";
    }

    legend += legendTextJustify;
    legend += " ";

    legend += legendReverse;
    legend += " ";

    legend += "samplen ";
    legend += legendSampleLength;
    legend += " ";

    legend += "spacing ";
    legend += legendSpacing;
    legend += " ";

    if (legendWidthIncrement != "")
    {
      legend += "width ";
      legend += legendWidthIncrement;
      legend += " ";
    }
    
    legend += "title ";
    legend += " '";
    legend += legendTitle;
    legend += "' ";
  
    legend += legendBox;
    legend += " ";

    legend += legendLinetype;
  }
  
  legend += "\n";

  fprintf(gnuCommand,legend.c_str());  // issue command
  fflush(gnuCommand);

  cout << legend;

  // set xtics options
  if (xticsOnFlag == 1)
  {
    fprintf(gnuCommand,"set xtics ");
    cout << "set xtics ";

    fprintf(gnuCommand,xticsLocation.c_str());
    fprintf(gnuCommand," ");
    cout << xticsLocation << " ";

    fprintf(gnuCommand,xticsMirror.c_str());
    fprintf(gnuCommand," ");
    cout << xticsMirror << " ";

    fprintf(gnuCommand,xticsRotation.c_str());
    fprintf(gnuCommand," ");
    cout << xticsRotation << " ";

    if (xticsPositionType == "SIE")
    {
      if (xticsStartPos != "")
      {
        fprintf(gnuCommand,xticsStartPos.c_str());
        fprintf(gnuCommand, ",");
        cout << xticsStartPos << ",";
      }

      if (xticsStartPos == "")
      {
        fprintf(gnuCommand, " ");
        cout << " ";
      }
      
      fprintf(gnuCommand,xticsIncPos.c_str());
      cout << xticsIncPos;
      
      if (xticsEndPos != "")
      {
        fprintf(gnuCommand,",");
        fprintf(gnuCommand,xticsEndPos.c_str());
        cout << "," << xticsEndPos;
      }
    }
    else if (xticsPositionType == "LABELS")
    {
      fprintf(gnuCommand," ");
      fprintf(gnuCommand,xticsLabelsPos.c_str());
      cout << " " << xticsLabelsPos;
    }

    fprintf(gnuCommand,"\n");
    fflush(gnuCommand);
    cout << endl;
  }
  
  // set ytics options
  if (yticsOnFlag == 1)
  {
    fprintf(gnuCommand,"set ytics ");
    cout << "set ytics ";

    fprintf(gnuCommand,yticsLocation.c_str());
    fprintf(gnuCommand," ");
    cout << yticsLocation << " ";

    fprintf(gnuCommand,yticsMirror.c_str());
    fprintf(gnuCommand," ");
    cout << yticsMirror << " ";

    fprintf(gnuCommand,yticsRotation.c_str());
    fprintf(gnuCommand," ");
    cout << yticsRotation << " ";

    if (yticsPositionType == "SIE")
    {
      if (yticsStartPos != "")
      {
        fprintf(gnuCommand,yticsStartPos.c_str());
        fprintf(gnuCommand, ",");
        cout << yticsStartPos << ",";
      }

      if (yticsStartPos == "")
      {
        fprintf(gnuCommand, " ");
        cout << " ";
      }
      
      fprintf(gnuCommand,yticsIncPos.c_str());
      cout << yticsIncPos;
      
      if (yticsEndPos != "")
      {
        fprintf(gnuCommand,",");
        fprintf(gnuCommand,yticsEndPos.c_str());
        cout << "," << yticsEndPos;
      }
    }
    else if (yticsPositionType == "LABELS")
    {
      fprintf(gnuCommand," ");
      fprintf(gnuCommand,yticsLabelsPos.c_str());
      cout << " " << yticsLabelsPos;
    }

    fprintf(gnuCommand,"\n");
    fflush(gnuCommand);
    cout << endl;
  }

  // set ztics options
  if (zticsOnFlag == 1)
  {
    fprintf(gnuCommand,"set ztics ");
    cout << "set ztics ";

    fprintf(gnuCommand,zticsMirror.c_str());
    fprintf(gnuCommand," ");
    cout << zticsMirror << " ";

    fprintf(gnuCommand,zticsRotation.c_str());
    fprintf(gnuCommand," ");
    cout << zticsRotation << " ";

    if (zticsPositionType == "SIE")
    {
      if (zticsStartPos != "")
      {
        fprintf(gnuCommand,zticsStartPos.c_str());
        fprintf(gnuCommand, ",");
        cout << zticsStartPos << ",";
      }

      if (zticsStartPos == "")
      {
        fprintf(gnuCommand, " ");
        cout << " ";
      }
      
      fprintf(gnuCommand,zticsIncPos.c_str());
      cout << zticsIncPos;
      
      if (zticsEndPos != "")
      {
        fprintf(gnuCommand,",");
        fprintf(gnuCommand,zticsEndPos.c_str());
        cout << "," << zticsEndPos;
      }
    }
    else if (zticsPositionType == "LABELS")
    {
      fprintf(gnuCommand," ");
      fprintf(gnuCommand,zticsLabelsPos.c_str());
      cout << " " << zticsLabelsPos;
    }

    fprintf(gnuCommand,"\n");
    fflush(gnuCommand);
    cout << endl;
  }

  // set x2tics options
  if (x2ticsOnFlag == 1)
  {
    fprintf(gnuCommand,"set x2tics ");
    cout << "set x2tics ";

    fprintf(gnuCommand,x2ticsLocation.c_str());
    fprintf(gnuCommand," ");
    cout << x2ticsLocation << " ";

    fprintf(gnuCommand,x2ticsMirror.c_str());
    fprintf(gnuCommand," ");
    cout << x2ticsMirror << " ";

    fprintf(gnuCommand,x2ticsRotation.c_str());
    fprintf(gnuCommand," ");
    cout << x2ticsRotation << " ";

    if (x2ticsPositionType == "SIE")
    {
      if (x2ticsStartPos != "")
      {
        fprintf(gnuCommand,x2ticsStartPos.c_str());
        fprintf(gnuCommand, ",");
        cout << x2ticsStartPos << ",";
      }

      if (x2ticsStartPos == "")
      {
        fprintf(gnuCommand, " ");
        cout << " ";
      }
      
      fprintf(gnuCommand,x2ticsIncPos.c_str());
      cout << x2ticsIncPos;
      
      if (x2ticsEndPos != "")
      {
        fprintf(gnuCommand,",");
        fprintf(gnuCommand,x2ticsEndPos.c_str());
        cout << "," << x2ticsEndPos;
      }
    }
    else if (x2ticsPositionType == "LABELS")
    {
      fprintf(gnuCommand," ");
      fprintf(gnuCommand,x2ticsLabelsPos.c_str());
      cout << " " << x2ticsLabelsPos;
    }

    fprintf(gnuCommand,"\n");
    fflush(gnuCommand);
    cout << endl;
  }

  // set y2tics options
  if (y2ticsOnFlag == 1)
  {
    fprintf(gnuCommand,"set y2tics ");
    cout << "set y2tics ";

    fprintf(gnuCommand,y2ticsLocation.c_str());
    fprintf(gnuCommand," ");
    cout << y2ticsLocation << " ";

    fprintf(gnuCommand,y2ticsMirror.c_str());
    fprintf(gnuCommand," ");
    cout << y2ticsMirror << " ";

    fprintf(gnuCommand,y2ticsRotation.c_str());
    fprintf(gnuCommand," ");
    cout << y2ticsRotation << " ";

    if (y2ticsPositionType == "SIE")
    {
      if (y2ticsStartPos != "")
      {
        fprintf(gnuCommand,y2ticsStartPos.c_str());
        fprintf(gnuCommand, ",");
        cout << y2ticsStartPos << ",";
      }

      if (y2ticsStartPos == "")
      {
        fprintf(gnuCommand, " ");
        cout << " ";
      }
      
      fprintf(gnuCommand,y2ticsIncPos.c_str());
      cout << y2ticsIncPos;
      
      if (y2ticsEndPos != "")
      {
        fprintf(gnuCommand,",");
        fprintf(gnuCommand,y2ticsEndPos.c_str());
        cout << "," << y2ticsEndPos;
      }
    }
    else if (y2ticsPositionType == "LABELS")
    {
      fprintf(gnuCommand," ");
      fprintf(gnuCommand,y2ticsLabelsPos.c_str());
      cout << " " << y2ticsLabelsPos;
    }

    fprintf(gnuCommand,"\n");
    fflush(gnuCommand);
    cout << endl;
  }

  // set log scale axis

  string logScaleCMD = "set logscale ";
  string noLogScaleCMD = "set nologscale ";

  // append axes to appropriate command

  if (logScaleXAxisFlag == 1)
    logScaleCMD += "x";
  else 
    noLogScaleCMD += "x";
  
  if (logScaleYAxisFlag == 1)
    logScaleCMD += "y";
  else 
    noLogScaleCMD += "y";

  if (logScaleZAxisFlag == 1)
    logScaleCMD += "z";
  else 
    noLogScaleCMD += "z";

  if (logScaleX2AxisFlag == 1)
    logScaleCMD += "x2";
  else 
    noLogScaleCMD += "x2";

  if (logScaleY2AxisFlag == 1)
    logScaleCMD += "y2";
  else 
    noLogScaleCMD += "y2";

  // if any axes are checked log scale, print and append base to command. 

  if ((logScaleXAxisFlag == 1) || (logScaleYAxisFlag == 1) ||
      (logScaleZAxisFlag == 1) || (logScaleX2AxisFlag == 1) ||
      (logScaleY2AxisFlag == 1))
  {
    fprintf(gnuCommand, logScaleCMD.c_str());
    cout << logScaleCMD;

    fprintf(gnuCommand," ");
    cout << " ";
    fprintf(gnuCommand,"%d",logScaleBase);
    cout << logScaleBase;
    fprintf(gnuCommand, "\n");
    cout << endl;
    fflush(gnuCommand);
  }

  // only print nologscale command if all axes are not set to log
  if ((logScaleXAxisFlag != 1) || (logScaleYAxisFlag != 1) ||
      (logScaleZAxisFlag != 1) || (logScaleX2AxisFlag != 1) ||
      (logScaleY2AxisFlag != 1))
  {
    fprintf(gnuCommand, noLogScaleCMD.c_str());
    fprintf(gnuCommand, "\n");
    cout << noLogScaleCMD << endl;
    fflush(gnuCommand);
  }

  // set bar options
  fprintf(gnuCommand,"set bar ");
  fprintf(gnuCommand, barSize.c_str());
  fprintf(gnuCommand,"\n");
  fflush(gnuCommand);
  cout << "set bar " << barSize << endl;

  // set box width options
  fprintf(gnuCommand,"set boxwidth ");
  fprintf(gnuCommand, boxWidth.c_str());
  fprintf(gnuCommand, "\n");
  fflush(gnuCommand);
  cout << "set boxwidth " << boxWidth << endl;

  // setup plotting range string that comes after plot/splot 

  // check to see if any range info is given
  if (replotFlag == 0)
  {
    if ((XVariableName != "") || (XRangeStart != "") || (XRangeEnd != ""))
    {
      // make sure a variable is not given without ranges
      if ((XVariableName != "") && (XRangeStart == "") && (XRangeEnd == ""))
      {
        cout << "X var specified, but no range given.\n";
      }
      else
      {
        xrange += "[";       // we have an x variable or range to specify
        xrange += XVariableName;    // insert x range
      
        if (XVariableName != "")
          xrange += "=";
      
        xrange += XRangeStart;
        xrange += ":";
        xrange += XRangeEnd;
        xrange += "]";
      }
    }

    // check to see if any range info is given
    if ((YVariableName != "") || (YRangeStart != "") || (YRangeEnd != ""))
    {
      // make sure a variable is not given without ranges
      if ((YVariableName != "") && (YRangeStart == "") && (YRangeEnd == ""))
      {
        cout << "Y var specified, but no range given. \n";
      }
      else
      {
        yrange += "[";       // we have a y variable or range to specify
        yrange += YVariableName;    // insert y range
          
        if (YVariableName != "")
          yrange += "=";
      
        yrange += YRangeStart;
        yrange += ":";
        yrange += YRangeEnd;
        yrange += "]";
      }
    }

    // check to see if any range info is given
    if ((ZRangeStart != "") || (ZRangeEnd != ""))
    {
      zrange += "[";       // we have a z range to specify
      zrange += ZRangeStart;
      zrange += ":";
      zrange += ZRangeEnd;
      zrange += "]";
    }

    rangePlotCMD += xrange;       // setup range string
  
    if (xrange != "")
      rangePlotCMD += " ";
  
    rangePlotCMD += yrange;
  
    if (yrange != "")
      rangePlotCMD += " ";
  
    rangePlotCMD += zrange;
  }

  // As a convention, plot files first then functions

    // start file plotting command generation code
    // filename or multiple filename option is checked

  if ((plotFileFlag == 1) || (plotMultipleFileFlag == 1))
  {
    // make sure single file is not "none" or null and is checked
    if ((plotFileOb->getFilename() != "") && 
        (plotFileOb->getFilename() != "none") && (plotFileFlag == 1))
    {
      filePlotCMD += plotFileOb->getPlotCmd(); // get command string 
    }
  }

  // now plot multiple files
  string tempFile;

  // get first file plotting command in list
  tempFile = multiFile->getMultiFileFirstPlotCmd();  

  // make sure flag is set
  if (plotMultipleFileFlag == 1)
  {
    // if already plotted a single file insert comma
    if ((plotFileFlag == 1) && (tempFile != "END"))
    {
      filePlotCMD += ", "; // insert comma
    }
    
    if (tempFile != "END")
      filePlotCMD += tempFile;

      // now iterate over the remaining files in list inserting commas before
    tempFile = multiFile->getMultiFileNextPlotCmd();

    while (tempFile != "END")
    {
      filePlotCMD += ",";
      filePlotCMD += tempFile;
      tempFile = multiFile->getMultiFileNextPlotCmd();
    }
  }

  // start function plotting command generation code
  
  if (plotFuncFlag == 1) // function option is checked
  {
    if (plotFunctionOb->getFunction() != "")
    {
      funcPlotCMD += plotFunctionOb->getPlotCmd(); // get command string
    }
  }

  // now plot multiple functions
  string tempFunc;

  // make sure flag is set
  if (plotMultipleFuncFlag == 1)
  {
    // now get first function plotting command in list
    tempFunc = multiFunc->getMultiFuncFirstPlotCmd();

      // if already plotted a single function insert comma
    if (plotFuncFlag == 1)
    {
      if (tempFunc != "END")
        funcPlotCMD += ", "; // insert comma
    }

    if (tempFunc != "END")
      funcPlotCMD += tempFunc;

      // now iterate over the remaining functions in list 
      // inserting commas before each
    tempFunc = multiFunc->getMultiFuncNextPlotCmd();
    
    while (tempFunc != "END")
    {
      funcPlotCMD += ", ";
      funcPlotCMD += tempFunc;
      tempFunc = multiFunc->getMultiFuncNextPlotCmd();
    }
  }


  // build plotting command based on what is selected: file(s)/function(s)/both
  // ------------------- issue file plotting command if present ----------
  if (filePlotCMD != "")
  {
    if (replotFlag == 1) // check for replot command
    {
      fprintf(gnuCommand,"replot");
      cout << "replot";
    }
    else
    {
      fprintf(gnuCommand,filePlotType.c_str()); // plot/splot
      cout << filePlotType;
    }
      
    // insert range info if present
    if (rangePlotCMD != "")
    {
      fprintf(gnuCommand," ");
      cout << " ";

      fprintf(gnuCommand,rangePlotCMD.c_str());
      cout << rangePlotCMD;
    }

    // add a space before file plotting command
    fprintf(gnuCommand," ");
    cout << " ";

    fprintf(gnuCommand,filePlotCMD.c_str());
    cout << filePlotCMD; 

    fflush(gnuCommand);
  }

  // add newline to end command if no function is being plotted
  if (funcPlotCMD == "")
  {
    fprintf(gnuCommand,"\n");
    fflush(gnuCommand);
    cout << endl;
  }

  // ---------- issue function plotting command if present ---------------

  if (funcPlotCMD != "")
  {
    // if not file command is present, insert plot/splot/replot command
    if (filePlotCMD == "")
    {
      if (replotFlag == 1) // check for replot command
      {
        fprintf(gnuCommand,"replot");
        cout << "replot";
      }
      else
      {
        fprintf(gnuCommand,funcPlotType.c_str()); // plot/splot
        cout << funcPlotType;
      }
      
      // insert range info if present
      if (rangePlotCMD != "")
      {
        fprintf(gnuCommand," ");
        cout << " ";

        fprintf(gnuCommand,rangePlotCMD.c_str());
        cout << rangePlotCMD;
      }

      // add a space before function plotting command
      fprintf(gnuCommand," ");
      cout << " ";

      // acutally plot functions
      fprintf(gnuCommand,funcPlotCMD.c_str());
      fprintf(gnuCommand,"\n");
      cout << funcPlotCMD << endl << endl;

      fflush(gnuCommand);
    }
    
    // if a file command is present, insert comma first before function command
    if (filePlotCMD != "")
    {
      fprintf(gnuCommand,", ");
      cout << ", ";
    
      fprintf(gnuCommand,funcPlotCMD.c_str());
      cout << funcPlotCMD;
      
      fprintf(gnuCommand,"\n");
      cout << endl << endl;
      
      fflush(gnuCommand);
    }
  }
}

void gnuInterface::setPlotFileFlag(int flag)
{
  plotFileFlag = flag;
}

int gnuInterface::getPlotFileFlag()
{
  return plotFileFlag;
}

void gnuInterface::setPlotMultipleFileFlag(int flag)
{
  plotMultipleFileFlag = flag;
}

int gnuInterface::getPlotMultipleFileFlag()
{
  return plotMultipleFileFlag;
}

void gnuInterface::setPlotMultipleFuncFlag(int flag)
{
  plotMultipleFuncFlag = flag;
}

int gnuInterface::getPlotMultipleFuncFlag()
{
  return plotMultipleFuncFlag;
}

void gnuInterface::setPlotFuncFlag(int flag)
{
  plotFuncFlag = flag;
}

int gnuInterface::getPlotFuncFlag()
{
  return plotFuncFlag;
}

void gnuInterface::doSave()
{
  fprintf(gnuCommand, "save '");
  fprintf(gnuCommand, gnuFileSave.c_str());
  fprintf(gnuCommand, "'\n");
  fflush(gnuCommand);
  cout << endl << "Saving to " << gnuFileSave << endl << endl;
}

void gnuInterface::doLoad()
{
  fprintf(gnuCommand, "load '");
  fprintf(gnuCommand, gnuFileLoad.c_str());
  fprintf(gnuCommand, "'\n");
  fflush(gnuCommand);
  cout << endl << "Loading  " << gnuFileLoad << endl << endl; 
}

void gnuInterface::setPlotFilename(string filename)
{
  plotFileOb->setFilename(filename);
}

string gnuInterface::getPlotFilename()
{
  return plotFileOb->getFilename();
}

void gnuInterface::setPlotFunction(string function)
{
  plotFunctionOb->setFunction(function);
}

string gnuInterface::getPlotFunction()
{
   return plotFunctionOb->getFunction();
}

void gnuInterface::setGnuFileSave(string file)
{
  gnuFileSave = file;
}
    
void gnuInterface::setGnuFileLoad(string file)
{
  gnuFileLoad = file;
}

void gnuInterface::setFilePlotType(string type)
{
  filePlotType = type;
}

string gnuInterface::getFilePlotType()
{
  return filePlotType;
}

void gnuInterface::setFileStyleType(string type)
{
  plotFileOb->setFileStyleType(type);
}

string gnuInterface::getFileStyleType()
{
  return plotFileOb->getFileStyleType();
}

void gnuInterface::setFileDataSetStart(string start)
{
  plotFileOb->setFileDataSetStart(start);
}

string gnuInterface::getFileDataSetStart()
{
  return plotFileOb->getFileDataSetStart();
}

void gnuInterface::setFileDataSetEnd(string end)
{
  plotFileOb->setFileDataSetEnd(end);
}

string gnuInterface::getFileDataSetEnd()
{
  return plotFileOb->getFileDataSetEnd();
}

void gnuInterface::setFileDataSetIncrement(string inc)
{
  plotFileOb->setFileDataSetIncrement(inc);
}

string gnuInterface::getFileDataSetIncrement()
{
  return plotFileOb->getFileDataSetIncrement();
}

void gnuInterface::setFileSampPointInc(string pinc)
{
  plotFileOb->setFileSampPointInc(pinc);
}

string gnuInterface::getFileSampPointInc()
{
  return plotFileOb->getFileSampPointInc();
}

void gnuInterface::setFileSampLineInc(string linc)
{
  plotFileOb->setFileSampLineInc(linc);
}

string gnuInterface::getFileSampLineInc()
{
  return plotFileOb->getFileSampLineInc();
}

void gnuInterface::setFileSampStartPoint(string startp)
{
  plotFileOb->setFileSampStartPoint(startp);
}

string gnuInterface::getFileSampStartPoint()
{
  return plotFileOb->getFileSampStartPoint();
}

void gnuInterface::setFileSampStartLine(string startl)
{
  plotFileOb->setFileSampStartLine(startl);
}

string gnuInterface::getFileSampStartLine()
{
  return plotFileOb->getFileSampStartLine();
}

void gnuInterface::setFileSampEndPoint(string endp)
{
  plotFileOb->setFileSampEndPoint(endp);
}

string gnuInterface::getFileSampEndPoint()
{
  return plotFileOb->getFileSampEndPoint();
}

void gnuInterface::setFileSampEndLine(string endl)
{
  plotFileOb->setFileSampEndLine(endl);
}

string gnuInterface::getFileSampEndLine()
{
  return plotFileOb->getFileSampEndLine();
}

void gnuInterface::setFileSmoothType(string type)
{
  plotFileOb->setFileSmoothType(type);
}

string gnuInterface::getFileSmoothType()
{
  return plotFileOb->getFileSmoothType();
}

void gnuInterface::setFileXColumn(string column)
{
  plotFileOb->setFileXColumn(column);
}

string gnuInterface::getFileXColumn()
{
  return plotFileOb->getFileXColumn();
}

void gnuInterface::setFileYColumn(string column)
{
  plotFileOb->setFileYColumn(column);
}

string gnuInterface::getFileYColumn()
{
  return plotFileOb->getFileYColumn();
}

void gnuInterface::setFileZColumn(string column)
{
  plotFileOb->setFileZColumn(column);
}

string gnuInterface::getFileZColumn()
{
  return plotFileOb->getFileZColumn();
}

void gnuInterface::setFileFormatString(string format)
{
  plotFileOb->setFileFormatString(format);
}

string gnuInterface::getFileFormatString()
{
  return plotFileOb->getFileFormatString();
}

void gnuInterface::setRawFileFormatString(string format)
{
  plotFileOb->setRawFileFormatString(format);
}

string gnuInterface::getRawFileFormatString()
{
  return plotFileOb->getRawFileFormatString();
}

void gnuInterface::setFileFilter(string filter)
{
  plotFileOb->setFileFilter(filter);
}

void gnuInterface::setFileFilterQuoteChar(string quote)
{
  plotFileOb->setFileFilterQuoteChar(quote);
}

string gnuInterface::getFileFilterQuoteChar()
{
  return plotFileOb->getFileFilterQuoteChar();
}

string gnuInterface::getFileFilter()
{
  return plotFileOb->getFileFilter();
}

void gnuInterface::setFuncPlotType(string type)
{
  funcPlotType = type;
}

string gnuInterface::getFuncPlotType()
{
  return funcPlotType;
}

void gnuInterface::setFuncStyleType(string type)
{
  funcStyleType = type;
  plotFunctionOb->setFunctionStyleType(type);
}

string gnuInterface::getFuncStyleType()
{
  return funcStyleType;
}

void gnuInterface::setXVariableName(string name)
{
  XVariableName = name;
}

string gnuInterface::getXVariableName()
{
  return XVariableName;
}

void gnuInterface::setXRangeStart(string range)
{
  XRangeStart = range;
}

string gnuInterface::getXRangeStart()
{
  return XRangeStart;
}

void gnuInterface::setXRangeEnd(string range)
{
  XRangeEnd = range;
}

string gnuInterface::getXRangeEnd()
{
  return XRangeEnd;
}

void gnuInterface::setYVariableName(string name)
{
  YVariableName = name;
}

string gnuInterface::getYVariableName()
{
  return YVariableName;
}

void gnuInterface::setYRangeStart(string range)
{
  YRangeStart = range;
}

string gnuInterface::getYRangeStart()
{
  return YRangeStart;
}

void gnuInterface::setYRangeEnd(string range)
{
  YRangeEnd = range;
}

string gnuInterface::getYRangeEnd()
{
  return YRangeEnd;
}

void gnuInterface::setZRangeStart(string range)
{
  ZRangeStart = range;
}

string gnuInterface::getZRangeStart()
{
  return ZRangeStart;
}

void gnuInterface::setZRangeEnd(string range)
{
  ZRangeEnd = range;
}

string gnuInterface::getZRangeEnd()
{
  return ZRangeEnd;
}

void gnuInterface::setXlabel(string label)
{
  XLabel = label;
}
 
string gnuInterface::getXlabel()
{
  return XLabel;
}
 
void gnuInterface::setXOffset_X(string offset)
{
  XOffset_X = offset;
}

string gnuInterface::getXOffset_X()
{
  return XOffset_X;
}

void gnuInterface::setXOffset_Y(string offset)
{
  XOffset_Y = offset;
}

string gnuInterface::getXOffset_Y()
{
  return XOffset_Y;
}

void gnuInterface::setYlabel(string label)
{
  YLabel = label;
}

string gnuInterface::getYlabel()
{
  return YLabel;
}
  
void gnuInterface::setYOffset_X(string offset)
{
  YOffset_X = offset;
}

string gnuInterface::getYOffset_X()
{
  return YOffset_X;
}

void gnuInterface::setYOffset_Y(string offset)
{
  YOffset_Y = offset;
}

string gnuInterface::getYOffset_Y()
{
  return YOffset_Y;
}

void gnuInterface::setZlabel(string label)
{
  ZLabel = label;
}

string gnuInterface::getZlabel()
{
  return ZLabel;
}
  
void gnuInterface::setZOffset_X(string offset)
{
  ZOffset_X = offset;
}

string gnuInterface::getZOffset_X()
{
  return ZOffset_X;
}

void gnuInterface::setZOffset_Y(string offset)
{
  ZOffset_Y = offset;
}

string gnuInterface::getZOffset_Y()
{
  return ZOffset_Y;
}
  
void gnuInterface::setTitle(string intitle)
{
  title = intitle;
}

string gnuInterface::getTitle()
{
  return title;
}
  
void gnuInterface::setTitleOffset_X(string offset)
{
  titleOffset_X = offset;
}

string gnuInterface::getTitleOffset_X()
{
  return titleOffset_X;
}

void gnuInterface::setTitleOffset_Y(string offset)
{
  titleOffset_Y = offset;
}

string gnuInterface::getTitleOffset_Y()
{
 return  titleOffset_Y;
}

void gnuInterface::setTerminal(string term)
{
  terminal = term;
}

string gnuInterface::getTerminal()
{
  return terminal;
}

void gnuInterface::setTermLateXEmtexFont(string font)
{
  termLatexEmtexFont = font;
}

string gnuInterface::getTermLateXEmtexFont()
{
  return termLatexEmtexFont;
}

void gnuInterface::setTermLateXEmtexFontSize(string size)
{
  termLatexEmtexFontSize = size;
}

string gnuInterface::getTermLateXEmtexFontSize()
{
  return termLatexEmtexFontSize;
}

void gnuInterface::setTermPBMFontSize(string size)
{
  termPBMfontSize = size;
}

string gnuInterface::getTermPBMFontSize()
{
  return termPBMfontSize;
}

void gnuInterface::setTermPBMColormode(string color)
{
  termPBMcolormode = color;
}

string gnuInterface::getTermPBMColormode()
{
  return termPBMcolormode;
}

void gnuInterface::setTermPBMhSize(string size)
{
  termPBMhSize = size;
  hSize = size;
}

string gnuInterface::getTermPBMhSize()
{
  return termPBMhSize;
}

void gnuInterface::setTermPBMvSize(string size)
{
  termPBMvSize = size;
  vSize = size;
}

string gnuInterface::getTermPBMvSize()
{
  return termPBMvSize;
}

void gnuInterface::setTermPSmode(string mode)
{
  termPSmode = mode;
}

string gnuInterface::getTermPSmode()
{
  return termPSmode;
}

void gnuInterface::setTermPScolor(string color)
{
  termPScolor = color;
}

string gnuInterface::getTermPScolor()
{
  return termPScolor;
}

void gnuInterface::setTermPSdashed(string type)
{
  termPSdashed = type;
}

string gnuInterface::getTermPSdashed()
{
  return termPSdashed;
}

void gnuInterface::setTermPSfont(string font)
{
  termPSfont = font;
}

string gnuInterface::getTermPSfont()
{
  return termPSfont;
}

void gnuInterface::setTermPSfontSize(string size)
{
  termPSfontSize = size;
}

string gnuInterface::getTermPSfontSize()
{
  return termPSfontSize;
}

void gnuInterface::setTermPSenhanced(string inenhanced)
{
  termPSenhanced = inenhanced;
}

string gnuInterface::getTermPSenhanced()
{
  return termPSenhanced;
}

void gnuInterface::setTermPShSize(string size)
{
  termPShSize = size;
  hSize = size;
}

string gnuInterface::getTermPShSize()
{
  return termPShSize;
}

void gnuInterface::setTermPSvSize(string size)
{
  termPSvSize = size;
  vSize = size;
}

string gnuInterface::getTermPSvSize()
{
  return termPSvSize;
}

void gnuInterface::setOutput(string inoutput)
{
  output = inoutput;
}

string gnuInterface::getOutput()
{
  return output;
}

void gnuInterface::setHorizSize(string size)
{
  hSize = size;
}

string gnuInterface::getHorizSize()
{
  return hSize;
}

void gnuInterface::setVertSize(string size)
{
  vSize = size;
}

string gnuInterface::getVertSize()
{
  return vSize;
}

void gnuInterface::closeGnuplot()
{
  pclose(gnuCommand);
}

void gnuInterface::doRawCommand(string command)
{
  if (command != "")
  {
    fprintf(gnuCommand,command.c_str());
    fprintf(gnuCommand,"\n");
    fflush(gnuCommand);
    cout << command << endl;
  }
  else
    cout << "No command given to plot!\n";
}

void gnuInterface::setReplotFlag(int flag)
{
  replotFlag = flag;
}

void gnuInterface::setLegendFlag(string flag)
{
  legendFlag = flag;
}

string gnuInterface::getLegendFlag()
{
  return legendFlag;
}

void gnuInterface::setLegendPositionLeft(int position)
{
  legendPositionLeft = position;
}

int gnuInterface::getLegendPositionLeft()
{
  return legendPositionLeft;
}

void gnuInterface::setLegendPositionRight(int position)
{
  legendPositionRight = position;
}

int gnuInterface::getLegendPositionRight()
{
  return legendPositionRight;
}

void gnuInterface::setLegendPositionTop(int position)
{
  legendPositionTop = position;
}

int gnuInterface::getLegendPositionTop()
{
  return legendPositionTop;
}

void gnuInterface::setLegendPositionBottom(int position)
{
  legendPositionBottom = position;
}

int gnuInterface::getLegendPositionBottom()
{
  return legendPositionBottom;
}

void gnuInterface::setLegendPositionOutside(int position)
{
  legendPositionOutside = position;
}

int gnuInterface::getLegendPositionOutside()
{
  return legendPositionOutside;
}

void gnuInterface::setLegendPositionBelow(int position)
{
  legendPositionBelow = position;
}

int gnuInterface::getLegendPositionBelow()
{
  return legendPositionBelow;
}

void gnuInterface::setLegendPositionXVal(string val)
{
  legendPositionXVal = val;
}

string gnuInterface::getLegendPositionXVal()
{
  return legendPositionXVal;
}

void gnuInterface::setLegendPositionYVal(string val)
{
  legendPositionYVal = val;
}

string gnuInterface::getLegendPositionYVal()
{
  return legendPositionYVal;
}

void gnuInterface::setLegendPositionZVal(string val)
{
  legendPositionZVal = val;
}

string gnuInterface::getLegendPositionZVal()
{
  return legendPositionZVal;
}

void gnuInterface::setLegendTextJustify(string justify)
{
  legendTextJustify = justify;
}

string gnuInterface::getLegendTextJustify()
{
  return legendTextJustify;
}

void gnuInterface::setLegendReverse(string reverse)
{
  legendReverse = reverse;
}

string gnuInterface::getLegendReverse()
{
  return legendReverse;
}

void gnuInterface::setLegendBox(string box)
{
  legendBox = box;
}

string gnuInterface::getLegendBox()
{
  return legendBox;
}

void gnuInterface::setLegendLinetype(string type)
{
  legendLinetype = type;
}

string gnuInterface::getLegendLinetype()
{
  return legendLinetype;
}

void gnuInterface::setLegendSampleLength(string length)
{
  legendSampleLength = length;
}

string gnuInterface::getLegendSampleLength()
{
  return legendSampleLength;
}

void gnuInterface::setLegendSpacing(string spacing)
{
  legendSpacing = spacing;
}

string gnuInterface::getLegendSpacing()
{
  return legendSpacing;
}

void gnuInterface::setLegendWidthIncrement(string width)
{
  legendWidthIncrement = width;
}

string gnuInterface::getLegendWidthIncrement()
{
  return legendWidthIncrement;
}

void gnuInterface::setLegendTitle(string title)
{
  legendTitle = title;
}

string gnuInterface::getLegendTitle()
{
  return legendTitle;
}

void gnuInterface::setXticsOnFlag(int flag)
{
  xticsOnFlag = flag;
}

int gnuInterface::getXticsOnFlag()
{
  return xticsOnFlag;
}

void gnuInterface::setXticsLocation(string location)
{
  xticsLocation = location;
}

string gnuInterface::getXticsLocation()
{
  return xticsLocation;
}

void gnuInterface::setXticsMirror(string mirror)
{
  xticsMirror = mirror;
}

string gnuInterface::getXticsMirror()
{
  return xticsMirror;
}

void gnuInterface::setXticsRotation(string rotation)
{
  xticsRotation = rotation;
}

string gnuInterface::getXticsRotation()
{
  return xticsRotation;
}

void gnuInterface::setXticsPositionType(string type)
{
  xticsPositionType = type;
}

string gnuInterface::getXticsPositionType()
{
  return xticsPositionType;
}

void gnuInterface::setXticsStartPos(string pos)
{
  xticsStartPos = pos;
}

string gnuInterface::getXticsStartPos()
{
  return xticsStartPos;
}

void gnuInterface::setXticsIncPos(string pos)
{
  xticsIncPos = pos;
}

string gnuInterface::getXticsIncPos()
{
  return xticsIncPos;
}

void gnuInterface::setXticsEndPos(string pos)
{
  xticsEndPos = pos;
}

string gnuInterface::getXticsEndPos()
{
  return xticsEndPos;
}

void gnuInterface::setXticsLabelsPos(string labels)
{
  xticsLabelsPos = labels;
}

string gnuInterface::getXticsLabelsPos()
{
  return xticsLabelsPos;
}

void gnuInterface::setYticsOnFlag(int flag)
{
  yticsOnFlag = flag;
}

int gnuInterface::getYticsOnFlag()
{
  return yticsOnFlag;
}

void gnuInterface::setYticsLocation(string location)
{
  yticsLocation = location;
}

string gnuInterface::getYticsLocation()
{
  return yticsLocation;
}

void gnuInterface::setYticsMirror(string mirror)
{
  yticsMirror = mirror;
}

string gnuInterface::getYticsMirror()
{
  return yticsMirror;
}

void gnuInterface::setYticsRotation(string rotation)
{
  yticsRotation = rotation;
}

string gnuInterface::getYticsRotation()
{
  return yticsRotation;
}

void gnuInterface::setYticsPositionType(string type)
{
  yticsPositionType = type;
}

string gnuInterface::getYticsPositionType()
{
  return yticsPositionType;
}

void gnuInterface::setYticsStartPos(string pos)
{
  yticsStartPos = pos;
}

string gnuInterface::getYticsStartPos()
{
  return yticsStartPos;
}

void gnuInterface::setYticsIncPos(string pos)
{
  yticsIncPos = pos;
}

string gnuInterface::getYticsIncPos()
{
  return yticsIncPos;
}

void gnuInterface::setYticsEndPos(string pos)
{
  yticsEndPos = pos;
}

string gnuInterface::getYticsEndPos()
{
  return yticsEndPos;
}

void gnuInterface::setYticsLabelsPos(string labels)
{
  yticsLabelsPos = labels;
}

string gnuInterface::getYticsLabelsPos()
{
  return yticsLabelsPos;
}

void gnuInterface::setZticsOnFlag(int flag)
{
  zticsOnFlag = flag;
}

int gnuInterface::getZticsOnFlag()
{
  return zticsOnFlag;
}

void gnuInterface::setZticsMirror(string mirror)
{
  zticsMirror = mirror;
}

string gnuInterface::getZticsMirror()
{
  return zticsMirror;
}

void gnuInterface::setZticsRotation(string rotation)
{
  zticsRotation = rotation;
}

string gnuInterface::getZticsRotation()
{
  return zticsRotation;
}

void gnuInterface::setZticsPositionType(string type)
{
  zticsPositionType = type;
}

string gnuInterface::getZticsPositionType()
{
  return zticsPositionType;
}

void gnuInterface::setZticsStartPos(string pos)
{
  zticsStartPos = pos;
}

string gnuInterface::getZticsStartPos()
{
  return zticsStartPos;
}

void gnuInterface::setZticsIncPos(string pos)
{
  zticsIncPos = pos;
}

string gnuInterface::getZticsIncPos()
{
  return zticsIncPos;
}

void gnuInterface::setZticsEndPos(string pos)
{
  zticsEndPos = pos;
}

string gnuInterface::getZticsEndPos()
{
  return zticsEndPos;
}

void gnuInterface::setZticsLabelsPos(string labels)
{
  zticsLabelsPos = labels;
}

string gnuInterface::getZticsLabelsPos()
{
  return zticsLabelsPos;
}

void gnuInterface::setX2ticsOnFlag(int flag)
{
  x2ticsOnFlag = flag;
}

int gnuInterface::getX2ticsOnFlag()
{
  return x2ticsOnFlag;
}

void gnuInterface::setX2ticsLocation(string location)
{
  x2ticsLocation = location;
}

string gnuInterface::getX2ticsLocation()
{
  return x2ticsLocation;
}

void gnuInterface::setX2ticsMirror(string mirror)
{
  x2ticsMirror = mirror;
}

string gnuInterface::getX2ticsMirror()
{
  return x2ticsMirror;
}

void gnuInterface::setX2ticsRotation(string rotation)
{
  x2ticsRotation = rotation;
}

string gnuInterface::getX2ticsRotation()
{
  return x2ticsRotation;
}

void gnuInterface::setX2ticsPositionType(string type)
{
  x2ticsPositionType = type;
}

string gnuInterface::getX2ticsPositionType()
{
  return x2ticsPositionType;
}

void gnuInterface::setX2ticsStartPos(string pos)
{
  x2ticsStartPos = pos;
}

string gnuInterface::getX2ticsStartPos()
{
  return x2ticsStartPos;
}

void gnuInterface::setX2ticsIncPos(string pos)
{
  x2ticsIncPos = pos;
}

string gnuInterface::getX2ticsIncPos()
{
  return x2ticsIncPos;
}

void gnuInterface::setX2ticsEndPos(string pos)
{
  x2ticsEndPos = pos;
}

string gnuInterface::getX2ticsEndPos()
{
  return x2ticsEndPos;
}

void gnuInterface::setX2ticsLabelsPos(string labels)
{
  x2ticsLabelsPos = labels;
}

string gnuInterface::getX2ticsLabelsPos()
{
  return x2ticsLabelsPos;
}

void gnuInterface::setY2ticsOnFlag(int flag)
{
  y2ticsOnFlag = flag;
}

int gnuInterface::getY2ticsOnFlag()
{
  return y2ticsOnFlag;
}

void gnuInterface::setY2ticsLocation(string location)
{
  y2ticsLocation = location;
}

string gnuInterface::getY2ticsLocation()
{
  return y2ticsLocation;
}

void gnuInterface::setY2ticsMirror(string mirror)
{
  y2ticsMirror = mirror;
}

string gnuInterface::getY2ticsMirror()
{
  return y2ticsMirror;
}

void gnuInterface::setY2ticsRotation(string rotation)
{
  y2ticsRotation = rotation;
}

string gnuInterface::getY2ticsRotation()
{
  return y2ticsRotation;
}

void gnuInterface::setY2ticsPositionType(string type)
{
  y2ticsPositionType = type;
}

string gnuInterface::getY2ticsPositionType()
{
  return y2ticsPositionType;
}

void gnuInterface::setY2ticsStartPos(string pos)
{
  y2ticsStartPos = pos;
}

string gnuInterface::getY2ticsStartPos()
{
  return y2ticsStartPos;
}

void gnuInterface::setY2ticsIncPos(string pos)
{
  y2ticsIncPos = pos;
}

string gnuInterface::getY2ticsIncPos()
{
  return y2ticsIncPos;
}

void gnuInterface::setY2ticsEndPos(string pos)
{
  y2ticsEndPos = pos;
}

string gnuInterface::getY2ticsEndPos()
{
  return y2ticsEndPos;
}

void gnuInterface::setY2ticsLabelsPos(string labels)
{
  y2ticsLabelsPos = labels;
}

string gnuInterface::getY2ticsLabelsPos()
{
  return y2ticsLabelsPos;
}

void gnuInterface::insertMultiFileNew(string filename)
{
  multiFile->insertMultiFileNew(filename);
}

void gnuInterface::removeMultiFile(string filename)
{
  multiFile->removeMultiFile(filename);
}

void gnuInterface::setMultiFileDataSetStart(string filename, string start)
{
  multiFile->setMultiFileDataSetStart(filename, start);
}

string gnuInterface::getMultiFileDataSetStart(string filename)
{
  return multiFile->getMultiFileDataSetStart(filename);
}

void gnuInterface::setMultiFileDataSetEnd(string filename,string end)
{
  multiFile->setMultiFileDataSetEnd(filename, end);
}

string gnuInterface::getMultiFileDataSetEnd(string filename)
{
  return multiFile->getMultiFileDataSetEnd(filename);
}

void gnuInterface::setMultiFileDataSetIncrement(string filename,string inc)
{
  multiFile->setMultiFileDataSetIncrement( filename, inc);
}

string gnuInterface::getMultiFileDataSetIncrement(string filename)
{
  return multiFile->getMultiFileDataSetIncrement( filename);
}

void gnuInterface::setMultiFileSampPointInc(string filename,string pinc)
{
  multiFile->setMultiFileSampPointInc( filename, pinc);
}

string gnuInterface::getMultiFileSampPointInc(string filename)
{
  return multiFile->getMultiFileSampPointInc(filename);
}

void gnuInterface::setMultiFileSampLineInc(string filename,string linc)
{
  multiFile->setMultiFileSampLineInc(filename, linc);
}

string gnuInterface::getMultiFileSampLineInc(string filename)
{
  return multiFile->getMultiFileSampLineInc( filename);
}

void gnuInterface::setMultiFileSampStartPoint(string filename,string startp)
{
  multiFile->setMultiFileSampStartPoint( filename, startp);
}

string gnuInterface::getMultiFileSampStartPoint(string filename)
{
  return multiFile->getMultiFileSampStartPoint(filename);
}

void gnuInterface::setMultiFileSampStartLine(string filename,string startl)
{
  multiFile->setMultiFileSampStartLine( filename, startl);
}

string gnuInterface::getMultiFileSampStartLine(string filename)
{
  return multiFile->getMultiFileSampStartLine(filename);
}

void gnuInterface::setMultiFileSampEndPoint(string filename,string endp)
{
  multiFile->setMultiFileSampEndPoint( filename, endp);
}

string gnuInterface::getMultiFileSampEndPoint(string filename)
{
  return multiFile->getMultiFileSampEndPoint(filename);
}

void gnuInterface::setMultiFileSampEndLine(string filename,string endl)
{
  multiFile->setMultiFileSampEndLine( filename, endl);
}

string gnuInterface::getMultiFileSampEndLine(string filename)
{
  return multiFile->getMultiFileSampEndLine(filename);
}

void gnuInterface::setMultiFileSmoothType(string filename,string type)
{
  multiFile->setMultiFileSmoothType( filename, type);
}

string gnuInterface::getMultiFileSmoothType(string filename)
{
  return multiFile->getMultiFileSmoothType(filename);
}

void gnuInterface::insertMultiFileXColumnOption(string filename, string xcol)
{
  multiFile->insertMultiFileXColumnOption(filename, xcol);
}

string gnuInterface::getMultiFileXColumnOption(string filename)
{
  return multiFile->getMultiFileXColumnOption(filename);
}

void gnuInterface::insertMultiFileYColumnOption(string filename, string ycol)
{
  multiFile->insertMultiFileYColumnOption(filename,ycol);
}

string gnuInterface::getMultiFileYColumnOption(string filename)
{
  return multiFile->getMultiFileYColumnOption(filename);
}

void gnuInterface::insertMultiFileZColumnOption(string filename, string zcol)
{
  multiFile->insertMultiFileZColumnOption(filename,zcol);
}

string gnuInterface::getMultiFileZColumnOption(string filename)
{
  return multiFile->getMultiFileZColumnOption(filename);
}

void gnuInterface::setMultiFileLegendTitle(string filename, string title)
{
  multiFile->setLegendTitle(filename,title);
}

string gnuInterface::getMultiFileLegendTitle(string filename)
{
  return multiFile->getLegendTitle(filename);
}

void gnuInterface::insertMultiFileFormatOption(string filename, string format)
{
  multiFile->insertMultiFileFormatOption(filename,format);
}

string gnuInterface::getMultiFileFormatOption(string filename)
{
  return multiFile->getMultiFileFormatOption(filename);
}

void gnuInterface::insertMultiFileRawFormatOption(string filename, string format)
{
  multiFile->insertMultiFileRawFormatOption(filename,format);
}

string gnuInterface::getMultiFileRawFormatOption(string filename)
{
  return multiFile->getMultiFileRawFormatOption(filename);
}

void gnuInterface::setMultiFileStyleOption(string filename, string style)
{
  multiFile->setMultiFileStyleOption(filename,style);
}

string gnuInterface::getMultiFileStyleOption(string filename)
{
  return multiFile->getMultiFileStyleOption(filename);
}

void gnuInterface::setMultiFileFilter(string filename, string filter)
{
  multiFile->setMultiFileFilter(filename, filter);
}

string gnuInterface::getMultiFileFilter(string filename)
{
  return multiFile->getMultiFileFilter(filename);
}

void gnuInterface::setMultiFileFilterQuoteChar(string filename, string quote)
{
  multiFile->setMultiFileFilterQuoteChar(filename, quote);
}

string gnuInterface::getMultiFileFilterQuoteChar(string filename)
{
  return multiFile->getMultiFileFilterQuoteChar(filename);
}

string gnuInterface::getMultiFileFirstFilename()
{
  return multiFile->getMultiFileFirstFilename();
}

string gnuInterface::getMultiFileNextFilename()
{
  return multiFile->getMultiFileNextFilename();
}

void gnuInterface::insertMultiFuncNew(string function)
{
  multiFunc->insertMultiFuncNew(function);
}

void gnuInterface::removeMultiFunc(string function)
{
  multiFunc->removeMultiFunc(function);
}

void gnuInterface::setMultiFuncStyleOption(string function, string style)
{
  multiFunc->setMultiFuncStyleOption(function,style);
}

string gnuInterface::getMultiFuncStyleOption(string function)
{
  return multiFunc->getMultiFuncStyleOption(function);
}

string gnuInterface::getMultiFuncFirstFunction()
{
  return multiFunc->getMultiFuncFirstFunction();
}

string gnuInterface::getMultiFuncNextFunction()
{
  return multiFunc->getMultiFuncNextFunction();
}

string gnuInterface::getMultiFuncFirstPlotCmd()
{
  return multiFunc->getMultiFuncFirstPlotCmd();
}

string gnuInterface::getMultiFuncNextPlotCmd()
{
  return multiFunc->getMultiFuncNextPlotCmd();
}

void gnuInterface::setFileLegendTitle(string title)
{
  plotFileOb->setLegendTitle(title);
}

string gnuInterface::getFileLegendTitle()
{
  return plotFileOb->getLegendTitle();
}

void gnuInterface::setFuncLegendTitle(string title)
{
  plotFunctionOb->setLegendTitle(title);
}

void gnuInterface::setMultiFuncLegendTitle(string function, string title)
{
  multiFunc->setLegendTitle(function, title);
}

string gnuInterface::getFuncLegendTitle()
{
  return plotFunctionOb->getLegendTitle();
}

string gnuInterface::getMultiFuncLegendTitle(string function)
{
  return multiFunc->getLegendTitle(function);
}

void gnuInterface::setLogScaleBase(int xAxis)
{
  logScaleXAxisFlag = xAxis;  
}

int gnuInterface::getLogScaleBase()
{
  return logScaleBase;
}

void gnuInterface::setLogScaleXAxis(int xAxis)
{
  logScaleXAxisFlag = xAxis;
}

int gnuInterface::getLogScaleXAxis()
{
  return logScaleXAxisFlag;
}

void gnuInterface::setLogScaleYAxis(int yAxis)
{
  logScaleYAxisFlag = yAxis;
}

int gnuInterface::getLogScaleYAxis()
{
  return logScaleYAxisFlag;
}

void gnuInterface::setLogScaleZAxis(int zAxis)
{
  logScaleZAxisFlag = zAxis;
}

int gnuInterface::getLogScaleZAxis()
{
  return logScaleZAxisFlag;
}

void gnuInterface::setLogScaleX2Axis(int x2Axis)
{
  logScaleX2AxisFlag = x2Axis;
}

int gnuInterface::getLogScaleX2Axis()
{
  return logScaleX2AxisFlag;
}

void gnuInterface::setLogScaleY2Axis(int y2Axis)
{
  logScaleY2AxisFlag = y2Axis;
}

int gnuInterface::getLogScaleY2Axis()
{
  return logScaleY2AxisFlag;
}

void gnuInterface::setBarSizeOption(string size)
{
  barSize = size;
}

string gnuInterface::getBarSizeOption()
{
  return barSize;
}

void gnuInterface::setCurveFitFunctionName(string name)
{
  curveFitOb->setFunctionName(name);
}

string gnuInterface::getCurveFitFunctionName()
{
  return curveFitOb->getFunctionName();
}

void gnuInterface::setCurveFitFunctionValue(string function)
{
  curveFitOb->setFunctionValue(function);
}

string gnuInterface::getCurveFitFunctionValue()
{
  return curveFitOb->getFunctionValue();
}

void gnuInterface::setCurveFitDataFile(string file)
{
  curveFitOb->setDataFile(file);
}

string gnuInterface::getCurveFitDataFile()
{
  return curveFitOb->getDataFile();
}

void gnuInterface::setCurveFitVarXRangeName(string range)
{
  curveFitOb->setVarXRangeName(range);
}

string gnuInterface::getCurveFitVarXRangeName()
{
  return curveFitOb->getVarXRangeName();
}

void gnuInterface::setCurveFitVarXRangeMin(string min)
{
  curveFitOb->setVarXRangeMin(min);
}

string gnuInterface::getCurveFitVarXRangeMin()
{
  return curveFitOb->getVarXRangeMin();
}

void gnuInterface::setCurveFitVarXRangeMax(string max)
{
  curveFitOb->setVarXRangeMax(max);
}

string gnuInterface::getCurveFitVarXRangeMax()
{
  return curveFitOb->getVarXRangeMax();
}

void gnuInterface::setCurveFitVarYRangeName(string range)
{
  curveFitOb->setVarYRangeName(range);
}

string gnuInterface::getCurveFitVarYRangeName()
{
  return curveFitOb->getVarYRangeName();
}

void gnuInterface::setCurveFitVarYRangeMin(string min)
{
  curveFitOb->setVarYRangeMin(min);
}

string gnuInterface::getCurveFitVarYRangeMin()
{
  return curveFitOb->getVarYRangeMin();
}

void gnuInterface::setCurveFitVarYRangeMax(string max)
{
  curveFitOb->setVarYRangeMax(max);
}

string gnuInterface::getCurveFitVarYRangeMax()
{
  return curveFitOb->getVarYRangeMax();
}

void gnuInterface::setCurveFitParamFile(string file)
{
  curveFitOb->setParamFile(file);
}

string gnuInterface::getCurveFitParamFile()
{
  return curveFitOb->getParamFile();
}

void gnuInterface::setCurveFitParamFileFlag(int flag)
{
  curveFitOb->setParamFileFlag(flag);
}

int gnuInterface::getCurveFitParamFileFlag()
{
  return curveFitOb->getParamFileFlag();
}

void gnuInterface::setCurveFitParamCSLFlag(int flag)
{
  curveFitOb->setParamCSLFlag(flag);
}

int gnuInterface::getCurveFitParamCSLFlag()
{
  return curveFitOb->getParamCSLFlag();
}

void gnuInterface::setCurveFitParamCSL(string list)
{
  curveFitOb->setParamCSL(list);
}

string gnuInterface::getCurveFitParamCSL()
{
  return curveFitOb->getParamCSL();
}

void gnuInterface::setCurveFitFitLimit(string limit)
{
  curveFitOb->setFitLimit(limit);
}

string gnuInterface::getCurveFitFitLimit()
{
  return curveFitOb->getFitLimit();
}

void gnuInterface::setCurveFitFitMaxIter(string iter)
{
  curveFitOb->setFitMaxIter(iter);
}

string gnuInterface::getCurveFitFitMaxIter()
{
  return curveFitOb->getFitMaxIter();
}

void gnuInterface::setCurveFitDataSetStart(string start)
{
  curveFitOb->setDataSetStart(start);
}

string gnuInterface::getCurveFitDataSetStart()
{
  return curveFitOb->getDataSetStart();
}

void gnuInterface::setCurveFitDataSetEnd(string end)
{
  curveFitOb->setDataSetEnd(end);
}

string gnuInterface::getCurveFitDataSetEnd()
{
  return curveFitOb->getDataSetEnd();
}

void gnuInterface::setCurveFitDataSetInc(string inc)
{
  curveFitOb->setDataSetInc(inc);
}

string gnuInterface::getCurveFitDataSetInc()
{
  return curveFitOb->getDataSetInc();
}

void gnuInterface::setCurveFitPointInc(string inc)
{
  curveFitOb->setPointInc(inc);
}

string gnuInterface::getCurveFitPointInc()
{
  return curveFitOb->getPointInc();
}

void gnuInterface::setCurveFitLineInc(string inc)
{
  curveFitOb->setLineInc(inc);
}

string gnuInterface::getCurveFitLineInc()
{
  return curveFitOb->getLineInc();
}

void gnuInterface::setCurveFitStartPoint(string start)
{
  curveFitOb->setStartPoint(start);
}

string gnuInterface::getCurveFitStartPoint()
{
  return curveFitOb->getStartPoint();
}

void gnuInterface::setCurveFitStartLine(string start)
{
  curveFitOb->setStartLine(start);
}

string gnuInterface::getCurveFitStartLine()
{
  return curveFitOb->getStartLine();
}

void gnuInterface::setCurveFitEndPoint(string end)
{
  curveFitOb->setEndPoint(end);
}

string gnuInterface::getCurveFitEndPoint()
{
  return curveFitOb->getEndPoint();
}

void gnuInterface::setCurveFitEndLine(string end)
{
  curveFitOb->setEndLine(end);
}

string gnuInterface::getCurveFitEndLine()
{
  return curveFitOb->getEndLine();
}

void gnuInterface::setCurveFitXColumn(string col)
{
  curveFitOb->setXColumn(col);
}

string gnuInterface::getCurveFitXColumn()
{
  return curveFitOb->getXColumn();
}

void gnuInterface::setCurveFitYColumn(string col)
{
  curveFitOb->setYColumn(col);
}

string gnuInterface::getCurveFitYColumn()
{
  return curveFitOb->getYColumn();
}

void gnuInterface::setCurveFitZColumn(string col)
{
  curveFitOb->setZColumn(col);
}

string gnuInterface::getCurveFitZColumn()
{
  return curveFitOb->getZColumn();
}

void gnuInterface::setCurveFitFormat(string informat)
{
  curveFitOb->setFormat(informat);
}

string gnuInterface::getCurveFitFormat()
{
  return curveFitOb->getFormat();
}

void gnuInterface::setCurveFitRawFormat(string format)
{
  curveFitOb->setRawFormat(format);
}

string gnuInterface::getCurveFitRawFormat()
{
  return curveFitOb->getRawFormat();
}

void gnuInterface::doCurveFit()
{
  string fitcmd;
  
  fitcmd = curveFitOb->getFitCmd();
  
  cout << fitcmd << endl;

  fprintf(gnuCommand,fitcmd.c_str());
  fprintf(gnuCommand,"\n");
  fflush(gnuCommand);
}

void gnuInterface::setBoxWidth(string width)
{
  boxWidth = width;
}

string gnuInterface::getBoxWidth()
{
  return boxWidth;
}

void gnuInterface::savePlotData(string filename)
{
  // open output file
  ofstream outfile(filename.c_str());
  
  // save all options to the file
  
  // save header to identify this file
  outfile << "XGFE-FILE" << endl;

  // single file flag
  outfile << "singleFileFlag " << plotFileFlag << ";" << endl;
  
  // single function flag
  outfile << "singleFuncFlag " << plotFuncFlag << ";" << endl;
  
  // multiple file flag
  outfile << "multiFileFlag " << plotMultipleFileFlag << ";" << endl;
  
  // multiple function flag
  outfile << "multiFuncFlag " << plotMultipleFuncFlag << ";" << endl;
  
  // single plot file filename
  outfile << "singleFilename " << getPlotFilename() << ";" << endl;
  
  // single plot function
  outfile <<  "singleFunction " << getPlotFunction() << ";" << endl;

  // single file plot type
  outfile << "singleFilePlotType " << getFilePlotType() << ";" << endl;
  
  // single file style type
  outfile << "singleFileStyleType " << getFileStyleType() << ";" << endl;

  // single file modifiers
  outfile << "singleFileDataSetStart " << getFileDataSetStart() << ";" << endl;
  outfile << "singleFileDataSetEnd " << getFileDataSetEnd() << ";" << endl;
  outfile << "singleFileDataSetIncrement " << getFileDataSetIncrement() 
          << ";" << endl;
  outfile << "singleFileSampPointInc " << getFileSampPointInc() << ";" << endl;
  outfile << "singleFileSampLineInc " << getFileSampLineInc() << ";" << endl;
  outfile << "singleFileSampStartPoint " << getFileSampStartPoint() 
          << ";" << endl;
  outfile << "singleFileSampStartLine " << getFileSampStartLine() << ";" 
          << endl; 
  outfile << "singleFileSampEndPoint " << getFileSampEndPoint() << ";" << endl;
  outfile << "singleFileSampEndLine " << getFileSampEndLine() << ";" << endl;
  outfile << "singleFileSmoothType " << getFileSmoothType() << ";" << endl;
  outfile << "singleFileXColumn " << getFileXColumn() << ";" << endl;
  outfile << "singleFileYColumn " << getFileYColumn() << ";" << endl;
  outfile << "singleFileZColumn " << getFileZColumn() << ";" << endl;
  outfile << "singleFileFormatString " << getFileFormatString()  << ";" << endl;
  outfile << "singleRawFileFormatString " << getRawFileFormatString()  << ";" << endl;
  outfile << "singleFileFilter " << getFileFilter()  << ";" << endl;
  outfile << "singleFileFilterQuoteChar " << getFileFilterQuoteChar()  << ";" << endl;
  outfile << "singleFileLegendTitle " << getFileLegendTitle()  << ";" << endl;

  // get overall options
  outfile << "XVariableName " << XVariableName  << ";" << endl;
  outfile << "XRangeStart " << XRangeStart  << ";" << endl;
  outfile << "XRangeEnd " << XRangeEnd  << ";" << endl;
  outfile << "YVariableName " << YVariableName  << ";" << endl;
  outfile << "YRangeStart " << YRangeStart  << ";" << endl;
  outfile << "YRangeEnd " << YRangeEnd  << ";" << endl;
  outfile << "ZRangeStart " << ZRangeStart  << ";" << endl;
  outfile << "ZRangeEnd " << ZRangeEnd  << ";" << endl;
  outfile << "XLabel " << XLabel  << ";" << endl;
  outfile << "XOffset_X " << XOffset_X  << ";" << endl;
  outfile << "XOffset_Y " << XOffset_Y  << ";" << endl;
  outfile << "YLabel " << YLabel  << ";" << endl;
  outfile << "YOffset_X " << YOffset_X  << ";" << endl;
  outfile << "YOffset_Y " << YOffset_Y  << ";" << endl;
  outfile << "ZLabel " << ZLabel  << ";" << endl;
  outfile << "ZOffset_X " << ZOffset_X  << ";" << endl;
  outfile << "ZOffset_Y " << ZOffset_Y  << ";" << endl;
  outfile << "title " << title  << ";" << endl;
  outfile << "titleOffset_X " << titleOffset_X  << ";" << endl;
  outfile << "titleOffset_Y " << titleOffset_Y  << ";" << endl;
  outfile << "terminal " << terminal  << ";" << endl;
  outfile << "termLatexEmtexFont " << termLatexEmtexFont  << ";" << endl;
  outfile << "termLatexEmtexFontSize " << termLatexEmtexFontSize  << ";" << endl;
  outfile << "termPBMfontSize " << termPBMfontSize  << ";" << endl;
  outfile << "termPBMcolormode " << termPBMcolormode  << ";" << endl;
  outfile << "termPBMhSize " << termPBMhSize  << ";" << endl;
  outfile << "termPBMvSize " << termPBMvSize  << ";" << endl;
  outfile << "termPSmode " << termPSmode  << ";" << endl;
  outfile << "termPScolor " << termPScolor  << ";" << endl;
  outfile << "termPSdashed " << termPSdashed  << ";" << endl;
  outfile << "termPSfont " << termPSfont  << ";" << endl;
  outfile << "termPSfontSize " << termPSfontSize  << ";" << endl;
  outfile << "termPSenhanced " << termPSenhanced  << ";" << endl;
  outfile << "termPShSize " << termPShSize  << ";" << endl;
  outfile << "termPSvSize " << termPSvSize  << ";" << endl;
  outfile << "output " << output  << ";" << endl;
  outfile << "hSize " << hSize  << ";" << endl;
  outfile << "vSize " << vSize  << ";" << endl;
  outfile << "legendFlag " << getLegendFlag()  << ";" << endl;
  outfile << "legendPositionLeftFlag " << legendPositionLeft  << ";" << endl;
  outfile << "legendPositionRightFlag " << legendPositionRight  << ";" << endl;
  outfile << "legendPositionTopFlag " << legendPositionTop  << ";" << endl;
  outfile << "legendPositionBottomFlag " << legendPositionBottom  << ";" << endl;
  outfile << "legendPositionOutsideFlag " << legendPositionOutside  << ";" << endl;
  outfile << "legendPositionBelowFlag " << legendPositionBelow  << ";" << endl;
  outfile << "legendPositionXVal " << legendPositionXVal  << ";" << endl;
  outfile << "legendPositionYVal " << legendPositionYVal  << ";" << endl;
  outfile << "legendPositionZVal " << legendPositionZVal  << ";" << endl;
  outfile << "legendTextJustify " << legendTextJustify  << ";" << endl;
  outfile << "legendReverse " << legendReverse  << ";" << endl;
  outfile << "legendBox " << legendBox  << ";" << endl;
  outfile << "legendLinetype " << legendLinetype  << ";" << endl;
  outfile << "legendSampleLength " << legendSampleLength  << ";" << endl;
  outfile << "legendSpacing " << legendSpacing  << ";" << endl;
  outfile << "legendWidthIncrement " << legendWidthIncrement  << ";" << endl;
  outfile << "legendTitle " << legendTitle  << ";" << endl;
  outfile << "logScaleBase " << logScaleBase  << ";" << endl;
  outfile << "logScaleXAxisFlag " << logScaleXAxisFlag  << ";" << endl;
  outfile << "logScaleYAxisFlag " << logScaleYAxisFlag  << ";" << endl;
  outfile << "logScaleZAxisFlag " << logScaleZAxisFlag  << ";" << endl;
  outfile << "logScaleX2AxisFlag " << logScaleX2AxisFlag  << ";" << endl;
  outfile << "logScaleY2AxisFlag " << logScaleY2AxisFlag  << ";" << endl;
  outfile << "barSize " << barSize  << ";" << endl;
  outfile << "boxWidth " << boxWidth  << ";" << endl;
  outfile << "xticsOnFlag " << xticsOnFlag  << ";" << endl;
  outfile << "xticsLocation " << xticsLocation  << ";" << endl;
  outfile << "xticsMirror " << xticsMirror  << ";" << endl;
  outfile << "xticsRotation " << xticsRotation  << ";" << endl;
  outfile << "xticsPositionType " << xticsPositionType  << ";" << endl;
  outfile << "xticsStartPos " << xticsStartPos  << ";" << endl;
  outfile << "xticsIncPos " << xticsIncPos  << ";" << endl;
  outfile << "xticsEndPos " << xticsEndPos  << ";" << endl;
  outfile << "xticsLabelsPos " << xticsLabelsPos  << ";" << endl;
  outfile << "yticsOnFlag " << yticsOnFlag  << ";" << endl;
  outfile << "yticsLocation " << yticsLocation  << ";" << endl;
  outfile << "yticsMirror " << yticsMirror  << ";" << endl;
  outfile << "yticsRotation " << yticsRotation  << ";" << endl;
  outfile << "yticsPositionType " << yticsPositionType  << ";" << endl;
  outfile << "yticsStartPos " << yticsStartPos  << ";" << endl;
  outfile << "yticsIncPos " << yticsIncPos  << ";" << endl;
  outfile << "yticsEndPos " << yticsEndPos  << ";" << endl;
  outfile << "yticsLabelsPos " << yticsLabelsPos  << ";" << endl;
  outfile << "zticsOnFlag " << zticsOnFlag  << ";" << endl;
  outfile << "zticsMirror " << zticsMirror  << ";" << endl;
  outfile << "zticsRotation " << zticsRotation  << ";" << endl;
  outfile << "zticsPositionType " << zticsPositionType  << ";" << endl;
  outfile << "zticsStartPos " << zticsStartPos  << ";" << endl;
  outfile << "zticsIncPos " << zticsIncPos  << ";" << endl;
  outfile << "zticsEndPos " << zticsEndPos  << ";" << endl;
  outfile << "zticsLabelsPos " << zticsLabelsPos  << ";" << endl;
  outfile << "x2ticsOnFlag " << x2ticsOnFlag  << ";" << endl;
  outfile << "x2ticsLocation " << x2ticsLocation  << ";" << endl;
  outfile << "x2ticsMirror " << x2ticsMirror  << ";" << endl;
  outfile << "x2ticsRotation " << x2ticsRotation  << ";" << endl;
  outfile << "x2ticsPositionType " << x2ticsPositionType  << ";" << endl;
  outfile << "x2ticsStartPos " << x2ticsStartPos  << ";" << endl;
  outfile << "x2ticsIncPos " << x2ticsIncPos  << ";" << endl;
  outfile << "x2ticsEndPos " << x2ticsEndPos  << ";" << endl;
  outfile << "x2ticsLabelsPos " << x2ticsLabelsPos  << ";" << endl;
  outfile << "y2ticsOnFlag " << y2ticsOnFlag  << ";" << endl;
  outfile << "y2ticsLocation " << y2ticsLocation  << ";" << endl;
  outfile << "y2ticsMirror " << y2ticsMirror  << ";" << endl;
  outfile << "y2ticsRotation " << y2ticsRotation  << ";" << endl;
  outfile << "y2ticsPositionType " << y2ticsPositionType  << ";" << endl;
  outfile << "y2ticsStartPos " << y2ticsStartPos  << ";" << endl;
  outfile << "y2ticsIncPos " << y2ticsIncPos  << ";" << endl;
  outfile << "y2ticsEndPos " << y2ticsEndPos  << ";" << endl;
  outfile << "y2ticsLabelsPos " << y2ticsLabelsPos  << ";" << endl;

  // write out multiple file data

  // get the first file
  string tempfile = getMultiFileFirstFilename();
  
  // get the remaining files
  while (tempfile != "END")
  {
    outfile << "MultiFileNew " << tempfile << ";" << endl;

    outfile << "MultiFileDataSetStart " << tempfile << " "
            << getMultiFileDataSetStart(tempfile) << ";" << endl;

    outfile << "MultiFileDataSetEnd " << tempfile << " "
            << getMultiFileDataSetEnd(tempfile) << ";" << endl;

    outfile << "MultiFileDataSetIncrement " << tempfile << " "
            << getMultiFileDataSetIncrement(tempfile)  << ";" << endl;
    
    outfile << "MultiFileSampPointInc " << tempfile << " "
            << getMultiFileSampPointInc(tempfile)  << ";" << endl;

    outfile << "MultiFileSampLineInc " << tempfile << " "
            << getMultiFileSampLineInc(tempfile)  << ";" << endl;

    outfile << "MultiFileSampStartPoint " << tempfile << " "
            <<  getMultiFileSampStartPoint(tempfile) << ";" << endl;

    outfile << "MultiFileSampStartLine " << tempfile << " "
            <<  getMultiFileSampStartLine(tempfile) << ";" << endl;

    outfile << "MultiFileSampEndPoint " << tempfile << " "
            <<  getMultiFileSampEndPoint(tempfile) << ";" << endl;

    outfile << "MultiFileSampEndLine " << tempfile << " "
            << getMultiFileSampEndLine(tempfile)  << ";" << endl;

    outfile << "MultiFileSmoothType " << tempfile << " "
            <<  getMultiFileSmoothType(tempfile) << ";" << endl;

    outfile << "MultiFileXColumnOption " << tempfile << " "
            <<  getMultiFileXColumnOption(tempfile) << ";" << endl;

    outfile << "MultiFileYColumnOption " << tempfile << " "
            <<  getMultiFileYColumnOption(tempfile) << ";" << endl;

    outfile << "MultiFileZColumnOption " << tempfile << " "
            <<  getMultiFileZColumnOption(tempfile) << ";" << endl;

    outfile << "MultiFileFormatOption " << tempfile << " "
            <<  getMultiFileFormatOption(tempfile) << ";" << endl;

    outfile << "MultiFileRawFormatOption " << tempfile << " "
            <<  getMultiFileRawFormatOption(tempfile) << ";" << endl;

    outfile << "MultiFileStyleOption " << tempfile << " "
            <<  getMultiFileStyleOption(tempfile) << ";" << endl;

    outfile << "MultiFileLegendTitle " << tempfile << " "
            <<  getMultiFileLegendTitle(tempfile) << ";" << endl;

    outfile << "MultiFileFilter " << tempfile << " "
            <<  getMultiFileFilter(tempfile) << ";" << endl;

    outfile << "MultiFileFilterQuoteChar " << tempfile << " "
            <<  getMultiFileFilterQuoteChar(tempfile) << ";" << endl;

    tempfile = getMultiFileNextFilename();
  }
  
  // write single function options
  outfile << "singleFuncPlotType " << getFuncPlotType()  << ";" << endl;
  outfile << "singleFuncStyleType " << getFuncStyleType()  << ";" << endl;
  outfile << "singleFuncLegendTitle " << getFuncLegendTitle()  << ";" << endl;

  // write multiple function options

  string tempfunc = getMultiFuncFirstFunction();
  
  while (tempfunc != "END")
  {
    outfile << "MultiFuncNew " << tempfunc << ";" << endl;

    outfile << "MultiFuncStyleOption " << tempfunc << " "
            << getMultiFuncStyleOption(tempfunc) << ";" << endl;

    outfile << "MultiFuncLegendTitle " << tempfunc << " "
            << getMultiFuncLegendTitle(tempfunc) << ";" << endl;

    tempfunc = getMultiFuncNextFunction();
  }

  outfile.close();
}

void gnuInterface::loadPlotData(string filename)
{
  string token;
  string tempstring;
  string tempfile;
  string tempfunc;
  int tempint;
  int buffsize = 100;
  char buffer[buffsize];

  ifstream infile(filename.c_str());

  // check header
  infile >> token;
  
  if (token != "XGFE-FILE")
    cout << endl << "Error! This is not an Xgfe saved file!" << endl;
  else
  {
    // read each line of the file and take appropriate action depending on 
    // the token (keyword)
    while (infile >> token)
    {
      if (token == "singleFileFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setPlotFileFlag(tempint);
      }
      else if (token == "singleFuncFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);
        
        if (temp >> tempint)
          setPlotFuncFlag(tempint);
      }
      else if (token == "multiFileFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setPlotMultipleFileFlag(tempint);
      }
      else if (token == "multiFuncFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setPlotMultipleFuncFlag(tempint);
      }
      else if (token == "singleFilename")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setPlotFilename(tempstring);
      }
      else if (token == "singleFunction")
      {
        tempstring = "";
        tempstring = getValue(infile);
                
        setPlotFunction(tempstring);
      }
      else if (token == "singleFilePlotType")
      {
        tempstring = "";
        tempstring = getValue(infile);

        setFilePlotType(tempstring);
      }
      else if (token == "singleFileStyleType")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileStyleType(tempstring);
      }
      else if (token == "singleFuncPlotType")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFuncPlotType(tempstring);
      }
      else if (token == "singleFuncStyleType")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFuncStyleType(tempstring);
      }
      else if (token == "singleFuncLegendTitle")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFuncLegendTitle(tempstring);
      }
      else if (token == "singleFileDataSetStart")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileDataSetStart(tempstring);
      }
      else if (token == "singleFileDataSetEnd")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileDataSetEnd(tempstring);
      }
      else if (token == "singleFileDataSetIncrement")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileDataSetIncrement(tempstring);
      }
      else if (token == "singleFileSampPointInc")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileSampPointInc(tempstring);
      }
      else if (token == "singleFileSampLineInc")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileSampLineInc(tempstring);
      }
      else if (token == "singleFileSampStartPoint")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileSampStartPoint(tempstring);
      }
      else if (token == "singleFileSampStartLine")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileSampStartLine(tempstring);
      }
      else if (token == "singleFileSampEndPoint")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileSampEndPoint(tempstring);
      }
      else if (token == "singleFileSampEndLine")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileSampEndLine(tempstring);
      }
      else if (token == "singleFileSmoothType")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileSmoothType(tempstring);
      }
      else if (token == "singleFileXColumn")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileXColumn(tempstring);
      }
      else if (token == "singleFileYColumn")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileYColumn(tempstring);
      }
      else if (token == "singleFileZColumn")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileZColumn(tempstring);
      }
      else if (token == "singleFileFormatString")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileFormatString(tempstring);
      }
      else if (token == "singleRawFileFormatString")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setRawFileFormatString(tempstring);
      }
      else if (token == "singleFileFilter")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileFilter(tempstring);
      }
      else if (token == "singleFileFilterQuoteChar")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileFilterQuoteChar(tempstring);
      }
      else if (token == "singleFileLegendTitle")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setFileLegendTitle(tempstring);
      }
      else if (token == "XVariableName")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXVariableName(tempstring);
      }
      else if (token == "XRangeStart")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXRangeStart(tempstring);
      }
      else if (token == "XRangeEnd")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXRangeEnd(tempstring);
      }
      else if (token == "YVariableName")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYVariableName(tempstring);
      }
      else if (token == "YRangeStart")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYRangeStart(tempstring);
      }
      else if (token == "YRangeEnd")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYRangeEnd(tempstring);
      }
      else if (token == "ZRangeStart")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setZRangeStart(tempstring);
      }
      else if (token == "ZRangeEnd")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setZRangeEnd(tempstring);
      }
      else if (token == "XLabel")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXlabel(tempstring);
      }
      else if (token == "XOffset_X")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXOffset_X(tempstring);
      }
      else if (token == "XOffset_Y")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXOffset_Y(tempstring);
      }
      else if (token == "YLabel")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYlabel(tempstring);
      }
      else if (token == "YOffset_X")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYOffset_X(tempstring);
      }
      else if (token == "YOffset_Y")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYOffset_Y(tempstring);
      }
      else if (token == "ZLabel")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setZlabel(tempstring);
      }
      else if (token == "ZOffset_X")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setZOffset_X(tempstring);
      }
      else if (token == "ZOffset_Y")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setZOffset_Y(tempstring);
      }
      else if (token == "title")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTitle(tempstring);
      }
      else if (token == "titleOffset_X")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTitleOffset_X(tempstring);
      }
      else if (token == "titleOffset_Y")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTitleOffset_Y(tempstring);
      }
      else if (token == "terminal")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTerminal(tempstring);
      }
      else if (token == "termLatexEmtexFont")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermLateXEmtexFont(tempstring);
      }
      else if (token == "termLatexEmtexFontSize")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermLateXEmtexFontSize(tempstring);
      }
      else if (token == "termPBMfontSize")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermPBMFontSize(tempstring);
      }
      else if (token == "termPBMcolormode")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermPBMColormode(tempstring);
      }
      else if (token == "termPBMhSize")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermPBMhSize(tempstring);
      }
      else if (token == "termPBMvSize")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermPBMvSize(tempstring);
      }
      else if (token == "termPSmode")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermPSmode(tempstring);
      }
      else if (token == "termPScolor")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermPScolor(tempstring);
      }
      else if (token == "termPSdashed")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermPSdashed(tempstring);
      }
      else if (token == "termPSfont")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermPSfont(tempstring);
      }
      else if (token == "termPSfontSize")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermPSfontSize(tempstring);
      }
      else if (token == "termPSenhanced")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermPSenhanced(tempstring);
      }
      else if (token == "termPShSize")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermPShSize(tempstring);
      }
      else if (token == "termPSvSize")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setTermPSvSize(tempstring);
      }
      else if (token == "output")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setOutput(tempstring);
      }
      else if (token == "hSize")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setHorizSize(tempstring);
      }
      else if (token == "vSize")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setVertSize(tempstring);
      }
      else if (token == "legendFlag")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setLegendFlag(tempstring);
      }
      else if (token == "legendPositionLeftFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setLegendPositionLeft(tempint);
      }
      else if (token == "legendPositionRightFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setLegendPositionRight(tempint);
      }
      else if (token == "legendPositionTopFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setLegendPositionTop(tempint);
      }
      else if (token == "legendPositionBottomFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setLegendPositionBottom(tempint);
      }
      else if (token == "legendPositionOutsideFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setLegendPositionOutside(tempint);
      }
      else if (token == "legendPositionBelowFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setLegendPositionBelow(tempint);
      }
      else if (token == "legendPositionXVal")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setLegendPositionXVal(tempstring);
      }
      else if (token == "legendPositionYVal")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setLegendPositionYVal(tempstring);
      }
      else if (token == "legendPositionZVal")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setLegendPositionZVal(tempstring);
      }
      else if (token == "legendTextJustify")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setLegendTextJustify(tempstring);
      }
      else if (token == "legendReverse")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setLegendReverse(tempstring);
      }
      else if (token == "legendBox")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setLegendBox(tempstring);
      }
      else if (token == "legendLinetype")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setLegendLinetype(tempstring);
      }
      else if (token == "legendSampleLength")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setLegendSampleLength(tempstring);
      }
      else if (token == "legendSpacing")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setLegendSpacing(tempstring);
      }
      else if (token == "legendWidthIncrement")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setLegendWidthIncrement(tempstring);
      }
      else if (token == "legendTitle")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setLegendTitle(tempstring);
      }
      else if (token == "logScaleBase")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setLogScaleBase(tempint);
      }
      else if (token == "logScaleXAxisFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setLogScaleYAxis(tempint);
      }
      else if (token == "logScaleYAxisFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setLogScaleYAxis(tempint);
      }
      else if (token == "logScaleZAxisFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setLogScaleZAxis(tempint);
      }
      else if (token == "logScaleX2AxisFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setLogScaleX2Axis(tempint);
      }
      else if (token == "logScaleY2AxisFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);

        if (temp >> tempint)
          setLogScaleY2Axis(tempint);
      }
      else if (token == "barSize")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setBarSizeOption(tempstring);
      }
      else if (token == "boxWidth")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setBoxWidth(tempstring);
      }
      else if (token == "xticsOnFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);
        
        if (temp >> tempint)
          setXticsOnFlag(tempint);
      }
      else if (token == "xticsLocation")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXticsLocation(tempstring);
      }
      else if (token == "xticsMirror")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXticsMirror(tempstring);
      }
      else if (token == "xticsRotation")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXticsRotation(tempstring);
      }
      else if (token == "xticsPositionType")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXticsPositionType(tempstring);
      }
      else if (token == "xticsStartPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXticsStartPos(tempstring);
      }
      else if (token == "xticsIncPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXticsIncPos(tempstring);
      }
      else if (token == "xticsEndPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXticsEndPos(tempstring);
      }
      else if (token == "xticsLabelsPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setXticsLabelsPos(tempstring);
      }
      else if (token == "yticsOnFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);
        
        if (temp >> tempint)
          setYticsOnFlag(tempint);
      }
      else if (token == "yticsLocation")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYticsLocation(tempstring);
      }
      else if (token == "yticsMirror")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYticsMirror(tempstring);
      }
      else if (token == "yticsRotation")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYticsRotation(tempstring);
      }
      else if (token == "yticsPositionType")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYticsPositionType(tempstring);
      }
      else if (token == "yticsStartPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYticsStartPos(tempstring);
      }
      else if (token == "yticsIncPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYticsIncPos(tempstring);
      }
      else if (token == "yticsEndPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYticsEndPos(tempstring);
      }
      else if (token == "yticsLabelsPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setYticsLabelsPos(tempstring);
      }
      else if (token == "zticsOnFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);
        
        if (temp >> tempint)
          setZticsOnFlag(tempint);
      }
      else if (token == "zticsMirror")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setZticsMirror(tempstring);
      }
      else if (token == "zticsRotation")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setZticsRotation(tempstring);
      }
      else if (token == "zticsPositionType")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setZticsPositionType(tempstring);
      }
      else if (token == "zticsStartPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setZticsStartPos(tempstring);
      }
      else if (token == "zticsIncPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setZticsIncPos(tempstring);
      }
      else if (token == "zticsEndPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setZticsEndPos(tempstring);
      }
      else if (token == "zticsLabelsPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setZticsLabelsPos(tempstring);
      }
      else if (token == "x2ticsOnFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);
        
        if (temp >> tempint)
          setX2ticsOnFlag(tempint);
      }
      else if (token == "x2ticsLocation")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setX2ticsLocation(tempstring);
      }
      else if (token == "x2ticsMirror")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setX2ticsMirror(tempstring);
      }
      else if (token == "x2ticsRotation")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setX2ticsRotation(tempstring);
      }
      else if (token == "x2ticsPositionType")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setX2ticsPositionType(tempstring);
      }
      else if (token == "x2ticsStartPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setX2ticsStartPos(tempstring);
      }
      else if (token == "x2ticsIncPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setX2ticsIncPos(tempstring);
      }
      else if (token == "x2ticsEndPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setX2ticsEndPos(tempstring);
      }
      else if (token == "x2ticsLabelsPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setX2ticsLabelsPos(tempstring);
      }
      else if (token == "y2ticsOnFlag")
      {
        tempint = 0;
        
        infile.getline(buffer,buffsize,';');
        istrstream temp(buffer);
        
        if (temp >> tempint)
          setY2ticsOnFlag(tempint);        
      }
      else if (token == "y2ticsLocation")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setY2ticsLocation(tempstring);
      }
      else if (token == "y2ticsMirror")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setY2ticsMirror(tempstring);
      }
      else if (token == "y2ticsRotation")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setY2ticsRotation(tempstring);
      }
      else if (token == "y2ticsPositionType")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setY2ticsPositionType(tempstring);
      }
      else if (token == "y2ticsStartPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setY2ticsStartPos(tempstring);
      }
      else if (token == "y2ticsIncPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setY2ticsIncPos(tempstring);
      }
      else if (token == "y2ticsEndPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setY2ticsEndPos(tempstring);
      }
      else if (token == "y2ticsLabelsPos")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        setY2ticsLabelsPos(tempstring);
      }
      else if (token == "MultiFileNew")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        insertMultiFileNew(tempstring);
      }
      else if (token == "MultiFileDataSetStart")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileDataSetStart(tempfile, tempstring);
      }
      else if (token == "MultiFileDataSetEnd")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileDataSetEnd(tempfile, tempstring);
      }
      else if (token == "MultiFileDataSetIncrement")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileDataSetIncrement(tempfile, tempstring);
      }
      else if (token == "MultiFileSampPointInc")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileSampPointInc(tempfile, tempstring);
      }
      else if (token == "MultiFileSampLineInc")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileSampLineInc(tempfile, tempstring);
      }
      else if (token == "MultiFileSampStartPoint")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileSampStartPoint(tempfile, tempstring);
      }
      else if (token == "MultiFileSampStartLine")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileSampStartLine(tempfile, tempstring);
      }
      else if (token == "MultiFileSampEndPoint")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileSampEndPoint(tempfile, tempstring);
      }
      else if (token == "MultiFileSampEndLine")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileSampEndLine(tempfile, tempstring);
      }
      else if (token == "MultiFileSmoothType")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileSmoothType(tempfile, tempstring);
      }
      else if (token == "MultiFileXColumnOption")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        insertMultiFileXColumnOption(tempfile, tempstring);
      }
      else if (token == "MultiFileYColumnOption")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        insertMultiFileYColumnOption(tempfile, tempstring);
      }
      else if (token == "MultiFileZColumnOption")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        insertMultiFileZColumnOption(tempfile, tempstring);
      }
      else if (token == "MultiFileFormatOption")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        insertMultiFileFormatOption(tempfile, tempstring);
      }
      else if (token == "MultiFileRawFormatOption")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        insertMultiFileRawFormatOption(tempfile, tempstring);
      }
      else if (token == "MultiFileStyleOption")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileStyleOption(tempfile, tempstring);
      }
      else if (token == "MultiFileLegendTitle")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileLegendTitle(tempfile, tempstring);
      }
      else if (token == "MultiFileFilter")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileFilter(tempfile, tempstring);
      }
      else if (token == "MultiFileFilterQuoteChar")
      {
        tempfile = "";
        infile >> tempfile;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFileFilterQuoteChar(tempfile, tempstring);
      }
      else if (token == "MultiFuncNew")
      {
        tempstring = "";
        tempstring = getValue(infile);
        
        insertMultiFuncNew(tempstring);
      }
      else if (token == "MultiFuncStyleOption")
      {
        tempfunc = "";
        infile >> tempfunc;

        tempstring = "";
        tempstring = getValue(infile);

        setMultiFuncStyleOption(tempfunc, tempstring);
      }
      else if (token == "MultiFuncLegendTitle")
      {
        tempfunc = "";
        infile >> tempfunc;

        tempstring = "";
        tempstring = getValue(infile);
        
        setMultiFuncLegendTitle(tempfunc, tempstring);
      }      
    }
  }
  
  infile.close();
}

string gnuInterface::getValue(ifstream& infile)
{
  string tempstring;
  int buffsize = 100;
  char buffer[buffsize];

  infile.ignore();
  infile.getline(buffer,buffsize,';');
  tempstring = buffer;
  return tempstring;
}
