/**********************************************************************

	--- Qt Architect generated file ---

	File: curveFit.cpp

    Xgfe: X Windows GUI front end to Gnuplot
    Copyright (C) 1998 David Ishee

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 *********************************************************************/

#include "curveFit.h"
#include <qstring.h>

#define Inherited curveFitData

curveFit::curveFit
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Curve Fitting" );
}


curveFit::~curveFit()
{
}

void curveFit::setGnuInterface(gnuInterface* gnu)
{
  gnuInt = gnu;

  // insert current options

  string functionName = gnuInt->getCurveFitFunctionName();
  string dataFile = gnuInt->getCurveFitDataFile();
  string functionValue = gnuInt->getCurveFitFunctionValue();
  string varXRangeName = gnuInt->getCurveFitVarXRangeName();
  string varXRangeMin = gnuInt->getCurveFitVarXRangeMin();
  string varXRangeMax = gnuInt->getCurveFitVarXRangeMax();
  string varYRangeName = gnuInt->getCurveFitVarYRangeName();
  string varYRangeMin = gnuInt->getCurveFitVarYRangeMin();
  string varYRangeMax = gnuInt->getCurveFitVarYRangeMax();
  string paramFile = gnuInt->getCurveFitParamFile();
  int paramFileFlag = gnuInt->getCurveFitParamFileFlag();
  int paramCSLFlag = gnuInt->getCurveFitParamCSLFlag();
  string paramCSL = gnuInt->getCurveFitParamCSL();
  string fitLimit = gnuInt->getCurveFitFitLimit();
  string fitMaxIter = gnuInt->getCurveFitFitMaxIter();
  string dataSetStart = gnuInt->getCurveFitDataSetStart();
  string dataSetEnd = gnuInt->getCurveFitDataSetEnd();
  string dataSetInc = gnuInt->getCurveFitPointInc();
  string pointInc = gnuInt->getCurveFitPointInc();
  string lineInc = gnuInt->getCurveFitLineInc();
  string startPoint = gnuInt->getCurveFitStartPoint();
  string startLine = gnuInt->getCurveFitStartLine();
  string endPoint = gnuInt->getCurveFitEndPoint();
  string endLine = gnuInt->getCurveFitEndLine();
  string xColumn = gnuInt->getCurveFitXColumn();
  string yColumn = gnuInt->getCurveFitYColumn();
  string zColumn = gnuInt->getCurveFitZColumn();
  string format = gnuInt->getCurveFitFormat();
  string rawFormat = gnuInt->getCurveFitRawFormat();

  functionNameEdit->setText(functionName.c_str());
  dataFileEdit->setText(dataFile.c_str());
  functionValueEdit->setText(functionValue.c_str());
  varXRangeNameEdit->setText(varXRangeName.c_str());
  varXRangeMinEdit->setText(varXRangeMin.c_str());
  varXRangeMaxEdit->setText(varXRangeMax.c_str());
  varYRangeNameEdit->setText(varYRangeName.c_str());
  varYRangeMinEdit->setText(varYRangeMin.c_str());
  varYRangeMaxEdit->setText(varYRangeMax.c_str());
  paramFileEdit->setText(paramFile.c_str());

  if (paramFileFlag == 1)
  {
    paramFileRB->setChecked(TRUE);
    paramCSLRB->setChecked(FALSE);
  }
  else if (paramCSLFlag == 1)
  {
    paramCSLRB->setChecked(TRUE);
    paramFileRB->setChecked(FALSE);
  }

  paramCSLEdit->setText(paramCSL.c_str());
  fitLimitEdit->setText(fitLimit.c_str());
  fitMaxIterEdit->setText(fitMaxIter.c_str());
  dataSetStartEdit->setText(dataSetStart.c_str());
  dataSetEndEdit->setText(dataSetEnd.c_str());
  dataSetIncEdit->setText(dataSetInc.c_str());
  pointIncEdit->setText(pointInc.c_str());
  lineIncEdit->setText(lineInc.c_str());
  startPointEdit->setText(startPoint.c_str());
  startLineEdit->setText(startLine.c_str());
  endPointEdit->setText(endPoint.c_str());
  endLineEdit->setText(endLine.c_str());
  xColumnEdit->setText(xColumn.c_str());
  yColumnEdit->setText(yColumn.c_str());
  zColumnEdit->setText(zColumn.c_str());
  formatEdit->setText(format.c_str());
  rawFormatEdit->setText(rawFormat.c_str());
}

void curveFit::dataFileOpen()
{
  QString fileName = QFileDialog::getOpenFileName();

  if ( !fileName.isNull() ) // got a file name
  {
    dataFileEdit->setText(fileName);
  }
}

void curveFit::paramFileOpen()
{
  QString fileName = QFileDialog::getOpenFileName();

  if ( !fileName.isNull() ) // got a file name
  {
    paramFileEdit->setText(fileName);
  }
}

void curveFit::doFit()
{
  // get current options

  string functionName = functionNameEdit->text();
  string functionValue = functionValueEdit->text();
  string dataFile = dataFileEdit->text();
  string varXRangeName = varXRangeNameEdit->text();
  string varXRangeMin = varXRangeMinEdit->text();
  string varXRangeMax = varXRangeMaxEdit->text();
  string varYRangeName = varYRangeNameEdit->text();
  string varYRangeMin = varYRangeMinEdit->text();
  string varYRangeMax = varYRangeMaxEdit->text();
  string paramFile = paramFileEdit->text();

  int paramFileFlag;
  int paramCSLFlag;

  if ((paramFileRB->isChecked() == TRUE) && 
      (paramCSLRB->isChecked() == FALSE))
  {
    paramFileFlag = 1;
    paramCSLFlag = 0;
  }
  else
  {
    paramFileFlag = 0;
    paramCSLFlag = 1;
  }

  string paramCSL = paramCSLEdit->text();
  string fitLimit = fitLimitEdit->text();
  string fitMaxIter = fitMaxIterEdit->text();
  string dataSetStart = dataSetStartEdit->text();
  string dataSetEnd = dataSetEndEdit->text();
  string dataSetInc = dataSetIncEdit->text();
  string pointInc = pointIncEdit->text();
  string lineInc = lineIncEdit->text();
  string startPoint = startPointEdit->text();
  string startLine = startLineEdit->text();
  string endPoint = endPointEdit->text();
  string endLine = endLineEdit->text();
  string xColumn = xColumnEdit->text();
  string yColumn = yColumnEdit->text();
  string zColumn = zColumnEdit->text();
  string format = formatEdit->text();
  string rawFormat = rawFormatEdit->text();

  // set options

  gnuInt->setCurveFitFunctionName(functionName);
  gnuInt->setCurveFitFunctionValue(functionValue);
  gnuInt->setCurveFitDataFile(dataFile);
  gnuInt->setCurveFitVarXRangeName(varXRangeName);
  gnuInt->setCurveFitVarXRangeMin(varXRangeMin);
  gnuInt->setCurveFitVarXRangeMax(varXRangeMax);
  gnuInt->setCurveFitVarYRangeName(varYRangeName);
  gnuInt->setCurveFitVarYRangeMin(varYRangeMin);
  gnuInt->setCurveFitVarYRangeMax(varYRangeMax);
  gnuInt->setCurveFitParamFile(paramFile);
  gnuInt->setCurveFitParamFileFlag(paramFileFlag);
  gnuInt->setCurveFitParamCSLFlag(paramCSLFlag);
  gnuInt->setCurveFitParamCSL(paramCSL);
  gnuInt->setCurveFitFitLimit(fitLimit);
  gnuInt->setCurveFitFitMaxIter(fitMaxIter);
  gnuInt->setCurveFitDataSetStart(dataSetStart);
  gnuInt->setCurveFitDataSetEnd(dataSetEnd);
  gnuInt->setCurveFitDataSetInc(dataSetInc);
  gnuInt->setCurveFitPointInc(pointInc);
  gnuInt->setCurveFitLineInc(lineInc);
  gnuInt->setCurveFitStartPoint(startPoint);
  gnuInt->setCurveFitStartLine(startLine);
  gnuInt->setCurveFitEndPoint(endPoint);
  gnuInt->setCurveFitEndLine(endLine);
  gnuInt->setCurveFitXColumn(xColumn);
  gnuInt->setCurveFitYColumn(yColumn);
  gnuInt->setCurveFitZColumn(zColumn);
  gnuInt->setCurveFitFormat(format);
  gnuInt->setCurveFitRawFormat(rawFormat);
  
  gnuInt->doCurveFit();
}
