/****************************************************************************

				xFgraphs v1.3

			    by Stelios Xanthakis
			     <axanth@tee.gr>
 
This package is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This package is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License along
with this package; if not, write to the Free Software Foundation, Inc.,
675 Mass Ave, Cambridge, MA 02139, USA.

	 
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <strings.h>
#include <math.h>
#include "JINX_extras.h"
#include "ParseOptions.h"

#define GRAPH_WIDTH 400		//** Default width
#define GRAPH_HEIGHT 300	//** Default height
#define MAX_PARENTH 20		//** Maximum number of parenthsis in function
#define MAX_NUMS 20             //** Maximum number of number constants.
#define LMARG -5		//** }
#define RMARG 5			//** } Margins defaults
#define UMARG 5			//** }
#define DMARG -5		//** }
#define PPMFILE "XFGraph.ppm"	//** File name for saved ppm graphs
#define PPMBACK "\01\01\01"	//** } 
#define PPMAXIS "\xbe\xbe\xbe"	//** } PPM file colors. See `man ppm`
#define PPMPOIN "\xee\xee\01"	//** }
#define LATEXFILE "XFGraph.tex"	//** File name for LaTeX graphs
#define LATEX_LENGTH 10.0	//** LaTeX Graph width: 10cm

/**** Do NOT change these ****/
#define FUCHARS 50
#define MAX_LENGTH FUCHARS
#define MESSCHARS 23
#define TEXTS 8
#define BUTTS 9
#define BL 12
#define DL 10
#define FUNC_NUM 12

#define INNUM(x) (((x >= '0') && (x <= '9')) || (x == '.'))
#define INCHARS(x) ((x >= 'A') && (x <='Z'))
#define ALLIN(x, y) for (ip = mainstr; *(ip+1) != '\0'; ip++) \
if (charinstring (*ip, x)) if (!charinstring (*(ip+1), y)) return 6;
#define DD delallnums (); getallfuncs (); delallfuncs ();

extern Pair LASTClick;
extern int Button;
extern int LASTKey;
extern Window EventWin;
extern Display *MainDisplay;
extern int Colors[6];
extern XFontStruct *MainFont;

typedef enum { MULT, DIVI, POWE } PRAXI;

char Msg1 [] = "xFgraphs ready";
char Msg2 [] = "Bad margins. Redefine";
char Msg3 [] = "Zoom operation performed";
char Msg4 [] = "PPM file saved";
char Msg5 [] = "LaTeX source saved";
char Msg6 [] = "No function defined!";
char Msg7 [] = "Graph window closed";
char Msg8 [] = "Help Mode";
char Msg9 [] = "Graph drawn";
char Msg10[] = "New function accepted";
char Msg11[] = "Error in parenthesis";
char Msg12[] = "Missing parenthesis";
char Msg13[] = "Invalid string sequence";
char Msg14[] = "Misplaced absolute value";
char Msg15[] = "Parenthesis - absolute values placement error";
char Msg16[] = "Syntax error";
char Msg17[] = "Invalid character in string!!!!!!!!!!!!";
char Msg18[] = "Not a function of x!";
char Msg19[] = "Error converting string to number";
char Msg20[] = "Graf window not open";
char Msg21[] = "Could not malloc ()";
char Msg22[] = "Can't create file";
char Msg23[] = "Click 'Draw' to redraw";
char Msg24[] = "Zoom canceled -- too small area";
char *error_index [] = 
	{ Msg1, Msg11, Msg12, Msg13, Msg14, Msg15, Msg16,
	  Msg17, Msg18, Msg19 };

static int mp = 0, fp = 1;
static char *p;
static double X;

char validchars [] = "0123456789+-*/^.()|cosintalgexphCOSINTALGEXPH";
char mainstr [MAX_LENGTH];
char goodstr [MAX_LENGTH];
char fstr [] = "COS\0SIN\0TAN\0LOG\0LN\0ATN\0COSH\0SINH\0EXP\0";
char cstr [] = "PI\0E\0X\0DUMY";
char* fst [] = 
	{ fstr, fstr+4, fstr+8, fstr+12, fstr+16,
 	  fstr+19, fstr+23, fstr+28, fstr+33, cstr,
	  cstr+3, cstr+5, cstr+7 };

double m [MAX_NUMS];
double (*funcat [MAX_PARENTH])(double);
Display *dpy;
Window w, Graf;
char *CurrentMsg;
char *dpyStr, *uFo;
char *ppmStr, *TeXStr;
char LastNum [25];
XFontStruct *xfs;
int GrafBool, Cgrey, Cyellow, Cblack;
GC lGc, axisGC, plotGC, zboxGC;
float GLeft, GRight, GUp, GDown;
char *GL, *GR, *GU, *GD;

double NOFUNC (double d) { return d; }

void	ParseOptions (int, char**);
void	ShowHelp ();
void	init ();
void	OpenGrafWin ();
void	CloseGrafWin ();
int	CheckMargins ();
Pair	GrafDimensions ();
void	DrawGraf ();
int	CheckFormula (char*);
void	SetMargins ();
int	Zoom (int);
int	UserZoom ();
int	charinstring (char, char*);
int	checkparenthesis (char, char);
int	checkwhole ();
void	del (char*);
void	insert (char*, char);
void	fixpriority ();
int	getallnums ();
void	getallfuncs ();
void	delallnums ();
void	delallfuncs ();
double	getreg (double (*fnx)(double));
void	addparenth ();
int	save_ppm ();
int	save_LaTeX ();
void	show_rules();

int main (int argc, char **argv)
{
	int	TextOK;
	char	*c;

	ParseOptions (argc, argv);

	init ();

	MatchCharsGet GF (xfs, 7, 13, 60, 0, 0, &w, "", validchars);
	GetTextBox Formula (0, 0, 474, 24, &w, "7x13bold", "f(x)=", 60, GF);
	DadBox Coords (0, Formula.Ends ().Y+1, 150, 153, &w);
	ConstTextBox PlotButton (Coords.Ends().X+1, Formula.Ends().Y+1, 80, 50, &w, "7x13bold", "Draw");
	ConstTextBox RulezButton (Coords.Ends().X+1, PlotButton.Ends().Y+1, 80, 50, &w, "7x13bold", "Rules");
	ConstTextBox CloseButton (PlotButton.Ends().X+1, Formula.Ends().Y+1, 80, 50, &w, "7x13bold", "CloseGraf");
	ConstTextBox ExitButton (PlotButton.Ends().X+1, CloseButton.Ends().Y+1, 80, 50, &w, "7x13bold", "Exit");
	ConstTextBox ZoomInButton (CloseButton.Ends().X+1, Formula.Ends().Y+1, 80, 50, &w, "7x13bold", "Zoomin");
	ConstTextBox ZoomOutButton (CloseButton.Ends().X+1, CloseButton.Ends().Y+1, 80, 50, &w, "7x13bold", "ZoomOut");
	ConstTextBox SaveButton (ZoomInButton.Ends().X+1, Formula.Ends().Y+1, 80, 50, &w, "7x13bold", "Save ppm");
	ConstTextBox TeXButton (ZoomOutButton.Ends().X+1, ZoomInButton.Ends().Y+1, 80, 50, &w, "7x13bold", "LaTeX");
	FloatGet FG1 (xfs, 7, 13, 18, 0, 0, &w, "");
	GetTextBox GiveX (Coords.Ends().X+1, RulezButton.Ends().Y+1, 161, 25, &w, "7x13bold", "x=", 18, FG1);
	ConstTextBox ShowY (GiveX.Ends().X+1, RulezButton.Ends().Y+1, 161, 25, &w, "7x13bold", "f(x)=", FLUSHL);
	FFDisplay FD1 (xfs, 7, 13, 16, GiveX.Ends().X+40, RulezButton.Ends().Y+4, &w, 1);
	DadBox MessagesBack (Coords.Ends().X+1, GiveX.Ends().Y+1, 323, 25, &w);
	FFDisplay FD2 (xfs, 7, 13, 44, Coords.Ends().X+4, GiveX.Ends().Y+4, &w, 1);
	xfs = XLoadQueryFont (dpy, "6x10");
	FloatGet UpG    (xfs, 6, 10, 5, 0, 0, &w, " ");
	FloatGet DownG  (xfs, 6, 10, 5, 0, 0, &w, " ");
	FloatGet RightG (xfs, 6, 10, 5, 0, 0, &w, " ");
	FloatGet LeftG  (xfs, 6, 10, 5, 0, 0, &w, " ");
	GetTextBox UpBox (Coords.Ends().X/4, Formula.Ends().Y+8, 60, 19, &w, "6x9", "U:", 5, UpG);
	GU = UpBox.QueryString ();
	GetTextBox DownBox (Coords.Ends().X/4, Coords.Ends().Y-24, 60, 19, &w, "6x9", "D:", 5, DownG);
	GD = DownBox.QueryString ();
	GetTextBox RightBox (Coords.Ends().X-65, Formula.Ends().Y+75, 60, 19, &w, "6x9", "R:", 5, RightG);
	GR = RightBox.QueryString ();
	GetTextBox LeftBox (4, Formula.Ends().Y+50, 60, 19, &w, "6x9", "L:", 5, LeftG);
	GL = LeftBox.QueryString ();
	SetMargins ();

	UpG.fg = DownG.fg = RightG.fg = LeftG.fg = YELLOW;
	FD2.fg = BROWN;
	UpBox.Sunken = DownBox.Sunken = RightBox.Sunken = LeftBox.Sunken = 0;

	DrawManager DM;
	DM.Register (&Formula);
	DM.Register (&Coords);
	DM.Register (&PlotButton); 
	DM.Register (&RulezButton); 
	DM.Register (&CloseButton); 
	DM.Register (&ExitButton); 
	DM.Register (&ZoomInButton); 
	DM.Register (&ZoomOutButton); 
	DM.Register (&SaveButton); 
	DM.Register (&TeXButton); 
	DM.Register (&GiveX);
	DM.Register (&ShowY);
	DM.Register (&MessagesBack);
	DM.Register (&UpBox);
	DM.Register (&DownBox);
	DM.Register (&RightBox);
	DM.Register (&LeftBox);
	DM.Draw ();
	TextBoxManager TBM;
	TBM.Register (&Formula);
	TBM.Register (&GiveX);
	TBM.Register (&UpBox);
	TBM.Register (&DownBox);
	TBM.Register (&RightBox);
	TBM.Register (&LeftBox);
	FD1.Draw ("");
	FD2.Draw (Msg1);
	XDrawLine (dpy, w, lGc, 10, 96, 140, 96);
	XDrawLine (dpy, w, lGc, 80, 55, 80, 150);

	if (uFo)
	{
		strcpy (Formula.QueryString (), uFo);
		Formula.Draw ();
		if (CheckMargins ())
		{
			OpenGrafWin ();
			DrawGraf ();
		}
		else
		{
			fprintf (stderr, "Bad Margins\n");
			exit (1);
		}
	}
	
	while (1) 
	switch (EventHandler (&w, 1))
	{ case Expose:
		if (EventWin == Graf)
		{
			DrawGraf ();
			break;
		}
		DM.Draw ();
		XDrawLine (dpy, w, lGc, 10, 96, 140, 96);
		XDrawLine (dpy, w, lGc, 80, 55, 80, 150);
		FD1.Draw (LastNum);
		FD2.Draw (CurrentMsg);
		XFlush (dpy);
		break;
	  case KeyPress:
		TextOK = GetTextBox::CurrentStatus (1);
		TBM.ProcChar ();
		if ((GetTextBox::CurrentStatus (1) == 0)
		 && (TextOK))
			switch (TextOK)
			{ case 1:
				CheckFormula (Formula.QueryString ());
				break;
			  case 2:
				if (CheckFormula (Formula.QueryString ()))
				{
					X = strtod (GiveX.QueryString (), &c);
					fp = 1;
					mp = 0;
					p = goodstr;
					sprintf (LastNum, "%.15f",
						 getreg (NOFUNC));
					FD1.Draw (LastNum);
					CurrentMsg = Msg1;
				}
				else
					CurrentMsg = Msg6;
				break;
			  default:
				if (CheckMargins ())
					CurrentMsg = Msg23;
			}
		FD2.Draw (CurrentMsg);
		break;
	  case ButtonPress:
		if (EventWin == Graf)
		{
			if (UserZoom ())
			{
				UpBox.Draw ();
				DownBox.Draw ();
				RightBox.Draw ();
				LeftBox.Draw ();
			}
			FD2.Draw (CurrentMsg);
			break;
		}
		TBM.ManageClick ();
		if (PlotButton.CheckClick ())
		{
			if (CheckFormula (Formula.QueryString ()))
			{
				if (CheckMargins ())
				{
					if (!GrafBool)
						OpenGrafWin ();
					DrawGraf ();
				}
			}
			else
				CurrentMsg = Msg6;
		}
		if (RulezButton.CheckClick ()) show_rules();
		if (CloseButton.CheckClick ()) CloseGrafWin ();
		if (ExitButton.CheckClick ())
			exit (0);
		if (ZoomInButton.CheckClick ())
			if (Zoom (0))
			{
				UpBox.Draw ();
				DownBox.Draw ();
				RightBox.Draw ();
				LeftBox.Draw ();
			}
		if (ZoomOutButton.CheckClick ())
			if (Zoom (1))
			{
				UpBox.Draw ();
				DownBox.Draw ();
				RightBox.Draw ();
				LeftBox.Draw ();
			}
		if (SaveButton.CheckClick ()) save_ppm ();
		if (TeXButton.CheckClick ()) save_LaTeX ();
		FD2.Draw (CurrentMsg);
	}
	return 0;
}

void ParseOptions (int argc, char **argv)
{
	int	i, j, k;

	dpyStr = uFo = NULL;
	ppmStr = PPMFILE;
	TeXStr = LATEXFILE;
	OptionBasicFloat o1 ("--Left=", &GLeft);
	OptionBasicFloat o2 ("--Right=", &GRight);
	OptionBasicFloat o3 ("--Down=", &GDown);
	OptionBasicFloat o4 ("--Up=", &GUp);
	OptionBasicStr   o5 ("--display=", &dpyStr);
	OptionBasicStr   o6 ("--ppmfile=", &ppmStr);
	OptionBasicStr   o7 ("--latexfile=", &TeXStr);
	OptionBasicStr *OptArr [] = { &o1, &o2, &o3, &o4, &o5, &o6, &o7 };

	GLeft = LMARG; 
	GRight = RMARG;
	GUp = UMARG;
	GDown = DMARG;

	if ((argc > 1) && (!(strcmp (*(argv + 1), "--help"))))
	{
		ShowHelp ();
		exit (0);
	}

	for (i = 1; i < argc; i++)
	{
		for (k = j = 0; j < 7; j++)
			k |= OptArr [j]->CheckIt (argv [i]);
		if (!k)
			if (i != argc - 1)
			{
				fprintf (stderr, "Unknown option %s\n",
					 argv [i]);
				ShowHelp ();
				exit (1);
			}
			else
				if (!CheckFormula (argv [i]))
				{
					fprintf (stderr, "Error in \'%s\':%s\n",
						argv [i], CurrentMsg);
					exit (1);
				}
				else
					uFo = argv [i];
	}
}

void ShowHelp ()
{
	puts ("Usage: xFgraphs [ OPTIONS ] [ FUNCTION ]");
	puts ("\nThe OPTIONS are:");
	puts ("	--Left= , --Right= , --Up= , --Down=	To define Margins");
	puts ("	--display=				To set display");
	puts ("	--ppmfile=			Filename for exported ppm Graph");
	puts ("	--latexfile=			Filename for exported LaTeX Graph");
	puts ("\nThe FUNCTION is a formula string.");
	puts (" Supported functions are { cos, sin, tan, atn, exp, log, ln, cosh, sinh }");
	puts (" The constants 'e' and 'pi' can be used.");
	puts (" The absolute value is '|' and does not replace parenthesis.\n");
}

void init ()
{
	Colormap		cmap;
	XColor			gett, dummy;
	XGCValues		Xgv;
	XSetWindowAttributes	attr;

	if (!(dpy = XOpenDisplay (dpyStr)))
	{
		fprintf (stderr, "Can't open display\n");
		exit (1);
	}
	attr.backing_store = Always;
	w = XCreateWindow (dpy, DefaultRootWindow(dpy), 0, 0,
		475, 179, 0, CopyFromParent, CopyFromParent, CopyFromParent,
		CWBackingStore, &attr);
	XSizeHints size_hints;
	size_hints.min_width = size_hints.max_width = 475;
	size_hints.min_height = size_hints.max_height = 179;
	size_hints.flags = PMinSize | PMaxSize;
	XSetNormalHints (dpy, w, &size_hints);
	XStoreName (dpy, w, "xFgraphs");
	XMapWindow (dpy, w);
	XFlush (dpy);
	cmap = XDefaultColormap (dpy, DefaultScreen (dpy));
	XAllocNamedColor (dpy, cmap, "black", &gett, &dummy);
	Cblack = gett.pixel;
	XAllocNamedColor (dpy, cmap, "yellow", &gett, &dummy);
	Cyellow = gett.pixel;
	XAllocNamedColor (dpy, cmap, "white", &gett, &dummy);
	Cgrey = gett.pixel;
	Xgv.foreground = Cgrey;
	Xgv.function = GXxor;
	zboxGC = XCreateGC (dpy, w, GCForeground + GCFunction, &Xgv);
	XAllocNamedColor (dpy, cmap, "grey", &gett, &dummy);
	Cgrey = gett.pixel;
	xfs = XLoadQueryFont (dpy, "7x13bold");
	Xgv.foreground = 0;
	lGc = XCreateGC (dpy, w, GCForeground, &Xgv);
	Xgv.foreground = Cgrey;
	axisGC = XCreateGC (dpy, w, GCForeground, &Xgv);
	Xgv.foreground = Cyellow;
	plotGC = XCreateGC (dpy, w, GCForeground, &Xgv);
	InitLib (dpy, &w);
	CurrentMsg = Msg1;
	strcpy (LastNum, "-");
	GrafBool = 0;
}

void OpenGrafWin ()
{
	XSetWindowAttributes	attr;
	XEvent			e;

	Graf = XCreateSimpleWindow (dpy, XRootWindow (dpy, DefaultScreen (dpy)),
		10, 10, GRAPH_WIDTH, GRAPH_HEIGHT, 0, Cyellow, Cblack);
	if (!Graf)
	{
		fprintf (stderr, "Cannot create window!\n");
		exit (1);
	}
	attr.backing_store = Always;
	XChangeWindowAttributes (dpy, Graf, CWBackingStore, &attr);
	GrafBool = 1;
	XStoreName (dpy, Graf, "Graph");
	XSelectInput (dpy, Graf, StructureNotifyMask);
	XMapWindow (dpy, Graf);
	XFlush (dpy);
	while (1)
	{
		XNextEvent (dpy, &e);
		if (e.type == MapNotify) break;
	}
	XSelectInput (dpy, Graf, ExposureMask | StructureNotifyMask |
			ButtonPressMask);
}

void CloseGrafWin ()
{
	if (GrafBool)
	{
		XDestroyWindow (dpy, Graf);
		GrafBool = 0;
		CurrentMsg = Msg7;
	}
	else
		CurrentMsg = Msg20;
}

int CheckMargins ()
{
	char	*endptr;
	double	a, b, c, d;

	a = strtod (GU, &endptr);
	b = strtod (GD, &endptr);
	c = strtod (GR, &endptr);
	d = strtod (GL, &endptr);
	if ((a < b) || (c < d))
	{
		CurrentMsg = Msg2;
		return 0;
	}
	GUp    = a;
	GDown  = b;
	GRight = c;
	GLeft  = d;
	return 1;
}

Pair GrafDimensions ()
return P;
{
	Window		a;
	int		b, c;
	unsigned int	d, e;

	XGetGeometry (dpy, Graf, &a, &b, &c, (unsigned int*) &P.X,
		      (unsigned int*) &P.Y, &d, &e);
}

void DrawGraf ()
{
	float	dx, dy, y;
	int	width, height, i;

	XClearWindow (dpy, Graf);
	if (!goodstr [0]) return;
	width = GrafDimensions ().X;
	height = GrafDimensions ().Y;
	dy = height / (GUp - GDown);
	dx = (GRight - GLeft) / width;
	X = GLeft;
	if ((GDown < 0) && (GUp > 0))
		XDrawLine (dpy, Graf, axisGC, 0, (int) (GUp*dy),
			   width, (int) (GUp*dy));
	if ((GLeft < 0) && (GRight > 0))
		XDrawLine (dpy, Graf, axisGC, (int) (-GLeft / dx), 0,
			   (int) (-GLeft / dx), height);

	for (i = 0; i < width; i++, X += dx)
	{
		fp = 1;
		mp = 0;
		p = goodstr;
		y = getreg (NOFUNC);
		if ((y > GDown) && (y < GUp))
			XDrawPoint (dpy, Graf, plotGC, i, (int) ((GUp - y)*dy));
	}
	XFlush (dpy);
	CurrentMsg = Msg9;
}

int CheckFormula (char *c)
{
	int	k;
	strcpy (mainstr, c);

	addparenth ();
	if ((k = checkwhole ()))
	{
		mainstr [0] = 0;
		CurrentMsg = error_index [k];
		return 0;
	}

	fixpriority ();
	if ((k = getallnums ()))
	{
		mainstr [0] = 0;
		CurrentMsg = error_index [k];
		return 0;
	}

	delallnums (); 
	getallfuncs (); 
	delallfuncs ();
	CurrentMsg = Msg10;
	strcpy (goodstr, mainstr);
	return 1;
}

void SetMargins ()
{
	sprintf (GU, "%.5f", GUp);
	sprintf (GD, "%.5f", GDown);
	sprintf (GR, "%.5f", GRight);
	sprintf (GL, "%.5f", GLeft);
}

int Zoom (int io)
{
	float	f;

	if (!GrafBool)
		CurrentMsg = Msg20;
	else if (mainstr [0])
	{
		f = (GLeft + GRight) / 2;
		GLeft = (io) ? 2 * GLeft - f : (GLeft + f) / 2;
		GRight = (io) ? 2 * GRight - f : (GRight + f) / 2;
		f = (GUp + GDown) / 2;
		GDown = (io) ? 2 * GDown - f : (GDown + f) / 2;
		GUp = (io) ? 2 * GUp - f : (GUp + f) / 2;
		SetMargins ();
		DrawGraf ();
		CurrentMsg = Msg3;
		return 1;
	}
	else
		CurrentMsg = Msg6;
	return 0;
}

int UserZoom ()
{
	XEvent	e;
	int	i;
	Pair	st, en;

	en = st = LASTClick;
	i = 1;
	XSelectInput (dpy, Graf, ButtonPressMask + ButtonReleaseMask +
			Button1MotionMask);
	XGrabPointer (dpy,w,1, Button1MotionMask+ButtonReleaseMask,
		GrabModeSync, GrabModeSync, None, None, CurrentTime);
	alarm (60);     //****SAFETY
	while (i)
	{
		XAllowEvents (dpy, SyncPointer, CurrentTime);
		XNextEvent (dpy, &e);
		switch (e.type)
		{ case ButtonRelease:
			i = 0;
			break;
		  case MotionNotify:
			if (!(st.X == en.X && st.Y == en.Y))
				XDrawRectangle (dpy, Graf, zboxGC, st.X <? en.X,
					st.Y <? en.Y, abs (st.X - en.X),
					abs (st.Y - en.Y));
			en.X = e.xmotion.x;
			en.Y = e.xmotion.y;
			XDrawRectangle (dpy, Graf, zboxGC, st.X <? en.X,
				st.Y <? en.Y, abs (st.X - en.X),
				abs (st.Y - en.Y));
			break;
		}
		XFlush (dpy);
	}
	XDrawRectangle (dpy, Graf, zboxGC, st.X <? en.X, st.Y <? en.Y,
		 abs (st.X - en.X), abs (st.Y - en.Y));
	XUngrabPointer (dpy,CurrentTime);
	XAllowEvents (dpy, SyncPointer, CurrentTime);
	XFlush (dpy);
	alarm (0);
	CurrentMsg = Msg24;
	if (abs (st.X - en.X) > 15 && abs (st.Y - en.Y) > 15)
	{
		float a, b;
		i = 1;
		if (en.X < 0) en.X = 0;
		if (en.X > GrafDimensions().X) en.X = GrafDimensions().X;
		if (en.Y < 0) en.Y = 0;
		if (en.Y > GrafDimensions().Y) en.Y = GrafDimensions().Y;
		a = GLeft;
		b = GRight;
		GLeft = a + (b - a) * (st.X <? en.X) / GrafDimensions().X;
		GRight = a + (b - a) * (st.X >? en.X) / GrafDimensions().X;
		a = GDown;
		b = GUp;
		GDown = b - (b - a) * (st.Y >? en.Y) / GrafDimensions().Y;
		GUp = b - (b - a) * (st.Y <? en.Y) / GrafDimensions().Y;
		SetMargins ();
		DrawGraf ();
		CurrentMsg = Msg3;
	}
	XSelectInput (dpy, Graf, ExposureMask | StructureNotifyMask
				 | ButtonPressMask);
	return i;
}

int charinstring (char c, char *s)
{
	for (; *s != '\0'; s++) if (*s == c) return 1;
	return 0;
}

int checkparenthesis (char o, char c)
{
	int i = 0, j = 0;
	while ((mainstr[i] != '\0') && (j >= 0))
	{
		if (mainstr[i] == o) j++;
		if (mainstr[i++] == c) j--;
	}
	return (j == 0) ? 0 : (j < 0) ? 1 : 2;
}

int checkwhole ()
{
	char befabso [] = "+-*/^([\0";
	char buffer [] = "1234567890XIE)]\0";
	char *ip, *jp;
	int i, d[DL], j = 0;
	for (ip = mainstr; *ip != '\0'; ip++)
	{
		if INCHARS((*ip)-32) *ip -= 32;
		if (!charinstring (*ip, "|1234567890-+*/^.)]([COSINTALGHPEX"))
		return 7;
	}
	if (!charinstring ('X', (ip = mainstr))) return 8;
	if ((i = checkparenthesis ('(', ')'))) return i;
	if (mainstr[0] == '|') mainstr[0] = '[';
	for (ip = mainstr+1; *ip != '\0'; ip++)
	if (*ip == '|')
	{
		if (charinstring (*(ip-1), befabso)) *ip = '[';
		else if (charinstring (*(ip-1), buffer)) *ip = ']';
			else return 4;
	}
	if ((i = checkparenthesis ('[', ']'))) return i;
	for (ip = mainstr, i = j = 0; *ip != '\0'; ip++)
	switch (*ip)
	{
		case '[': i++; break;
		case ']': i--; break;
		case '(': d[j++] = i; break;
		case ')': if (d[--j] != i) return 5;
	}
	ip = mainstr;
	while (*ip != '\0')
	if INCHARS(*ip)
	{
		jp = ip;
		while INCHARS(*ip) ip++;		
		i = 0;
		while ((i < BL) && (jp < ip)) buffer[i++] = *jp++;
		buffer[i] = '\0';
		i = 0;
		while ((i<FUNC_NUM) && (strcmp (buffer, fst[i]))) i++;
		if (i == 12) return 3;
	}
	else ip++;
	ALLIN("1234567890", ".1234567890-+*/^)]")
	ALLIN("-+*/^", "1234567890CSTALPEX([")
	ALLIN("NGH", "H(")
	ALLIN("S", "I(H")
	ALLIN("P", "I(")
	ALLIN("EX)]", "-+*/^)]XP")
	ALLIN("I", "N-+*/^)]")
	ALLIN("[(", "1234567890CSTALPEX([-")
	ALLIN(".", "1234567890")
	if (charinstring (mainstr[0], ".+*/^")) return 6;
	if (charinstring (*ip, ".-+*/^CSTAL")) return 6;
	return 0;
}

inline void del (char *cc)
{
	char *a = cc;
	while (*a++ != '\0') *(a-1) = *a;
}

void insert (char *cp, char c)
{
	char buffer [100];
	strcpy (buffer, cp);
	*cp = c;
	*(cp + 1) = 0;
	strcat (cp, buffer);
}

void fixpriority ()
{
	char *c, *d, *e;
	signed char s, w;

	for (c = mainstr; *c; c++)
	if (*c == '^')
	{
		e = d = c;
		e++;
		s = w = 0;
		while (((*d != '+') && (*d != '-') && (*d != '/')
			&& (*d != '*') && (*d)) || (s < 0))
		{
			if (*d == ')') s--;
			if (*d == '(') s++;
			d--;
		}
		if (((*d == '*') || (*d == '/')) && (s == 0))
		{
			while (((*e != '+') && (*e != '-') && (*e != '/')
				&& (*e != '*') && (*e)) || (w > 0))
			{
				if (*e == ')') w--;
				if (*e == '(') w++;
				e++;
			}
			insert (d + 1, '(');
			insert (e + 1, ')');
			c = mainstr;
		}
	}
}

int getallnums ()
{
	char *ip, *jp, buffer [BL], *kp;
	int i, j = 0;
	for (ip = mainstr; *ip != '\0'; ip++) 
	if INNUM(*ip)
	{
		jp = ip;
		while INNUM(*ip) ip++;
		i = 0;
		while ((i < BL) && (jp < ip)) buffer[i++] = *jp++;
		buffer[i] = '\0';
		i = 0;
		m[j++] = strtod (buffer, &kp);
		if (*kp != '\0') return 9;
	}
	else if (((*ip == 'P') && (*(ip+1) != '(')) || ((*ip == 'E') && (*(ip+1) != 'X'))) 
	     m[j++] = (*ip=='E') ? M_E : M_PI;
	return 0;
}

void getallfuncs ()
{
	char *ip = mainstr;
	int j = 0;
	while (*ip != '\0')
	switch (*ip)
	{
		case 'C': 
			if (*(ip+3) == 'H') { funcat [j++] = cosh; ip += 5; }
			else { funcat [j++] = cos; ip += 4; } break;
		case 'S': 
			if (*(ip+3) == 'H') { funcat [j++] = sinh; ip += 5; }
			else { funcat [j++] = sin; ip += 4; } break;
		case 'T': funcat [j++] = tan; ip += 4; break;
		case 'A': funcat [j++] = atan; ip += 4; break;
		case 'L': 
			if (*(ip+1) == 'N') { funcat[j++] = log; ip += 3; }
			else { funcat [j++] = log10; ip += 4; } break;
		case 'E': funcat [j++] = exp; ip += 4; break;
		case '(': funcat [j++] = NOFUNC; ip++; break;
		case '[': funcat [j++] = fabs; ip++; break;
		default : ip++;
	}
}

void delallnums ()
{
	char *ip = mainstr;
	while (*ip != '\0')
	if INNUM(*ip)
	{
		while INNUM(*(ip+1)) del (ip);
		*ip = 'm';
	}
	else 
	switch(*ip)
	{
		case 'P': del (ip);
		case 'E': if (*(ip+1) == 'X') ip += 3;
		          else *ip = 'm'; break;
		case 'X': if (*(ip+1) != 'P') *ip = 'x';
		default: ip++;
	}
}

void delallfuncs ()
{
	char *ip = mainstr;
	while (*ip != '\0')
	if INCHARS(*ip)	del (ip);
	else
	switch (*ip)
	{
		case '[': *ip = '('; break;
		case ']': *ip = ')';
		default: ip++;
	}
}

double getreg (double (*fnx)(double))
{
	double accum = 1, reg = 0, num;
	PRAXI pr = MULT;
	if (*(++p) == '-') 
	{
		accum = -1;
		p++;
	}
	while (1)
	{
		num = (*p == 'm') ? m[mp++] : 
		      (*p == 'x') ? X : getreg (funcat[fp++]);
		switch (pr) 
		{
			case MULT: accum *= num; break;
			case DIVI: accum /= num; break;
			case POWE: accum = pow (accum, num); 
		}
		if (*(++p) == ')') 
		{ 
			reg += accum;
			break;
		}
		switch (*p)
		{
			case '*': pr = MULT; break;
			case '/': pr = DIVI; break;
			case '^': pr = POWE; break;
			default : reg += accum; pr = MULT;
				accum = (*p == '-') ? -1 : 1;
		}
		p++;
	}
	return fnx (reg);
}

void addparenth ()
{
	char perm [MAX_LENGTH] = "(";
	strcpy (mainstr, (char *)strcat (strcat (perm, mainstr), (char *)")"));
}

int save_ppm ()
{
	float		dx, dy, y;
	unsigned int	width, height, i;
	unsigned int	ix, iy;
        unsigned int	Yaxis, Xaxis;
	unsigned int	*chp;
	FILE		*ppm;

	if (!GrafBool)
	{
		CurrentMsg = Msg20;
		return 0;
	}
	width = (unsigned int) GrafDimensions ().X;
	height = (unsigned int) GrafDimensions ().Y;
	
	if (!(chp = (unsigned int *) malloc (sizeof (int) * width)))
	{
		CurrentMsg = Msg21;
		return 0;
	}

	dy = height / (GUp - GDown);
	dx = (GRight - GLeft) / width;
	Xaxis = ((GDown < 0) && (GUp > 0)) ? (unsigned int) (GUp * dy) : 65535;
	Yaxis = (unsigned int) ((GLeft < 0) && (GRight > 0)) 
		? (unsigned int) (-GLeft / dx) : 65535;
	
	for (i = 0, X = GLeft; i < width; i++, X += dx)
	{
		fp = 1;
		mp = 0;
		p = mainstr;
		y = getreg(NOFUNC);
		*(chp + i) = ((y > GDown) && (y < GUp)) ? 
			      (unsigned int) ((GUp - y) * dy) : 65535;
	}
	
	if ((ppm = fopen (ppmStr, "w")) == NULL)
	{
		CurrentMsg = Msg22;
		return 0;
	}

	fprintf (ppm, "P6\n%i %i\n255\n", width, height);

	for (iy = 0; iy < height; iy++)
		for (ix = 0; ix < width; ix++)
         		if (*(chp + ix) == iy)
				fprintf (ppm, PPMPOIN);
			else if ((ix == Yaxis) || (iy == Xaxis))
				fprintf (ppm, PPMAXIS);
			else
				fprintf (ppm, PPMBACK);

	fclose (ppm);
	free (chp);
	CurrentMsg = Msg4;
	return 1;
}

int save_LaTeX ()
{
        unsigned int	XPoints, YPoints;
	float		dx, y, dy, ddx, ddy, YSIZE, yp, xp;
	FILE		*tex;
	
	if (!GrafBool)
	{
		CurrentMsg = Msg20;
		return 0;
	}
	XPoints = (unsigned int) GrafDimensions ().X;
	YPoints = (unsigned int) GrafDimensions ().Y;
	X = xp = GLeft;
	fp = 1;
	mp = 0;
	p = mainstr;
	yp = getreg (NOFUNC);
	dx = (GRight - GLeft) / XPoints;
	YSIZE = (LATEX_LENGTH * YPoints) / XPoints;
	ddx = LATEX_LENGTH / (GRight - GLeft);
	ddy = YSIZE / (GUp - GDown);
	
	if (!(tex = fopen (TeXStr, "w")))
	{
		CurrentMsg = Msg22;
		return 1;
	}
	
	fputs ("% LaTeX Graph created with xFgraphs 1.3\n", tex);
	fputs ("\\setlength{\\unitlength}{1cm}\n", tex);
	fprintf (tex, "\\begin{picture}(%.3f,%.3f)\n", LATEX_LENGTH, YSIZE);
	
	for (X = GLeft + dx; X < GRight; X += dx)
	{
		fp = 1;
		mp = 0;
		p = mainstr;
		y = getreg (NOFUNC);
		dy = y - yp;
		if ((y > GDown) && (y < GUp)) {
		fprintf(tex, "\\qbezier(%.3f,%.3f)(%.3f,%.3f)(%.3f,%.3f)\n",
				(xp - GLeft) * ddx,
				(yp - GDown) * ddy,
				(xp + dx * 0.5 - GLeft) * ddx,
				((yp + y) * 0.5 - GDown) * ddy,
				(X - GLeft) * ddx,
				(y - GDown) * ddy
				);
		}
		yp = y;
		xp = X;
	}
	
	fputs ("\\thicklines\n", tex);

	if ((GLeft < 0) && (GRight > 0))
		fprintf (tex, "\\put(%.3f,0){\\line(0,1){%.3f}}\n",
			-GLeft * ddx, YSIZE );

	if ((GDown < 0) && (GUp > 0))
		fprintf (tex, "\\put(0,%.3f){\\line(1,0){%.3f}}\n",
			-GDown * ddy, LATEX_LENGTH );

	fputs ("\\thinlines\n", tex);
	fputs ("\\end{picture}\n", tex);
	fclose (tex);
	CurrentMsg = Msg5;

	return 0;
}

char Rule1 [] = "Syntax Rules";
char Rule2 [] = "------------";
char Rule3 [] = "Supported functions:";
char Rule4 [] = "  COS SIN TAN ATN LOG";
char Rule5 [] = "  LN COSH SINH EXP";
char Rule6 [] = " The absolute value | does not replace parenthesis";
char Rule7 [] = " Numbers can't be in exponential notation (10E-02)";
char Rule8 [] = " Decimal point must be between numbers";
char Rule81[] = "1-2^x is will not produce any output since the";	
char Rule82[] = "  base is considered negative. It can be 1-(2^x)";
char Rule9 []=" ";
char Rule10[] = "Exporting Graphs";
char Rule11[] = "----------------";
char Rule12[] = "Click on 'Save ppm' button to save the graph in a ppm file";
char Rule13[] = "Rlick on 'LaTeX' button to create a LaTeX picture file";
char *Rules [] =
	{ Rule1, Rule2, Rule3, Rule4, Rule5, Rule6, Rule7,
	  Rule8, Rule81, Rule82, Rule9, Rule10, Rule11, Rule12, Rule13, NULL };

void show_rules()
{
	char	**c;
	int	i;

	if (!GrafBool)
		OpenGrafWin ();

	XClearWindow(dpy, Graf); 
	for (i = 10, c = Rules; *c; c++, i += 12)
		XDrawString (dpy, Graf, plotGC, 10, i, *c, strlen (*c));

	CurrentMsg = Msg8;
}
