//---------------------------------------------------------------------------
//                                                                          
// Cool option parsing classes.
//                                                       
// With inheritance a lot more can be done.
// Right now only what's needed for GetWeb is implemented.
//  2Do: A member function that will show us the option name?
// See the code of GetWeb and it's ParseOptions () function
// for usage of the classes.
//
// This implementation is flexible for options of the type
// '--optionname=value'. Options seperated from the value
// with a space (next *argv) is not easy to be parsed.
//---------------------------------------------------------------------------

class OptionBasicStr
{
     private:
	char **PutStr;
     protected:
	char *OptName;
	int l;
	virtual void PlaceVal (char *c)     { *PutStr = c + l; }
     public:
	OptionBasicStr () { }
	OptionBasicStr (char *c, char **cp) 
	{ l = strlen (OptName = c); PutStr = cp; }
	int CheckIt (char *c)
	{ if (strncmp (c, OptName, l)) return 0; PlaceVal (c); return 1; }
};

class OptionBasicBool : public OptionBasicStr
{
     private:
	int BoolFlag;
     protected:
	int *PutInt;
	virtual void PlaceVal (char *)      { *PutInt = BoolFlag; }
     public:
	OptionBasicBool () { }
	OptionBasicBool (char *c, int *i1, int i2)
	{ l = strlen (OptName = c); PutInt = i1; BoolFlag = i2; }
};

class OptionBasicInt : public OptionBasicBool
{
     protected:
	virtual void PlaceVal (char *c)  { *PutInt = atoi (c + l); }
     public:
        OptionBasicInt (char *c, int *i)
	{ l = strlen (OptName = c); PutInt = i; }
};

class OptionBasicFloat : public OptionBasicStr
{
     private:
	float *PutFloat;
     protected:
	virtual void PlaceVal (char *c)  
	{ char *e; *PutFloat = (float) strtod (c + l, &e); }
     public:
        OptionBasicFloat (char *c, float *i)
	{ l = strlen (OptName = c); PutFloat = i; }
};

class OptionManyStr : public OptionBasicStr
// not happy with this one. good only for getweb....
{
     private:
	char *OptArray;
	int ElemL;
	int Max;
     protected:
	virtual void PlaceVal (char *c)
	{ if (Top <= Max) 
	{ strncpy (OptArray + ElemL * Top++, c + l, ElemL - 1); } }
     public:
	int Top;
	OptionManyStr (char *c1, char *c2, int i1, int i2)
	{ OptArray = c2; l = strlen (OptName = c1); Max = i1; 
	  Top = 0; ElemL = i2; }
};

