#include "JINX.h"

/*
 * This is an ancestor of FFGet.
 * It gets float numbers. That is:
 *	- Numbers
 *	- A minus sign only if first character
 *	- Only one decimal point
 *
 */
 
class FloatGet : public FFGet
{
   private:
	virtual int valid (const unsigned char);
	int Decimal;
   public:
	FloatGet (XFontStruct *f, int x, int y, int w, int l, int q,
		Window *ww, char* c)
	: FFGet (f, x, y, w, l, q, ww, c, 1) { Decimal = 0; }
};

/*
 * This is a box that shows a percentage meter.
 *  Given 'Max' value and by the value of 'Count'
 *  draws a ratio filled box.
 * By 'Reset' it resets and takes a new 'Max' value.
 *
 */
 
class PerCentBox : public DadBox
{
   private:
	int Max;
	virtual void PersonalDraw ();
   public:
	int Count;
	PerCentBox (int x, int y, int w, int l, Window *ww)
	: DadBox (x, y, w, l, ww) { }
	void Reset (int);
};

