#include "JINX_extras.h"
#include <string.h>

/*
 * Ancestor of FFGet.
 * Gets float numbers, that is:
 *	numbers, 
 *	a minus sign only first character, 
 *	one decimal dot
 */

int FloatGet::valid (const unsigned char c)
{
	int i;
	i = StandardCheck (c);
	if (i != 2)
		return i;
	if (pointer == 0 && Text[0] == '-') return 0;
	if (c == '-') return (pointer == 0);
	if (c == '.') return (strchr (Text, '.') == NULL);
	if (c >= '0' && c <= '9') return 1;
	return 0;
}

void PerCentBox::PersonalDraw ()
{
	float activeWidth = Dimen.X - 6;
	if (Max > 0)
	activeWidth *= (float (Count) / float (Max) > 1.0) ? 1.0 
		: float (Count) / float (Max);
	SetGCColor (BLACK);
	XFillRectangle (D, *W, gc, Origin.X, Origin.Y, Dimen.X, Dimen.Y);
	SetGCColor (BROWN);
	XFillRectangle (D, *W, gc, Origin.X + 3, Origin.Y + 3, (int) activeWidth, Dimen.Y - 6);
}

void PerCentBox::Reset (int x)
{
	Count = 0;
	Draw ();
	Max = x;
}
