/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include"mplot.h"
#include<cstring>
#include<cstdlib>
#include<cctype>
#include<cmath>
#include<cerrno>
#include<new>

/*
  Le routines che seguono sono delle funzioni di utilita' di carattere
  matematico e non solo.
*/

/*
  round restituisce,nella forma di un double,il valore intero piu' prossimo
  al valore double che le viene passato come parametro.
  Se questo e' maggiore o uguale di 0 allora viene preso il valore intero
  immediatamente maggiore se la parte frazionaria e' maggiore di 0.5,altri-
  menti il valore intero immediatamente minore.Se invece l'argomento e' mi-
  nire di 0 allora ritorna il valore intero immediatamente minore  se  la
  parte frazionaria e' minore di -0.5,altrimenti ritorna il valore intero
  immediatamente maggiore.In ogni caso non viene effettuato alcun arroton-
  damento se la parte frazionaria e' 0.
*/

double
round (double d)
{
  double fp, ip, rounded;

  fp = modf (d, &ip);
  if (fp >= 0)
    rounded = (fp > 0.5) ? ip + 1 : ip;
  else
    rounded = (fp < -0.5) ? ip - 1 : ip;
  return rounded;
}

/* intp restituisce la parte intera dell'argomento */

double
intp (double d)
{
  double fp, ip;

  fp = modf (d, &ip);
  return ip;
}

/* frac restituisce la parte frazionaria dell'argomento */

double
frac (double d)
{
  double fp, ip;

  fp = modf (d, &ip);
  return fp;
}

/*
  trunc restituisce la parte intera dell'argomento nella forma di un long.
  Attenzione ad eventuali perdite di dati!
*/

long
trunc (double d)
{
  double fp, ip;

  fp = modf (d, &ip);
  return (long) ip;
}

/*
  La funzione vald converte una stringa in un double.Accetta come primo
  argomento un puntatore alla stringa e come secondo parametro l'indirizzo
  di una variabile intera.Quest'ultima assume,dopo l'esecuzione della fun-
  zione,i seguenti valori:
  0 in caso di conversione riuscita
  1 in caso di mancata conversione,quando la stringa non contiene un numero
  2 in caso di overflow 
  FATAL_ERROR in caso di errore fatale verificatosi durante l'esecuzione.
  Cio' che la funzione tenta di convertire e'in realta' la stringa s+"\'",
  facendo uso della funzione strtod,la quale restituisce in pfin la strin-
  ga "\'" se la conversione riesce e una stringa piu' lunga se s non con-
  tiene un numero.In caso di overflow strtod restituisce un valore diverso
  da 0 e imposta a ERANGE la variabile errno dell' header <errno.h>.
*/

double
vald (const char *s, int *codice_errore)
{
  double d;
  char *pfin, *t;
  unsigned int l;

  errno = 0;
  if( (l = strlen (s)) == 0 )
     {
	*codice_errore=1;
	return 0;
     }
  //: t = (char *) malloc ((l + 2) * sizeof (char));
  t=new(nothrow)char[l+2];
  if(!t)
    {
      *codice_errore=FATAL_ERROR;
      return 0;
    }
  strcpy (t, s);
  strcat (t, "\'");
  d = strtod (t, &pfin);
  if (errno == ERANGE && d != 0)	/* ==In caso di overflow... */
    {
      *codice_errore = 2;
      /* 2=Conversione effettuata ma il numero contenuto in s era troppo */
      //: free ((void *) t);
      delete[] t;
      /*   grande (in valore ass.) per essere contenuto in un double     */
      return 0;
    }
  else if (strcmp (pfin, "\'"))
    {
      *codice_errore = 1;	/* 1= Mancata Conversione */
      //: free ((void *) t);
      delete[] t;
      return 0;
    }
  else
    {
      *codice_errore = 0;
      //: free ((void *) t);
      delete[] t;
      return d;
    }
}

/*
  La routine che segue elimina da una stringa s tutti gli spazi vuoti
  (tabulazioni,spazi bianchi e via dicendo) e ne converte in maiuscolo
  tutti i caratteri alfabetici.Utilizzata sulle variabili globali expr
  e last per consentire all'utente di ignorare la distinzione maiusco-
  le-minuscole e di non dare importanza agli spazi vuoti
*/

int
Delete_spaces (char *s)
{
  unsigned long i, l, n;
  char *ps;			/* ps=puntatore a stringa */

  l = strlen (s);
  ps=new(nothrow)char[l+1];
  if(!ps)
    return FATAL_ERROR;
  for (n = 0, i = 0; i < l; i++)
    {
      if (!isspace (s[i]))
	ps[n++] = toupper (s[i]);
    }
  ps[n] = '\0';
  for (i = 0; i <= n; i++)
    s[i] = ps[i];
  delete[] ps;
  return 0;
}

/* 
   La routine che segue sostituisce il carattere '-' con il carattere '_' ogni
   volta che questo compare nella stringa s all'inizio della medesima  o  dopo
   una parentesi aperta.In questo modo il '-' unario  viene  correttamente in-
   terpretato dal parser.
   Inoltre la funzione sostituisce il carattere '-' con il carattere '\'' ogni
   volta che questo compare nella stringa s dopo 'E' ;  analogamente,il carat-
   tere '+' viene sostituito con il carattere '\"' se esso compare dopo il
   carattere 'E'(TODO).
*/

void
Transform(char* s)
{
  unsigned long i,l;

  l=strlen(s);
  if(l>0)
    {
      if(s[0]=='-')
	s[0]='_';
      for(i=1 ; i<l ; i++)
	{
	  if(( s[i]=='-' ) && ( s[i-1]=='(' ))
	    s[i]='_';
	  else if(( s[i]=='-' ) && ( s[i-1]=='E' ))
	    s[i]='\'';
	  else if(( s[i]=='+' ) && ( s[i-1]=='E' ))
	    s[i]='\"';
	}
    }
}

/* La funzione restituisce 1 se c e' un segno d'operazione,0 altrimenti */

int
isoperation (char c)
{
  return ((c == '+') + (c == '-') + (c == '*') + (c == '/') + (c == '\\') +
	  (c == '&') + (c == '%') + (c == '^'));
}


/*
  La funzione restituisce 1 se c e' una cifra,
  un punto o il segno _ (equivalente al - unario),
  0 altrimenti.
*/

int
isnumberelement (char c)
{
  return (isdigit (c) + (c == '.'));
}


/*
   La funzione restituisce 1 quando c e' un segno operazionale,una cifra,
   un punto,il segno _ o quando c e' una parentesi tonda
*/

int
ischarmathematic (char c)
{
  return (isoperation (c) + isnumberelement (c) + (c == '(') + (c == ')'));
}

/*
  La routine di utilita' che segue restituisce 1 se c e' un carattere
  che puo' comparire in una espressione accettabile dal programma,al-
  trimenti restituisce 0.
*/

int
ischaragreable (char c)
{
  int temp;

  temp =
    isalnum (c) + (c == '$') + (c == '/') + (c == '+') + (c == '-') + (c ==
								       '*');
  temp +=
    ((c == '\\') + (c == '&') + (c == '^') + (c == '%') + (c == '.'));
  temp += ((c == '(') + (c == ')') + (c == '?') + ( c == '!' ) + isspace (c));
  return temp;
}

/*
  Aggiunta in data 31/1/2002.  La funzione che segue prende come parametro
  un puntatore ad un stringa costante s e restituisce un valore intero.
  Questo valore intero e`:
  -1 se s==NULL,
  il numero delle linee che compongono la stringa s in qualsiasi altro caso.
  Per linea si deve intendere una sequenza di caratteri NON NULLI
  terminata da un '\n' o '\0'; se e` terminata da un '\n' questo fa
  parte integrante della linea; infine, "\n" e` una linea.
  ESEMPIO:
  "\n","Data\n","Ambra" sono linee ma "" non e` una linea.
*/

int nlines(const char* s)
{
  int nl,c;
  char* p;

  if(s==NULL)
    return -1;
  else
    {
      for(nl=0, p=(char*)s ; *p != '\0' ; nl++)
	{
	  c=strcspn(p,"\n");
	  p+= c + (( *(p + c) != '\0') ? 1 : 0);
	}
    }
  return nl;
}

/*
  Aggiunta in data 31/1/2002.  La funzione che segue prende come parametro
  un puntatore ad un stringa costante s e un puntatore ad un intero.
  Restituisce un puntatore a carattere. La prima volta che viene chiamata
  su una stringa str bisogna passarle come primo argomento proprio str
  mentre per le volte successive il primo argomento deve essere NULL.
  La prima volta che la funzione viene chiamata su un puntatore a stringa str
  restituisce il puntatore medesimo mentre n punta alla lunghezza della
  prima linea di s; successivamente la funzione restituisce un puntatore
  al primo carattere della seconda, della terza, della quarta... linea di
  s; in *n viene conservata la lunghezza della linea in questione.
  Ricordiamo che per linea si deve intendere una sequenza di caratteri
  NON NULLI terminata da '\n' o da '\0'; se e` terminata da un '\n' questo
  fa parte integrante della linea. La lunghezza di una linea
  e` il numero di caratteri non nulli che la compongono.
  La prima volta che la funzione restituisce NULL vuol dire che la
  stringa puntata da str e` stata esaminata per intero.
*/

char* next_line(const char** p, unsigned int* n)
{
  char *oldp;

  if(!*p)      
    return NULL;
  else
    {
      if( (**p) )
	{
	  *n=strcspn(*p,"\n");
	  oldp=(char*)*p;
	  *p+= *n+= ( *(*p + *n) != '\0') ? 1 : 0 ;
	}
      else
	return NULL;
    }
  return oldp;
}

/* Aggiunta in data 9/2/2002. La funzione verifica che al stringa puntata da "s" sia vuota,
   vale a dire formata esclusivamente da spazi vuoti e dal carattere di terminazione.
   E` usata nelle funzioni di caricamento.                                                  */ 

int isempty(const char* s)
{
  char* p;

  for(p=(char*)s; *p != '\0'; p++)
    {
      if( !(isspace(*p)) )
	return 0;
    }
  return 1;
}
