/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#ifndef _MY_CANVAS_
#define _MY_CANVAS_

#include<new>
#include<FL/Fl_Box.H>
#include<FL/Enumerations.h>
#include"mplot.h"

// Definitions of the canvas types
#define C2D 1
#define C3D 2
#define SF 3

// Not all the display area is available to the drawing operations
// (the display area is a rectangle with upper left corner in (x,y) and
// width given by w, height given by h, see below). The drawing area is
// a rectangle contained inside the display area. DIST (where DIST
// stays for distance) is the distance between the right (left)
// side of the drawing area and the same side of the display area and,
// at the same time, the distance between the upper (lower) side of the
// drawing area and the correspondent side of the display area.
//
// (x,y)
//   +-------T-----------+  T
//   |       |  DIST     |  |
//   |    +--V------+    |  |
//   |    | DRAWING |    |  |
//   |    |  AREA   <---->  h
//   |    +---------+    |  |             
//   |                   |  |
//   +-------------------+  |
//                          |
//   <---------w--------->  V

#define DIST 11

// Definition of the plotting styles for 2D plot
#define CONNECTED_PLOT 0
#define SQUARES 1
#define DIAMONDS 2
#define CROSSES 3

// I have decided to repeat here some definitions of "makeps.h"
// These macros must be updated whenever are updated the corresponding
// macros inside makeps.h

#define PS_PORTRAIT   1 // Default orientation
#define PS_A3         0 // Default medium

class mycanvas : public Fl_Box {
 public:
  mycanvas(int x,int y,int w,int h,const char* label=0) : Fl_Box(x,y,w,h,label)
    {
      box(FL_FLAT_BOX);
      color(FL_BLACK);
      grid=0;
      table=0;
      draw_infos=draw_axes=draw_grid=0;
      encfmt=rainbow=lpareq=0;
      medium= PS_A3;
      orientation= PS_PORTRAIT;
      for(short i=0 ; i < MAX_NC ; plotstyle[i++]=0)
	; 
      gridstep=1;
      par3d.zoom=par2d.zoom=0;
      par3d.lambda=45;
      par3d.phi=35;
      par3d.mu=0;
      par3d.fog=0;
    }
  void set_type(int tp){
    cnvtype=tp;
  }
  int get_type(void){
    return cnvtype;
  }
  void set_long(double x){
    par3d.lambda=x;
  }
  void set_lat(double x){
    par3d.phi=x;
  }
  void set_vang(double x){
    par3d.mu=x;
  }
  double get_long(){
    return par3d.lambda;
  }
  double get_lat(){
    return par3d.phi;
  }
  double get_vang(){
    return par3d.mu;
  }
  void set_x0(double x){
    (cnvtype == C2D ? par2d.x0 : par3d.x0) = x;
  }
  void set_y0(double x){
    (cnvtype == C2D ? par2d.y0 : par3d.y0) = x;
  }
  void set_z0(double x){
    par3d.z0 = x;
  }
  double get_x0(void){
    return (cnvtype==C2D ? par2d.x0 : par3d.x0);
  }
  double get_y0(void){
    return (cnvtype==C2D ? par2d.y0 : par3d.y0);
  }
  double get_z0(void){
    return par3d.z0;
  }
  void set_fog(double x){
    par3d.fog=x;
  }
  void infos_on_off(int which){
    draw_infos=which;
  }
  int infos_status(void){
    return draw_infos;
  }
  void set_plotstyle(int which, unsigned char value){
    plotstyle[which]=value;
  }
  unsigned char get_plotstyle(int which){
    return plotstyle[which];
  }
  void grid_on_off(int which){
    draw_grid=which;
  }
  void axes_on_off(int which){
    draw_axes=which;
  }
  void set_gstep(double x){
    gridstep=x;
  }
  /* The function below is used to adjust the zoom factor; currently
     it can go from -4 to 4. inc should be 0,-1,1.                   */
  int zoomfactor(const short inc);
  void zoomreset(void){
    par3d.zoom=par2d.zoom=0;
  }
  void encflag(int value){
    encfmt=value;  // !0= active, 0= not active
  }
  void colorprint(int onoff){
    rainbow=onoff; // !0= on, 0= off
  }
  void setmedium(int which){
    medium=which;
  }
  void setorient(int which){
    orientation=which;
  }
  void listpareq(int yesno){
    lpareq=yesno; // !0 = yes, 0= no
  }
  // The 2 following functions return -1 when the memory allocation
  // fails else they return 0.
  int set_par2d(const struct Param2d *p);
  int set_par3d(const struct Param3d *p);
  struct Param2d* get_par2d(void);
  struct Param3d* get_par3d(void);
  // "index" is the index of the first vertex (P) of the line
  void setv(struct point P, int index);
  void free_mem(){
    delete[] grid;
    grid=0;
    delete[] table;
    table=0;
  }
  int print(const char* doctitle, int doc_opening_mode);
 protected:
  void draw(void);
  int handle(int event) {
    return Fl_Widget::handle(event);
  }
 private:
  int set_dim(int vn, int vm=1);// It is recalled by set_par2d() / set_par3d() 
  void draw2d(void);
  void draw3d(void);
  void _draw_infos(void);
  void _draw_center(void);
  void _draw_axes(void);
  void _draw_grid(void);
  int print2d(void);
  int print3d(void);
  int _print_infos(void);
  int _print_header(void);
  int _print_center(void);
  int _print_axes(void);
  int _print_grid(void);
  int cnvtype,draw_grid,draw_axes,draw_infos;
  // encfmt (ENCAPSULATED FORMAT) and rainbow (COLOR PRINT) are used only for
  // printing operations; the same is for medium, orientation and
  // l(ist)par(ametric)eq(uations).
  int encfmt,rainbow,medium,orientation,lpareq;
  // plotstyle is only for 2D plot (at the moment)
  unsigned char plotstyle[MAX_NC];
  struct Param2d par2d;
  struct Param3d par3d;
  float gridstep;
  struct point* grid;
  struct element* table;
  int m,n; // m*n = number of points of the grid
};         //   m = number of points along the horizontal side
           //   n = number of points along the vertical side
#endif

