/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

/* Mplot.h */
#ifndef _Mplot_

#define _Mplot_

#define PI 3.14159265358979324

#define MAX_LUN 81
/*
  MAX_LUN-1= Greatest number of characters accepted in a single parametric
  equation ( if an equation has more than MAX_LUN-1 characters the ones
  after the 80th are discarded ).
*/

#define MAX_CHAR 30
/*
  Maximum number of characters (digits, decimal point and so on) can
  appear into the writing of a number.
*/

#define FATAL_ERROR 10000
/*
  This constant is used to signal a fatal error (memory not allocated when
  requested).
*/

#define MAX_MOD_CPCOORD 1.0e7
/*
  Maximum possible value for the modulus of each coordinate of the central
  point of the display area.
*/

#define MIN_DIM 0.01
/*
  Minimum admissible value for the dimensions of the display area.
*/

#define MAX_DIM 1.0e7
/*
  Maximum admissible value for the dimensions of the display area.
*/

#define MIN_AR 0.099999 // It stays for 0.1
/*
  The smallest possible value for the aspect ratio
  of the display area (used in 2D graphic routines only).
*/

#define MAX_AR 10.000001 // It stays for 10.0
/*
  The largest possible value for the aspect ratio
  of the display area (used in 2D graphic routines only).
*/

#define MIN_DIMOCPC 1.0e-6
/*
  The smallest value that the can be taken by the ratio between
  the smallest dimension and the largest modulus of the coordinates
  of the central point of the display area.
*/

#define MAX_NC 10
/*
  The greatest number of curves you can display at the same time
  in bidimensional graphic.
*/

#define MAX_EXTVIPRM 2000
/*
  The largest possible extension for the variation's interval of
  each parameter.
*/

#define MAX_NNOD_C2D 12010
/*
  The greatest number of the interpolation's equidistant nodes can be used 
  in the plotting of a bidimensional curve.
*/

#define MAX_NNOD_C3D 4001
/*
  The greatest number of the interpolation's equidistant nodes can be used 
  in the plotting of a tridimensional curve.
*/

#define MAX_NNOD_SF 5001
/*
  The greatest number of the interpolation's equidistant nodes can be used 
  in the plotting of a surface.
*/


#define MAX_ZOOM  4

#define MIN_ZOOM -4
/*
  Maximum and minimum value for the zoom-index.
*/

#define NGRAYS 24  // Number of the grays: 0==black, NGRAYS-1==white

struct __prm {
  char x[MAX_LUN],y[MAX_LUN],z[MAX_LUN];
};
/*
   x[],y[],z[] vengono utilizzate per prelevare le espressioni matematiche da
   analizzare
*/

struct item
{
  char *psz;
  short prec,prec2,type;
  double valore;
};
/*
  Per l'uso di item cfr. Scicalc.c
*/

struct coppia
{
  short prec,index;
};
/*
  Per l'uso di coppia vedi Command.c
*/

/*** Strutture utili per la grafica ***/

struct Param2d
{
  /* Non tutto il piano viene visualizzato all'interno della finestra  */
  /* aperta sullo schermo  ma solo una sua parte avente forma  di ret- */
  /* tangolo; questo rettangolo e` il rettangolo di visualizzazione o  */
  /* area di visualizzazione.                                          */

  /* Coordinate del centro del rettangolo di visualizzazione (e` il */
  /* punto di intersezione delle diagonali).                        */
  double x0,y0;
  /* Lunghezze dei lati del rettangolo di visualizzazione.          */
  /* w= larghezza (x-length), h= altezza (y-length)                 */
  double w,h;
  /* t1,t2= inf e sup dell'intervallo di variazione del parametro t */
  double t1,t2;
  /* nnod  == numero dei valori di t per i quali si procede al cal- */
  /*          colo della curva C(t) da rappresentare                */
  /* nnod-1== numero delle suddivisioni dell'intervallo [t1,t2]     */
  unsigned short nnod;
  /* zoom = indice di ingrandimento o riduzione dell'immagine */
  short zoom;
  /* nc = numero delle curve che devono essere disegnate */
  unsigned char  nc;
};
/* La struttura Param2d viene utilizzata per contenere l'insieme dei */
/* parametri necessari al tracciamento di una curva piana.           */
/* La curva risultera` visibile solo se  contenuta nel rettangolo di */
/* visualizzazione.                                                  */

struct Param3d
{
  /* Coordinate del centro della sfera di visualizzazione  */
  double x0,y0,z0;
  /* Raggio della sfera di visualizzazione                 */
  double R;
  /* Parametri dell'assonometria */
  double lambda,phi,mu;
  /* N.B.:  per rappresentare una curva nello spazio basta un para- */
  /*        metro (t),mentre una superficie e' descritta al variare */
  /*        di 2 parametri (s,t)                                    */
  /* s1,s2= inf e sup dell'intervallo di variazione del parametro s */
  /* t1,t2= inf e sup dell'intervallo di variazione del parametro t */
  double s1,s2,t1,t2;
  /* nnods-1 == numero delle suddivisioni dell'intervallo [s1,s2]   */
  /* nnodt-1 == numero delle suddivisioni dell'intervallo [t1,t2]   */
  unsigned short nnods,nnodt;
  /* zoom = indice di ingrandimento o riduzione dell'immagine */
  short zoom;
  /* fog e` un coefficiente tra 0 ed 1: l'indice di nebbiosita` */
  float fog;
};
/* La struttura Param3d viene impiegata per contenere i parametri */
/* necessari al tracciamento di una curva 3D o di una superficie. */
/* La curva 3D o la superficie risultera` visibile solo se conte- */
/* nuta nel parallelepipedo di visualizzazione.                   */

struct point2d
{
  double x,y;
};
/* Un punto nel piano */


struct point3d
{
  double x,y,z;
};
/* Un punto nello spazio */


struct point{
  float x,y,z;
  unsigned char color; // Un numero fra 0 e NGRAYS-1 o 127 per segnalare
};                     // un punto da non disegnare


struct element{
  short index;
  unsigned char type,key;
};
/*** Utilizzata in mycanvas.h ***/

/*** Fine 1a sezione di dichiarazioni ***/

/*Dichiarazione delle funzioni contenute nei vari moduli del programma*/

double round(double d);
double intp(double d);
double frac(double d);
long trunc(double d);
double vald(const char *s,int *codice_errore);
int Delete_spaces(char *s); // It may return 0 or FATAL_ERROR
void Transform(char *s);
short Call_function(short nome_fun,double arg);
short Call_operation(double op1,double op2,short operazione);
int isoperation(char c);
int isnumberelement(char c);
int isnumbercomponent(char c);
int ischarmathematic(char c);
int ischaragreable(char c);
int nlines(const char* s);
char* next_line(const char** p, unsigned int* n);
int isempty(const char* s);
char* Evaluate(int which, short* nel, int ic=0);
short Check_Move(char *expr,struct item lista[],short *nel);
short CommInt(struct item lista[],struct coppia **v,short nel);
short CommExec(double s,double t,int which,short nel);
void clean(int which);  // see evaluate.cxx

#include"config.h"

#endif
