/*
    Mplot++ : a math plotter for Unix(R)/Windows(R)/MacOS X(R) -
              - version 0.78     
    Copyright (C)  2002    Ivano Primi ( ivano.primi@tin.it )    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You can contact the author of this software by paper mail writing to
    the next address

	Ivano Primi
	via Colle Cannetacce 50/A
	C.A.P. 00038 - Valmontone (ROMA)
	Italy                                                          .

    If you prefer the electronic mail you can write to the address

	ivano.primi@tin.it                                             .
*/

#include<cstdio>
#include<cstring>
#include<cfloat>
#include"mplot.h"
#include"mathplot.h"
#include"numbutils.h"

#define BUFFSIZE 150 /* This it would be enough */
#define MSGSIZE  60  /* ....................... */

char* LoadC2Dparams(FILE* pf, struct Param2d* par)
{
  char buff[BUFFSIZE];
  static char errmsg[MSGSIZE];
  __number nlist[4];
  int errcode;
  unsigned int ncd; /* Number of the curve to be drawn */

  /* First we have to read lb(t1),ub(t2),n(nnod) and nc */
  if( !fgets(buff,BUFFSIZE,pf) )
    {
      strncpy(errmsg," Error occurred ( unexpected end of file ? )",MSGSIZE-1);
      errmsg[MSGSIZE-1]='\0';
      return errmsg;
    }
  else if( stonlist(buff, "FFwu", nlist, &errcode) < 4 )
    {
      strncpy(errmsg," Error occurred ( bad parameters ? )",MSGSIZE-1);
      errmsg[MSGSIZE-1]='\0';
      return errmsg;
    }
  else
    {
      par->t1  =nlist[0].F;
      par->t2  =nlist[1].F;
      par->nnod=nlist[2].w;
      ncd=nlist[3].u;
    } 
  if( (par->t2-par->t1<= 0) || (par->t2-par->t1 >MAX_EXTVIPRM) )
    {
      strncpy(errmsg," ub-lb: Its value is out of the admissible range",MSGSIZE-1);
      errmsg[MSGSIZE-1]='\0';
      return errmsg;
    }
  else if( (ncd< 1) || (ncd > MAX_NC) )
    {
      strncpy(errmsg," Number of the curves to be drawn: unagreable value",MSGSIZE-1);
      errmsg[MSGSIZE-1]='\0';
      return errmsg;
    }
  else if( (par->nnod < 2) || (ncd* par->nnod > MAX_NNOD_C2D) )
    {
      strncpy(errmsg," n: Unagreable value",MSGSIZE-1);
      errmsg[MSGSIZE-1]='\0';
      return errmsg;
    }
  else
    par->nc=(unsigned char)ncd;
  return NULL;
}

char* LoadC2(mycanvas* cnv, FILE* pf, struct Param2d* par)
{
  struct point P;
  char buff[BUFFSIZE];
  static char errmsg[MSGSIZE];
  __number nlist[2];
  int errcode;
  unsigned int ncd; /* Number of the curve to be drawn */
  int n,i;          /* Counter variables */

  /* I am going to load the curves */
  for(n=0 ; n< par->nc ; n++)
    {
      /* Before each block i want to read an empty line */
      if( !fgets(buff,BUFFSIZE,pf) )
	{
	  strncpy(errmsg," Error occurred ( unexpected end of file ? )",MSGSIZE-1);
	  errmsg[MSGSIZE-1]='\0';
	  return errmsg;
	}
      else if( !(isempty(buff)) )
	{
	  strncpy(errmsg," Error : requested empty line",MSGSIZE-1);
	  errmsg[MSGSIZE-1]='\0';
	  return errmsg;
	}
      else
	{
	  for(i=0 ; i< par->nnod ; i++)
	    {
	      if( !fgets(buff,BUFFSIZE,pf) )
		{
		  strncpy(errmsg," Error occurred ( unexpected end of file ? )",MSGSIZE-1);
		  errmsg[MSGSIZE-1]='\0';
		  return errmsg;
		}
	      /* We must read the x and y coordinate of the point i+1 */
	      else if( stonlist(buff, "ff", nlist, &errcode) < 2 )
		{
		  strncpy(errmsg," Error occurred ( bad coordinates ? )", MSGSIZE-1);
		  errmsg[MSGSIZE-1]='\0';
		  return errmsg;
		}
	      else
		{
		  sscanf(buff,"%f %f",&P.x,&P.y); // I have decided to use sscanf()
		  //to load P.x and P.y because I want to avoid the approssimation errors 
		  P.z=0;
		  P.color= ( (P.x==FLT_MAX) && (P.y==FLT_MAX) ) ? 127:0;
		  //The special value 127 is used to signal points you must not draw
		  cnv->setv(P,n*par->nnod+i);
		  // i=0,...,par->nnod-1 is the index of the vertex
		}
	    } // end for(i=0 ...
	} // end else
    } // end for(n=0 ...
  fprintf(stderr,"mplotxx: Load successfully completed\n");
  /* I would expsect to have reached the end of file; if no */
  /* I make to print a warning                               */
  if( !feof(pf) )
    {
      fprintf(stderr,"Not reached EOF; perhaps there are some inused data\n");
      fprintf(stderr,"However, do not worry about that !\n");
    }
  return NULL;
}
	      

