type expr = 
  | N_ of float
  | V_ of string
      
  | Sum_  of expr * expr
  | Diff_ of expr * expr
  | Prod_ of expr * expr
  | Quot_ of expr * expr
  | Pow_  of expr * expr

  | Func_ of string * expr


type exprN = 
  | N of float
  | V of string
      
  | Sum  of exprN list
  | Prod of exprN list
  | Pow  of exprN list

  | Func of string * exprN

type cmp = Eq | Inf | InfEq | Sup | SupEq

type equation = 
  | Eq0_ of expr
  | Cmp_ of cmp * expr * expr

type equationN = 
  | Eq0 of exprN
  | Cmp of cmp * exprN * exprN

exception EmptyOperandList of string
exception UnknownFunction of string
exception InternalError of string
