open Types

let rec print_expr = function
    N_(n) -> print_float n
  | V_(v) -> print_string v
  | Sum_ (e1, e2) -> print_string "(" ; print_expr e1 ; print_string ")+(" ; print_expr e2 ; print_string ")"
  | Diff_(e1, e2) -> print_string "(" ; print_expr e1 ; print_string ")-(" ; print_expr e2 ; print_string ")"
  | Prod_(e1, e2) -> print_string "(" ; print_expr e1 ; print_string ")*(" ; print_expr e2 ; print_string ")"
  | Quot_(e1, e2) -> print_string "(" ; print_expr e1 ; print_string ")/(" ; print_expr e2 ; print_string ")"
  | Pow_ (e1, e2) -> print_string "(" ; print_expr e1 ; print_string ")^(" ; print_expr e2 ; print_string ")"

  | Func_(f, e) -> print_string f ; print_string "(" ; print_expr e ; print_string ")"


let rec addp n e = 
  let n2, e2 = exprN2string e in
    if (n < n2) then "(" ^ e2 ^ ")" else e2

and exprN2string = function
	N(n) -> (1, string_of_float n)
      | V(v) -> (1, v)
      | Sum (l) -> (5, String.concat "+" (List.map (addp 5) l))
      | Prod(l) -> (4, String.concat "*" (List.map (addp 4) l))
      | Pow (l) -> (3, String.concat "^" (List.map (addp 2) l))

      |	Func("-", e) -> (4, "-" ^ addp 4 e)
      | Func(f, e) -> (2, f ^ addp 0 e)

let string_of_exprN e = snd (exprN2string (Preprint.preprintN e))

let string_of_cmp = function
  | SupEq -> ">="
  | InfEq -> "<="
  | Eq -> "="
  | Sup -> ">"
  | Inf -> "<"

let string_of_equationN = function
  | Eq0 e -> string_of_exprN e
  | Cmp(cmp, a, b) -> string_of_exprN a ^ string_of_cmp cmp ^ string_of_exprN b

let print_exprN e = print_string (string_of_exprN e)
let print_equationN e = print_string (string_of_equationN e)
