open Types
open List
open Any

let rec preprintN = function
  | Prod [ N (-1.) ; e ] -> Func("-", preprintN e)
  | Prod ( N (-1.) :: l) -> Func("-", Prod (map preprintN l))
  | Pow  [ e ; N (-1.) ] -> Func("inv", preprintN e)
  | Pow  [ e ; N n ] when n < 0. -> Func("inv", preprintN (Pow [ e ; N (-.n) ]))
	
  | Func("exp", N 1.) -> V "e"

  | Sum  l -> Sum  (map preprintN l)
  | Prod l -> Prod (map preprintN l)
  | Pow  l -> Pow  (map preprintN l)
  | Func(f, e) -> Func(f, preprintN e)

  | N n -> N n
  | V v -> V v

let preprintE = function
  | Eq0 e -> Eq0 (preprintN e)
  | Cmp(cmp, a, b) -> Cmp(cmp, preprintN a, preprintN b)
