/* File parser.mly */
%{
  open Types

  let verify e = 
    let e2 = (String.lowercase e) in
    if (List.mem e2 [ "ln" ; "exp" ; "cos" ; "sin" ; "tan"; "acos"; "asin"; "atan" ; "inv" ; "abs" ; "sign" ])
	then e2
	else raise (UnknownFunction e2)
%}
%token <float> FLOAT
%token <string> VAR
%token PLUS MINUS TIMES DIV EXP
%token LPAREN RPAREN
%token EOL INFEQ SUPEQ EQ INF SUP
%left PLUS MINUS        /* lowest precedence */
%left TIMES DIV         /* medium precedence */
%nonassoc UMINUS        /* highest precedence */
%right EXP         /* very highest precedence */
%start expr equation      /* the entry point */
%type <Types.expr> expr
%type <Types.equation> equation

%%
equation:
    e EOL		 { Eq0_ $1 }
  | e op e EOL		 { Cmp_($2, $1, $3) }
;
expr:
    e EOL                { $1 }
;
e:
    FLOAT                { N_($1) }
  | VAR			 { V_($1) }
  | VAR LPAREN e RPAREN  { Func_(verify $1, $3) }
  | LPAREN e RPAREN      { $2 }
  | e PLUS e             { Sum_ ($1, $3) }
  | e MINUS e            { Diff_($1, $3) }
  | e TIMES e            { Prod_($1, $3) }
  | e DIV e              { Quot_($1, $3) }
  | e EXP e              { Pow_ ($1, $3) }
  | MINUS e %prec UMINUS { Func_("-", $2) }
;
op:
    INFEQ		 { InfEq }
  | SUPEQ		 { SupEq }
  | EQ			 { Eq }
  | INF			 { Inf }
  | SUP			 { Sup }
