{
(* File lexer.mll *)
open Parser        (* The type token is defined in parser.mli *)
exception Eof
}
rule token = parse
    [' ' '\t']     { token lexbuf }     (* skip blanks *)
  | ['\n' ]        { EOL }
  | ['0'-'9']*'.'?['0'-'9']+(['e' 'E']['-' '+']?['0'-'9']+)?     { FLOAT(float_of_string(Lexing.lexeme lexbuf)) }
  | ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9']* { VAR(Lexing.lexeme lexbuf) }
  | '+'            { PLUS }
  | '-'            { MINUS }
  | '*'            { TIMES }
  | '/'            { DIV }
  | '^'		   { EXP }
  | '('            { LPAREN }
  | ')'            { RPAREN }
  | "<="	   { INFEQ }	
  | "=<"	   { INFEQ }	
  | ">="	   { SUPEQ }	
  | "=>"	   { SUPEQ }	
  | '='		   { EQ }	
  | '<'		   { INF }
  | '>'		   { SUP }
  | eof            { raise Eof }
