open Types
open List
open Any
open Print

(* does a variable exists in an expression ? *)
let rec exist_in f = function
    N(n) -> false
  | V(v) -> f v
  | Sum (l) -> exists (exist_in f) l
  | Prod(l) -> exists (exist_in f) l
  | Pow (l) -> exists (exist_in f) l
  | Func (ff, e) -> exist_in f e

let rec substitute var by = function
    N(n) -> N(n)
  | V(v) -> if var = v then by else V(v)
  | Sum (l) -> Sum (map (substitute var by) l)
  | Prod(l) -> Prod(map (substitute var by) l)
  | Pow (l) -> Pow (map (substitute var by) l)
  | Func (ff, e) -> Func(ff, substitute var by e)


let exist_inE f = function
  | Eq0 e -> exist_in f e
  | Cmp(_, e1, e2) -> exists (exist_in f) [e1 ; e2]

let substituteE var by = function
  | Eq0 e -> Eq0 (substitute var by e)
  | Cmp(c, e1, e2) -> Cmp(c, substitute var by e1, substitute var by e2)

let compareN e1 e2 = let f = (compose String.length string_of_exprN) in (f e1 <= f e2) 
let compareE e1 e2 = let f = (compose String.length string_of_equationN) in (f e1 <= f e2) 

