open Types

exception IsolateFailed

let exist_in e e2 = Iterateur.exist_in ((=) e) e2

(* sisolate to-isolate without-part with-part  *)
let rec sisolate e r = 
  function
    N(n) -> raise IsolateFailed
  | V(v) -> if v = e then r else raise IsolateFailed
  | Func(f, e2) -> sisolate e (Func(Inverse.inverse f, r)) e2

  | Sum  [] -> raise IsolateFailed
  | Prod [] -> raise IsolateFailed
  | Pow  [] -> raise IsolateFailed
  | Sum  [e2] -> sisolate e r e2
  | Prod [e2] -> sisolate e r e2
  | Pow  [e2] -> sisolate e r e2
  | Sum(e2::l) -> if exist_in e e2 
                  then (if exist_in e (Sum l) then raise IsolateFailed else
                       sisolate e (Sum [r ; Func("-", Sum l) ]) e2)
	          else sisolate e (Sum [r ; Func("-", e2)]) (Sum l)
  | Prod(e2::l) -> if exist_in e e2
                  then (if exist_in e (Prod l) then raise IsolateFailed else
		       sisolate e (Prod [r ; Func("inv", Sum l) ]) e2)
	          else sisolate e (Prod [r ; Func("inv", e2)]) (Prod l)
  | Pow(e2::l) -> if exist_in e e2
                  then (if exist_in e (Pow l) then raise IsolateFailed else
		       sisolate e (Pow [r ; Func("inv", Sum l) ]) e2)
	          else sisolate e (Prod [Func("ln", r) ; Func("inv", Func("ln", e2))]) (Pow l)

let rec sisolate2 cmp e r = 
  function
    N(n) -> raise IsolateFailed
  | V(v) -> if v = e then (cmp, r) else raise IsolateFailed
  | Sum  [] -> raise IsolateFailed
  | Prod [] -> raise IsolateFailed
  | Pow  [] -> raise IsolateFailed
  | Sum  [e2] -> sisolate2 cmp e r e2
  | Prod [e2] -> sisolate2 cmp e r e2
  | Pow  [e2] -> sisolate2 cmp e r e2
  | Sum(e2::l) -> if exist_in e e2 
                  then (if exist_in e (Sum l) then raise IsolateFailed else
                       sisolate2 cmp e (Sum [r ; Func("-", Sum l) ]) e2)
	          else sisolate2 cmp e (Sum [r ; Func("-", e2)]) (Sum l)
  | Prod(e2::l) -> let n = try Eval.eval_const e2 with Eval.UnknownVariable _ -> raise IsolateFailed in
                   if n > 0. then sisolate2 cmp e (Prod [r ; Func("inv", e2)]) (Prod l)
		   else if n < 0. then sisolate2 (Inverse.inverse_cmp cmp) e (Prod [r ; Func("inv", e2)]) (Prod l)
		   else raise IsolateFailed
  | _ -> raise IsolateFailed
    
let isolateN v f = sisolate v (N 0.) f

let isolate e = function
    | Eq0 e2 -> Cmp(Eq, V e, isolateN e e2)
    | Cmp (Eq, e1, e2) -> if exist_in e e1 then (if exist_in e e2 then raise IsolateFailed else 
                             Cmp(Eq, V e, sisolate e e2 e1))
    else if exist_in e e2 then Cmp(Eq, V e, sisolate e e1 e2) else raise IsolateFailed
    | Cmp (cmp, e1, e2) -> 
	let cmp2, e3 = if exist_in e e1 then (if exist_in e e2 then raise IsolateFailed else 
          sisolate2 cmp e e2 e1) else if exist_in e e2 then sisolate2 (Inverse.inverse_cmp cmp) e e1 e2 else raise IsolateFailed
	    in Cmp(cmp2, V e, e3)

(*
let isolateE e f = match isolate e f with
  Cmp(_, _, b) -> b
| _ -> raise (InternalError "isolateE")
*)
