open Types

exception InverseImpossible

let inverse = function
  | "-"    -> "-"
  | "ln"   -> "exp"
  | "exp"  -> "ln"
  | "cos"  -> "acos"
  | "sin"  -> "asin"
  | "tan"  -> "atan"
  | "acos" -> "cos"
  | "asin" -> "sin"
  | "atan" -> "tan"
  | "inv"  -> "inv"
  | "abs"  -> raise InverseImpossible
  | "sign"  -> raise InverseImpossible
  | f -> raise (UnknownFunction f)

let inverse_cmp = function
  | InfEq -> SupEq
  | SupEq -> InfEq
  | Sup -> Inf
  | Inf -> Sup
  | Eq -> Eq
