open Any
open Types
open List
open Graph
open Graph_batch
open Graphics

let graphics_round2it n = round2int (if abs_float n > 1e4 then 1e4 *. sign_float n else n)
let moveto x y = Graphics.moveto (graphics_round2it x) (graphics_round2it y)
let lineto x y = Graphics.lineto (graphics_round2it x) (graphics_round2it y)
let pointto x y = Graphics.plot (graphics_round2it x) (graphics_round2it y)

class virtual graphX =
  object(o)

  inherit graph

  method line (x1, y1, x2, y2) = moveto x1 y1 ; lineto x2 y2
      
  method templ s f = f s.i (o#y_en_j s.y)
  method moveto s = o#templ s moveto

  method draw_text (t, i, j) = moveto i j; Graphics.draw_string t
  method text_size t = let (l, h) = Graphics.text_size t in (float l, float h)

  method graphs_actions actions =
    (let ended = ref false in
    let button_was_down = ref false in
    let button_i, button_j = ref 0, ref 0 in
    let redraw = ref true in
    let colors = [| blue ; green ; red ; magenta ; cyan ; yellow |] in
    let defxmin, defxmax, defymin, defymax = xmin, xmax, ymin, ymax in
  
    imin <- 0;
    jmin <- 0;
    minStep <- 1.;
    maxStep <- 7.;
    o#rangeR actions.range;
    Graphics.open_graph "";
    while not !ended do
      if !redraw then (
  	Graphics.clear_graph();
  	imax <- Graphics.size_x();
  	jmax <- Graphics.size_y();
  	o#update_vars;
  
  	for i = 0 to length actions.plots - 1 do
  	  Graphics.set_color colors.(i mod (Array.length colors));
  	  o#draw (nth actions.plots i)
  	done;
  	for i = 0 to length actions.xplots - 1 do
  	  Graphics.set_color colors.((i + length actions.plots) mod (Array.length colors));
  	  o#xdraw (nth actions.xplots i)
  	done;
  	Graphics.set_color Graphics.black;
  	iter o#hatching actions.hatchings;  
  	iter o#tangent_f actions.tangents;
	iter o#point actions.points;
	iter o#fpoint actions.fpoints;
	o#inequations_hatching actions.plots actions.xplots;
  	o#axes;
  	redraw := false
      );
      try
      (let s = Graphics.wait_next_event [ Key_pressed ; Mouse_motion ; Button_up ; Button_down ] in
  	if s.keypressed then (
  	  redraw := true;
  	  match s.key with
  	  | 'q' -> print_string (o#string_of_graphAction actions) ; ended := true
  	  | 'r' -> o#range (defxmin, defxmax, defymin, defymax)
  	  | 'a' -> o#adjust_int_number_of_tick
	  | 'A' -> o#autoscale actions.plots
  	  | 'o' -> o#orthorme
  	  | '5' -> o#center
  	  | '8' -> o#up 1.
  	  | '2' -> o#down 1.
  	  | '4' -> o#left 1.
  	  | '6' -> o#right 1.
  	  | '+' -> o#zoom_in 2.
  	  | '-' -> o#zoom_out 2. 
  	  | '*' -> o#zoom_in 8.
  	  | '/' -> o#zoom_out 8. 
  	  | _ -> redraw := false
  	) else if s.button && not !button_was_down then (
  	    button_was_down := true;
  	    button_i := s.mouse_x;
  	    button_j := s.mouse_y
  
  	) else if not s.button && !button_was_down then (
  	  button_was_down := false;
  	  redraw := true;
  	  if abs (!button_i - s.mouse_x) < 4 or
  	     abs (!button_j - s.mouse_y) < 4 then (
  	     let x, y = o#ij_en_xy (float s.mouse_x, float s.mouse_y) in
  	       actions.tangents <- (N x, o#nearest_function actions.plots (x, y)) :: actions.tangents
  	    ) else let (x1, y1), (x2, y2) = o#ij_en_xy (float s.mouse_x, float s.mouse_y), o#ij_en_xy (float !button_i, float !button_j) in
  	      o#range (min x1 x2, max x1 x2, min y1 y2, max y1 y2)
  	);
  	if not !redraw then redraw := imax <> size_x() or jmax <> size_y()
      ) with Graphic_failure _ -> print_string (o#string_of_graphAction actions) ; ended := true
    done;
    (*Printf.printf "range %g %g %g %g\n" xmin xmax ymin ymax;*)
    close_graph ();
  )
end

class graphXLines =
  object(o)
  inherit graphX
  method lineto s1 s2 = o#templ s2 lineto
end
      
class graphXPoints =
  object(o)
  inherit graphX
  method lineto s1 s2 = o#templ s2 pointto
end

let x_fgraphs l = new graphXLines # graphs_actions (functions2graphAction l)
let x_graphs c = new graphXLines # graphs_actions (getActions c)
