open Types


type range = { mutable xmin : float; mutable xmax : float ; mutable ymin : float ; mutable ymax : float }

val default_range : unit -> range

type named_exprN = string * exprN
type named_equationN = string * equationN

type graphActionRaw =
  | Point of string * named_exprN * named_exprN (* Point "A" at (0,1) *)
  | FPoint of string * named_exprN (* FPoint "A" at x=0, on the function *)
  | Tangent of named_exprN (* draw the tangent at x=0 of the current function *)
  | Plot of named_equationN (* plot the function *)
  | XPlot of named_equationN (* plot the function with no y like x=2 *)
  | Hatching (* hatching between the last two functions *)
  | Range of exprN * exprN * exprN * exprN (* plotting range *)

type graphAction = {
    mutable points : (string * named_exprN * named_exprN) list; (* Point "A" at (0,1) *)
    mutable fpoints : (string * named_exprN * named_equationN) list; (* Point "A" at x=0 on the function f *)
    mutable tangents : (named_exprN * named_equationN) list; (* draw the tangent at x=0 of the function f *)
    mutable plots : named_equationN list; (* plot the function *)
    mutable xplots : named_equationN list; (* plot the function with no y like x=2 *)
    mutable hatchings : (named_equationN * named_equationN) list; (* hatching between the functions *)
    mutable range : range
  } 

val getExprN_ : equationN -> exprN
val getExprN : named_equationN -> exprN
val getName : named_equationN -> string

val actions_from_lstring : string list -> graphAction
val getActions : in_channel -> graphAction
val strings_of_graphAction : graphAction -> string list
val string_of_graphAction : graphAction -> string

val default_graphAction : unit -> graphAction
val add_graphActions : graphAction -> graphAction -> graphAction
val functions2graphAction : named_equationN list -> graphAction

val equationWithYFirst_from_string : string -> graphActionRaw
val unname : named_exprN -> exprN
val unnameE : named_equationN -> equationN
val name : exprN -> named_exprN
val nameE : equationN -> named_equationN

val tryit : (string -> 'b) -> ('a -> 'b) -> 'a -> 'b
