open Types
open Graph_batch


type state = { mutable pendown: bool ; mutable error: bool; mutable i: float ; mutable x: float ; mutable y: float ; mutable y2 : float }


class virtual graph :
    object 
    val mutable xmin : float
    val mutable xmax : float
    val mutable ymin : float
    val mutable ymax : float
    val mutable imin : int
    val mutable imax : int
    val mutable jmin : int
    val mutable jmax : int
  
    val mutable xtick : float
    val mutable ytick : float
    val mutable tickSize : float
    val mutable minNbTicks : float
    val mutable maxNbTicks : float
  
    val mutable arrowAngle : float
    val mutable arrowSize : float
    val mutable minArrowSize : float
    val mutable tangentSize : float
  
    val mutable step : float
    val mutable hatchingStep : float
    val mutable draw_asymptot : bool
  
    val mutable ratio2start_reducingStep : float
    val mutable coeff_stepReduction : float
    val mutable ratio2start_augmentingStep : float
    val mutable coeff_stepAugmentation : float
  
    val mutable angleMeaningBreak : float
    val mutable minStep : float
    val mutable maxStep : float

    method di : int
    method dj : int
    method dx : float
    method dy : float
    method fdi : float
    method fdj : float
    method update_vars : unit
    method x_en_i : float -> float
    method y_en_j : float -> float
    method i_en_x : float -> float
    method j_en_y : float -> float
    method xy_en_ij : float * float -> float * float
    method ij_en_xy : float * float -> float * float
    method ijsize : float
    method get_range : range
    method strings_of_graphAction : graphAction -> string list
    method string_of_graphAction : graphAction -> string
    method rangeR : range -> unit
    method range : float * float * float * float -> unit
    method mrange : float * float * float * float -> unit
    method up : float -> unit
    method down : float -> unit
    method right : float -> unit
    method left : float -> unit
    method zoom : float * float -> unit
    method zoom_out : float -> unit
    method zoom_in : float -> unit
    method center : unit
    method orthorme : unit
    method adjust_int_number_of_tick : unit
    method arrow_head : float -> float -> float -> unit
    method tangent : float -> float -> float -> unit
    method tangent_f : (named_exprN * named_equationN) -> unit
    method nearest_functions : named_equationN list -> float * float -> named_equationN list
    method nearest_function : named_equationN list -> float * float -> named_equationN
    method nearest_functions_ : named_equationN list -> float * float * float * float -> named_equationN list
    method nearest_function_ : named_equationN list -> float * float * float * float -> named_equationN
    method point : string * named_exprN * named_exprN -> unit
    method fpoint : string * named_exprN * named_equationN -> unit
    method axes : unit
    method draw : named_equationN -> unit
    method xdraw : named_equationN -> unit
    method hatching : (named_equationN * named_equationN) -> unit
    method autoscale : named_equationN list -> unit
    method inequations_hatching : named_equationN list -> named_equationN list -> unit
    method virtual line : float * float * float * float -> unit
    method virtual text_size : string -> float * float
    method virtual draw_text : string * float * float -> unit
    method virtual moveto : state -> unit
    method virtual lineto : state -> state -> unit
end

