open Types
open Any
open List


let rec expand_step = function
    N(n) -> N(n)
  | V(v) -> V(v)
  | Sum (e1 :: Func("inv", e2) :: l) -> Sum (Prod [ Sum [ N 1. ; Prod [e1;e2]]  ; Func("inv", e2) ] :: l)
  | Sum (e1 :: Prod [e2 ; Func("inv", e3) ] :: l) -> Sum (Prod [ Sum [ e2 ; Prod [e1;e3]]  ; Func("inv", e3) ] :: l)
  | Sum [] -> Sum []
  | Sum (e::l) -> let e1 = expand_step e in (match expand_step (Sum l) with Sum l2 -> Sum (e1::l2) | e2 -> Sum [e1;e2])
  | Prod(l) -> let l2 = rev l in (match l2 with
      Sum l2 :: ll -> Sum (map (function e -> Prod (e::(rev ll))) l2)
    | _ -> Prod(map expand_step l))

  | Pow(l) -> let l2 = rev l in (match l2 with
      N n :: ll -> if n > 1. && mod_float n 1. = 0. then Prod [ Pow (rev ll) ; Pow ((rev ll) @ [ N (n -. 1.) ]) ]
	           else Pow(map expand_step l)
    | Sum l2 :: ll -> Prod (map (function e -> Pow ((rev ll) @ [e])) l2)
    | _ -> Pow(map expand_step l))

  | Func ("inv", Prod l) -> Prod (map (function e -> Func("inv", e)) l)
  | Func ("exp", Sum l) -> Prod (map (function e -> Func("exp", e)) l)
  | Func ("exp", Func("-", l)) -> Func("inv", Func("exp", l))
  | Func ("ln", Func("inv", l)) -> Func("-", Func("ln", l))
  | Func ("ln", Prod l) -> Sum (map (function e -> Func("ln", e)) l)
  | Func ("cos", Sum (e1 :: l)) -> 
      let e2 = Sum l in Sum [ Prod [ Func("cos", e1) ; Func("cos", e2) ] ;
		    Func("-", Prod [ Func("sin", e1) ; Func("sin", e2) ]) ]
  | Func ("sin", Sum (e1 :: l)) -> 
      let e2 = Sum l in Sum [ Prod [ Func("cos", e1) ; Func("sin", e2) ] ;
		              Prod [ Func("sin", e1) ; Func("cos", e2) ] ]
  | Func ("tan", Sum (e1 :: l)) -> 
      let e2 = Sum l in Prod [ Sum [ Func("tan", e1) ; Func("tan", e2) ] ;
		   Func("inv", Sum [ N 1. ; Func("-", Prod [ Func("tan", e1) ; Func("tan", e2) ]) ]) ]
  | Func (ff, e) -> Func(ff, expand_step e)

let expand e = iterate (compose Normalize.normalize expand_step) e

