open Types
open Any

exception UnknownVariable of string

let eval_func n = function
    "-"    -> -. n
  | "ln"   -> log n
  | "exp"  -> exp n
  | "cos"  -> cos n
  | "sin"  -> sin n
  | "tan"  -> tan n
  | "acos" -> acos n
  | "asin" -> asin n
  | "atan" -> atan n
  | "inv"  -> 1. /. n
  | "abs"  -> abs_float n
  | "sign" -> sign_float n
  |  f -> raise (UnknownFunction f)

let constants = [ 
  "e", exp 1. ;
  "pi", pi ;
]


let rec eval x n = function
    N(n2) -> n2
  | V(v) -> if v = x then n else (try List.assoc v constants with Not_found -> raise (UnknownVariable v))
  | Func(f, e) -> eval_func (eval x n e) f
  | Sum  l -> List.fold_left ( +. ) 0. (List.map (eval x n) l)
  | Prod l -> List.fold_left ( *. ) 1. (List.map (eval x n) l)
  | Pow [] -> raise (EmptyOperandList "eval")
  | Pow [e] -> eval x n e
  | Pow (e::l) -> List.fold_left ( ** ) (eval x n e) (List.map (eval x n) l)

let eval_x n f = eval "x" n f
let eval_const f = eval "" 0. f
