open Types
open Iterateur
open Derive

let rec any = function
    [] -> []
  | (e::l) -> (e, l) :: List.map (function (e2, l) -> (e2, e::l)) (any l)


and derive var = function
    N(_) -> N(0.)
  | V(v) -> N(if var = V(v) then 1. else 0.)

  | Sum(l) -> Sum(List.map (derive var) l)
 
  | Prod(l) -> Sum(List.map (function (e, l) -> Prod (derive var e :: l) )
		            (any l))

  | Pow([]) -> raise (EmptyOperandList "derive")
  | Pow([u]) -> derive var u
  | Pow(u::l) as upv -> let v = Pow l in
                   Sum [
                     Prod [ v ; Pow [u ; Sum [v ; N(-1.)]] ; derive var u ] ;
                     Prod [ upv ; Func("ln", u) ; derive var v ]
                   ]

  | Func(f, e) -> Prod [ (derive var e) ; (derive_func e f) ]

and derive_func e = function
    "-"    -> N (-1.)
  | "ln"   -> Func("inv", e)
  | "exp"  -> Func("exp", e)
  | "cos"  -> Func("-", Func("sin", e))
  | "sin"  -> Func("cos", e)
  | "tan"  -> Sum [ N 1. ; Pow [ Func("tan", e) ; N 2. ] ]
  | "acos" -> Func("-", Func("inv", Pow [ Sum [ N 1. ; Func("-", Pow [ e ; N 2. ]) ] ; N 0.5 ])) (* -1/sqrt(1-x^2) *)
  | "asin" ->           Func("inv", Pow [ Sum [ N 1. ; Func("-", Pow [ e ; N 2. ]) ] ; N 0.5 ])  (*  1/sqrt(1-x^2) *)
  | "atan" -> Func("inv", Sum [ N 1. ; Pow [ e ; N 2. ] ])
  | "inv"  -> Func("-", Func("inv", Pow [ e ; N(2.) ])) 
  | "abs"  -> Func("sign", e)
  | "sign" -> N 0.
  |  f -> raise (UnknownFunction f)

let derive_x e = derive (V "x") e
