open Types
open Any
open List
open Iterateur

let precision = 1e-10

let ftruncate = compose float truncate

let rec sfraction_from_float n0 n (a, b, c, d) =
  if abs_float(n0 -. a /. c) < precision then (a, c)
  else let n = 1. /. n in
       let k = ftruncate n in
       sfraction_from_float n0 (n -. k) (a *. k +. b, a, c *. k +. d, c)

let fraction_from_float n0 = (* ex: 1.33333... -> (4, 3) *)
  sfraction_from_float n0 (n0 -. ftruncate n0) (ftruncate n0, 1., 1., 0.)

let expr2fraction (N n) =
  let (a, b) = fraction_from_float n in
  let f = compose String.length string_of_float in
    if (f n <= (f a) + (f b))
    then (N n) 
    else Prod [ N a ; Func("inv", N b) ]

let rec iterate_once_list f = function
  | [] -> []
  | e::l -> let e2 = colct_step e in
              if e = e2 then e :: f l else e2 :: l

and mem_ l = function
  | [] -> raise DeleteNotFound
  | (Prod l2) :: l3 -> match intersection l l2 with
    | [] -> mem_ l l3
    | l4 -> l4

and colct_sum = function
  | (e1 :: e2 :: l) when e1 = e2 -> (* ``x + x'' *)
      colct_sum (Prod [ N 2. ; e1 ] :: l)
  | (e1 :: Prod l1 :: l) when mem e1 l1 -> (* ``x + m*x'' *)
      colct_sum (Prod [ e1 ; Sum (N 1. :: delete e1 l1) ] :: l)
  | (Prod [ (N n1) ; e1 ] :: Prod [ (N n2) ; e2 ] :: l) when e1 = e2 -> (* ``n*x + m*x'' *)
      colct_sum (Prod [ N (n1 +. n2) ; e1 ] :: l) 
  | l -> iterate_once_list colct_sum l

and colct_prod = function
  | (e1 :: e2 :: l) when e1 = e2 -> (* ``x * x'' *)
      colct_prod (Pow [ e1 ; N 2. ] :: l)
  | (e1 :: Pow [ e2 ; (N n) ] :: l) when e1 = e2 -> (* ``x * x^m'' *)
      colct_prod (Pow [ e1 ; N (n +. 1.) ] :: l)
  | (Pow [ e1 ; (N n1) ] :: Pow [ e2 ; (N n2) ] :: l) when e1 = e2 -> (* ``x^n + x^m'' *)
      colct_prod (Pow [ e1 ; N (n1 +. n2) ] :: l) 
  | l -> iterate_once_list colct_prod l

and colct_pow = function
  | l -> iterate_once_list colct_pow l

and colct_step = function
  | N n -> expr2fraction (N n)
  | V v -> V v

  | Sum  l -> Sum  (colct_sum  l)
  | Prod l -> Prod (colct_prod l)
  | Pow  l -> Pow  (colct_pow  l)
  | Func (ff, e) -> Func(ff, colct_step e)

let colct e = iterate (compose Normalize.normalize colct_step) e
