open Types
open List
open String
open Normalize

type tformat = TString | TExprN | TLexprN | TEquationN
type format = FString of string | FExprN of exprN | FLexprN of exprN list | FEquationN of equationN

let basename s =
  let i = ref (length s - 1) in
  while !i >= 0 && (get s !i) <> '/' do
    i := !i - 1
  done;
  if !i >= 0 then sub s (!i + 1) (length s - !i - 1) else s

let toLeq e = map (function e -> Eq0 e) e

let usages = [
  ( "symb-plot_x", (1, "\n", [], function _ -> Graph_x.x_graphs stdin; [])) ;
  ( "symb-plot_ps", (1, "\n", [], function _ -> Graph_postscript.postscript_graphs stdin; [])) ;
  ( "symb-derive", (2, "<functions>\n", [ TLexprN ], function [ FLexprN l ] -> toLeq (map Derive.derive_x l))) ;
  ( "symb-normalize", (2, "<functions>\n", [ TLexprN ], function [ FLexprN l ] -> toLeq l)) ;
  ( "symb-colct", (2, "<functions>\n", [ TLexprN ], function [ FLexprN l ] -> toLeq (map Colct.colct l))) ;
  ( "symb-expand", (2, "<functions>\n", [ TLexprN ], function [ FLexprN l ] -> toLeq (map Expand.expand_step l))) ;
  ( "symb-expand_all", (2, "<functions>\n", [ TLexprN ], function [ FLexprN l ] -> toLeq (map Expand.expand l))) ;
  ( "symb-isolate", (3, "<var> <function>\n(eg: isolate x ln(1/x)-y  gives  inv(exp(y))\n", [ TString ; TEquationN ], function [FString v ; FEquationN e] -> [ Isolate.isolate v e ])) ;
  ( "symb-substitute", (4, "<var> <function> <expr>\n(eg: substitute x ln(x) y+z  gives  ln(y+z)\n", [ TString ; TExprN ; TExprN ], function [FString v ; FExprN e ; FExprN v2] -> [ Eq0 (Iterateur.substitute v v2 e) ]))
]

;;
  
let prog = basename Sys.argv.(0) in
  try 
    let n, msg, format, f = assoc prog usages in
      if Array.length Sys.argv < n then (
	Printf.printf "usage: %s %s" prog msg;
        exit 1
      );

    let i = ref 0 in
    let l = map (function
	TString -> i := !i + 1; FString Sys.argv.(!i)
      |	TExprN -> i := !i + 1; FExprN (exprN_from_string Sys.argv.(!i))
      |	TEquationN -> i := !i + 1; FEquationN (equationN_from_string Sys.argv.(!i))
      |	TLexprN -> i := !i + 1; FLexprN (map exprN_from_string (Array.to_list (Array.sub Sys.argv !i (Array.length Sys.argv - !i))))
	    ) format in    
    map (function e -> Print.print_equationN (Normalize.normalizeE e) ; print_string "\n") (f l);    

  with Not_found -> (prerr_string "internal error: unknown prog name\n" ; exit 1);
