open Types
open List


exception DeleteNotFound
exception ListCombineError

let identity x = x
let compose f g = function x -> f (g x)
let rec remove e = function
  | [] -> []
  | (e2::l) when e = e2 -> remove e l
  | (e2::l) -> e2 :: remove e l
let rec delete e = function
  | [] -> raise DeleteNotFound
  | (e2::l) when e = e2 -> l
  | (e2::l) -> e2 :: delete e l

let sqr n = n *. n
let sign_float n = if n < 0. then (-1.) else 1.
let length_of_float n = String.length (string_of_float n)
let round n m = floor (n *. m +. 0.5) /. m
let round_norm n = round n 1e10
let round2int n = truncate (n +. 0.5)

let pi = 3.14159265358979323846

let verify_inf y = 
  let inf = 1. /. 0. in
  if y = inf then 1e5 else if y = -. inf then -1e5 else y

let rec readlines c = 
  try let l = input_line c in l :: readlines c
  with End_of_file -> []

let basename s =
  let i = ref (String.length s - 1) in
  while !i >= 0 && (String.get s !i) <> '/' do i := !i - 1 done;
  if !i >= 0 then String.sub s (!i + 1) (String.length s - !i - 1) else s

let rec grep f = function
  | [] -> []
  | e::l when (f e) -> e :: grep f l
  | e::l -> grep f l
let rec grepmap f = function
  | [] -> []
  | e::l -> let (b, e2) = f e in if b then e2 :: grepmap f l else grepmap f l

let mapcount f l =
  let rec mapcount_ n = function
  | [] -> []
  | e::l -> f n e :: mapcount_ (n + 1) l
  in mapcount_ 0 l

let rec map_once f_step = function
  | [] -> []
  | e1::l -> let e2 = f_step e1 in
    		if (e1 = e2) 
		then e1 :: map_once f_step l
		else e2 :: l

let rec iterate f_step e1 =
  let e2 = f_step e1 in 
  if (e1 = e2) then e1 else iterate f_step e2

let rec apply_n_times f e = function
  | 1 -> e
  | n -> f e (apply_n_times f e (n - 1))

let rec ssplice = function
  | 0 -> (function _ -> [])
  | n -> (function l -> (hd l) :: (ssplice (n - 1) (tl l)))
let rec splice beg len l = if beg = 0 then ssplice len l else splice (beg - 1) len (tl l)

let isInequality = function
  | Eq0 _ -> false
  | Cmp(Eq, _, _) -> false
  | Cmp(_, _, _) -> true


let rec intersection l = function
  | [] -> []
  | e::l1 -> try e :: intersection (delete e l) l1
             with DeleteNotFound -> intersection l l1

let rec substraction l = function
  | [] -> l
  | e::l1 -> substraction (delete e l) l1

let rec listCombine2 = function
  | [] -> []
  | [e] -> raise ListCombineError
  | e1 :: e2 :: l -> (e1, e2) :: listCombine2 l

(* eg:  [a; c; b; a; a; c] gives [(a,3) ; (c, 2) ; (b, 1)]  (!! unordered) *)
let rec listGroup = function
  | [] -> []
  | e :: l -> let l2 = listGroup l in try 
      let n = assoc e l2 in
      (e, n + 1) :: delete (e, n) l2
  with Not_found -> (e, 1) :: l2

