
(* numbers_comp is an assoc list from float to exprN
   it is constructed with the elements of the constant numbers, the constant generators_numbers and their opposite, inverses, opposite&inverses, half... *)
let numbers_comp =
  List.map (function e -> (round_norm (Eval.eval_const e), e))
    (numbers @
     (List.concat (List.map (function e -> e :: Func("inv", e) :: List.map (function e2 -> Prod [ e ; e2 ]) numbers)
     (List.concat (List.map (function e -> [ e ; Func("-", e) ]) 
		     generators_numbers)))))

let number_accepted newn old =
  let newn = round_norm newn in
  let lg = length_of_float newn in
    if (lg <= length_of_float old) then N newn
    else List.assoc newn numbers_comp
let expression_accepted e = 
  try let n = Eval.eval_const e in number_accepted n 10.01 (* complexity max otherwise keep initial *)
  with Eval.UnknownVariable -> raise Not_found

  | (e1 :: (Func("-", e2) :: l as l2)) -> (* for the ``x - x'' case *)
      if (e1 = e2) then rsimplify_sum l else e1 :: rsimplify_sum l2

  | (e1 :: (Func("inv", e2) :: l as l2)) -> (* for the ``x / x'' case *)
      if (e1 = e2) then rsimplify_prod l else e1 :: rsimplify_prod l2

(*  | [ N n1 ; N n2 ] as e -> let n = n1 ** n2 in (try [ number_accepted n n1 ] with Not_found -> e)*)
